/*
 * Decompiled with CFR 0.152.
 */
package com.simontuffs.onejar;

import com.simontuffs.onejar.Boot;
import com.simontuffs.onejar.Handler;
import com.simontuffs.onejar.IProperties;
import com.simontuffs.onejar.OneJarURLConnection;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JarClassLoader
extends ClassLoader
implements IProperties {
    public static final String LIB_PREFIX = "lib/";
    public static final String BINLIB_PREFIX = "binlib/";
    public static final String MAIN_PREFIX = "main/";
    public static final String RECORDING = "recording";
    public static final String TMP = "tmp";
    public static final String UNPACK = "unpack";
    public static final String EXPAND = "One-Jar-Expand";
    public static final String EXPAND_DIR = "One-Jar-Expand-Dir";
    public static final String SHOW_EXPAND = "One-Jar-Show-Expand";
    public static final String CONFIRM_EXPAND = "One-Jar-Confirm-Expand";
    public static final String CLASS = ".class";
    public static final String NL = System.getProperty("line.separator");
    public static final String JAVA_PROTOCOL_HANDLER = "java.protocol.handler.pkgs";
    protected String name;
    protected boolean noExpand;
    protected boolean expanded;
    protected ClassLoader externalClassLoader;
    protected Map byteCode = Collections.synchronizedMap(new HashMap());
    protected Map pdCache = Collections.synchronizedMap(new HashMap());
    protected Map binLibPath = Collections.synchronizedMap(new HashMap());
    protected Set jarNames = Collections.synchronizedSet(new HashSet());
    protected boolean record = false;
    protected boolean flatten = false;
    protected boolean unpackFindResource = false;
    protected boolean verbose = false;
    protected boolean info = false;
    protected boolean warning = true;
    protected String recording = "recording";
    protected String jarName;
    protected String mainJar;
    protected String wrapDir;
    protected boolean delegateToParent;
    protected static ThreadLocal current;
    protected URLStreamHandler oneJarHandler = new Handler();
    protected IURLFactory urlFactory = new FileURLFactory();
    static /* synthetic */ Class class$com$simontuffs$onejar$JarClassLoader;

    protected String PREFIX() {
        return "JarClassLoader: ";
    }

    protected String NAME() {
        return this.name != null ? "'" + this.name + "' " : "";
    }

    protected void VERBOSE(String message) {
        if (this.verbose) {
            System.out.println(this.PREFIX() + this.NAME() + message);
        }
    }

    protected void WARNING(String message) {
        if (this.warning) {
            System.err.println(this.PREFIX() + "Warning: " + this.NAME() + message);
        }
    }

    protected void INFO(String message) {
        if (this.info) {
            System.out.println(this.PREFIX() + "Info: " + this.NAME() + message);
        }
    }

    protected void PRINTLN(String message) {
        System.out.println(message);
    }

    protected void PRINT(String message) {
        System.out.print(message);
    }

    public JarClassLoader(String $wrap) {
        this.wrapDir = $wrap;
        this.delegateToParent = this.wrapDir == null;
        Boot.setProperties(this);
        this.init();
    }

    public JarClassLoader(ClassLoader parent) {
        super(parent);
        this.delegateToParent = true;
        Boot.setProperties(this);
        this.init();
    }

    protected void init() {
        String classpath = System.getProperty("one-jar.class.path");
        if (classpath != null) {
            String[] tokens = classpath.split("\\|");
            ArrayList<URL> list = new ArrayList<URL>();
            for (int i = 0; i < tokens.length; ++i) {
                String path = tokens[i];
                try {
                    list.add(new URL(path));
                    continue;
                }
                catch (MalformedURLException mux) {
                    try {
                        String _path = new File(path).getCanonicalPath();
                        list.add(new File(_path).toURI().toURL());
                        continue;
                    }
                    catch (MalformedURLException ignore) {
                        Boot.WARNING("Unable to parse external path: " + path);
                        continue;
                    }
                    catch (IOException ignore) {
                        Boot.WARNING("Unable to parse external path: " + path);
                        continue;
                    }
                    catch (IllegalArgumentException ignore) {
                        Boot.WARNING("Unable to parse external path: " + path);
                    }
                }
            }
            URL[] urls = list.toArray(new URL[0]);
            Boot.INFO("external URLs=" + Arrays.asList(urls));
            this.externalClassLoader = new URLClassLoader(urls, (ClassLoader)this){
                static final String LOAD_CLASS = "loadClass():";
                static final String GET_RESOURCE = "getResource():";
                static final String FIND_RESOURCE = "findResource():";

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Class loadClass(String name) throws ClassNotFoundException {
                    if (this.reentered(LOAD_CLASS + name)) {
                        throw new ClassNotFoundException(name);
                    }
                    JarClassLoader.this.VERBOSE("externalClassLoader.loadClass(" + name + ")");
                    Object old = current.get();
                    current.set(LOAD_CLASS + name);
                    try {
                        Class<?> clazz = super.loadClass(name);
                        return clazz;
                    }
                    finally {
                        current.set(old);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public URL getResource(String name) {
                    if (this.reentered(GET_RESOURCE + name)) {
                        return null;
                    }
                    JarClassLoader.this.VERBOSE("externalClassLoader.getResource(" + name + ")");
                    Object old = current.get();
                    current.set(GET_RESOURCE + name);
                    try {
                        URL uRL = super.getResource(name);
                        return uRL;
                    }
                    finally {
                        current.set(old);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public URL findResource(String name) {
                    if (this.reentered(FIND_RESOURCE + name)) {
                        return null;
                    }
                    JarClassLoader.this.VERBOSE("externalClassLoader.findResource(" + name + ")");
                    Object old = current.get();
                    current.set(name);
                    try {
                        current.set(FIND_RESOURCE + name);
                        URL uRL = super.findResource(name);
                        return uRL;
                    }
                    finally {
                        current.set(old);
                    }
                }

                protected boolean reentered(String name) {
                    Object old = current.get();
                    return old != null && old.equals(name);
                }
            };
        }
    }

    public String load(String mainClass) {
        String jarname = Boot.getMyJarPath();
        return this.load(mainClass, jarname);
    }

    public String load(String mainClass, String jarName) {
        this.VERBOSE("load(" + mainClass + "," + jarName + ")");
        if (this.record) {
            new File(this.recording).mkdirs();
        }
        try {
            boolean showexpand;
            if (jarName == null) {
                jarName = Boot.getMyJarPath();
            }
            JarFile jarFile = new JarFile(jarName);
            Enumeration<JarEntry> _enum = jarFile.entries();
            Manifest manifest = jarFile.getManifest();
            String[] expandPaths = null;
            String expand = manifest.getMainAttributes().getValue(EXPAND);
            String expanddir = System.getProperty("one-jar.expand.dir");
            if (expanddir == null) {
                expanddir = manifest.getMainAttributes().getValue(EXPAND_DIR);
            }
            if (expanddir == null) {
                String jar = new File(jarName).getName().replaceFirst("\\.[^\\.]*$", "");
                expanddir = "${java.io.tmpdir}/" + jar;
            }
            expanddir = this.replaceProps(System.getProperties(), expanddir);
            System.setProperty("one-jar.expand.dir", expanddir);
            boolean shouldExpand = true;
            File tmpdir = new File(expanddir);
            if (!this.noExpand && expand != null) {
                this.expanded = true;
                this.VERBOSE("One-Jar-Expand=" + expand);
                expandPaths = expand.split(",");
                boolean getconfirm = Boolean.TRUE.toString().equals(manifest.getMainAttributes().getValue(CONFIRM_EXPAND));
                if (getconfirm) {
                    String answer = this.getConfirmation(tmpdir);
                    if (answer == null) {
                        answer = "n";
                    }
                    if ((answer = answer.trim().toLowerCase()).startsWith("q")) {
                        this.PRINTLN("exiting without expansion.");
                        System.exit(1);
                    } else if (answer.startsWith("n")) {
                        shouldExpand = false;
                    }
                }
            }
            if (showexpand = Boolean.TRUE.toString().equals(manifest.getMainAttributes().getValue(SHOW_EXPAND))) {
                this.PRINTLN("Expanding to: " + tmpdir.getAbsolutePath());
            }
            while (_enum.hasMoreElements()) {
                InputStream is;
                JarEntry entry = _enum.nextElement();
                if (entry.isDirectory()) continue;
                String $entry = entry.getName();
                if (expandPaths != null && shouldExpand && JarClassLoader.shouldExpand(expandPaths, $entry)) {
                    String msg;
                    File dest = new File(tmpdir, $entry);
                    if (!dest.exists() || dest.lastModified() < entry.getTime()) {
                        File parent;
                        msg = "Expanding:  " + $entry;
                        if (showexpand) {
                            this.PRINTLN(msg);
                        } else {
                            this.INFO(msg);
                        }
                        if (dest.exists()) {
                            this.INFO("Update because lastModified=" + new Date(dest.lastModified()) + ", entry=" + new Date(entry.getTime()));
                        }
                        if ((parent = dest.getParentFile()) != null) {
                            parent.mkdirs();
                        }
                        this.VERBOSE("using jarFile.getInputStream(" + entry + ")");
                        InputStream is2 = jarFile.getInputStream(entry);
                        FileOutputStream os = new FileOutputStream(dest);
                        this.copy(is2, os);
                        is2.close();
                        os.close();
                    } else {
                        msg = "Up-to-date: " + $entry;
                        if (showexpand) {
                            this.PRINTLN(msg);
                        } else {
                            this.VERBOSE(msg);
                        }
                    }
                }
                if (this.wrapDir != null && $entry.startsWith(this.wrapDir) || $entry.startsWith(LIB_PREFIX) || $entry.startsWith(MAIN_PREFIX)) {
                    if (this.wrapDir != null && !entry.getName().startsWith(this.wrapDir)) continue;
                    this.VERBOSE("caching " + $entry);
                    this.VERBOSE("using jarFile.getInputStream(" + entry + ")");
                    is = jarFile.getInputStream(entry);
                    if (is == null) {
                        throw new IOException("Unable to load resource /" + $entry + " using " + this);
                    }
                    this.loadByteCode(is, $entry, null);
                    if (!$entry.startsWith(MAIN_PREFIX)) continue;
                    if (mainClass == null) {
                        JarInputStream jis = new JarInputStream(jarFile.getInputStream(entry));
                        Manifest m = jis.getManifest();
                        jis.close();
                        if (m == null) continue;
                        mainClass = jis.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
                        this.mainJar = $entry;
                        continue;
                    }
                    if (this.mainJar == null) continue;
                    this.WARNING("A main class is defined in multiple jar files inside main/" + this.mainJar + " and " + $entry);
                    this.WARNING("The main class " + mainClass + " from " + this.mainJar + " will be used");
                    continue;
                }
                if (this.wrapDir == null && $entry.startsWith(UNPACK)) {
                    is = this.getClass().getResourceAsStream("/" + $entry);
                    if (is == null) {
                        throw new IOException($entry);
                    }
                    File dir = new File(TMP);
                    File sentinel = new File(dir, $entry.replace('/', '.'));
                    if (sentinel.exists()) continue;
                    this.INFO("unpacking " + $entry + " into " + dir.getCanonicalPath());
                    this.loadByteCode(is, $entry, TMP);
                    sentinel.getParentFile().mkdirs();
                    sentinel.createNewFile();
                    continue;
                }
                if ($entry.endsWith(CLASS)) {
                    this.loadBytes(entry, jarFile.getInputStream(entry), "/", null, manifest);
                    this.VERBOSE("One-Jar class: " + jarFile.getName() + "!/" + entry.getName());
                    continue;
                }
                this.loadBytes(entry, jarFile.getInputStream(entry), "/", null, manifest);
                this.VERBOSE("One-Jar resource: " + jarFile.getName() + "!/" + entry.getName());
            }
        }
        catch (IOException iox) {
            System.err.println("Unable to load resource: " + iox);
            iox.printStackTrace(System.err);
        }
        return mainClass;
    }

    public String replaceProps(Map replace, String string) {
        Pattern pat = Pattern.compile("\\$\\{([^\\}]*)");
        Matcher mat = pat.matcher(string);
        boolean found = mat.find();
        HashMap props = new HashMap();
        while (found) {
            String prop = mat.group(1);
            props.put(prop, replace.get(prop));
            found = mat.find();
        }
        Set keys = props.keySet();
        Iterator iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String prop = (String)iter.next();
            string = string.replace("${" + prop + "}", (String)props.get(prop));
        }
        return string;
    }

    public static boolean shouldExpand(String[] expandPaths, String name) {
        for (int i = 0; i < expandPaths.length; ++i) {
            if (!name.startsWith(expandPaths[i])) continue;
            return true;
        }
        return false;
    }

    protected void loadByteCode(InputStream is, String jar, String tmp) throws IOException {
        JarInputStream jis = new JarInputStream(is);
        JarEntry entry = null;
        Manifest manifest = jis.getManifest();
        if (manifest == null) {
            this.WARNING("Null manifest from input stream associated with: " + jar);
        }
        while ((entry = jis.getNextJarEntry()) != null) {
            this.loadBytes(entry, jis, jar, tmp, manifest);
        }
        if (manifest != null) {
            entry = new JarEntry("META-INF/MANIFEST.MF");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            manifest.write(baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            this.loadBytes(entry, bais, jar, tmp, manifest);
        }
    }

    protected void loadBytes(JarEntry entry, InputStream is, String jar, String tmp, Manifest man) throws IOException {
        String packageName;
        String entryName = entry.getName();
        int index = entryName.lastIndexOf(46);
        String type = entryName.substring(index + 1);
        int index2 = entryName.lastIndexOf(47, index - 1);
        if (entryName.endsWith(CLASS) && index2 > -1 && this.getPackage(packageName = entryName.substring(0, index2).replace('/', '.')) == null) {
            if (man != null) {
                this.definePackage(packageName, man, this.urlFactory.getCodeBase(jar));
            } else {
                this.definePackage(packageName, null, null, null, null, null, null, null);
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.copy(is, baos);
        if (tmp != null) {
            File file = new File(tmp, entry.getName());
            file.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(baos.toByteArray());
            fos.close();
        } else if (type.equals("class")) {
            if (this.alreadyCached(entryName, jar, baos)) {
                return;
            }
            this.byteCode.put(entryName, new ByteCode(entryName, entry.getName(), baos, jar, man));
            this.VERBOSE("cached bytes for class " + entryName);
        } else {
            String localname = jar + "/" + entryName;
            this.byteCode.put(localname, new ByteCode(localname, entry.getName(), baos, jar, man));
            this.jarNames.add(jar);
            this.VERBOSE("cached bytes for local name " + localname);
            if (this.alreadyCached(entryName, jar, baos)) {
                return;
            }
            this.byteCode.put(entryName, new ByteCode(entryName, entry.getName(), baos, jar, man));
            this.VERBOSE("cached bytes for entry name " + entryName);
        }
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Thread.currentThread().setContextClassLoader(this);
        return super.loadClass(name, resolve);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class<?> cls = null;
        if (this.externalClassLoader != null) {
            try {
                return this.externalClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException cnfx) {
                // empty catch block
            }
        }
        if ((cls = this.findLoadedClass(name)) != null) {
            return cls;
        }
        this.VERBOSE("findClass(" + name + ")");
        String cache = name.replace('.', '/') + CLASS;
        ByteCode bytecode = (ByteCode)this.byteCode.get(cache);
        if (bytecode != null) {
            ProtectionDomain pd;
            this.VERBOSE("found " + name + " in codebase '" + bytecode.codebase + "'");
            if (this.record) {
                this.record(bytecode);
            }
            if ((pd = (ProtectionDomain)this.pdCache.get(bytecode.codebase)) == null) {
                try {
                    URL url = this.urlFactory.getCodeBase(bytecode.codebase);
                    CodeSource source = new CodeSource(url, (Certificate[])null);
                    pd = new ProtectionDomain(source, null, this, null);
                    this.pdCache.put(bytecode.codebase, pd);
                }
                catch (MalformedURLException mux) {
                    throw new ClassNotFoundException(name, mux);
                }
            }
            byte[] bytes = bytecode.bytes;
            int i = name.lastIndexOf(46);
            if (i != -1) {
                String pkgname = name.substring(0, i);
                Package pkg = this.getPackage(pkgname);
                Manifest man = bytecode.manifest;
                if (pkg != null) {
                    if (pkg.isSealed()) {
                        if (!pkg.isSealed(pd.getCodeSource().getLocation())) {
                            throw new SecurityException("sealing violation: package " + pkgname + " is sealed");
                        }
                    } else if (man != null && this.isSealed(pkgname, man)) {
                        throw new SecurityException("sealing violation: can't seal package " + pkgname + ": already loaded");
                    }
                } else if (man != null) {
                    this.definePackage(pkgname, man, pd.getCodeSource().getLocation());
                } else {
                    this.definePackage(pkgname, null, null, null, null, null, null, null);
                }
            }
            return this.defineClass(name, bytes, pd);
        }
        this.VERBOSE(name + " not found");
        throw new ClassNotFoundException(name);
    }

    private boolean isSealed(String name, Manifest man) {
        String path = name.concat("/");
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    protected Package definePackage(String name, Manifest man, URL url) throws IllegalArgumentException {
        boolean isSealed;
        String path = name.concat("/");
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        String sealed = null;
        URL sealBase = null;
        Attributes attr = man.getAttributes(path);
        if (attr != null) {
            specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if ((attr = man.getMainAttributes()) != null) {
            if (specTitle == null) {
                specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (specVersion == null) {
                specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (specVendor == null) {
                specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (implTitle == null) {
                implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (implVersion == null) {
                implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (implVendor == null) {
                implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (sealed == null) {
                sealed = attr.getValue(Attributes.Name.SEALED);
            }
        }
        if (sealed != null && (isSealed = Boolean.parseBoolean(sealed))) {
            sealBase = url;
        }
        return this.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    protected Class defineClass(String name, byte[] bytes, ProtectionDomain pd) throws ClassFormatError {
        this.VERBOSE("defineClass(" + name + ")");
        return this.defineClass(name, bytes, 0, bytes.length, pd);
    }

    protected void record(ByteCode bytecode) {
        String fileName;
        File dir = new File(this.recording, this.flatten ? "" : bytecode.codebase);
        File file = new File(dir, fileName = bytecode.original);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            this.VERBOSE("" + file);
            try {
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(bytecode.bytes);
                fos.close();
            }
            catch (IOException iox) {
                System.err.println(this.PREFIX() + "unable to record " + file + ": " + iox);
            }
        }
    }

    protected String canon(String path) {
        String canon;
        String next = canon = (path = path.replaceAll("/\\./", "/"));
        while (!(next = canon).equals(canon = canon.replaceFirst("([^/]*/\\.\\./)", ""))) {
        }
        return canon;
    }

    public InputStream getByteStream(String resource) {
        ClassLoader parent;
        this.VERBOSE("getByteStream(" + resource + ")");
        InputStream result = null;
        if (this.externalClassLoader != null) {
            result = this.externalClassLoader.getResourceAsStream(resource);
        }
        if (result == null && (parent = this.getParent()) != null) {
            result = parent.getResourceAsStream(resource);
        }
        if (result == null) {
            ByteCode bytecode = (ByteCode)this.byteCode.get(this.resolve(resource = this.canon(resource)));
            if (bytecode == null) {
                bytecode = (ByteCode)this.byteCode.get(resource);
            }
            if (bytecode != null) {
                result = new ByteArrayInputStream(bytecode.bytes);
            }
        }
        if (result == null && this.jarNames.contains(resource)) {
            this.INFO("loading resource file directly" + resource);
            result = super.getResourceAsStream(resource);
        }
        if (result == null && this.delegateToParent) {
            ClassLoader parentClassLoader = this.getParent();
            result = parentClassLoader instanceof JarClassLoader ? ((JarClassLoader)parentClassLoader).getByteStream(resource) : parentClassLoader.getResourceAsStream(resource);
        }
        this.VERBOSE("getByteStream(" + resource + ") -> " + result);
        return result;
    }

    protected String resolve(String $resource) {
        String tmp;
        if ($resource.startsWith("/")) {
            $resource = $resource.substring(1);
        }
        String resource = null;
        String caller = this.getCaller();
        ByteCode callerCode = (ByteCode)this.byteCode.get(caller);
        if (callerCode != null && this.byteCode.get(tmp = callerCode.codebase + "/" + $resource) != null) {
            resource = tmp;
        }
        if (resource == null) {
            resource = this.byteCode.get($resource) == null ? null : $resource;
        }
        this.VERBOSE("resource " + $resource + " resolved to " + resource + (callerCode != null ? " in codebase " + callerCode.codebase : " (unknown codebase)"));
        return resource;
    }

    protected boolean alreadyCached(String name, String jar, ByteArrayOutputStream baos) {
        ByteCode existing = (ByteCode)this.byteCode.get(name);
        if (existing != null) {
            byte[] bytes = baos.toByteArray();
            if (!Arrays.equals(existing.bytes, bytes) && !name.startsWith("META-INF")) {
                String message = existing.name + " in " + jar + " is hidden by " + existing.codebase + " (with different bytecode)";
                if (name.endsWith(CLASS)) {
                    this.WARNING(existing.name + " in " + jar + " is hidden by " + existing.codebase + " (with different bytecode)");
                } else {
                    this.INFO(existing.name + " in " + jar + " is hidden by " + existing.codebase + " (with different bytes)");
                }
            } else {
                this.VERBOSE(existing.name + " in " + jar + " is hidden by " + existing.codebase + " (with same bytecode)");
            }
            bytes = null;
            return true;
        }
        return false;
    }

    protected String getCaller() {
        return null;
    }

    public void setRecording(String $recording) {
        this.recording = $recording;
        if (this.recording == null) {
            this.recording = RECORDING;
        }
    }

    public String getRecording() {
        return this.recording;
    }

    public void setRecord(boolean $record) {
        this.record = $record;
    }

    public boolean getRecord() {
        return this.record;
    }

    public void setFlatten(boolean $flatten) {
        this.flatten = $flatten;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public void setVerbose(boolean $verbose) {
        this.verbose = $verbose;
        if (this.verbose) {
            this.info = true;
        }
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setInfo(boolean $info) {
        this.info = $info;
    }

    public boolean getInfo() {
        return this.info;
    }

    public void setWarning(boolean $warning) {
        this.warning = $warning;
    }

    public boolean getWarning() {
        return this.warning;
    }

    public URL getResource(String name) {
        URL url;
        if (this.externalClassLoader != null && (url = this.externalClassLoader.getResource(name)) != null) {
            return url;
        }
        return super.getResource(name);
    }

    public void setURLFactory(String urlFactory) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.urlFactory = (IURLFactory)this.loadClass(urlFactory).newInstance();
    }

    public IURLFactory getURLFactory() {
        return this.urlFactory;
    }

    protected URL findResource(String $resource) {
        try {
            URL url;
            this.VERBOSE("findResource(\"" + $resource + "\")");
            URL uRL = url = this.externalClassLoader != null ? this.externalClassLoader.getResource($resource) : null;
            if (url != null) {
                this.INFO("findResource() found in external: \"" + $resource + "\"");
                return url;
            }
            ClassLoader parent = this.getParent();
            if (parent != null && (url = parent.getResource($resource)) != null) {
                return url;
            }
            String resource = this.resolve($resource);
            if (resource != null) {
                ByteCode entry = (ByteCode)this.byteCode.get(resource);
                this.INFO("findResource() found: \"" + $resource + "\" for caller " + this.getCaller() + " in codebase " + entry.codebase);
                return this.urlFactory.getURL(entry.codebase, $resource);
            }
            this.INFO("findResource(): unable to locate \"" + $resource + "\"");
            return null;
        }
        catch (MalformedURLException mux) {
            this.WARNING("unable to locate " + $resource + " due to " + mux);
            return null;
        }
    }

    protected Enumeration findResources(String name) throws IOException {
        this.INFO("findResources(" + name + ")");
        this.INFO("findResources: looking in " + this.jarNames);
        Iterator iter = this.jarNames.iterator();
        ArrayList<URL> resources = new ArrayList<URL>();
        while (iter.hasNext()) {
            String resource = iter.next().toString() + "/" + name;
            ByteCode entry = (ByteCode)this.byteCode.get(resource);
            if (!this.byteCode.containsKey(resource)) continue;
            URL url = this.urlFactory.getURL(entry.codebase, name);
            this.INFO("findResources(): Adding " + url + " to resources list.");
            resources.add(url);
        }
        final Iterator ri = resources.iterator();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return ri.hasNext();
            }

            public Object nextElement() {
                return ri.next();
            }
        };
    }

    protected void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
    }

    public String toString() {
        return super.toString() + (this.name != null ? "(" + this.name + ")" : "");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setExpand(boolean expand) {
        this.noExpand = !expand;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    protected String findLibrary(String name) {
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        String BINLIB_LINUX32_PREFIX = "binlib/linux32/";
        String BINLIB_LINUX64_PREFIX = "binlib/linux64/";
        String BINLIB_MACOSX_PREFIX = "binlib/macosx/";
        String BINLIB_WINDOWS32_PREFIX = "binlib/windows32/";
        String BINLIB_WINDOWS64_PREFIX = "binlib/windows64/";
        String binlib = null;
        binlib = os.startsWith("mac os x") ? "binlib/macosx/" : (os.startsWith("windows") ? (arch.equals("x86") ? "binlib/windows32/" : "binlib/windows64/") : (arch.equals("i386") ? "binlib/linux32/" : "binlib/linux64/"));
        this.VERBOSE("Using arch-specific native library path: " + binlib);
        String retValue = this.findTheLibrary(binlib, name);
        if (retValue != null) {
            this.VERBOSE("Found in arch-specific directory!");
            return retValue;
        }
        this.VERBOSE("Search in standard native directory!");
        return this.findTheLibrary(BINLIB_PREFIX, name);
    }

    protected String findTheLibrary(String BINLIB_PREFIX, String name) {
        String result = null;
        String resourcePath = BINLIB_PREFIX + System.mapLibraryName(name);
        if (this.binLibPath.get(resourcePath) != null) {
            result = (String)this.binLibPath.get(resourcePath);
        } else {
            File tempNativeLib = null;
            FileOutputStream os = null;
            try {
                InputStream is;
                int lastdot = resourcePath.lastIndexOf(46);
                String suffix = null;
                if (lastdot >= 0) {
                    suffix = resourcePath.substring(lastdot);
                }
                if ((is = this.getClass().getResourceAsStream("/" + resourcePath)) != null) {
                    tempNativeLib = File.createTempFile(name + "-", suffix);
                    tempNativeLib.deleteOnExit();
                    os = new FileOutputStream(tempNativeLib);
                    this.copy(is, os);
                    os.close();
                    this.VERBOSE("Stored native library " + name + " at " + tempNativeLib);
                    result = tempNativeLib.getPath();
                    this.binLibPath.put(resourcePath, result);
                } else {
                    this.VERBOSE("No native library at " + resourcePath + "java.library.path will be searched instead.");
                }
            }
            catch (Throwable e) {
                this.WARNING("Unable to load native library: " + e);
            }
        }
        return result;
    }

    protected String getConfirmation(File location) throws IOException {
        String answer = "";
        while (answer == null || !answer.startsWith("n") && !answer.startsWith("y") && !answer.startsWith("q")) {
            this.promptForConfirm(location);
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            answer = br.readLine();
            br.close();
        }
        return answer;
    }

    protected void promptForConfirm(File location) {
        this.PRINTLN("Do you want to allow '" + Boot.getMyJarName() + "' to expand files into the file-system at the following location?");
        this.PRINTLN("  " + location);
        this.PRINT("Answer y(es) to expand files, n(o) to continue without expanding, or q(uit) to exit: ");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String handlerPackage = System.getProperty(JAVA_PROTOCOL_HANDLER);
        if (handlerPackage == null) {
            handlerPackage = "";
        }
        if (handlerPackage.length() > 0) {
            handlerPackage = "|" + handlerPackage;
        }
        handlerPackage = "com.simontuffs" + handlerPackage;
        System.setProperty(JAVA_PROTOCOL_HANDLER, handlerPackage);
        current = new ThreadLocal();
    }

    public static class OneJarURLFactory
    implements IURLFactory {
        public URL getURL(String codebase, String resource) throws MalformedURLException {
            String base = resource.endsWith(JarClassLoader.CLASS) ? "" : codebase + "/";
            URL url = new URL(Handler.PROTOCOL + ":/" + base + resource);
            return url;
        }

        public URL getCodeBase(String jar) throws MalformedURLException {
            return new URL(Handler.PROTOCOL + ":" + jar);
        }
    }

    public static class FileURLFactory
    implements IURLFactory {
        public URLStreamHandler jarHandler = new URLStreamHandler(){

            protected URLConnection openConnection(URL url) throws IOException {
                OneJarURLConnection connection = new OneJarURLConnection(url);
                ((URLConnection)connection).connect();
                return connection;
            }
        };

        public URL getURL(String codebase, String resource) throws MalformedURLException {
            codebase = !codebase.equals("/") ? codebase + "!/" : "";
            String path = "file:/" + Boot.getMyJarPath() + "!/" + codebase + resource;
            URL url = new URL("jar", "", -1, path, this.jarHandler);
            return url;
        }

        public URL getCodeBase(String jar) throws MalformedURLException {
            ProtectionDomain cd = (class$com$simontuffs$onejar$JarClassLoader == null ? (class$com$simontuffs$onejar$JarClassLoader = JarClassLoader.class$("com.simontuffs.onejar.JarClassLoader")) : class$com$simontuffs$onejar$JarClassLoader).getProtectionDomain();
            URL url = cd.getCodeSource().getLocation();
            if (url != null) {
                url = new URL("jar", "", -1, url + "!/" + jar, this.jarHandler);
            }
            return url;
        }
    }

    public static interface IURLFactory {
        public URL getURL(String var1, String var2) throws MalformedURLException;

        public URL getCodeBase(String var1) throws MalformedURLException;
    }

    protected static class ByteCode {
        public byte[] bytes;
        public String name;
        public String original;
        public String codebase;
        public Manifest manifest;

        public ByteCode(String $name, String $original, ByteArrayOutputStream baos, String $codebase, Manifest $manifest) {
            this.name = $name;
            this.original = $original;
            this.bytes = baos.toByteArray();
            this.codebase = $codebase;
            this.manifest = $manifest;
        }
    }
}

