/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlFileInput;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlNumberInput;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import com.gargoylesoftware.htmlunit.html.impl.SelectableTextInput;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.AbstractList;
import com.gargoylesoftware.htmlunit.javascript.host.dom.TextRange;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.MouseEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.PointerEvent;
import com.gargoylesoftware.htmlunit.javascript.host.file.FileList;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCanvasElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLFormElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.LabelsHelper;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.xml.sax.helpers.AttributesImpl;

@JsxClass(domClass=HtmlInput.class)
public class HTMLInputElement
extends HTMLElement {
    private AbstractList labels_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public HTMLInputElement() {
    }

    @JsxGetter
    public String getType() {
        BrowserVersion browserVersion = this.getBrowserVersion();
        String type = this.getDomNodeOrDie().getTypeAttribute();
        return HTMLInputElement.isSupported(type = type.toLowerCase(Locale.ROOT), browserVersion) ? type : "text";
    }

    private static boolean isSupported(String type, BrowserVersion browserVersion) {
        boolean supported = false;
        switch (type) {
            case "date": {
                supported = browserVersion.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_DATETIME_SUPPORTED);
                break;
            }
            case "datetime-local": {
                supported = browserVersion.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_DATETIME_LOCAL_SUPPORTED);
                break;
            }
            case "month": {
                supported = browserVersion.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_MONTH_SUPPORTED);
                break;
            }
            case "time": {
                supported = browserVersion.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_DATETIME_SUPPORTED);
                break;
            }
            case "week": {
                supported = browserVersion.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_WEEK_SUPPORTED);
                break;
            }
            case "color": {
                supported = !browserVersion.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_COLOR_NOT_SUPPORTED);
                break;
            }
            case "email": 
            case "text": 
            case "submit": 
            case "checkbox": 
            case "radio": 
            case "hidden": 
            case "password": 
            case "image": 
            case "reset": 
            case "button": 
            case "file": 
            case "number": 
            case "range": 
            case "search": 
            case "tel": 
            case "url": {
                supported = true;
                break;
            }
        }
        return supported;
    }

    @JsxSetter
    public void setType(String newType) {
        this.setType(newType, false);
    }

    private void setType(String newType, boolean setThroughAttribute) {
        HtmlInput input = this.getDomNodeOrDie();
        String currentType = input.getAttributeDirect("type");
        BrowserVersion browser = this.getBrowserVersion();
        if (!currentType.equalsIgnoreCase(newType)) {
            AttributesImpl attributes;
            int index;
            if (newType != null && browser.hasFeature(BrowserVersionFeatures.JS_INPUT_SET_TYPE_LOWERCASE)) {
                newType = newType.toLowerCase(Locale.ROOT);
            }
            if (!HTMLInputElement.isSupported(newType.toLowerCase(Locale.ROOT), browser)) {
                if (setThroughAttribute) {
                    newType = "text";
                } else if (browser.hasFeature(BrowserVersionFeatures.JS_INPUT_SET_UNSUPORTED_TYPE_EXCEPTION)) {
                    throw Context.reportRuntimeError((String)("Invalid argument '" + newType + "' for setting property type."));
                }
            }
            if ((index = (attributes = this.readAttributes(input)).getIndex("type")) > -1) {
                attributes.setValue(index, newType);
            } else {
                attributes.addAttribute(null, "type", "type", null, newType);
            }
            if (DomElement.ATTRIBUTE_NOT_DEFINED != currentType || !"text".equalsIgnoreCase(newType)) {
                SgmlPage page = input.getPage();
                HtmlInput newInput = (HtmlInput)page.getWebClient().getPageCreator().getHtmlParser().getFactory("input").createElement(page, "input", attributes);
                if (input.wasCreatedByJavascript()) {
                    newInput.markAsCreatedByJavascript();
                }
                if (input.getParentNode() == null) {
                    input = newInput;
                } else {
                    input.getParentNode().replaceChild(newInput, input);
                }
                input.setScriptableObject(null);
                this.setDomNode(newInput, true);
            } else {
                super.setAttribute("type", newType);
            }
        }
    }

    @Override
    @JsxSetter
    public void setValue(Object newValue) {
        if (null == newValue) {
            this.getDomNodeOrDie().setValueAttribute("");
            this.getDomNodeOrDie().valueModifiedByJavascript();
            return;
        }
        String val = Context.toString((Object)newValue);
        BrowserVersion browserVersion = this.getBrowserVersion();
        if (StringUtils.isNotEmpty((CharSequence)val) && "file".equalsIgnoreCase(this.getType())) {
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_SELECT_FILE_THROWS)) {
                throw Context.reportRuntimeError((String)"InvalidStateError: Failed to set the 'value' property on 'HTMLInputElement'.");
            }
            return;
        }
        this.getDomNodeOrDie().setValueAttribute(val);
        this.getDomNodeOrDie().valueModifiedByJavascript();
    }

    @JsxSetter
    public void setChecked(boolean checked) {
        this.getDomNodeOrDie().setChecked(checked);
    }

    @Override
    public HtmlInput getDomNodeOrDie() {
        return (HtmlInput)super.getDomNodeOrDie();
    }

    @JsxGetter
    public boolean isChecked() {
        return this.getDomNodeOrDie().isChecked();
    }

    @JsxFunction
    public void select() {
        HtmlInput input = this.getDomNodeOrDie();
        if (input instanceof HtmlTextInput) {
            ((HtmlTextInput)input).select();
        }
    }

    @Override
    public void setAttribute(String name, String value) {
        if ("type".equalsIgnoreCase(name)) {
            this.setType(value, true);
            return;
        }
        if ("value".equalsIgnoreCase(name)) {
            this.setDefaultValue(value);
        } else {
            super.setAttribute(name, value);
        }
    }

    @JsxGetter
    public String getDefaultValue() {
        return this.getDomNodeOrDie().getDefaultValue();
    }

    @JsxSetter
    public void setDefaultValue(String defaultValue) {
        this.getDomNodeOrDie().setDefaultValue(defaultValue);
    }

    @JsxGetter
    public boolean isDefaultChecked() {
        return this.getDomNodeOrDie().isDefaultChecked();
    }

    @JsxSetter
    public void setDefaultChecked(boolean defaultChecked) {
        this.getDomNodeOrDie().setDefaultChecked(defaultChecked);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF78})
    public int getTextLength() {
        return this.getValue().length();
    }

    @JsxGetter
    public Object getSelectionStart() {
        HtmlInput dom = this.getDomNodeOrDie();
        if (dom instanceof SelectableTextInput) {
            if ("number".equalsIgnoreCase(this.getType()) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INPUT_NUMBER_SELECTION_START_END_NULL)) {
                return null;
            }
            return ((SelectableTextInput)((Object)dom)).getSelectionStart();
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLINPUT_FILE_SELECTION_START_END_NULL)) {
            return null;
        }
        throw Context.reportRuntimeError((String)("Failed to read the 'selectionStart' property from 'HTMLInputElement': The input element's type (" + this.getType() + ") does not support selection."));
    }

    @JsxSetter
    public void setSelectionStart(int start) {
        HtmlInput dom = this.getDomNodeOrDie();
        if (dom instanceof SelectableTextInput) {
            if ("number".equalsIgnoreCase(this.getType()) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INPUT_NUMBER_SELECTION_START_END_NULL)) {
                throw Context.reportRuntimeError((String)"Failed to set the 'selectionStart' propertyfrom 'HTMLInputElement': The input element's type ('number') does not support selection.");
            }
            ((SelectableTextInput)((Object)dom)).setSelectionStart(start);
            return;
        }
        throw Context.reportRuntimeError((String)("Failed to set the 'selectionStart' property from 'HTMLInputElement': The input element's type (" + this.getType() + ") does not support selection."));
    }

    @JsxGetter
    public Object getSelectionEnd() {
        HtmlInput dom = this.getDomNodeOrDie();
        if (dom instanceof SelectableTextInput) {
            if ("number".equalsIgnoreCase(this.getType()) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INPUT_NUMBER_SELECTION_START_END_NULL)) {
                return null;
            }
            return ((SelectableTextInput)((Object)dom)).getSelectionEnd();
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLINPUT_FILE_SELECTION_START_END_NULL)) {
            return null;
        }
        throw Context.reportRuntimeError((String)("Failed to read the 'selectionEnd' property from 'HTMLInputElement': The input element's type (" + this.getType() + ") does not support selection."));
    }

    @JsxSetter
    public void setSelectionEnd(int end) {
        HtmlInput dom = this.getDomNodeOrDie();
        if (dom instanceof SelectableTextInput) {
            if ("number".equalsIgnoreCase(this.getType()) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INPUT_NUMBER_SELECTION_START_END_NULL)) {
                throw Context.reportRuntimeError((String)"Failed to set the 'selectionEnd' propertyfrom 'HTMLInputElement': The input element's type ('number') does not support selection.");
            }
            ((SelectableTextInput)((Object)dom)).setSelectionEnd(end);
            return;
        }
        throw Context.reportRuntimeError((String)("Failed to set the 'selectionEnd' property from 'HTMLInputElement': The input element's type (" + this.getType() + ") does not support selection."));
    }

    @JsxGetter
    public int getMaxLength() {
        String attrValue = this.getDomNodeOrDie().getAttribute("maxLength");
        return NumberUtils.toInt((String)attrValue, (int)-1);
    }

    @JsxSetter
    public void setMaxLength(int length) {
        this.getDomNodeOrDie().setMaxLength(length);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public int getMinLength() {
        String attrValue = this.getDomNodeOrDie().getAttribute("minLength");
        return NumberUtils.toInt((String)attrValue, (int)-1);
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public void setMinLength(int length) {
        this.getDomNodeOrDie().setMinLength(length);
    }

    @JsxGetter
    public String getMin() {
        return this.getDomNodeOrDie().getAttributeDirect("min");
    }

    @JsxSetter
    public void setMin(String min) {
        this.getDomNodeOrDie().setAttribute("min", min);
    }

    @JsxGetter
    public String getMax() {
        return this.getDomNodeOrDie().getAttributeDirect("max");
    }

    @JsxSetter
    public void setMax(String max) {
        this.getDomNodeOrDie().setAttribute("max", max);
    }

    @JsxGetter
    public String getStep() {
        return this.getDomNodeOrDie().getAttributeDirect("step");
    }

    @JsxSetter
    public void setStep(String step) {
        this.getDomNodeOrDie().setAttribute("step", step);
    }

    @JsxGetter
    public boolean isReadOnly() {
        return this.getDomNodeOrDie().isReadOnly();
    }

    @JsxSetter
    public void setReadOnly(boolean readOnly) {
        this.getDomNodeOrDie().setReadOnly(readOnly);
    }

    @JsxFunction
    public void setSelectionRange(int start, int end) {
        this.setSelectionStart(start);
        this.setSelectionEnd(end);
    }

    @JsxGetter
    public String getAlt() {
        return this.getDomNodeOrDie().getAttributeDirect("alt");
    }

    @JsxSetter
    public void setAlt(String alt) {
        this.getDomNodeOrDie().setAttribute("alt", alt);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getBorder() {
        return this.getDomNodeOrDie().getAttributeDirect("border");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setBorder(String border) {
        this.getDomNodeOrDie().setAttribute("border", border);
    }

    @JsxGetter
    public String getAlign() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ALIGN_FOR_INPUT_IGNORES_VALUES)) {
            return "";
        }
        return this.getAlign(true);
    }

    @JsxSetter
    public void setAlign(String align) {
        boolean ignoreIfNoError = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ALIGN_FOR_INPUT_IGNORES_VALUES);
        this.setAlign(align, ignoreIfNoError);
    }

    @JsxGetter
    public String getSrc() {
        return this.getDomNodeOrDie().getSrc();
    }

    @JsxSetter
    public void setSrc(String src) {
        this.getDomNodeOrDie().setSrcAttribute(src);
    }

    @Override
    @JsxGetter
    public String getValue() {
        HtmlInput htmlInput = this.getDomNodeOrDie();
        if (htmlInput instanceof HtmlFileInput) {
            File[] files = ((HtmlFileInput)htmlInput).getFiles();
            if (files == null || files.length == 0) {
                return DomElement.ATTRIBUTE_NOT_DEFINED;
            }
            File first = files[0];
            String name = first.getName();
            if (name.isEmpty()) {
                return name;
            }
            return "C:\\fakepath\\" + name;
        }
        if (htmlInput instanceof HtmlNumberInput) {
            HtmlNumberInput htmlNumberInput = (HtmlNumberInput)htmlInput;
            String valueAttr = htmlInput.getAttributeDirect("value");
            if (!valueAttr.isEmpty()) {
                if ("-".equals(valueAttr) || "+".equals(valueAttr)) {
                    return "";
                }
                String val = valueAttr;
                int lastPos = val.length() - 1;
                if (lastPos >= 0 && val.charAt(lastPos) == '.') {
                    if (htmlNumberInput.hasFeature(BrowserVersionFeatures.JS_INPUT_NUMBER_DOT_AT_END_IS_DOUBLE)) {
                        return "";
                    }
                    val = val.substring(0, lastPos);
                }
                try {
                    Double.parseDouble(valueAttr);
                }
                catch (NumberFormatException e) {
                    return "";
                }
            }
        }
        return htmlInput.getAttributeDirect("value");
    }

    @Override
    public String getAttribute(String attributeName, Integer flags) {
        String superAttribute = super.getAttribute(attributeName, flags);
        if ("value".equalsIgnoreCase(attributeName)) {
            if ((superAttribute == null || !superAttribute.isEmpty()) && this.getDefaultValue().isEmpty()) {
                return null;
            }
            if (!"file".equals(this.getType())) {
                return this.getDefaultValue();
            }
        }
        return superAttribute;
    }

    @Override
    public void click() throws IOException {
        HtmlInput domNode = this.getDomNodeOrDie();
        boolean originalState = domNode.isChecked();
        MouseEvent event = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONCLICK_USES_POINTEREVENT) ? new PointerEvent(domNode, "click", false, false, false, 0) : new MouseEvent(domNode, "click", false, false, false, 0);
        domNode.click(event, ((Event)event).isShiftKey(), ((Event)event).isCtrlKey(), ((Event)event).isAltKey(), true);
        boolean newState = domNode.isChecked();
        if (originalState != newState && (domNode instanceof HtmlRadioButtonInput || domNode instanceof HtmlCheckBoxInput)) {
            domNode.fireEvent("change");
        }
    }

    @Override
    protected boolean isEndTagForbidden() {
        return true;
    }

    @JsxGetter
    public boolean isRequired() {
        return this.getDomNodeOrDie().isRequired();
    }

    @JsxSetter
    public void setRequired(boolean required) {
        this.getDomNodeOrDie().setRequired(required);
    }

    @JsxGetter
    public String getSize() {
        return this.getDomNodeOrDie().getSize();
    }

    @JsxSetter
    public void setSize(String size) {
        this.getDomNodeOrDie().setSize(size);
    }

    @JsxGetter
    public String getAccept() {
        return this.getDomNodeOrDie().getAccept();
    }

    @JsxSetter
    public void setAccept(String accept) {
        this.getDomNodeOrDie().setAccept(accept);
    }

    @JsxGetter
    public String getAutocomplete() {
        return this.getDomNodeOrDie().getAutocomplete();
    }

    @JsxSetter
    public void setAutocomplete(String autocomplete) {
        this.getDomNodeOrDie().setAutocomplete(autocomplete);
    }

    @JsxGetter
    public Object getFiles() {
        HtmlInput htmlInput = this.getDomNodeOrDie();
        if (htmlInput instanceof HtmlFileInput) {
            FileList list = new FileList(((HtmlFileInput)htmlInput).getFiles());
            list.setParentScope(this.getParentScope());
            list.setPrototype(this.getPrototype(list.getClass()));
            return list;
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLINPUT_FILES_UNDEFINED)) {
            return Undefined.instance;
        }
        return null;
    }

    @JsxGetter
    public String getPlaceholder() {
        return this.getDomNodeOrDie().getPlaceholder();
    }

    @JsxSetter
    public void setPlaceholder(String placeholder) {
        this.getDomNodeOrDie().setPlaceholder(placeholder);
    }

    @Override
    @JsxGetter
    public int getWidth() {
        String value = this.getDomNodeOrDie().getAttributeDirect("width");
        Integer intValue = HTMLCanvasElement.getValue(value);
        if (intValue != null) {
            return intValue;
        }
        return 0;
    }

    @JsxSetter
    public void setWidth(int width) {
        this.getDomNodeOrDie().setAttribute("width", Integer.toString(width));
    }

    @Override
    @JsxGetter
    public int getHeight() {
        String value = this.getDomNodeOrDie().getAttributeDirect("height");
        Integer intValue = HTMLCanvasElement.getValue(value);
        if (intValue != null) {
            return intValue;
        }
        return 0;
    }

    @JsxSetter
    public void setHeight(int height) {
        this.getDomNodeOrDie().setAttribute("height", Integer.toString(height));
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public AbstractList getLabels() {
        if (this.labels_ == null) {
            this.labels_ = new LabelsHelper(this.getDomNodeOrDie());
        }
        return this.labels_;
    }

    @JsxFunction
    public boolean checkValidity() {
        return this.getDomNodeOrDie().isValid();
    }

    @Override
    @JsxFunction(value={SupportedBrowser.IE})
    public TextRange createTextRange() {
        return super.createTextRange();
    }

    @Override
    @JsxGetter
    public String getName() {
        return super.getName();
    }

    @Override
    @JsxSetter
    public void setName(String newName) {
        super.setName(newName);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public boolean isDisabled() {
        return super.isDisabled();
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
    }

    @Override
    @JsxGetter
    public HTMLFormElement getForm() {
        return super.getForm();
    }
}

