/*
 * Decompiled with CFR 0.152.
 */
package org.wetator;

import org.wetator.util.VersionUtil;

public final class Version {
    static final String WETATOR_JAR_PATTERN = "wetator(-[0-9\\.]*)?(-SNAPSHOT)?.jar";

    public static void main(String[] anArgsArray) {
        System.out.println(Version.getFullProductName());
    }

    public static String getFullProductName() {
        return Version.getProductName() + " Version " + Version.getVersion() + " Build " + Version.getBuild();
    }

    public static String getProductName() {
        return Version.readFromManifest("Application-Name", "Wetator");
    }

    public static String getVersion() {
        String tmpVersion = Version.readFromManifest("Version", "local build");
        return tmpVersion.replaceAll("_", ".");
    }

    public static String getBuild() {
        return Version.readFromManifest("Build", "");
    }

    private Version() {
    }

    private static String readFromManifest(String anAttributeName, String aDefault) {
        return VersionUtil.readAttributeFromJarManifest(WETATOR_JAR_PATTERN, "Application", anAttributeName, aDefault);
    }
}

