/*
 * Decompiled with CFR 0.152.
 */
package org.wetator;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.swing.JWindow;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wetator.Version;
import org.wetator.core.Command;
import org.wetator.core.IScripter;
import org.wetator.exception.InvalidInputException;
import org.wetator.gui.DialogUtil;
import org.wetator.scriptcreator.IScriptCreator;
import org.wetator.scriptcreator.LegacyXMLScriptCreator;
import org.wetator.scriptcreator.WikiTextScriptCreator;
import org.wetator.scriptcreator.XMLScriptCreator;
import org.wetator.scripter.ExcelScripter;
import org.wetator.scripter.LegacyXMLScripter;
import org.wetator.scripter.WikiTextScripter;
import org.wetator.scripter.XMLScripter;

public final class WetatorScriptConverter {
    private static final Logger LOG = LogManager.getLogger(WetatorScriptConverter.class);
    private IScripter scripter;
    private IScriptCreator creator;
    private List<File> inputFiles = new LinkedList<File>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] anArgsArray) {
        System.out.println(Version.getFullProductName());
        System.out.println("    " + com.gargoylesoftware.htmlunit.Version.getProductName() + " " + com.gargoylesoftware.htmlunit.Version.getProductVersion());
        if (null == anArgsArray || anArgsArray.length < 3) {
            System.err.println("Parameters: <scripter> <script creator> <outputDir> (<dtd type> <dtd>)");
            System.err.println("example1: xls xml /Users/me/tests");
            System.err.println("example2: xls xml /Users/me/tests SYSTEM testcase.dtd");
            System.err.println("example1: xls legacy_xml /Users/me/tests");
            System.exit(1);
            return;
        }
        String tmpScripterType = anArgsArray[0];
        String tmpScriptCreatorType = anArgsArray[1];
        String tmpOutputDir = anArgsArray[2];
        System.out.println("Starting converter using scripter '" + tmpScripterType + "', script creator '" + tmpScriptCreatorType + "' and output directory '" + tmpOutputDir + "'.");
        WetatorScriptConverter tmpConverter = new WetatorScriptConverter();
        JWindow tmpWindow = new JWindow();
        try {
            Scripter tmpScripter = Scripter.valueOf(tmpScripterType.toUpperCase(Locale.ROOT));
            IScripter tmpIScripter = tmpScripter.getScripter();
            ScriptCreator tmpScriptCreator = ScriptCreator.valueOf(tmpScriptCreatorType.toUpperCase(Locale.ROOT));
            IScriptCreator tmpCreator = tmpScriptCreator.getScriptCreator();
            tmpCreator.setOutputDir(tmpOutputDir);
            if (tmpCreator instanceof LegacyXMLScriptCreator && anArgsArray.length == 5) {
                String tmpDtd = anArgsArray[3] + " \"" + anArgsArray[4] + "\"";
                LOG.info("Using DTD '" + tmpDtd + "'.");
                ((LegacyXMLScriptCreator)tmpCreator).setDtd(tmpDtd);
            }
            tmpConverter.setScripter(tmpIScripter);
            tmpConverter.setCreator(tmpCreator);
            File[] tmpFiles = DialogUtil.chooseFiles(tmpWindow, null);
            if (null == tmpFiles || tmpFiles.length < 1) {
                System.exit(0);
            }
            for (File tmpFile : tmpFiles) {
                tmpConverter.addTestFile(tmpFile);
            }
            System.out.println("Begin converting...");
            tmpConverter.convert();
            System.out.println("Converting successfully completed.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        finally {
            tmpWindow.dispose();
        }
        System.exit(0);
    }

    private WetatorScriptConverter() {
    }

    public void convert() throws InvalidInputException {
        for (File tmpInputFile : this.inputFiles) {
            System.out.print("    Converting '" + tmpInputFile.getAbsolutePath() + "'...");
            this.scripter.script(tmpInputFile);
            List<Command> tmpCommands = this.scripter.getCommands();
            String tmpFileName = tmpInputFile.getName().substring(0, tmpInputFile.getName().lastIndexOf(46));
            this.creator.setFileName(tmpFileName);
            this.creator.setCommands(tmpCommands);
            this.creator.createScript();
            System.out.println(" done");
        }
    }

    public IScripter getScripter() {
        return this.scripter;
    }

    public void setScripter(IScripter aScripter) {
        this.scripter = aScripter;
    }

    public IScriptCreator getCreator() {
        return this.creator;
    }

    public void setCreator(IScriptCreator aCreator) {
        this.creator = aCreator;
    }

    public void addTestFile(File aFile) throws InvalidInputException {
        if (!aFile.exists()) {
            throw new InvalidInputException("The file '" + aFile.getAbsolutePath() + "' does not exist.");
        }
        this.inputFiles.add(aFile);
    }

    public static enum ScriptCreator {
        LEGACY_XML(new LegacyXMLScriptCreator()),
        XML(new XMLScriptCreator()),
        WETT(new WikiTextScriptCreator());

        private IScriptCreator scriptCreator;

        private ScriptCreator(IScriptCreator aIScriptCreator) {
            this.scriptCreator = aIScriptCreator;
        }

        public IScriptCreator getScriptCreator() {
            return this.scriptCreator;
        }
    }

    public static enum Scripter {
        LEGACY_XML(new LegacyXMLScripter()),
        XML(new XMLScripter()),
        XLS(new ExcelScripter()),
        WETT(new WikiTextScripter());

        private IScripter scripter;

        private Scripter(IScripter aIScripter) {
            this.scripter = aIScripter;
        }

        public IScripter getScripter() {
            return this.scripter;
        }
    }
}

