/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend;

import java.net.URL;
import org.wetator.backend.IControlFinder;
import org.wetator.backend.control.IControl;
import org.wetator.core.searchpattern.ContentPattern;
import org.wetator.exception.ActionException;
import org.wetator.exception.AssertionException;
import org.wetator.exception.BackendException;
import org.wetator.util.SecretString;

public interface IBrowser {
    public IControlFinder getControlFinder() throws BackendException;

    public IControl getFocusedControl() throws BackendException;

    public void close();

    public void startNewSession(BrowserType var1);

    public void endSession();

    public void openUrl(URL var1) throws ActionException;

    public boolean waitForImmediateJobs() throws BackendException;

    public boolean waitForImmediateJobs(long var1) throws BackendException;

    public boolean assertTitleInTimeFrame(ContentPattern var1, long var2) throws AssertionException;

    public boolean assertContentInTimeFrame(ContentPattern var1, long var2) throws AssertionException;

    public void saveCurrentWindowToLog(IControl ... var1);

    public void markControls(IControl ... var1);

    public void goBackInCurrentWindow(int var1) throws ActionException;

    public void closeWindow(SecretString var1) throws ActionException;

    public URL getBookmark(String var1);

    public void saveBookmark(String var1, URL var2);

    public void bookmarkPage(String var1) throws ActionException;

    public void addFailure(AssertionException var1);

    public void addFailure(String var1, Object[] var2, Throwable var3);

    public AssertionException checkAndResetFailures();

    public static enum BrowserType {
        FIREFOX_78("Firefox78", "Firefox_78"),
        FIREFOX("Firefox", "Firefox"),
        INTERNET_EXPLORER("IE11", "IE_11"),
        CHROME("Chrome", "Chrome");

        private String label;
        private String symbol;

        private BrowserType(String aLabel, String aSymbol) {
            this.label = aLabel;
            this.symbol = aSymbol;
        }

        public String getLabel() {
            return this.label;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public static BrowserType getForSymbol(String aSymbol) {
            if (null == aSymbol) {
                return null;
            }
            String tmpSymbol = aSymbol.trim();
            BrowserType tmpFound = null;
            for (BrowserType tmpBrowserType : BrowserType.values()) {
                if (!tmpBrowserType.getSymbol().equalsIgnoreCase(tmpSymbol)) continue;
                tmpFound = tmpBrowserType;
                break;
            }
            return tmpFound;
        }
    }

    public static enum ContentType {
        HTML,
        CSS,
        JAVASCRIPT,
        TEXT,
        XML,
        PDF,
        XLS,
        XLSX,
        DOCX,
        RTF,
        PNG,
        GIF,
        BMP,
        JPEG,
        SVG,
        ZIP,
        OTHER;

    }
}

