/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.wetator.core.WetatorConfiguration;
import org.wetator.exception.InvalidInputException;
import org.wetator.i18n.Messages;
import org.wetator.util.SecretString;

public class WPath {
    private static final String TABLE_COORDINATES_START = "[";
    private static final String TABLE_COORDINATES_END = "]";
    private static final String TABLE_COORDINATES_END_ESCAPED = "\\]";
    private SecretString rawPath;
    private List<SecretString> pathNodes = new ArrayList<SecretString>();
    private List<TableCoordinate> tableCoordinates = new ArrayList<TableCoordinate>();
    private List<TableCoordinate> tableCoordinatesReversed;
    private SecretString lastNode;

    public WPath(SecretString aPathNodes, WetatorConfiguration aConfiguration) throws InvalidInputException {
        if (aPathNodes == null) {
            String tmpMessage = Messages.getMessage("invalidNullWPath", new Object[0]);
            throw new InvalidInputException(tmpMessage);
        }
        this.rawPath = aPathNodes;
        this.parseNodes(aConfiguration.getWPathSeparator());
    }

    public List<SecretString> getPathNodes() {
        return this.pathNodes;
    }

    public List<TableCoordinate> getTableCoordinates() {
        return this.tableCoordinates;
    }

    public List<TableCoordinate> getTableCoordinatesReversed() {
        return this.tableCoordinatesReversed;
    }

    public SecretString getLastNode() {
        return this.lastNode;
    }

    public boolean isEmpty() {
        return this.rawPath.isEmpty();
    }

    public String toString() {
        return this.rawPath.toString();
    }

    private void parseNodes(String aSeparator) throws InvalidInputException {
        List<SecretString> tmpNodes = this.rawPath.split(aSeparator, 92);
        for (SecretString tmpNode : tmpNodes) {
            tmpNode.trim();
        }
        boolean tmpTableCoordinatesFinished = false;
        if (!tmpNodes.isEmpty()) {
            for (SecretString tmpNode : tmpNodes.subList(0, tmpNodes.size() - 1)) {
                if (tmpNode.startsWith(TABLE_COORDINATES_START) && tmpNode.endsWith(TABLE_COORDINATES_END) && !tmpNode.endsWith(TABLE_COORDINATES_END_ESCAPED)) {
                    if (tmpTableCoordinatesFinished) {
                        String tmpMessage = Messages.getMessage("invalidWPath", this.rawPath);
                        throw new InvalidInputException(tmpMessage);
                    }
                    this.tableCoordinates.add(new TableCoordinate(tmpNode));
                    continue;
                }
                if (!tmpTableCoordinatesFinished && !this.tableCoordinates.isEmpty()) {
                    tmpTableCoordinatesFinished = true;
                }
                this.pathNodes.add(tmpNode);
            }
            this.lastNode = tmpNodes.get(tmpNodes.size() - 1);
            if (this.lastNode.startsWith(TABLE_COORDINATES_START) && this.lastNode.endsWith(TABLE_COORDINATES_END) && !this.lastNode.endsWith(TABLE_COORDINATES_END_ESCAPED)) {
                this.tableCoordinates.add(new TableCoordinate(this.lastNode));
                this.lastNode = null;
            }
        }
        this.tableCoordinatesReversed = new ArrayList<TableCoordinate>(this.tableCoordinates);
        Collections.reverse(this.tableCoordinatesReversed);
    }

    public static class TableCoordinate {
        private SecretString coordinateX;
        private SecretString coordinateY;

        public TableCoordinate(SecretString aTableCoordinates) throws InvalidInputException {
            if (!aTableCoordinates.startsWith(WPath.TABLE_COORDINATES_START) || !aTableCoordinates.endsWith(WPath.TABLE_COORDINATES_END)) {
                throw new InvalidInputException(aTableCoordinates.toString() + " is not a valid table coordinate.");
            }
            SecretString tmpTableCoordinates = aTableCoordinates.substring(1, aTableCoordinates.length() - 1);
            if (tmpTableCoordinates.contains(";")) {
                List<SecretString> tmpCoordinates = tmpTableCoordinates.split(";", 92);
                if (tmpCoordinates.size() > 2) {
                    throw new InvalidInputException(aTableCoordinates.toString() + " is not a valid table coordinate.");
                }
                if (tmpCoordinates.get(0).trim().length() > 0) {
                    this.coordinateX = tmpCoordinates.get(0).trim();
                }
                this.coordinateY = tmpCoordinates.get(1).trim();
            } else {
                this.coordinateX = tmpTableCoordinates.trim();
            }
        }

        public SecretString getCoordinateX() {
            return this.coordinateX;
        }

        public SecretString getCoordinateY() {
            return this.coordinateY;
        }

        public String toString() {
            return WPath.TABLE_COORDINATES_START + this.coordinateX + ';' + this.coordinateY + WPath.TABLE_COORDINATES_END;
        }
    }
}

