/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.wetator.backend.control.IControl;

public final class WeightedControlList {
    public static final WeightedControlList EMPTY_LIST = new WeightedControlList();
    private final List<Entry> entries = Collections.synchronizedList(new LinkedList());

    public void add(IControl aControl, FoundType aFoundType, int aDeviation, int aDistance, int aStart, int anIndex) {
        Entry tmpEntry = new Entry();
        tmpEntry.control = aControl;
        tmpEntry.foundType = aFoundType;
        tmpEntry.deviation = aDeviation;
        tmpEntry.distance = aDistance;
        tmpEntry.start = aStart;
        tmpEntry.index = anIndex;
        this.entries.add(tmpEntry);
    }

    public List<Entry> getEntriesSorted() {
        Collections.sort(this.entries, new EntryComperator());
        LinkedList<Entry> tmpResult = new LinkedList<Entry>();
        for (Entry tmpEntry : this.entries) {
            IControl tmpControl = tmpEntry.getControl();
            boolean tmpNotPresent = true;
            for (Entry tmpResultEntry : tmpResult) {
                IControl tmpResultControl = tmpResultEntry.getControl();
                if (!tmpResultControl.hasSameBackendControl(tmpControl)) continue;
                tmpNotPresent = false;
                break;
            }
            if (!tmpNotPresent) continue;
            tmpResult.add(tmpEntry);
        }
        return tmpResult;
    }

    public void addAll(WeightedControlList anOtherWeightedControlList) {
        this.entries.addAll(anOtherWeightedControlList.entries);
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public String toString() {
        return "WeightedControlList " + this.entries;
    }

    private static final class EntryComperator
    implements Comparator<Entry>,
    Serializable {
        private static final long serialVersionUID = 8655421244982375767L;

        private EntryComperator() {
        }

        @Override
        public int compare(Entry anEntry1, Entry anEntry2) {
            int tmpWeightComp = anEntry1.foundType.getValue() - anEntry2.foundType.getValue();
            if (0 == tmpWeightComp) {
                int tmpDeviationComp = anEntry1.deviation - anEntry2.deviation;
                if (0 == tmpDeviationComp) {
                    int tmpDistanceComp = anEntry1.distance - anEntry2.distance;
                    if (0 == tmpDistanceComp) {
                        int tmpStartComp = anEntry1.start - anEntry2.start;
                        if (0 == tmpStartComp) {
                            return anEntry1.index - anEntry2.index;
                        }
                        return tmpStartComp;
                    }
                    return tmpDistanceComp;
                }
                return tmpDeviationComp;
            }
            return tmpWeightComp;
        }
    }

    public static final class Entry {
        private IControl control;
        private FoundType foundType;
        private int deviation;
        private int distance;
        private int start;
        private int index;

        public IControl getControl() {
            return this.control;
        }

        public String toString() {
            StringBuilder tmpResult = new StringBuilder(this.control.getDescribingText()).append(" found by: ").append(this.foundType.toString()).append(" deviation: ").append(Integer.toString(this.deviation)).append(" distance: ").append(Integer.toString(this.distance)).append(" start: ").append(Integer.toString(this.start)).append(" index: ").append(Integer.toString(this.index));
            return tmpResult.toString();
        }
    }

    public static final class FoundType {
        public static final FoundType BY_TITLE_TEXT = new FoundType("BY_TITLE_TEXT", 9900);
        public static final FoundType BY_TEXT = new FoundType("BY_TEXT", 9000);
        public static final FoundType BY_TABLE_COORDINATE = new FoundType("BY_TABLE_COORDINATE", 6000);
        public static final FoundType BY_ARIA_LABEL_ATTRIBUTE = new FoundType("BY_ARIA_LABEL_ATTRIBUTE", 5500);
        public static final FoundType BY_IMG_SRC_ATTRIBUTE = new FoundType("BY_IMG_SRC_ATTRIBUTE", 5000);
        public static final FoundType BY_IMG_ALT_ATTRIBUTE = new FoundType("BY_IMG_ALT_ATTRIBUTE", 5000);
        public static final FoundType BY_IMG_TITLE_ATTRIBUTE = new FoundType("BY_IMG_TITLE_ATTRIBUTE", 5000);
        public static final FoundType BY_INNER_IMG_SRC_ATTRIBUTE = new FoundType("BY_INNER_IMG_SRC_ATTRIBUTE", 4000);
        public static final FoundType BY_INNER_IMG_ALT_ATTRIBUTE = new FoundType("BY_INNER_IMG_ALT_ATTRIBUTE", 4000);
        public static final FoundType BY_INNER_IMG_TITLE_ATTRIBUTE = new FoundType("BY_INNER_IMG_TITLE_ATTRIBUTE", 4000);
        public static final FoundType BY_TITLE_ATTRIBUTE = new FoundType("BY_TITLE_ATTRIBUTE", 3500);
        public static final FoundType BY_LABELING_TEXT = new FoundType("BY_LABELING_TEXT", 3000);
        public static final FoundType BY_PLACEHOLDER = new FoundType("BY_PLACEHOLDER", 2500);
        public static final FoundType BY_LABEL_ELEMENT = new FoundType("BY_LABEL_ELEMENT", 2000);
        public static final FoundType BY_LABEL = new FoundType("BY_LABEL", 2000);
        public static final FoundType BY_NAME = new FoundType("BY_NAME", 1000);
        public static final FoundType BY_INNER_NAME = new FoundType("BY_INNER_NAME", 900);
        public static final FoundType BY_ID = new FoundType("BY_ID", 400);
        private final String name;
        private final int value;

        public FoundType(String aName, FoundType aBaseType, int anOffset) {
            this.name = aName;
            this.value = aBaseType.value + anOffset;
        }

        FoundType(String aName, int aValue) {
            this.name = aName;
            this.value = aValue;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }
    }
}

