/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.DefaultCredentialsProvider;
import com.gargoylesoftware.htmlunit.DialogWindow;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.History;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.RefreshHandler;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.TopLevelWindow;
import com.gargoylesoftware.htmlunit.WaitingRefreshHandler;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebConsole;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowEvent;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.DebuggerImpl;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJob;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJobManager;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.util.WebClientUtils;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.text.BadLocationException;
import net.sourceforge.htmlunit.corejs.javascript.WrappedException;
import net.sourceforge.htmlunit.corejs.javascript.debug.Debugger;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.CredentialsProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.wetator.backend.IBrowser;
import org.wetator.backend.IControlFinder;
import org.wetator.backend.control.IControl;
import org.wetator.backend.htmlunit.HtmlUnitControlRepository;
import org.wetator.backend.htmlunit.HtmlUnitFinderDelegator;
import org.wetator.backend.htmlunit.JavaScriptErrorListener;
import org.wetator.backend.htmlunit.ResponseStore;
import org.wetator.backend.htmlunit.control.HtmlUnitAnchor;
import org.wetator.backend.htmlunit.control.HtmlUnitBaseControl;
import org.wetator.backend.htmlunit.control.HtmlUnitButton;
import org.wetator.backend.htmlunit.control.HtmlUnitImage;
import org.wetator.backend.htmlunit.control.HtmlUnitInputButton;
import org.wetator.backend.htmlunit.control.HtmlUnitInputCheckBox;
import org.wetator.backend.htmlunit.control.HtmlUnitInputFile;
import org.wetator.backend.htmlunit.control.HtmlUnitInputHidden;
import org.wetator.backend.htmlunit.control.HtmlUnitInputImage;
import org.wetator.backend.htmlunit.control.HtmlUnitInputPassword;
import org.wetator.backend.htmlunit.control.HtmlUnitInputRadioButton;
import org.wetator.backend.htmlunit.control.HtmlUnitInputReset;
import org.wetator.backend.htmlunit.control.HtmlUnitInputSubmit;
import org.wetator.backend.htmlunit.control.HtmlUnitInputText;
import org.wetator.backend.htmlunit.control.HtmlUnitOption;
import org.wetator.backend.htmlunit.control.HtmlUnitOptionGroup;
import org.wetator.backend.htmlunit.control.HtmlUnitSelect;
import org.wetator.backend.htmlunit.control.HtmlUnitTextArea;
import org.wetator.backend.htmlunit.util.ContentTypeUtil;
import org.wetator.backend.htmlunit.util.ExceptionUtil;
import org.wetator.backend.htmlunit.util.HtmlPageIndex;
import org.wetator.core.WetatorConfiguration;
import org.wetator.core.WetatorEngine;
import org.wetator.core.searchpattern.ContentPattern;
import org.wetator.core.searchpattern.SearchPattern;
import org.wetator.exception.ActionException;
import org.wetator.exception.AssertionException;
import org.wetator.exception.BackendException;
import org.wetator.exception.ResourceException;
import org.wetator.i18n.Messages;
import org.wetator.util.Assert;
import org.wetator.util.ContentUtil;
import org.wetator.util.NormalizedString;
import org.wetator.util.SecretString;

public final class HtmlUnitBrowser
implements IBrowser {
    private static final Logger LOG = LogManager.getLogger(HtmlUnitBrowser.class);
    private static final int MAX_LENGTH = 4000;
    private WebClient webClient;
    private JavaScriptJobFilter jobFilter;
    private Map<BrowserVersion, ResponseStore> responseStores;
    private WetatorEngine wetatorEngine;
    private List<AssertionException> failures;
    private long jsTimeoutInMillis;
    private Map<String, URL> bookmarks;
    private WeakHashMap<Page, String> savedPages;
    private HtmlUnitControlRepository controlRepository = new HtmlUnitControlRepository();

    public HtmlUnitBrowser(WetatorEngine aWetatorEngine) {
        System.getProperties().put("apache.commons.httpclient.cookiespec", "COMPATIBILITY");
        this.savedPages = new WeakHashMap();
        this.failures = new LinkedList<AssertionException>();
        this.wetatorEngine = aWetatorEngine;
        WetatorConfiguration tmpConfiguration = this.wetatorEngine.getConfiguration();
        this.jsTimeoutInMillis = (long)tmpConfiguration.getJsTimeoutInSeconds() * 1000L;
        this.responseStores = new HashMap<BrowserVersion, ResponseStore>();
        for (IBrowser.BrowserType tmpBrowserType : tmpConfiguration.getBrowserTypes()) {
            BrowserVersion tmpBrowserVersion = this.determineBrowserVersionFor(tmpBrowserType);
            for (Map.Entry<String, String> tmpMapping : tmpConfiguration.getMimeTypes().entrySet()) {
                tmpBrowserVersion.registerUploadMimeType(tmpMapping.getKey(), tmpMapping.getValue());
            }
            ResponseStore tmpStrore = new ResponseStore(tmpConfiguration.getOutputDir(), tmpBrowserType.getLabel(), true);
            this.responseStores.put(tmpBrowserVersion, tmpStrore);
        }
        this.controlRepository.add(HtmlUnitAnchor.class);
        this.controlRepository.add(HtmlUnitButton.class);
        this.controlRepository.add(HtmlUnitImage.class);
        this.controlRepository.add(HtmlUnitInputButton.class);
        this.controlRepository.add(HtmlUnitInputCheckBox.class);
        this.controlRepository.add(HtmlUnitInputFile.class);
        this.controlRepository.add(HtmlUnitInputHidden.class);
        this.controlRepository.add(HtmlUnitInputImage.class);
        this.controlRepository.add(HtmlUnitInputPassword.class);
        this.controlRepository.add(HtmlUnitInputRadioButton.class);
        this.controlRepository.add(HtmlUnitInputReset.class);
        this.controlRepository.add(HtmlUnitInputSubmit.class);
        this.controlRepository.add(HtmlUnitInputText.class);
        this.controlRepository.add(HtmlUnitOption.class);
        this.controlRepository.add(HtmlUnitOptionGroup.class);
        this.controlRepository.add(HtmlUnitSelect.class);
        this.controlRepository.add(HtmlUnitTextArea.class);
        this.controlRepository.addAll(tmpConfiguration.getControls());
    }

    @Override
    public void close() {
        try {
            HtmlUnitFinderDelegator.shutdownThreadPool();
        }
        catch (InterruptedException e) {
            LOG.warn("Could not shutdown the Thread Pool.", (Throwable)e);
        }
    }

    @Override
    public void startNewSession(IBrowser.BrowserType aBrowserType) {
        SecretString tmpNtlmUser;
        SecretString tmpBasicAuthUser;
        Iterator<SearchPattern> tmpPassword;
        String tmpUser;
        this.endSession();
        WetatorConfiguration tmpConfiguration = this.wetatorEngine.getConfiguration();
        this.bookmarks = new HashMap<String, URL>();
        BrowserVersion tmpBrowserVersion = this.determineBrowserVersionFor(aBrowserType);
        DefaultCredentialsProvider tmpCredentialProvider = null;
        String tmpHost = tmpConfiguration.getProxyHost();
        if (StringUtils.isNotEmpty((CharSequence)tmpHost)) {
            LOG.info("Proxy configured");
            LOG.info("Proxy Host: '" + tmpHost + "'");
            int tmpPort = tmpConfiguration.getProxyPort();
            LOG.info("Proxy Port: '" + tmpPort + "'");
            this.webClient = new WebClient(tmpBrowserVersion, tmpHost, tmpPort);
            SecretString tmpProxyUser = tmpConfiguration.getProxyUser();
            if (null != tmpProxyUser && !tmpProxyUser.isEmpty()) {
                tmpUser = tmpProxyUser.getValue();
                LOG.info("Proxy User: '" + tmpUser + "'");
                tmpPassword = tmpConfiguration.getProxyPassword().getValue();
                tmpCredentialProvider = new DefaultCredentialsProvider();
                this.webClient.setCredentialsProvider((CredentialsProvider)tmpCredentialProvider);
                tmpCredentialProvider.addCredentials(tmpUser, (String)((Object)tmpPassword), tmpHost, tmpPort, null);
            } else {
                LOG.info("Proxy no user defined");
            }
            Set<String> tmpNonProxyHosts = tmpConfiguration.getProxyHostsToBypass();
            for (String tmpString : tmpNonProxyHosts) {
                String tmpHostsToProxyBypass = tmpString.trim();
                tmpHostsToProxyBypass = tmpHostsToProxyBypass.replaceAll("\\.", "\\\\.");
                tmpHostsToProxyBypass = tmpHostsToProxyBypass.replaceAll("^\\*", ".*");
                this.webClient.getOptions().getProxyConfig().addHostsToProxyBypass(tmpHostsToProxyBypass);
                LOG.info("Proxy HostsToProxyBypass: '" + tmpHostsToProxyBypass + "'");
            }
        } else {
            this.webClient = new WebClient(tmpBrowserVersion);
        }
        if (null != (tmpBasicAuthUser = tmpConfiguration.getBasicAuthUser()) && !tmpBasicAuthUser.isEmpty()) {
            String tmpUser2 = tmpBasicAuthUser.getValue();
            String tmpPassword2 = tmpConfiguration.getBasicAuthPassword().getValue();
            if (null == tmpCredentialProvider) {
                tmpCredentialProvider = new DefaultCredentialsProvider();
                this.webClient.setCredentialsProvider((CredentialsProvider)tmpCredentialProvider);
            }
            tmpCredentialProvider.addCredentials(tmpUser2, tmpPassword2);
            this.webClient.setCredentialsProvider((CredentialsProvider)tmpCredentialProvider);
            LOG.info("BasicAuth enabled  user '" + tmpUser2 + "'.");
        }
        if (null != (tmpNtlmUser = tmpConfiguration.getNtlmUser()) && !tmpNtlmUser.isEmpty()) {
            tmpUser = tmpNtlmUser.getValue();
            tmpPassword = tmpConfiguration.getNtlmPassword().getValue();
            String tmpWorkstation = tmpConfiguration.getNtlmWorkstation().getValue();
            String tmpDomain = tmpConfiguration.getNtlmDomain().getValue();
            if (null == tmpCredentialProvider) {
                tmpCredentialProvider = new DefaultCredentialsProvider();
                this.webClient.setCredentialsProvider((CredentialsProvider)tmpCredentialProvider);
            }
            tmpCredentialProvider.addNTLMCredentials(tmpUser, (String)((Object)tmpPassword), null, -1, tmpWorkstation, tmpDomain);
            LOG.info("NTLM enabled  user '" + tmpUser + "' workstation '" + tmpWorkstation + "' domain '" + tmpDomain + "'.");
        }
        this.webClient.addWebWindowListener((com.gargoylesoftware.htmlunit.WebWindowListener)new WebWindowListener(this));
        this.webClient.setAttachmentHandler((com.gargoylesoftware.htmlunit.attachment.AttachmentHandler)new AttachmentHandler());
        this.webClient.setAlertHandler((com.gargoylesoftware.htmlunit.AlertHandler)new AlertHandler(this.wetatorEngine));
        this.webClient.getWebConsole().setLogger((WebConsole.Logger)new WebConsoleLogger(this.wetatorEngine));
        this.webClient.setIncorrectnessListener((com.gargoylesoftware.htmlunit.IncorrectnessListener)new IncorrectnessListener(this.wetatorEngine));
        this.webClient.setConfirmHandler((com.gargoylesoftware.htmlunit.ConfirmHandler)new ConfirmHandler(this.wetatorEngine));
        this.webClient.setRefreshHandler((RefreshHandler)new WaitingRefreshHandler());
        this.webClient.getOptions().setJavaScriptEnabled(true);
        this.webClient.getOptions().setThrowExceptionOnScriptError(false);
        this.webClient.setJavaScriptErrorListener((com.gargoylesoftware.htmlunit.javascript.JavaScriptErrorListener)new JavaScriptErrorListener(this));
        Set<SearchPattern> tmpFilters = tmpConfiguration.getJsJobFilterPatterns();
        if (tmpFilters.isEmpty()) {
            this.jobFilter = null;
        } else {
            this.jobFilter = new JavaScriptJobFilter();
            for (SearchPattern tmpSearchPattern : tmpFilters) {
                this.jobFilter.addPattern(tmpSearchPattern);
            }
        }
        this.webClient.setActiveXObjectMap(tmpConfiguration.getBrowserActiveXObjects());
        this.webClient.addRequestHeader("Accept-Language", tmpConfiguration.getAcceptLanaguage());
        this.webClient.getOptions().setUseInsecureSSL(true);
        this.webClient.getOptions().setTimeout(tmpConfiguration.getHttpTimeoutInSeconds() * 1000);
        if (tmpConfiguration.isDebugLoggingEnabled()) {
            HtmlUnitContextFactory tmpContextFactory = ((JavaScriptEngine)this.webClient.getJavaScriptEngine()).getContextFactory();
            tmpContextFactory.setDebugger((Debugger)new DebuggerImpl());
        }
        if (tmpConfiguration.startJsDebugger()) {
            WebClientUtils.attachVisualDebugger((WebClient)this.webClient);
        }
    }

    @Override
    public void endSession() {
        if (null != this.webClient) {
            try {
                this.webClient.setOnbeforeunloadHandler(null);
                this.webClient.close();
            }
            catch (ScriptException e) {
                LOG.warn("Could not close previous window.", (Throwable)e);
            }
        }
    }

    @Override
    public void openUrl(URL aUrl) throws ActionException {
        try {
            this.webClient.getPage(aUrl);
            this.waitForImmediateJobs();
        }
        catch (ScriptException e) {
            this.addFailure("javascriptError", new String[]{e.getMessage()}, e);
        }
        catch (WrappedException e) {
            Exception tmpScriptException = ExceptionUtil.getScriptExceptionCauseIfPossible(e);
            this.addFailure("javascriptError", new String[]{tmpScriptException.getMessage()}, tmpScriptException);
        }
        catch (FailingHttpStatusCodeException e) {
            String tmpMessage = Messages.getMessage("openServerError", aUrl, e.getMessage());
            throw new ActionException(tmpMessage, e);
        }
        catch (UnknownHostException e) {
            String tmpMessage = Messages.getMessage("unknownHostError", aUrl, e.getMessage());
            throw new ActionException(tmpMessage, e);
        }
        catch (BackendException e) {
            String tmpMessage = Messages.getMessage("openBackendError", e.getMessage());
            throw new ActionException(tmpMessage, e);
        }
        catch (Throwable e) {
            LOG.error("OpenUrl '" + aUrl.toExternalForm() + "' fails. " + e.getMessage());
            String tmpMessage = Messages.getMessage("openServerError", aUrl, e.getMessage());
            throw new ActionException(tmpMessage, e);
        }
    }

    public void chooseOkOnNextConfirmFor(ContentPattern aMessagePattern) {
        ConfirmHandler tmpHandler = (ConfirmHandler)this.webClient.getConfirmHandler();
        tmpHandler.chooseOkOnNextConfirmFor(aMessagePattern);
    }

    public void chooseCancelOnNextConfirmFor(ContentPattern aMessagePattern) {
        ConfirmHandler tmpHandler = (ConfirmHandler)this.webClient.getConfirmHandler();
        tmpHandler.chooseCancelOnNextConfirmFor(aMessagePattern);
    }

    @Override
    public void closeWindow(SecretString aWindowName) throws ActionException {
        List tmpWebWindows = this.webClient.getWebWindows();
        if (tmpWebWindows.isEmpty()) {
            String tmpMessage = Messages.getMessage("noWindowToClose", new Object[0]);
            throw new ActionException(tmpMessage);
        }
        if (null == aWindowName || aWindowName.isEmpty()) {
            for (int i = tmpWebWindows.size() - 1; i >= 0; --i) {
                WebWindow tmpWebWindow = (WebWindow)tmpWebWindows.get(i);
                if (tmpWebWindow instanceof TopLevelWindow) {
                    this.wetatorEngine.informListenersInfo("closeWindow", tmpWebWindow.getName());
                    ((TopLevelWindow)tmpWebWindow).close();
                    return;
                }
                if (!(tmpWebWindow instanceof DialogWindow)) continue;
                this.wetatorEngine.informListenersInfo("closeDialogWindow", tmpWebWindow.getName());
                ((DialogWindow)tmpWebWindow).close();
                return;
            }
            String tmpMessage = Messages.getMessage("noWindowToClose", new Object[0]);
            throw new ActionException(tmpMessage);
        }
        SearchPattern tmpWindowNamePattern = aWindowName.getSearchPattern();
        for (int i = tmpWebWindows.size() - 1; i > 0; --i) {
            WebWindow tmpWebWindow = (WebWindow)tmpWebWindows.get(i);
            String tmpWindowName = tmpWebWindow.getName();
            if (!tmpWindowNamePattern.matches(tmpWindowName)) continue;
            if (tmpWebWindow instanceof TopLevelWindow) {
                this.wetatorEngine.informListenersInfo("closeWindow", tmpWindowName);
                ((TopLevelWindow)tmpWebWindow).close();
                return;
            }
            if (!(tmpWebWindow instanceof DialogWindow)) continue;
            this.wetatorEngine.informListenersInfo("closeDialogWindow", tmpWindowName);
            ((DialogWindow)tmpWebWindow).close();
            return;
        }
        String tmpMessage = Messages.getMessage("noWindowByNameToClose", aWindowName);
        throw new ActionException(tmpMessage);
    }

    @Override
    public void goBackInCurrentWindow(int aSteps) throws ActionException {
        WebWindow tmpCurrentWindow = this.webClient.getCurrentWindow();
        if (null == tmpCurrentWindow) {
            String tmpMessage = Messages.getMessage("noWebWindow", new Object[0]);
            throw new ActionException(tmpMessage);
        }
        History tmpHistory = (tmpCurrentWindow = tmpCurrentWindow.getTopWindow()).getHistory();
        int tmpIndexPos = tmpHistory.getIndex() - aSteps;
        if (tmpIndexPos >= tmpHistory.getLength() || tmpIndexPos < 0) {
            String tmpMessage = Messages.getMessage("outsideHistory", aSteps, tmpIndexPos, tmpHistory.getLength());
            throw new ActionException(tmpMessage);
        }
        try {
            tmpHistory.go(-1 * aSteps);
        }
        catch (IOException e) {
            String tmpMessage = Messages.getMessage("historyFailed", e.getMessage());
            throw new ActionException(tmpMessage);
        }
    }

    @Override
    public void saveCurrentWindowToLog(IControl ... aControls) {
        WebWindow tmpCurrentWindow = this.webClient.getCurrentWindow();
        if (null != tmpCurrentWindow) {
            try {
                tmpCurrentWindow = tmpCurrentWindow.getTopWindow();
                Page tmpPage = tmpCurrentWindow.getEnclosedPage();
                if (null != tmpPage) {
                    ResponseStore tmpResponseStore = this.getResponseStore(this.webClient.getBrowserVersion());
                    String tmpPageFile = tmpResponseStore.storePage(this.webClient, tmpPage);
                    this.savedPages.put(tmpPage, tmpPageFile);
                    StringBuilder tmpParam = new StringBuilder();
                    if (null != aControls) {
                        String tmpDelim = "";
                        for (IControl tmpControl : aControls) {
                            String tmpSelector;
                            HtmlUnitBaseControl tmpHtmlUnitControl = (HtmlUnitBaseControl)tmpControl;
                            if (!tmpHtmlUnitControl.isPartOf(tmpPage) || null == (tmpSelector = tmpControl.getUniqueSelector())) continue;
                            tmpParam.append("highlight=");
                            tmpParam.append(URLEncoder.encode(tmpControl.getUniqueSelector(), "ASCII"));
                            tmpParam.append(tmpDelim);
                            tmpDelim = "&";
                        }
                    }
                    if (tmpParam.length() > 0) {
                        tmpPageFile = tmpPageFile + '?' + tmpParam;
                    }
                    this.wetatorEngine.informListenersResponseStored(tmpPageFile);
                }
            }
            catch (ResourceException e) {
                LOG.warn("Saving page failed!", (Throwable)e);
            }
            catch (Throwable e) {
                LOG.fatal("Problem with window handling. Saving page failed!", e);
            }
        }
    }

    @Override
    public void markControls(IControl ... aControls) {
        WebWindow tmpCurrentWindow = this.webClient.getCurrentWindow();
        if (null != tmpCurrentWindow) {
            try {
                String tmpPageFile;
                tmpCurrentWindow = tmpCurrentWindow.getTopWindow();
                Page tmpPage = tmpCurrentWindow.getEnclosedPage();
                if (null != tmpPage && null != (tmpPageFile = this.savedPages.get(tmpPage))) {
                    StringBuilder tmpParam = new StringBuilder();
                    if (null != aControls) {
                        String tmpDelim = "";
                        for (IControl tmpControl : aControls) {
                            tmpParam.append("highlight=");
                            tmpParam.append(tmpDelim);
                            tmpParam.append(URLEncoder.encode(tmpControl.getUniqueSelector(), "ASCII"));
                            tmpDelim = "&";
                        }
                    }
                    if (tmpParam.length() > 0) {
                        tmpPageFile = tmpPageFile + '?' + tmpParam;
                    }
                    this.wetatorEngine.informListenersHighlightedResponse(tmpPageFile);
                }
            }
            catch (ResourceException e) {
                LOG.warn("Saving page failed!", (Throwable)e);
            }
            catch (Throwable e) {
                LOG.fatal("Problem with window handling. Saving page failed!", e);
            }
        }
    }

    private ResponseStore getResponseStore(BrowserVersion aBrowserVersion) {
        return this.responseStores.get(aBrowserVersion);
    }

    private Page getCurrentPage() throws BackendException {
        WebWindow tmpWebWindow = this.webClient.getCurrentWindow();
        if (null == tmpWebWindow) {
            String tmpMessage = Messages.getMessage("noWebWindow", new Object[0]);
            throw new BackendException(tmpMessage);
        }
        Page tmpPage = (tmpWebWindow = tmpWebWindow.getTopWindow()).getEnclosedPage();
        if (null == tmpPage) {
            String tmpMessage = Messages.getMessage("noPageInWebWindow", new Object[0]);
            throw new BackendException(tmpMessage);
        }
        return tmpPage;
    }

    private BrowserVersion determineBrowserVersionFor(IBrowser.BrowserType aBrowserType) {
        if (IBrowser.BrowserType.FIREFOX_78 == aBrowserType) {
            return BrowserVersion.FIREFOX_78;
        }
        if (IBrowser.BrowserType.FIREFOX == aBrowserType) {
            return BrowserVersion.FIREFOX;
        }
        if (IBrowser.BrowserType.INTERNET_EXPLORER == aBrowserType) {
            return BrowserVersion.INTERNET_EXPLORER;
        }
        if (IBrowser.BrowserType.CHROME == aBrowserType) {
            return BrowserVersion.CHROME;
        }
        return BrowserVersion.FIREFOX_78;
    }

    public HtmlPage getCurrentHtmlPage() throws BackendException {
        Page tmpPage = this.getCurrentPage();
        if (tmpPage.isHtmlPage()) {
            return (HtmlPage)tmpPage;
        }
        String tmpMessage = Messages.getMessage("noHtmlPage", tmpPage.getClass());
        throw new BackendException(tmpMessage);
    }

    @Override
    public IControlFinder getControlFinder() throws BackendException {
        HtmlPage tmpHtmlPage = this.getCurrentHtmlPage();
        return new HtmlUnitFinderDelegator(tmpHtmlPage, this.controlRepository);
    }

    @Override
    public IControl getFocusedControl() throws BackendException {
        HtmlElement tmpHtmlElement;
        Class<HtmlUnitBaseControl<?>> tmpControlClass;
        DomElement tmpDomElement = this.getCurrentHtmlPage().getFocusedElement();
        if (tmpDomElement instanceof HtmlElement && (tmpControlClass = this.controlRepository.getForHtmlElement(tmpHtmlElement = (HtmlElement)tmpDomElement)) != null) {
            try {
                return tmpControlClass.getConstructor(tmpHtmlElement.getClass()).newInstance(tmpHtmlElement);
            }
            catch (Exception e) {
                this.wetatorEngine.informListenersWarn("createFocusedControlError", (Object[])new String[]{tmpControlClass.getName(), tmpHtmlElement.getClass().getName()}, e);
            }
        }
        return null;
    }

    @Override
    public boolean waitForImmediateJobs() throws BackendException {
        return this.waitForImmediateJobs(this.jsTimeoutInMillis);
    }

    @Override
    public boolean waitForImmediateJobs(long aTimeoutInMillis) throws BackendException {
        boolean tmpPendingJobs = false;
        Page tmpPage = this.getCurrentPage();
        long tmpEndTime = System.currentTimeMillis() + aTimeoutInMillis;
        if (tmpPage.isHtmlPage()) {
            long tmpNow;
            while ((tmpNow = System.currentTimeMillis()) < tmpEndTime) {
                HtmlPage tmpHtmlPage = (HtmlPage)tmpPage;
                tmpPendingJobs = this.areJobsPendig(tmpHtmlPage, tmpEndTime - tmpNow);
                if (tmpPendingJobs) continue;
                if (tmpPage == this.getCurrentPage() || !(tmpPage = this.getCurrentPage()).isHtmlPage()) break;
                tmpEndTime = System.currentTimeMillis() + aTimeoutInMillis;
            }
        }
        Window tmpWin = (Window)tmpPage.getEnclosingWindow().getTopWindow().getScriptableObject();
        long tmpTimeout = Math.max(1000L, tmpEndTime - System.currentTimeMillis());
        tmpEndTime = System.currentTimeMillis() + tmpTimeout;
        int tmpPendingAnimationFrames = tmpWin.animateAnimationsFrames();
        while (tmpPendingAnimationFrames > 0 && System.currentTimeMillis() < tmpEndTime) {
            tmpPendingAnimationFrames = tmpWin.animateAnimationsFrames();
        }
        if (tmpPendingAnimationFrames > 0) {
            this.wetatorEngine.informListenersWarn("stillAnimataionFramesPending", new Object[]{(double)tmpTimeout / 1000.0, tmpPendingAnimationFrames}, (String)null);
        }
        if (tmpPendingJobs && tmpPage.isHtmlPage()) {
            this.wetatorEngine.informListenersWarn("stillJobsPending", new Object[]{(double)aTimeoutInMillis / 1000.0}, ((HtmlPage)tmpPage).getEnclosingWindow().getJobManager().jobStatusDump((JavaScriptJobManager.JavaScriptJobFilter)this.jobFilter));
            return true;
        }
        return false;
    }

    private boolean areJobsPendig(HtmlPage aHtmlPage, long anDuration) {
        JavaScriptJobManager tmpJobManager = aHtmlPage.getEnclosingWindow().getJobManager();
        int tmpJobCount = tmpJobManager.waitForJobsStartingBefore(anDuration, (JavaScriptJobManager.JavaScriptJobFilter)this.jobFilter);
        if (tmpJobCount > 0) {
            return true;
        }
        for (FrameWindow tmpFrameWindow : aHtmlPage.getFrames()) {
            Page tmpPage = tmpFrameWindow.getEnclosedPage();
            if (!tmpPage.isHtmlPage() || !this.areJobsPendig((HtmlPage)tmpPage, anDuration)) continue;
            return true;
        }
        return false;
    }

    private int areJobsActive(HtmlPage aHtmlPage) {
        JavaScriptJobManager tmpJobManager = aHtmlPage.getEnclosingWindow().getJobManager();
        int tmpJobCount = tmpJobManager.getJobCount((JavaScriptJobManager.JavaScriptJobFilter)this.jobFilter);
        if (tmpJobCount > 0) {
            return tmpJobCount;
        }
        for (FrameWindow tmpFrameWindow : aHtmlPage.getFrames()) {
            Page tmpPage = tmpFrameWindow.getEnclosedPage();
            if (!tmpPage.isHtmlPage() || (tmpJobCount = this.areJobsActive((HtmlPage)tmpFrameWindow.getEnclosedPage())) <= 0) continue;
            return tmpJobCount;
        }
        return 0;
    }

    @Override
    public boolean assertTitleInTimeFrame(ContentPattern aTitleToWaitFor, long aTimeoutInSeconds) throws AssertionException {
        long tmpWaitTime = Math.max(this.jsTimeoutInMillis, aTimeoutInSeconds * 1000L);
        boolean tmpPageChanged = false;
        try {
            HtmlPage tmpHtmlPage;
            Page tmpPage;
            long tmpEndTime = System.currentTimeMillis() + tmpWaitTime;
            while (System.currentTimeMillis() < tmpEndTime && (tmpPage = this.getCurrentPage()).isHtmlPage()) {
                tmpHtmlPage = (HtmlPage)tmpPage;
                String tmpCurrentTitle = tmpHtmlPage.getTitleText();
                try {
                    aTitleToWaitFor.matches(tmpCurrentTitle, 4000);
                    int tmpJobCount = this.areJobsActive(tmpHtmlPage);
                    if (tmpJobCount > 0) {
                        this.wetatorEngine.informListenersWarn("stillJobsActive", new Object[]{(double)this.jsTimeoutInMillis / 1000.0, tmpJobCount}, ((HtmlPage)tmpPage).getEnclosingWindow().getJobManager().jobStatusDump((JavaScriptJobManager.JavaScriptJobFilter)this.jobFilter));
                    }
                    return tmpPageChanged;
                }
                catch (AssertionException tmpJobCount) {
                    tmpPageChanged = true;
                    if (this.areJobsPendig(tmpHtmlPage, 1L)) {
                        if (tmpPage == this.getCurrentPage()) continue;
                        tmpEndTime = Math.max(tmpEndTime, System.currentTimeMillis() + this.jsTimeoutInMillis);
                        continue;
                    }
                    if (tmpPage == this.getCurrentPage()) break;
                    tmpEndTime = Math.max(tmpEndTime, System.currentTimeMillis() + this.jsTimeoutInMillis);
                }
            }
            if ((tmpPage = this.getCurrentPage()).isHtmlPage()) {
                tmpHtmlPage = (HtmlPage)tmpPage;
                int tmpJobCount = this.areJobsActive(tmpHtmlPage);
                if (tmpJobCount > 0) {
                    this.wetatorEngine.informListenersWarn("stillJobsActive", new Object[]{(double)this.jsTimeoutInMillis / 1000.0, tmpJobCount}, ((HtmlPage)tmpPage).getEnclosingWindow().getJobManager().jobStatusDump((JavaScriptJobManager.JavaScriptJobFilter)this.jobFilter));
                }
                String tmpCurrentTitle = tmpHtmlPage.getTitleText();
                aTitleToWaitFor.matches(tmpCurrentTitle, 4000);
            }
            IBrowser.ContentType tmpContentType = ContentTypeUtil.getContentType(tmpPage);
            WebResponse tmpResponse = tmpPage.getWebResponse();
            if (IBrowser.ContentType.PDF == tmpContentType) {
                try {
                    String tmpNormalizedTitle = ContentUtil.getPdfTitleAsString(tmpResponse.getContentAsStream());
                    aTitleToWaitFor.matches(tmpNormalizedTitle, 4000);
                    return tmpPageChanged;
                }
                catch (IOException e) {
                    Assert.fail("pdfConversionToTextFailed", e.getMessage());
                    return tmpPageChanged;
                }
            }
            Assert.fail("assertTitleUnsupportedContent", new Object[]{tmpContentType});
        }
        catch (BackendException e) {
            String tmpMessage = Messages.getMessage("browserBackendError", e.getMessage());
            throw new AssertionException(tmpMessage, e);
        }
        return tmpPageChanged;
    }

    @Override
    public boolean assertContentInTimeFrame(ContentPattern aContentToWaitFor, long aTimeoutInSeconds) throws AssertionException {
        long tmpWaitTime = Math.max(this.jsTimeoutInMillis, aTimeoutInSeconds * 1000L);
        boolean tmpPageChanged = false;
        try {
            String tmpNormalizedContent;
            HtmlPage tmpHtmlPage;
            Page tmpPage;
            long tmpEndTime = System.currentTimeMillis() + tmpWaitTime;
            while (System.currentTimeMillis() < tmpEndTime && (tmpPage = this.getCurrentPage()).isHtmlPage()) {
                tmpHtmlPage = (HtmlPage)tmpPage;
                try {
                    tmpNormalizedContent = new HtmlPageIndex(tmpHtmlPage).getText();
                    try {
                        aContentToWaitFor.matches(tmpNormalizedContent, 4000);
                        int tmpJobCount = this.areJobsActive(tmpHtmlPage);
                        if (tmpJobCount > 0) {
                            this.wetatorEngine.informListenersWarn("stillJobsActive", new Object[]{(double)this.jsTimeoutInMillis / 1000.0, tmpJobCount}, ((HtmlPage)tmpPage).getEnclosingWindow().getJobManager().jobStatusDump((JavaScriptJobManager.JavaScriptJobFilter)this.jobFilter));
                        }
                        return tmpPageChanged;
                    }
                    catch (AssertionException tmpJobCount) {
                    }
                }
                catch (IllegalStateException e) {
                    if (this.areJobsActive(tmpHtmlPage) > 0) {
                        throw e;
                    }
                    this.wetatorEngine.informListenersWarn("pageIndexFailed", (Object[])new String[]{e.getMessage()}, e);
                }
                tmpPageChanged = true;
                if (this.areJobsPendig(tmpHtmlPage, 1L)) {
                    if (tmpPage == this.getCurrentPage()) continue;
                    tmpEndTime = Math.max(tmpEndTime, System.currentTimeMillis() + this.jsTimeoutInMillis);
                    continue;
                }
                if (tmpPage == this.getCurrentPage()) break;
                tmpEndTime = Math.max(tmpEndTime, System.currentTimeMillis() + this.jsTimeoutInMillis);
            }
            if ((tmpPage = this.getCurrentPage()).isHtmlPage()) {
                tmpHtmlPage = (HtmlPage)tmpPage;
                int tmpJobCount = this.areJobsActive(tmpHtmlPage);
                if (tmpJobCount > 0) {
                    this.wetatorEngine.informListenersWarn("stillJobsActive", new Object[]{(double)this.jsTimeoutInMillis / 1000.0, tmpJobCount}, ((HtmlPage)tmpPage).getEnclosingWindow().getJobManager().jobStatusDump((JavaScriptJobManager.JavaScriptJobFilter)this.jobFilter));
                }
                String tmpNormalizedContent2 = new HtmlPageIndex(tmpHtmlPage).getText();
                this.matchesWithLog(aContentToWaitFor, tmpNormalizedContent2);
                return tmpPageChanged;
            }
            if (tmpPage instanceof XmlPage) {
                XmlPage tmpXmlPage = (XmlPage)tmpPage;
                String tmpXmlContent = tmpXmlPage.getWebResponse().getContentAsString();
                String tmpNormalizedContent3 = new NormalizedString(tmpXmlContent).toString();
                this.matchesWithLog(aContentToWaitFor, tmpNormalizedContent3);
                return tmpPageChanged;
            }
            if (tmpPage instanceof TextPage) {
                TextPage tmpTextPage = (TextPage)tmpPage;
                tmpNormalizedContent = tmpTextPage.getContent();
                this.matchesWithLog(aContentToWaitFor, new NormalizedString(tmpNormalizedContent).toString());
                return tmpPageChanged;
            }
            IBrowser.ContentType tmpContentType = ContentTypeUtil.getContentType(tmpPage);
            WebResponse tmpResponse = tmpPage.getWebResponse();
            if (IBrowser.ContentType.PDF == tmpContentType) {
                try {
                    String tmpNormalizedContent4 = ContentUtil.getPdfContentAsString(tmpResponse.getContentAsStream(), 4000);
                    this.matchesWithLog(aContentToWaitFor, tmpNormalizedContent4);
                    return tmpPageChanged;
                }
                catch (IOException e) {
                    Assert.fail("pdfConversionToTextFailed", e.getMessage());
                    return tmpPageChanged;
                }
            }
            if (IBrowser.ContentType.XLS == tmpContentType || IBrowser.ContentType.XLSX == tmpContentType) {
                String tmpNormalizedContent5 = "";
                try {
                    String tmpAcceptLangHeader = (String)tmpPage.getWebResponse().getWebRequest().getAdditionalHeaders().get("Accept-Language");
                    Locale tmpLocale = ContentUtil.determineLocaleFromRequestHeader(tmpAcceptLangHeader);
                    tmpNormalizedContent5 = ContentUtil.getExcelContentAsString(tmpResponse.getContentAsStream(), tmpLocale, 4000);
                }
                catch (IOException | InvalidFormatException e) {
                    try {
                        tmpNormalizedContent5 = ContentUtil.getTxtContentAsString(tmpResponse.getContentAsStream(), tmpResponse.getContentCharset(), 4000);
                        if (ContentUtil.isTxt(tmpNormalizedContent5)) {
                            this.wetatorEngine.informListenersWarn("xlsConversionToTextFailed", (Object[])new String[]{e.getMessage()}, e);
                            this.matchesWithLog(aContentToWaitFor, tmpNormalizedContent5);
                            return tmpPageChanged;
                        }
                    }
                    catch (IOException eAsString) {
                        Assert.fail("xlsConversionToTextFailed", eAsString.getMessage());
                    }
                    Assert.fail("xlsConversionToTextFailed", e.getMessage());
                }
                this.matchesWithLog(aContentToWaitFor, tmpNormalizedContent5);
                return tmpPageChanged;
            }
            if (IBrowser.ContentType.DOCX == tmpContentType) {
                try {
                    String tmpNormalizedContent6 = ContentUtil.getWordContentAsString(tmpResponse.getContentAsStream(), 4000);
                    this.matchesWithLog(aContentToWaitFor, tmpNormalizedContent6);
                    return tmpPageChanged;
                }
                catch (IOException | InvalidFormatException e) {
                    Assert.fail("docConversionToTextFailed", e.getMessage());
                    return tmpPageChanged;
                }
            }
            if (IBrowser.ContentType.RTF == tmpContentType) {
                try {
                    String tmpNormalizedContent7 = ContentUtil.getRtfContentAsString(tmpResponse.getContentAsStream(), 4000);
                    this.matchesWithLog(aContentToWaitFor, tmpNormalizedContent7);
                    return tmpPageChanged;
                }
                catch (IOException | BadLocationException e) {
                    Assert.fail("rtfConversionToTextFailed", e.getMessage());
                    return tmpPageChanged;
                }
            }
            if (IBrowser.ContentType.TEXT == tmpContentType) {
                try {
                    String tmpNormalizedContent8 = ContentUtil.getTxtContentAsString(tmpResponse.getContentAsStream(), tmpResponse.getContentCharset(), 4000);
                    this.matchesWithLog(aContentToWaitFor, tmpNormalizedContent8);
                    return tmpPageChanged;
                }
                catch (IOException e) {
                    Assert.fail("txtConversionToTextFailed", e.getMessage());
                    return tmpPageChanged;
                }
            }
            if (IBrowser.ContentType.ZIP == tmpContentType) {
                try {
                    String tmpAcceptLangHeader = (String)tmpPage.getWebResponse().getWebRequest().getAdditionalHeaders().get("Accept-Language");
                    Locale tmpLocale = ContentUtil.determineLocaleFromRequestHeader(tmpAcceptLangHeader);
                    String tmpNormalizedContent9 = ContentUtil.getZipContentAsString(tmpResponse.getContentAsStream(), tmpResponse.getContentCharset(), tmpLocale, 4000);
                    this.matchesWithLog(aContentToWaitFor, tmpNormalizedContent9);
                    return tmpPageChanged;
                }
                catch (IOException e) {
                    Assert.fail("zipConversionToTextFailed", e.getMessage());
                    return tmpPageChanged;
                }
            }
            Charset tmpCharset = tmpResponse.getContentCharset();
            this.wetatorEngine.informListenersInfo("unsupportedPageType", tmpPage.getWebResponse().getContentType(), tmpCharset.name());
            try {
                String tmpNormalizedContent10 = ContentUtil.getTxtContentAsString(tmpResponse.getContentAsStream(), tmpCharset, 4000);
                this.matchesWithLog(aContentToWaitFor, tmpNormalizedContent10);
                return tmpPageChanged;
            }
            catch (IOException e) {
                Assert.fail("txtConversionToTextFailed", e.getMessage());
                return tmpPageChanged;
            }
        }
        catch (BackendException e) {
            String tmpMessage = Messages.getMessage("browserBackendError", e.getMessage());
            throw new AssertionException(tmpMessage, e);
        }
    }

    private void matchesWithLog(ContentPattern aContentToWaitFor, String aContent) throws AssertionException {
        try {
            aContentToWaitFor.matches(aContent, 4000);
        }
        catch (AssertionException e) {
            if (aContent.length() > 4000) {
                String tmpPageFile = this.getResponseStore(this.webClient.getBrowserVersion()).storeTextContent(aContent);
                this.wetatorEngine.informListenersResponseStored(tmpPageFile);
            }
            throw e;
        }
    }

    @Override
    public void addFailure(String aMessageKey, Object[] aParameters, Throwable aCause) {
        String tmpMessage = Messages.getMessage(aMessageKey, aParameters);
        AssertionException tmpFailure = new AssertionException(tmpMessage, aCause);
        this.addFailure(tmpFailure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFailure(AssertionException aFailure) {
        List<AssertionException> list = this.failures;
        synchronized (list) {
            this.failures.add(aFailure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssertionException checkAndResetFailures() {
        List<AssertionException> list = this.failures;
        synchronized (list) {
            if (this.failures.isEmpty()) {
                return null;
            }
            AssertionException tmpResult = this.failures.get(0);
            for (AssertionException tmpException : this.failures) {
                Throwable tmpCause = tmpException.getCause();
                this.wetatorEngine.informListenersWarn("pageError", (Object[])new String[]{tmpException.getMessage()}, tmpCause);
            }
            this.failures.clear();
            return tmpResult;
        }
    }

    @Override
    public URL getBookmark(String aBookmarkName) {
        return this.bookmarks.get(aBookmarkName);
    }

    @Override
    public void saveBookmark(String aBookmarkName, URL aBookmarkUrl) {
        this.bookmarks.put(aBookmarkName, aBookmarkUrl);
    }

    @Override
    public void bookmarkPage(String aBookmarkName) throws ActionException {
        try {
            URL tmpUrl = this.getCurrentPage().getWebResponse().getWebRequest().getUrl();
            this.saveBookmark(aBookmarkName, tmpUrl);
        }
        catch (BackendException e) {
            String tmpMessage = Messages.getMessage("browserBackendError", e.getMessage());
            throw new ActionException(tmpMessage, e);
        }
    }

    public static final class JavaScriptJobFilter
    implements JavaScriptJobManager.JavaScriptJobFilter {
        private static final Logger LOG = LogManager.getLogger(JavaScriptJobFilter.class);
        private List<SearchPattern> patterns = new ArrayList<SearchPattern>();
        private boolean isDebugEnabled;

        public void addPattern(SearchPattern aPattern) {
            this.patterns.add(aPattern);
        }

        public boolean passes(JavaScriptJob aJob) {
            String tmpJob = aJob.toString().replace("\n", "").replace("\r", "");
            for (SearchPattern tmpPattern : this.patterns) {
                if (!tmpPattern.matches(tmpJob)) continue;
                if (this.isDebugEnabled && LOG.isDebugEnabled()) {
                    LOG.debug("JsJob filtered out: '" + tmpJob + "'");
                }
                return false;
            }
            return true;
        }
    }

    public static final class WebWindowListener
    implements com.gargoylesoftware.htmlunit.WebWindowListener {
        private HtmlUnitBrowser htmlUnitBrowser;

        public WebWindowListener(HtmlUnitBrowser anHtmlUnitBrowser) {
            this.htmlUnitBrowser = anHtmlUnitBrowser;
        }

        public void webWindowOpened(WebWindowEvent anEvent) {
            LOG.debug("webWindowOpened");
        }

        public void webWindowClosed(WebWindowEvent anEvent) {
            Page tmpPage = anEvent.getWebWindow().getEnclosedPage();
            if (null == tmpPage) {
                LOG.debug("webWindowClosed: (page null)");
            } else {
                this.htmlUnitBrowser.savedPages.remove(tmpPage);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("webWindowClosed: (url '" + anEvent.getWebWindow().getEnclosedPage().getWebResponse().getWebRequest().getUrl() + "')");
                }
            }
        }

        public void webWindowContentChanged(WebWindowEvent anEvent) {
            LOG.debug("webWindowContentChanged");
            if (null != anEvent.getOldPage()) {
                this.htmlUnitBrowser.savedPages.remove(anEvent.getOldPage());
            }
        }
    }

    public static class IncorrectnessListener
    implements com.gargoylesoftware.htmlunit.IncorrectnessListener {
        private WetatorEngine wetatorEngine;

        public IncorrectnessListener(WetatorEngine aWetatorEngine) {
            this.wetatorEngine = aWetatorEngine;
        }

        public void notify(String aMessage, Object anOrigin) {
            LOG.warn("Incorrectness: " + aMessage + " (detected by: " + anOrigin + ")");
            this.wetatorEngine.informListenersWarn("Incorrectness", new Object[]{aMessage, anOrigin}, (String)null);
        }
    }

    public static class WebConsoleLogger
    implements WebConsole.Logger {
        private WetatorEngine wetatorEngine;

        public WebConsoleLogger(WetatorEngine aWetatorEngine) {
            this.wetatorEngine = aWetatorEngine;
        }

        public void trace(Object aMessage) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Console [trace]: " + aMessage);
            }
            this.wetatorEngine.informListenersInfo("ConsoleTrace", aMessage);
        }

        public void debug(Object aMessage) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Console [debug]: " + aMessage);
            }
            this.wetatorEngine.informListenersInfo("ConsoleDebug", aMessage);
        }

        public void info(Object aMessage) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Console [info]: " + aMessage);
            }
            this.wetatorEngine.informListenersInfo("ConsoleInfo", aMessage);
        }

        public void warn(Object aMessage) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Console [warn]: " + aMessage);
            }
            this.wetatorEngine.informListenersInfo("ConsoleWarn", aMessage);
        }

        public void error(Object aMessage) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Console [error]: " + aMessage);
            }
            this.wetatorEngine.informListenersInfo("ConsoleError", aMessage);
        }

        public boolean isTraceEnabled() {
            return true;
        }

        public boolean isDebugEnabled() {
            return true;
        }

        public boolean isInfoEnabled() {
            return true;
        }

        public boolean isWarnEnabled() {
            return true;
        }

        public boolean isErrorEnabled() {
            return true;
        }
    }

    public static final class ConfirmHandler
    implements com.gargoylesoftware.htmlunit.ConfirmHandler {
        private WetatorEngine wetatorEngine;
        private ContentPattern message;
        private boolean result;

        public ConfirmHandler(WetatorEngine aWetatorEngine) {
            this.wetatorEngine = aWetatorEngine;
            this.chooseOkOnNextConfirmFor(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleConfirm(Page aPage, String aConfirmationMessage) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("handleConfirm " + aConfirmationMessage);
            }
            String tmpConfirmationMessage = "";
            if (StringUtils.isNotEmpty((CharSequence)aConfirmationMessage)) {
                tmpConfirmationMessage = aConfirmationMessage;
            }
            String tmpUrl = "";
            try {
                tmpUrl = aPage.getWebResponse().getWebRequest().getUrl().toExternalForm();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.wetatorEngine.informListenersInfo("javascriptConfirm", tmpConfirmationMessage, tmpUrl);
            try {
                if (null != this.message) {
                    this.message.matches(aConfirmationMessage, 4000);
                }
                if (this.result) {
                    this.wetatorEngine.informListenersInfo("javascriptConfirmOk", tmpConfirmationMessage);
                } else {
                    this.wetatorEngine.informListenersInfo("javascriptConfirmCancel", tmpConfirmationMessage);
                }
                boolean bl = this.result;
                return bl;
            }
            catch (AssertionException e) {
                String tmpMessage = Messages.getMessage("confirmationMessageDoesNotMatch", e.getMessage());
                this.wetatorEngine.getBrowser().addFailure(new AssertionException(tmpMessage, e));
                this.wetatorEngine.informListenersInfo("javascriptConfirmOk", tmpConfirmationMessage);
                boolean bl = false;
                return bl;
            }
            finally {
                this.chooseOkOnNextConfirmFor(null);
            }
        }

        void chooseOkOnNextConfirmFor(ContentPattern aMessagePattern) {
            this.message = aMessagePattern;
            this.result = true;
        }

        void chooseCancelOnNextConfirmFor(ContentPattern aMessagePattern) {
            this.message = aMessagePattern;
            this.result = false;
        }
    }

    public static final class AttachmentHandler
    implements com.gargoylesoftware.htmlunit.attachment.AttachmentHandler {
        public void handleAttachment(Page aPage) {
            aPage.getEnclosingWindow().getWebClient().setCurrentWindow(aPage.getEnclosingWindow());
        }
    }

    public static final class AlertHandler
    implements com.gargoylesoftware.htmlunit.AlertHandler {
        private WetatorEngine wetatorEngine;

        public AlertHandler(WetatorEngine aWetatorEngine) {
            this.wetatorEngine = aWetatorEngine;
        }

        public void handleAlert(Page aPage, String aMessage) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("handleAlert " + aMessage);
            }
            String tmpMessage = "";
            if (StringUtils.isNotEmpty((CharSequence)aMessage)) {
                tmpMessage = aMessage;
            }
            String tmpUrl = "";
            try {
                tmpUrl = aPage.getWebResponse().getWebRequest().getUrl().toExternalForm();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.wetatorEngine.informListenersInfo("javascriptAlert", tmpMessage, tmpUrl);
        }
    }
}

