/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit;

import com.gargoylesoftware.htmlunit.html.HtmlElement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.wetator.backend.control.IClickable;
import org.wetator.backend.control.IControl;
import org.wetator.backend.control.IDeselectable;
import org.wetator.backend.control.ISelectable;
import org.wetator.backend.control.ISettable;
import org.wetator.backend.htmlunit.control.HtmlUnitBaseControl;
import org.wetator.backend.htmlunit.control.identifier.AbstractHtmlUnitControlIdentifier;

public class HtmlUnitControlRepository {
    private Map<String, Class<HtmlUnitBaseControl<?>>> forElementMap = new HashMap();
    private Map<String, Map<String, Class<HtmlUnitBaseControl<?>>>> forElementAndAttributeMap = new HashMap();
    private List<Class<? extends AbstractHtmlUnitControlIdentifier>> settableIdentifiers = new LinkedList<Class<? extends AbstractHtmlUnitControlIdentifier>>();
    private List<Class<? extends AbstractHtmlUnitControlIdentifier>> clickableIdentifiers = new LinkedList<Class<? extends AbstractHtmlUnitControlIdentifier>>();
    private List<Class<? extends AbstractHtmlUnitControlIdentifier>> selectableIdentifiers = new LinkedList<Class<? extends AbstractHtmlUnitControlIdentifier>>();
    private List<Class<? extends AbstractHtmlUnitControlIdentifier>> deselectableIdentifiers = new LinkedList<Class<? extends AbstractHtmlUnitControlIdentifier>>();
    private List<Class<? extends AbstractHtmlUnitControlIdentifier>> otherIdentifiers = new LinkedList<Class<? extends AbstractHtmlUnitControlIdentifier>>();

    public void addAll(List<Class<? extends IControl>> aControlClassList) {
        if (aControlClassList != null) {
            for (Class<? extends IControl> tmpControlClass : aControlClassList) {
                this.add(tmpControlClass);
            }
        }
    }

    public void add(Class<? extends IControl> aControlClass) {
        if (aControlClass == null) {
            return;
        }
        if (HtmlUnitBaseControl.class.isAssignableFrom(aControlClass)) {
            HtmlUnitBaseControl.IdentifiedBy tmpIdentifiers;
            HtmlUnitBaseControl.ForHtmlElement tmpForHtmlElement = aControlClass.getAnnotation(HtmlUnitBaseControl.ForHtmlElement.class);
            if (tmpForHtmlElement != null) {
                Class<? extends HtmlElement> tmpHtmlElementClass = tmpForHtmlElement.value();
                String tmpAttributeName = tmpForHtmlElement.attributeName();
                String[] tmpAttributeValues = tmpForHtmlElement.attributeValues();
                if (StringUtils.isEmpty((CharSequence)tmpAttributeName) || tmpAttributeValues == null || tmpAttributeValues.length == 0) {
                    this.forElementMap.put(tmpHtmlElementClass.getName(), aControlClass);
                } else {
                    Map<String, Class<HtmlUnitBaseControl<?>>> tmpAttributeMap = this.forElementAndAttributeMap.get(tmpHtmlElementClass.getName());
                    if (tmpAttributeMap == null) {
                        tmpAttributeMap = new HashMap();
                        this.forElementAndAttributeMap.put(tmpHtmlElementClass.getName(), tmpAttributeMap);
                    }
                    for (String tmpValue : tmpAttributeValues) {
                        tmpAttributeMap.put(tmpAttributeName + "||" + tmpValue, aControlClass);
                    }
                }
            }
            if ((tmpIdentifiers = aControlClass.getAnnotation(HtmlUnitBaseControl.IdentifiedBy.class)) != null) {
                List<Class<? extends AbstractHtmlUnitControlIdentifier>> tmpIdentifierClasses = Arrays.asList(tmpIdentifiers.value());
                boolean tmpFound = false;
                if (ISettable.class.isAssignableFrom(aControlClass)) {
                    tmpFound = true;
                    this.settableIdentifiers.addAll(tmpIdentifierClasses);
                }
                if (IClickable.class.isAssignableFrom(aControlClass)) {
                    tmpFound = true;
                    this.clickableIdentifiers.addAll(tmpIdentifierClasses);
                }
                if (ISelectable.class.isAssignableFrom(aControlClass)) {
                    tmpFound = true;
                    this.selectableIdentifiers.addAll(tmpIdentifierClasses);
                }
                if (IDeselectable.class.isAssignableFrom(aControlClass)) {
                    tmpFound = true;
                    this.deselectableIdentifiers.addAll(tmpIdentifierClasses);
                }
                if (!tmpFound) {
                    this.otherIdentifiers.addAll(tmpIdentifierClasses);
                }
            }
        }
    }

    public Class<? extends HtmlUnitBaseControl<?>> getForHtmlElement(HtmlElement anHtmlElement) {
        if (anHtmlElement == null) {
            return null;
        }
        Map<String, Class<HtmlUnitBaseControl<?>>> tmpAttributeMap = this.forElementAndAttributeMap.get(anHtmlElement.getClass().getName());
        if (tmpAttributeMap != null) {
            for (Map.Entry<String, Class<HtmlUnitBaseControl<?>>> tmpEntry : tmpAttributeMap.entrySet()) {
                String[] tmpParts = tmpEntry.getKey().split("\\|\\|");
                if (!tmpParts[1].equals(anHtmlElement.getAttribute(tmpParts[0]))) continue;
                return tmpEntry.getValue();
            }
        }
        return this.forElementMap.get(anHtmlElement.getClass().getName());
    }

    public List<Class<? extends AbstractHtmlUnitControlIdentifier>> getSettableIdentifiers() {
        return this.settableIdentifiers;
    }

    public List<Class<? extends AbstractHtmlUnitControlIdentifier>> getClickableIdentifiers() {
        return this.clickableIdentifiers;
    }

    public List<Class<? extends AbstractHtmlUnitControlIdentifier>> getSelectableIdentifiers() {
        return this.selectableIdentifiers;
    }

    public List<Class<? extends AbstractHtmlUnitControlIdentifier>> getDeselectableIdentifiers() {
        return this.deselectableIdentifiers;
    }

    public List<Class<? extends AbstractHtmlUnitControlIdentifier>> getOtherIdentifiers() {
        return this.otherIdentifiers;
    }
}

