/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit;

import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.wetator.backend.IControlFinder;
import org.wetator.backend.WPath;
import org.wetator.backend.WeightedControlList;
import org.wetator.backend.htmlunit.HtmlUnitControlRepository;
import org.wetator.backend.htmlunit.finder.AbstractHtmlUnitControlsFinder;
import org.wetator.backend.htmlunit.finder.IdentifierBasedHtmlUnitControlsFinder;
import org.wetator.backend.htmlunit.finder.SettableHtmlUnitControlsFinder;
import org.wetator.backend.htmlunit.finder.UnknownHtmlUnitControlsFinder;
import org.wetator.backend.htmlunit.util.HtmlPageIndex;

public class HtmlUnitFinderDelegator
implements IControlFinder {
    protected HtmlPageIndex htmlPageIndex;
    private static ThreadPoolExecutor threadPool;
    private IdentifierBasedHtmlUnitControlsFinder settablesFinder;
    private IdentifierBasedHtmlUnitControlsFinder clickablesFinder;
    private IdentifierBasedHtmlUnitControlsFinder selectablesFinder;
    private IdentifierBasedHtmlUnitControlsFinder deselectablesFinder;
    private IdentifierBasedHtmlUnitControlsFinder othersFinder;
    private AbstractHtmlUnitControlsFinder forTextFinder;

    private static synchronized ThreadPoolExecutor getThreadPool() {
        if (threadPool == null) {
            ThreadPoolExecutor tmpThreadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            tmpThreadPool.setThreadFactory(new ThreadNamingFactory(tmpThreadPool.getThreadFactory()));
            tmpThreadPool.prestartAllCoreThreads();
            threadPool = tmpThreadPool;
        }
        return threadPool;
    }

    public static synchronized void shutdownThreadPool() throws InterruptedException {
        if (threadPool != null) {
            threadPool.shutdown();
            threadPool.awaitTermination(1L, TimeUnit.SECONDS);
            threadPool = null;
        }
    }

    public HtmlUnitFinderDelegator(HtmlPage anHtmlPage) {
        this(anHtmlPage, null);
    }

    public HtmlUnitFinderDelegator(HtmlPage anHtmlPage, HtmlUnitControlRepository aControlRepository) {
        if (null == anHtmlPage) {
            throw new IllegalArgumentException("HtmlPage can't be null");
        }
        this.htmlPageIndex = new HtmlPageIndex(anHtmlPage);
        ThreadPoolExecutor tmpThreadPool = HtmlUnitFinderDelegator.getThreadPool();
        this.settablesFinder = new SettableHtmlUnitControlsFinder(this.htmlPageIndex, tmpThreadPool);
        this.clickablesFinder = new IdentifierBasedHtmlUnitControlsFinder(this.htmlPageIndex, tmpThreadPool);
        this.selectablesFinder = new IdentifierBasedHtmlUnitControlsFinder(this.htmlPageIndex, tmpThreadPool);
        this.deselectablesFinder = new IdentifierBasedHtmlUnitControlsFinder(this.htmlPageIndex, tmpThreadPool);
        this.othersFinder = new IdentifierBasedHtmlUnitControlsFinder(this.htmlPageIndex, tmpThreadPool);
        this.forTextFinder = new UnknownHtmlUnitControlsFinder(this.htmlPageIndex, aControlRepository);
        if (aControlRepository != null) {
            this.settablesFinder.addIdentifiers(aControlRepository.getSettableIdentifiers());
            this.clickablesFinder.addIdentifiers(aControlRepository.getClickableIdentifiers());
            this.selectablesFinder.addIdentifiers(aControlRepository.getSelectableIdentifiers());
            this.deselectablesFinder.addIdentifiers(aControlRepository.getDeselectableIdentifiers());
            this.othersFinder.addIdentifiers(aControlRepository.getOtherIdentifiers());
        }
    }

    @Override
    public WeightedControlList getAllSettables(WPath aWPath) {
        return this.settablesFinder.find(aWPath);
    }

    @Override
    public WeightedControlList getAllClickables(WPath aWPath) {
        return this.clickablesFinder.find(aWPath);
    }

    @Override
    public WeightedControlList getAllSelectables(WPath aWPath) {
        return this.selectablesFinder.find(aWPath);
    }

    @Override
    public WeightedControlList getAllDeselectables(WPath aWPath) {
        return this.deselectablesFinder.find(aWPath);
    }

    @Override
    public WeightedControlList getAllOtherControls(WPath aWPath) {
        return this.othersFinder.find(aWPath);
    }

    @Override
    public WeightedControlList getAllControlsForText(WPath aWPath) {
        return this.forTextFinder.find(aWPath);
    }

    private static final class ThreadNamingFactory
    implements ThreadFactory {
        private static int id = 1;
        private ThreadFactory baseFactory;

        private ThreadNamingFactory(ThreadFactory aBaseFactory) {
            this.baseFactory = aBaseFactory;
        }

        @Override
        public Thread newThread(Runnable aRunnable) {
            Thread tmpThread = this.baseFactory.newThread(aRunnable);
            tmpThread.setName("WETATOR FinderThread " + id++);
            return tmpThread;
        }
    }
}

