/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.control;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.Keyboard;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.sourceforge.htmlunit.corejs.javascript.WrappedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wetator.backend.IBrowser;
import org.wetator.backend.control.IControl;
import org.wetator.backend.control.KeySequence;
import org.wetator.backend.htmlunit.control.identifier.AbstractHtmlUnitControlIdentifier;
import org.wetator.backend.htmlunit.util.ExceptionUtil;
import org.wetator.core.WetatorContext;
import org.wetator.exception.ActionException;
import org.wetator.exception.BackendException;
import org.wetator.exception.UnsupportedOperationException;
import org.wetator.i18n.Messages;
import org.wetator.util.CssUtil;

public abstract class HtmlUnitBaseControl<T extends HtmlElement>
implements IControl {
    private static final Logger LOG = LogManager.getLogger(HtmlUnitBaseControl.class);
    private T htmlElement;

    protected HtmlUnitBaseControl(T anHtmlElement) {
        this.htmlElement = anHtmlElement;
    }

    @Override
    public boolean hasSameBackendControl(IControl aControl) {
        if (aControl instanceof HtmlUnitBaseControl) {
            HtmlUnitBaseControl tmpHtmlUnitControl = (HtmlUnitBaseControl)aControl;
            return this.getHtmlElement() == tmpHtmlUnitControl.getHtmlElement();
        }
        return false;
    }

    protected T getHtmlElement() {
        return this.htmlElement;
    }

    @Override
    public void click(WetatorContext aWetatorContext) throws ActionException {
        String tmpMessage;
        Exception tmpScriptException;
        this.mouseOver(aWetatorContext);
        Object tmpHtmlElement = this.getHtmlElement();
        if (this.canReceiveFocus(aWetatorContext)) {
            try {
                tmpHtmlElement.focus();
            }
            catch (ScriptException e) {
                aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{e.getMessage()}, e);
            }
            catch (WrappedException e) {
                tmpScriptException = ExceptionUtil.getScriptExceptionCauseIfPossible(e);
                aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{tmpScriptException.getMessage()}, tmpScriptException);
            }
        }
        try {
            HtmlPage tmpHtmlPage;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Click - HtmlUnitBaseControl<T>.click() '" + tmpHtmlElement + "'");
            }
            if ((tmpHtmlPage = (HtmlPage)tmpHtmlElement.getPage()) != null) {
                tmpHtmlPage.setElementFromPointHandler((aHtmlPage, anX, anY) -> tmpHtmlElement);
            }
            tmpHtmlElement.click();
            this.waitForImmediateJobs(aWetatorContext);
            if (tmpHtmlPage != null) {
                tmpHtmlPage.setElementFromPointHandler(null);
            }
        }
        catch (ScriptException e) {
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{e.getMessage()}, e);
        }
        catch (WrappedException e) {
            tmpScriptException = ExceptionUtil.getScriptExceptionCauseIfPossible(e);
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{tmpScriptException.getMessage()}, tmpScriptException);
        }
        catch (BackendException e) {
            tmpMessage = Messages.getMessage("backendError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
        catch (Throwable e) {
            tmpMessage = Messages.getMessage("serverError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
    }

    @Override
    public void clickDouble(WetatorContext aWetatorContext) throws ActionException {
        String tmpMessage;
        Exception tmpScriptException;
        this.mouseOver(aWetatorContext);
        Object tmpHtmlElement = this.getHtmlElement();
        if (this.canReceiveFocus(aWetatorContext)) {
            try {
                tmpHtmlElement.focus();
            }
            catch (ScriptException e) {
                aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{e.getMessage()}, e);
            }
            catch (WrappedException e) {
                tmpScriptException = ExceptionUtil.getScriptExceptionCauseIfPossible(e);
                aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{tmpScriptException.getMessage()}, tmpScriptException);
            }
        }
        try {
            HtmlPage tmpHtmlPage;
            if (LOG.isDebugEnabled()) {
                LOG.debug("ClickDouble - HtmlUnitBaseControl<T>.clickDouble() '" + tmpHtmlElement + "'");
            }
            if ((tmpHtmlPage = (HtmlPage)tmpHtmlElement.getPage()) != null) {
                tmpHtmlPage.setElementFromPointHandler((aHtmlPage, anX, anY) -> tmpHtmlElement);
            }
            tmpHtmlElement.dblClick();
            this.waitForImmediateJobs(aWetatorContext);
            if (tmpHtmlPage != null) {
                tmpHtmlPage.setElementFromPointHandler(null);
            }
        }
        catch (ScriptException e) {
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{e.getMessage()}, e);
        }
        catch (WrappedException e) {
            tmpScriptException = ExceptionUtil.getScriptExceptionCauseIfPossible(e);
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{tmpScriptException.getMessage()}, tmpScriptException);
        }
        catch (BackendException e) {
            tmpMessage = Messages.getMessage("backendError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
        catch (Throwable e) {
            tmpMessage = Messages.getMessage("serverError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
    }

    @Override
    public void clickRight(WetatorContext aWetatorContext) throws ActionException {
        String tmpMessage;
        Exception tmpScriptException;
        this.mouseOver(aWetatorContext);
        Object tmpHtmlElement = this.getHtmlElement();
        if (this.canReceiveFocus(aWetatorContext)) {
            try {
                tmpHtmlElement.focus();
            }
            catch (ScriptException e) {
                aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{e.getMessage()}, e);
            }
            catch (WrappedException e) {
                tmpScriptException = ExceptionUtil.getScriptExceptionCauseIfPossible(e);
                aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{tmpScriptException.getMessage()}, tmpScriptException);
            }
        }
        try {
            HtmlPage tmpHtmlPage;
            if (LOG.isDebugEnabled()) {
                LOG.debug("ClickRight - HtmlUnitBaseControl<T>.clickRight() '" + tmpHtmlElement + "'");
            }
            if ((tmpHtmlPage = (HtmlPage)tmpHtmlElement.getPage()) != null) {
                tmpHtmlPage.setElementFromPointHandler((aHtmlPage, anX, anY) -> tmpHtmlElement);
            }
            tmpHtmlElement.rightClick();
            this.waitForImmediateJobs(aWetatorContext);
            if (tmpHtmlPage != null) {
                tmpHtmlPage.setElementFromPointHandler(null);
            }
        }
        catch (ScriptException e) {
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{e.getMessage()}, e);
        }
        catch (WrappedException e) {
            tmpScriptException = ExceptionUtil.getScriptExceptionCauseIfPossible(e);
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{tmpScriptException.getMessage()}, tmpScriptException);
        }
        catch (BackendException e) {
            tmpMessage = Messages.getMessage("backendError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
        catch (Throwable e) {
            tmpMessage = Messages.getMessage("serverError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
    }

    @Override
    public void type(WetatorContext aWetatorContext, KeySequence aKeySequence) throws ActionException {
        T tmpHtmlElement = this.getHtmlElement();
        try {
            Keyboard tmpKeyboard = new Keyboard();
            for (KeySequence.Key tmpKey : aKeySequence.getKeys()) {
                if (KeySequence.Key.KEY_RETURN == tmpKey) {
                    tmpKeyboard.press(13);
                    continue;
                }
                tmpKeyboard.type(tmpKey.getChar());
            }
            tmpHtmlElement.type(tmpKeyboard);
            this.waitForImmediateJobs(aWetatorContext);
        }
        catch (ScriptException e) {
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{e.getMessage()}, e);
        }
        catch (WrappedException e) {
            Exception tmpScriptException = ExceptionUtil.getScriptExceptionCauseIfPossible(e);
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{tmpScriptException.getMessage()}, tmpScriptException);
        }
        catch (IOException | BackendException e) {
            String tmpMessage = Messages.getMessage("backendError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
        catch (Throwable e) {
            String tmpMessage = Messages.getMessage("serverError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
    }

    @Override
    public void mouseOver(WetatorContext aWetatorContext) throws ActionException {
        boolean tmpIsIE;
        T tmpHtmlElement = this.getHtmlElement();
        boolean tmpMouseOver = tmpHtmlElement.isMouseOver();
        if (!tmpMouseOver) {
            try {
                ((HtmlPage)tmpHtmlElement.getPage()).getBody().mouseMove();
            }
            catch (ScriptException e) {
                aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{e.getMessage()}, e);
            }
            catch (WrappedException e) {
                Exception tmpScriptException = ExceptionUtil.getScriptExceptionCauseIfPossible(e);
                aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{tmpScriptException.getMessage()}, tmpScriptException);
            }
        }
        boolean bl = tmpIsIE = aWetatorContext.getBrowserType() == IBrowser.BrowserType.INTERNET_EXPLORER;
        if (tmpIsIE) {
            tmpHtmlElement.mouseMove();
        }
        try {
            if (!tmpMouseOver) {
                tmpHtmlElement.mouseOver();
            }
            tmpHtmlElement.mouseMove();
            this.waitForImmediateJobs(aWetatorContext);
        }
        catch (ScriptException e) {
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{e.getMessage()}, e);
        }
        catch (WrappedException e) {
            Exception tmpScriptException = ExceptionUtil.getScriptExceptionCauseIfPossible(e);
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{tmpScriptException.getMessage()}, tmpScriptException);
        }
        catch (BackendException e) {
            String tmpMessage = Messages.getMessage("backendError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
        catch (Throwable e) {
            String tmpMessage = Messages.getMessage("serverError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
    }

    @Override
    public boolean isDisabled(WetatorContext aWetatorContext) {
        String tmpMessage = Messages.getMessage("disabledCheckNotSupported", this.getDescribingText());
        throw new UnsupportedOperationException(tmpMessage);
    }

    @Override
    public boolean canReceiveFocus(WetatorContext aWetatorContext) {
        return false;
    }

    @Override
    public boolean hasFocus(WetatorContext aWetatorContext) {
        T tmpHtmlElement = this.getHtmlElement();
        HtmlPage tmpHtmlPage = (HtmlPage)tmpHtmlElement.getPage();
        return tmpHtmlElement.equals(tmpHtmlPage.getFocusedElement());
    }

    protected void waitForImmediateJobs(WetatorContext aContext) throws BackendException {
        aContext.getBrowser().waitForImmediateJobs();
    }

    @Override
    public String getUniqueSelector() {
        T tmpHtmlElement = this.getHtmlElement();
        return this.getUniqueSelector((HtmlElement)tmpHtmlElement);
    }

    protected String getUniqueSelector(HtmlElement aHtmlElement) {
        if (null == aHtmlElement) {
            return null;
        }
        HtmlElement tmpHtmlElement = aHtmlElement;
        HtmlElement tmpParent = (HtmlElement)tmpHtmlElement.getParentNode();
        if (null == tmpParent) {
            return null;
        }
        String tmpHtmlElementId = this.getUniqueElementId(tmpHtmlElement);
        StringBuilder tmpSelector = new StringBuilder();
        while (DomElement.ATTRIBUTE_NOT_DEFINED == tmpHtmlElementId) {
            StringBuilder tmpSel;
            tmpSelector = tmpSel = new StringBuilder().append('>').append(tmpHtmlElement.getTagName()).append(":nth-of-type(").append(this.childIndex(tmpParent, tmpHtmlElement)).append(')').append((CharSequence)tmpSelector);
            if ("body".equalsIgnoreCase(tmpParent.getTagName())) break;
            tmpHtmlElement = tmpParent;
            tmpHtmlElementId = this.getUniqueElementId(tmpHtmlElement);
            tmpParent = (HtmlElement)tmpHtmlElement.getParentNode();
            if (null != tmpParent) continue;
            return null;
        }
        if (DomElement.ATTRIBUTE_NOT_DEFINED != tmpHtmlElementId) {
            return "#" + CssUtil.escapeIdentifier(tmpHtmlElementId) + tmpSelector.toString();
        }
        return "body" + tmpSelector.toString();
    }

    private String getUniqueElementId(HtmlElement aHtmlElement) {
        SgmlPage tmpSgmlPage;
        String tmpHtmlElementId = aHtmlElement.getId();
        if (DomElement.ATTRIBUTE_NOT_DEFINED != tmpHtmlElementId && (tmpSgmlPage = aHtmlElement.getPage()) instanceof HtmlPage && ((HtmlPage)tmpSgmlPage).getElementsById(tmpHtmlElementId).size() > 1) {
            return DomElement.ATTRIBUTE_NOT_DEFINED;
        }
        return tmpHtmlElementId;
    }

    public boolean isPartOf(Page aPage) {
        HtmlPage tmpPage = this.getHtmlElement().getHtmlPageOrNull();
        if (aPage == tmpPage) {
            return true;
        }
        if (aPage instanceof HtmlPage) {
            for (FrameWindow tmpFrame : ((HtmlPage)aPage).getFrames()) {
                Page tmpFramePage = tmpFrame.getEnclosedPage();
                if (!(tmpFramePage instanceof HtmlPage) || !this.isPartOf(tmpFramePage)) continue;
                return true;
            }
        }
        return false;
    }

    private int childIndex(HtmlElement aParent, HtmlElement aChild) {
        int tmpRes = 1;
        for (DomElement tmpDomElement : aParent.getChildElements()) {
            if (tmpDomElement == aChild) {
                return tmpRes;
            }
            if (!aChild.getTagName().equalsIgnoreCase(tmpDomElement.getTagName())) continue;
            ++tmpRes;
        }
        return -1;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IdentifiedBy {
        public Class<? extends AbstractHtmlUnitControlIdentifier>[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ForHtmlElement {
        public Class<? extends HtmlElement> value();

        public String attributeName() default "";

        public String[] attributeValues() default {};
    }
}

