/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.control;

import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.html.HtmlHiddenInput;
import java.io.File;
import net.sourceforge.htmlunit.corejs.javascript.WrappedException;
import org.wetator.backend.control.ISettable;
import org.wetator.backend.htmlunit.control.HtmlUnitBaseControl;
import org.wetator.backend.htmlunit.util.ExceptionUtil;
import org.wetator.backend.htmlunit.util.HtmlElementUtil;
import org.wetator.core.WetatorContext;
import org.wetator.exception.ActionException;
import org.wetator.exception.AssertionException;
import org.wetator.exception.BackendException;
import org.wetator.i18n.Messages;
import org.wetator.util.Assert;
import org.wetator.util.SecretString;

@HtmlUnitBaseControl.ForHtmlElement(value=HtmlHiddenInput.class)
public class HtmlUnitInputHidden
extends HtmlUnitBaseControl<HtmlHiddenInput>
implements ISettable {
    public HtmlUnitInputHidden(HtmlHiddenInput anHtmlElement) {
        super(anHtmlElement);
    }

    @Override
    public String getDescribingText() {
        return HtmlElementUtil.getDescribingTextForHtmlHiddenInput((HtmlHiddenInput)this.getHtmlElement());
    }

    @Override
    public void setValue(WetatorContext aWetatorContext, SecretString aValue, File aDirectory) throws ActionException {
        HtmlHiddenInput tmpHtmlHiddenInput = (HtmlHiddenInput)this.getHtmlElement();
        if (tmpHtmlHiddenInput.isDisabled()) {
            String tmpMessage = Messages.getMessage("elementDisabled", this.getDescribingText());
            throw new ActionException(tmpMessage);
        }
        if (tmpHtmlHiddenInput.isReadOnly()) {
            String tmpMessage = Messages.getMessage("elementReadOnly", this.getDescribingText());
            throw new ActionException(tmpMessage);
        }
        try {
            String tmpValue = aValue.getValue();
            tmpHtmlHiddenInput.setAttribute("value", tmpValue);
            this.waitForImmediateJobs(aWetatorContext);
        }
        catch (ScriptException e) {
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{e.getMessage()}, e);
        }
        catch (WrappedException e) {
            Exception tmpScriptException = ExceptionUtil.getScriptExceptionCauseIfPossible(e);
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{tmpScriptException.getMessage()}, tmpScriptException);
        }
        catch (BackendException e) {
            String tmpMessage = Messages.getMessage("backendError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
        catch (Throwable e) {
            String tmpMessage = Messages.getMessage("serverError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
    }

    @Override
    public void assertValue(WetatorContext aWetatorContext, SecretString anExpectedValue) throws AssertionException {
        Assert.assertEquals(anExpectedValue, ((HtmlHiddenInput)this.getHtmlElement()).getValueAttribute(), "expectedValueNotFound", new Object[0]);
    }

    @Override
    public boolean isDisabled(WetatorContext aWetatorContext) {
        HtmlHiddenInput tmpHtmlHiddenInput = (HtmlHiddenInput)this.getHtmlElement();
        return tmpHtmlHiddenInput.isDisabled();
    }
}

