/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.control;

import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlOptionGroup;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import net.sourceforge.htmlunit.corejs.javascript.WrappedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wetator.backend.IBrowser;
import org.wetator.backend.control.IDeselectable;
import org.wetator.backend.htmlunit.control.HtmlUnitBaseControl;
import org.wetator.backend.htmlunit.control.identifier.HtmlUnitOptionIdentifier;
import org.wetator.backend.htmlunit.control.identifier.HtmlUnitOptionInSelectIdentifier;
import org.wetator.backend.htmlunit.util.ExceptionUtil;
import org.wetator.backend.htmlunit.util.HtmlElementUtil;
import org.wetator.core.WetatorContext;
import org.wetator.exception.ActionException;
import org.wetator.exception.BackendException;
import org.wetator.i18n.Messages;

@HtmlUnitBaseControl.ForHtmlElement(value=HtmlOption.class)
@HtmlUnitBaseControl.IdentifiedBy(value={HtmlUnitOptionInSelectIdentifier.class, HtmlUnitOptionIdentifier.class})
public class HtmlUnitOption
extends HtmlUnitBaseControl<HtmlOption>
implements IDeselectable {
    private static final Logger LOG = LogManager.getLogger(HtmlUnitOption.class);

    public HtmlUnitOption(HtmlOption anHtmlElement) {
        super(anHtmlElement);
    }

    @Override
    public String getDescribingText() {
        return HtmlElementUtil.getDescribingTextForHtmlOption((HtmlOption)this.getHtmlElement());
    }

    @Override
    public void select(WetatorContext aWetatorContext) throws ActionException {
        HtmlOption tmpHtmlOption = (HtmlOption)this.getHtmlElement();
        if (tmpHtmlOption.isDisabled()) {
            String tmpMessage = Messages.getMessage("elementDisabled", this.getDescribingText());
            throw new ActionException(tmpMessage);
        }
        if (tmpHtmlOption.getEnclosingSelect().isDisabled()) {
            String tmpMessage = Messages.getMessage("elementDisabled", this.getDescribingText());
            throw new ActionException(tmpMessage);
        }
        try {
            if (tmpHtmlOption.isSelected()) {
                aWetatorContext.informListenersWarn("elementAlreadySelected", this.getDescribingText());
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Select - HtmlUnitOption.click() '" + tmpHtmlOption + "'");
                }
                tmpHtmlOption.click(true, false, false);
            }
            this.waitForImmediateJobs(aWetatorContext);
        }
        catch (ScriptException e) {
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{e.getMessage()}, e);
        }
        catch (WrappedException e) {
            Exception tmpScriptException = ExceptionUtil.getScriptExceptionCauseIfPossible(e);
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{tmpScriptException.getMessage()}, tmpScriptException);
        }
        catch (BackendException e) {
            String tmpMessage = Messages.getMessage("backendError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
        catch (Throwable e) {
            String tmpMessage = Messages.getMessage("serverError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
    }

    @Override
    public boolean isSelected(WetatorContext aWetatorContext) {
        HtmlOption tmpHtmlOption = (HtmlOption)this.getHtmlElement();
        return tmpHtmlOption.isSelected();
    }

    @Override
    public void deselect(WetatorContext aWetatorContext) throws ActionException {
        HtmlOption tmpHtmlOption = (HtmlOption)this.getHtmlElement();
        if (tmpHtmlOption.isDisabled()) {
            String tmpMessage = Messages.getMessage("elementDisabled", this.getDescribingText());
            throw new ActionException(tmpMessage);
        }
        try {
            HtmlSelect tmpHtmlSelect = tmpHtmlOption.getEnclosingSelect();
            if (tmpHtmlSelect.isMultipleSelectEnabled()) {
                if (tmpHtmlSelect.isDisabled()) {
                    String tmpMessage = Messages.getMessage("elementDisabled", this.getDescribingText());
                    throw new ActionException(tmpMessage);
                }
                if (tmpHtmlOption.isSelected()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Deselect - HtmlUnitOption.click() '" + tmpHtmlOption + "'");
                    }
                    tmpHtmlOption.click(false, true, false);
                } else {
                    aWetatorContext.informListenersWarn("elementAlreadyDeselected", this.getDescribingText());
                }
            } else {
                String tmpMessage = Messages.getMessage("deselectNotSupported", this.getDescribingText());
                throw new ActionException(tmpMessage);
            }
            this.waitForImmediateJobs(aWetatorContext);
        }
        catch (ScriptException e) {
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{e.getMessage()}, e);
        }
        catch (WrappedException e) {
            Exception tmpScriptException = ExceptionUtil.getScriptExceptionCauseIfPossible(e);
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{tmpScriptException.getMessage()}, tmpScriptException);
        }
        catch (ActionException e) {
            throw e;
        }
        catch (BackendException e) {
            String tmpMessage = Messages.getMessage("backendError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
        catch (Throwable e) {
            String tmpMessage = Messages.getMessage("serverError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
    }

    @Override
    public void mouseOver(WetatorContext aWetatorContext) throws ActionException {
        String tmpMessage;
        Exception tmpScriptException;
        Object tmpHtmlElement = this.getHtmlElement();
        try {
            ((HtmlPage)tmpHtmlElement.getPage()).getBody().mouseMove();
        }
        catch (ScriptException e) {
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{e.getMessage()}, e);
        }
        catch (WrappedException e) {
            tmpScriptException = ExceptionUtil.getScriptExceptionCauseIfPossible(e);
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{tmpScriptException.getMessage()}, tmpScriptException);
        }
        try {
            boolean tmpIsIE;
            HtmlSelect tmpSelect = ((HtmlOption)tmpHtmlElement).getEnclosingSelect();
            boolean bl = tmpIsIE = aWetatorContext.getBrowserType() == IBrowser.BrowserType.INTERNET_EXPLORER;
            if (tmpIsIE) {
                tmpSelect.mouseMove();
                tmpSelect.mouseOver();
                tmpSelect.mouseMove();
            } else {
                tmpSelect.mouseMove();
                tmpSelect.mouseOver();
                tmpSelect.mouseOut();
                tmpHtmlElement.mouseOver();
                tmpHtmlElement.mouseMove();
            }
            this.waitForImmediateJobs(aWetatorContext);
        }
        catch (ScriptException e) {
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{e.getMessage()}, e);
        }
        catch (WrappedException e) {
            tmpScriptException = ExceptionUtil.getScriptExceptionCauseIfPossible(e);
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{tmpScriptException.getMessage()}, tmpScriptException);
        }
        catch (BackendException e) {
            tmpMessage = Messages.getMessage("backendError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
        catch (Throwable e) {
            tmpMessage = Messages.getMessage("serverError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
    }

    @Override
    public boolean isDisabled(WetatorContext aWetatorContext) {
        HtmlOption tmpHtmlOption = (HtmlOption)this.getHtmlElement();
        HtmlSelect tmpHtmlSelect = tmpHtmlOption.getEnclosingSelect();
        HtmlOptionGroup tmpHtmlOptionGroup = (HtmlOptionGroup)tmpHtmlOption.getEnclosingElement("optgroup");
        boolean tmpOptionGroupDisabled = false;
        if (tmpHtmlOptionGroup != null) {
            tmpOptionGroupDisabled = tmpHtmlOptionGroup.isDisabled();
        }
        return tmpHtmlOption.isDisabled() || tmpOptionGroupDisabled || tmpHtmlSelect.isDisabled();
    }

    @Override
    public String getUniqueSelector() {
        HtmlOption tmpHtmlOption = (HtmlOption)this.getHtmlElement();
        HtmlSelect tmpHtmlSelect = tmpHtmlOption.getEnclosingSelect();
        return this.getUniqueSelector((HtmlElement)tmpHtmlSelect);
    }

    @Override
    public boolean canReceiveFocus(WetatorContext aWetatorContext) {
        return !this.isDisabled(aWetatorContext);
    }
}

