/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.control.identifier;

import com.gargoylesoftware.htmlunit.html.HtmlElement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.wetator.backend.WPath;
import org.wetator.backend.WeightedControlList;
import org.wetator.backend.control.IControl;
import org.wetator.backend.htmlunit.control.identifier.AbstractHtmlUnitControlIdentifier;
import org.wetator.backend.htmlunit.matcher.AbstractHtmlUnitElementMatcher;
import org.wetator.backend.htmlunit.matcher.ByTableCoordinatesMatcher;
import org.wetator.core.searchpattern.SearchPattern;
import org.wetator.util.FindSpot;

public abstract class AbstractMatcherBasedIdentifier
extends AbstractHtmlUnitControlIdentifier {
    @Override
    public WeightedControlList identify(WPath aWPath, HtmlElement aHtmlElement) {
        ArrayList<AbstractHtmlUnitElementMatcher> tmpMatchers = new ArrayList<AbstractHtmlUnitElementMatcher>();
        this.addMatchers(aWPath, aHtmlElement, tmpMatchers);
        if (tmpMatchers.isEmpty()) {
            return WeightedControlList.EMPTY_LIST;
        }
        LinkedList<AbstractHtmlUnitElementMatcher.MatchResult> tmpMatches = new LinkedList<AbstractHtmlUnitElementMatcher.MatchResult>();
        for (AbstractHtmlUnitElementMatcher tmpMatcher : tmpMatchers) {
            tmpMatches.addAll(tmpMatcher.matches(aHtmlElement));
        }
        ArrayList<AbstractHtmlUnitElementMatcher.MatchResult> tmpProcessedMatches = new ArrayList<AbstractHtmlUnitElementMatcher.MatchResult>();
        if (aWPath.getTableCoordinates().isEmpty() || aWPath.getLastNode() == null) {
            tmpProcessedMatches.addAll(tmpMatches);
        } else {
            SearchPattern tmpPathSearchPattern = SearchPattern.createFromList(aWPath.getPathNodes());
            FindSpot tmpPathSpot = this.htmlPageIndex.firstOccurence(tmpPathSearchPattern);
            for (AbstractHtmlUnitElementMatcher.MatchResult tmpMatchResult : tmpMatches) {
                HtmlElement tmpFoundHtmlElement = tmpMatchResult.getHtmlElement();
                if (!ByTableCoordinatesMatcher.isHtmlElementInTableCoordinates(tmpFoundHtmlElement, aWPath.getTableCoordinatesReversed(), this.htmlPageIndex, tmpPathSpot)) continue;
                tmpProcessedMatches.add(tmpMatchResult);
            }
        }
        WeightedControlList tmpResult = new WeightedControlList();
        for (AbstractHtmlUnitElementMatcher.MatchResult tmpMatch : tmpProcessedMatches) {
            HtmlElement tmpHtmlElement = tmpMatch.getHtmlElement();
            FindSpot tmpPosition = this.htmlPageIndex.getPosition(tmpHtmlElement);
            if (tmpPosition == null) continue;
            IControl tmpControl = this.createControl(tmpMatch);
            WeightedControlList.FoundType tmpFoundType = tmpMatch.getFoundType();
            int tmpDeviation = tmpMatch.getDeviation();
            int tmpDistance = tmpMatch.getDistance();
            int tmpStartPosition = tmpPosition.getStartPos();
            int tmpIndex = this.htmlPageIndex.getIndex(tmpHtmlElement);
            tmpResult.add(tmpControl, tmpFoundType, tmpDeviation, tmpDistance, tmpStartPosition, tmpIndex);
        }
        return tmpResult;
    }

    protected abstract void addMatchers(WPath var1, HtmlElement var2, List<AbstractHtmlUnitElementMatcher> var3);

    protected abstract IControl createControl(AbstractHtmlUnitElementMatcher.MatchResult var1);
}

