/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.control.identifier;

import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import java.util.List;
import org.wetator.backend.WPath;
import org.wetator.backend.control.IControl;
import org.wetator.backend.htmlunit.control.HtmlUnitAnchor;
import org.wetator.backend.htmlunit.control.identifier.AbstractMatcherBasedIdentifier;
import org.wetator.backend.htmlunit.matcher.AbstractHtmlUnitElementMatcher;
import org.wetator.backend.htmlunit.matcher.ByAriaLabelAttributeMatcher;
import org.wetator.backend.htmlunit.matcher.ByIdMatcher;
import org.wetator.backend.htmlunit.matcher.ByInnerImageMatcher;
import org.wetator.backend.htmlunit.matcher.ByNameAttributeMatcher;
import org.wetator.backend.htmlunit.matcher.ByTableCoordinatesMatcher;
import org.wetator.backend.htmlunit.matcher.ByTextMatcher;
import org.wetator.backend.htmlunit.matcher.ByTitleAttributeMatcher;
import org.wetator.core.searchpattern.SearchPattern;
import org.wetator.util.FindSpot;

public class HtmlUnitAnchorIdentifier
extends AbstractMatcherBasedIdentifier {
    @Override
    public boolean isHtmlElementSupported(HtmlElement aHtmlElement) {
        return aHtmlElement instanceof HtmlAnchor;
    }

    @Override
    protected void addMatchers(WPath aWPath, HtmlElement aHtmlElement, List<AbstractHtmlUnitElementMatcher> aMatchers) {
        SearchPattern tmpPathSearchPattern = null;
        FindSpot tmpPathSpot = null;
        if (!aWPath.getPathNodes().isEmpty()) {
            tmpPathSearchPattern = SearchPattern.createFromList(aWPath.getPathNodes());
            tmpPathSpot = this.htmlPageIndex.firstOccurence(tmpPathSearchPattern);
        }
        if (tmpPathSpot == FindSpot.NOT_FOUND) {
            return;
        }
        if (aWPath.getLastNode() != null) {
            SearchPattern tmpSearchPattern = aWPath.getLastNode().getSearchPattern();
            aMatchers.add(new ByInnerImageMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern));
            aMatchers.add(new ByTextMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern));
            aMatchers.add(new ByTitleAttributeMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern));
            aMatchers.add(new ByAriaLabelAttributeMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern));
            aMatchers.add(new ByNameAttributeMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern));
            aMatchers.add(new ByIdMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern));
        } else if (!aWPath.getTableCoordinates().isEmpty()) {
            aMatchers.add(new ByTableCoordinatesMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, aWPath.getTableCoordinatesReversed(), HtmlAnchor.class));
        }
    }

    @Override
    protected IControl createControl(AbstractHtmlUnitElementMatcher.MatchResult aMatch) {
        return new HtmlUnitAnchor((HtmlAnchor)aMatch.getHtmlElement());
    }
}

