/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.control.identifier;

import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlLabel;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import java.util.ArrayList;
import java.util.List;
import org.wetator.backend.WPath;
import org.wetator.backend.control.IControl;
import org.wetator.backend.htmlunit.control.HtmlUnitSelect;
import org.wetator.backend.htmlunit.control.identifier.AbstractMatcherBasedIdentifier;
import org.wetator.backend.htmlunit.matcher.AbstractHtmlUnitElementMatcher;
import org.wetator.backend.htmlunit.matcher.ByHtmlLabelMatcher;
import org.wetator.backend.htmlunit.matcher.ByIdMatcher;
import org.wetator.backend.htmlunit.matcher.ByLabelingTextBeforeMatcher;
import org.wetator.backend.htmlunit.matcher.ByNameAttributeMatcher;
import org.wetator.backend.htmlunit.matcher.ByTableCoordinatesMatcher;
import org.wetator.backend.htmlunit.matcher.ByWholeTextBeforeMatcher;
import org.wetator.core.searchpattern.SearchPattern;
import org.wetator.util.FindSpot;
import org.wetator.util.SecretString;

public class HtmlUnitSelectIdentifier
extends AbstractMatcherBasedIdentifier {
    @Override
    public boolean isHtmlElementSupported(HtmlElement aHtmlElement) {
        return aHtmlElement instanceof HtmlSelect || aHtmlElement instanceof HtmlLabel;
    }

    @Override
    protected void addMatchers(WPath aWPath, HtmlElement aHtmlElement, List<AbstractHtmlUnitElementMatcher> aMatchers) {
        SearchPattern tmpPathSearchPattern = null;
        FindSpot tmpPathSpot = null;
        if (!aWPath.getPathNodes().isEmpty()) {
            tmpPathSearchPattern = SearchPattern.createFromList(aWPath.getPathNodes());
            tmpPathSpot = this.htmlPageIndex.firstOccurence(tmpPathSearchPattern);
        }
        if (tmpPathSpot == FindSpot.NOT_FOUND) {
            return;
        }
        if (aWPath.getLastNode() != null) {
            SearchPattern tmpSearchPattern = aWPath.getLastNode().getSearchPattern();
            if (aHtmlElement instanceof HtmlSelect) {
                ArrayList<SecretString> tmpWholePath = new ArrayList<SecretString>(aWPath.getPathNodes());
                tmpWholePath.add(aWPath.getLastNode());
                SearchPattern tmpWholePathSearchPattern = SearchPattern.createFromList(tmpWholePath);
                aMatchers.add(new ByWholeTextBeforeMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpWholePathSearchPattern));
                aMatchers.add(new ByLabelingTextBeforeMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern));
                aMatchers.add(new ByNameAttributeMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern));
                aMatchers.add(new ByIdMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern));
            } else if (aHtmlElement instanceof HtmlLabel) {
                aMatchers.add(new ByHtmlLabelMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern, HtmlSelect.class));
            }
        } else if (!aWPath.getTableCoordinates().isEmpty()) {
            aMatchers.add(new ByTableCoordinatesMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, aWPath.getTableCoordinatesReversed(), HtmlSelect.class));
        }
    }

    @Override
    protected IControl createControl(AbstractHtmlUnitElementMatcher.MatchResult aMatch) {
        return new HtmlUnitSelect((HtmlSelect)aMatch.getHtmlElement());
    }
}

