/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.finder;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import java.util.List;
import org.wetator.backend.WPath;
import org.wetator.backend.WeightedControlList;
import org.wetator.backend.htmlunit.HtmlUnitControlRepository;
import org.wetator.backend.htmlunit.control.HtmlUnitUnspecificControl;
import org.wetator.backend.htmlunit.finder.AbstractHtmlUnitControlsFinder;
import org.wetator.backend.htmlunit.matcher.AbstractHtmlUnitElementMatcher;
import org.wetator.backend.htmlunit.matcher.ByIdMatcher;
import org.wetator.backend.htmlunit.matcher.ByTableCoordinatesMatcher;
import org.wetator.backend.htmlunit.matcher.ByTitleAttributeMatcher;
import org.wetator.backend.htmlunit.util.HtmlPageIndex;
import org.wetator.core.searchpattern.SearchPattern;
import org.wetator.util.FindSpot;

public class UnknownHtmlUnitControlsFinder
extends AbstractHtmlUnitControlsFinder {
    private HtmlUnitControlRepository controlRepository;

    public UnknownHtmlUnitControlsFinder(HtmlPageIndex aHtmlPageIndex, HtmlUnitControlRepository aControlRepository) {
        super(aHtmlPageIndex);
        this.controlRepository = aControlRepository;
    }

    @Override
    public WeightedControlList find(WPath aWPath) {
        WeightedControlList tmpFoundControls = new WeightedControlList();
        if (aWPath.getLastNode() == null && aWPath.getTableCoordinates().isEmpty()) {
            return tmpFoundControls;
        }
        SearchPattern tmpPathSearchPattern = null;
        FindSpot tmpPathSpot = null;
        if (!aWPath.getPathNodes().isEmpty()) {
            tmpPathSearchPattern = SearchPattern.createFromList(aWPath.getPathNodes());
            tmpPathSpot = this.htmlPageIndex.firstOccurence(tmpPathSearchPattern);
        }
        if (tmpPathSpot == FindSpot.NOT_FOUND) {
            return tmpFoundControls;
        }
        if (aWPath.getLastNode() == null || aWPath.getLastNode().isEmpty()) {
            int tmpStartPos = 0;
            if (tmpPathSpot != null) {
                tmpStartPos = Math.max(0, tmpPathSpot.getEndPos());
            }
            for (HtmlElement tmpHtmlElement : this.htmlPageIndex.getAllVisibleHtmlElementsBottomUp()) {
                FindSpot tmpNodeSpot = this.htmlPageIndex.getPosition(tmpHtmlElement);
                if (tmpStartPos > tmpNodeSpot.getStartPos() || this.controlRepository != null && this.controlRepository.getForHtmlElement(tmpHtmlElement) != null || !aWPath.getTableCoordinates().isEmpty() && !ByTableCoordinatesMatcher.isHtmlElementInTableCoordinates(tmpHtmlElement, aWPath.getTableCoordinatesReversed(), this.htmlPageIndex, null)) continue;
                String tmpTextBefore = this.htmlPageIndex.getTextBefore((DomNode)tmpHtmlElement);
                int tmpDeviation = this.htmlPageIndex.getAsText((DomNode)tmpHtmlElement).length();
                int tmpDistance = tmpPathSearchPattern != null ? tmpPathSearchPattern.noOfCharsAfterLastShortestOccurenceIn(tmpTextBefore) : tmpTextBefore.length();
                tmpFoundControls.add(new HtmlUnitUnspecificControl<HtmlElement>(tmpHtmlElement), WeightedControlList.FoundType.BY_TEXT, tmpDeviation, tmpDistance, tmpNodeSpot.getStartPos(), this.htmlPageIndex.getIndex(tmpHtmlElement));
                break;
            }
            return tmpFoundControls;
        }
        SearchPattern tmpSearchPattern = aWPath.getLastNode().getSearchPattern();
        ByIdMatcher tmpIdMatcher = new ByIdMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern);
        ByTitleAttributeMatcher tmpTitleMatcher = new ByTitleAttributeMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern);
        for (HtmlElement tmpHtmlElement : this.htmlPageIndex.getAllVisibleHtmlElements()) {
            if (this.controlRepository != null && this.controlRepository.getForHtmlElement(tmpHtmlElement) != null) continue;
            List<AbstractHtmlUnitElementMatcher.MatchResult> tmpMatches = tmpIdMatcher.matches(tmpHtmlElement);
            for (AbstractHtmlUnitElementMatcher.MatchResult tmpMatch : tmpMatches) {
                if (!aWPath.getTableCoordinates().isEmpty() && !ByTableCoordinatesMatcher.isHtmlElementInTableCoordinates(tmpMatch.getHtmlElement(), aWPath.getTableCoordinatesReversed(), this.htmlPageIndex, tmpPathSpot)) continue;
                tmpFoundControls.add(new HtmlUnitUnspecificControl<HtmlElement>(tmpMatch.getHtmlElement()), tmpMatch.getFoundType(), tmpMatch.getDeviation(), tmpMatch.getDistance(), tmpMatch.getStart(), this.htmlPageIndex.getIndex(tmpMatch.getHtmlElement()));
            }
            tmpMatches = tmpTitleMatcher.matches(tmpHtmlElement);
            for (AbstractHtmlUnitElementMatcher.MatchResult tmpMatch : tmpMatches) {
                if (!aWPath.getTableCoordinates().isEmpty() && !ByTableCoordinatesMatcher.isHtmlElementInTableCoordinates(tmpMatch.getHtmlElement(), aWPath.getTableCoordinatesReversed(), this.htmlPageIndex, null)) continue;
                tmpFoundControls.add(new HtmlUnitUnspecificControl<HtmlElement>(tmpMatch.getHtmlElement()), WeightedControlList.FoundType.BY_TITLE_TEXT, tmpMatch.getDeviation(), tmpMatch.getDistance(), tmpMatch.getStart(), this.htmlPageIndex.getIndex(tmpMatch.getHtmlElement()));
            }
        }
        int tmpStartPos = 0;
        if (tmpPathSpot != null) {
            tmpStartPos = Math.max(0, tmpPathSpot.getEndPos());
        }
        FindSpot tmpHitSpot = this.htmlPageIndex.firstOccurence(tmpSearchPattern, tmpStartPos);
        while (tmpHitSpot != FindSpot.NOT_FOUND && tmpHitSpot.getEndPos() > -1) {
            for (HtmlElement tmpHtmlElement : this.htmlPageIndex.getAllVisibleHtmlElementsBottomUp()) {
                FindSpot tmpNodeSpot = this.htmlPageIndex.getPosition(tmpHtmlElement);
                if (tmpNodeSpot.getStartPos() > tmpHitSpot.getStartPos() || tmpHitSpot.getEndPos() > tmpNodeSpot.getEndPos()) continue;
                if (this.controlRepository != null && this.controlRepository.getForHtmlElement(tmpHtmlElement) != null || !aWPath.getTableCoordinates().isEmpty() && !ByTableCoordinatesMatcher.isHtmlElementInTableCoordinates(tmpHtmlElement, aWPath.getTableCoordinatesReversed(), this.htmlPageIndex, null)) break;
                String tmpTextBefore = this.htmlPageIndex.getTextBeforeIncludingMyself((DomNode)tmpHtmlElement);
                FindSpot tmpLastOccurence = tmpSearchPattern.lastOccurenceIn(tmpTextBefore);
                int tmpDeviation = tmpTextBefore.length() - tmpLastOccurence.getEndPos();
                tmpTextBefore = tmpTextBefore.substring(0, tmpLastOccurence.getStartPos());
                int tmpDistance = tmpPathSearchPattern != null ? tmpPathSearchPattern.noOfCharsAfterLastShortestOccurenceIn(tmpTextBefore) : tmpTextBefore.length();
                tmpFoundControls.add(new HtmlUnitUnspecificControl<HtmlElement>(tmpHtmlElement), WeightedControlList.FoundType.BY_TEXT, tmpDeviation, tmpDistance, tmpNodeSpot.getStartPos(), this.htmlPageIndex.getIndex(tmpHtmlElement));
                break;
            }
            tmpHitSpot = this.htmlPageIndex.firstOccurence(tmpSearchPattern, tmpHitSpot.getStartPos() + 1);
        }
        return tmpFoundControls;
    }
}

