/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.matcher;

import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlImageInput;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.wetator.backend.WeightedControlList;
import org.wetator.backend.htmlunit.matcher.AbstractByAttributeMatcher;
import org.wetator.backend.htmlunit.matcher.AbstractHtmlUnitElementMatcher;
import org.wetator.backend.htmlunit.util.HtmlPageIndex;
import org.wetator.core.searchpattern.SearchPattern;
import org.wetator.util.FindSpot;

public class ByInnerImageMatcher
extends AbstractHtmlUnitElementMatcher {
    public ByInnerImageMatcher(HtmlPageIndex aHtmlPageIndex, SearchPattern aPathSearchPattern, FindSpot aPathSpot, SearchPattern aSearchPattern) {
        super(aHtmlPageIndex, aPathSearchPattern, aPathSpot, aSearchPattern);
    }

    @Override
    public List<AbstractHtmlUnitElementMatcher.MatchResult> matches(HtmlElement aHtmlElement) {
        if (FindSpot.NOT_FOUND == this.pathSpot) {
            return Collections.emptyList();
        }
        FindSpot tmpNodeSpot = this.htmlPageIndex.getPosition(aHtmlElement);
        if (this.pathSpot == null || this.pathSpot.getEndPos() <= tmpNodeSpot.getStartPos()) {
            LinkedList<AbstractHtmlUnitElementMatcher.MatchResult> tmpMatches = new LinkedList<AbstractHtmlUnitElementMatcher.MatchResult>();
            Iterable tmpAllchildElements = aHtmlElement.getHtmlElementDescendants();
            for (HtmlElement tmpInnerElement : tmpAllchildElements) {
                if (!(tmpInnerElement instanceof HtmlImage)) continue;
                tmpMatches.addAll(new ByInnerImageAltAttributeMatcher(this.htmlPageIndex, this.pathSearchPattern, this.pathSpot, this.searchPattern, tmpInnerElement).matches(aHtmlElement));
                tmpMatches.addAll(new ByInnerImageTitleAttributeMatcher(this.htmlPageIndex, this.pathSearchPattern, this.pathSpot, this.searchPattern, tmpInnerElement).matches(aHtmlElement));
                tmpMatches.addAll(new ByInnerImageSrcAttributeMatcher(this.htmlPageIndex, this.pathSearchPattern, this.pathSpot, this.searchPattern, tmpInnerElement).matches(aHtmlElement));
                tmpMatches.addAll(new ByInnerNameMatcher(this.htmlPageIndex, this.pathSearchPattern, this.pathSpot, this.searchPattern, tmpInnerElement).matches(aHtmlElement));
            }
            return tmpMatches;
        }
        return Collections.emptyList();
    }

    protected static class ByInnerNameMatcher
    extends AbstractByAttributeMatcher {
        private HtmlElement innerHtmlElement;

        public ByInnerNameMatcher(HtmlPageIndex aHtmlPageIndex, SearchPattern aPathSearchPattern, FindSpot aPathSpot, SearchPattern aSearchPattern, HtmlElement anInnerHtmlElement) {
            super(aHtmlPageIndex, aPathSearchPattern, aPathSpot, aSearchPattern, WeightedControlList.FoundType.BY_INNER_NAME);
            this.innerHtmlElement = anInnerHtmlElement;
            this.matchType = AbstractByAttributeMatcher.MatchType.EXACT;
        }

        @Override
        protected String getAttributeValue(HtmlElement aHtmlElement) {
            if (this.innerHtmlElement instanceof HtmlImage || this.innerHtmlElement instanceof HtmlImageInput) {
                return this.innerHtmlElement.getAttribute("name");
            }
            return null;
        }
    }

    protected static class ByInnerImageTitleAttributeMatcher
    extends AbstractByAttributeMatcher {
        private HtmlElement innerHtmlElement;

        public ByInnerImageTitleAttributeMatcher(HtmlPageIndex aHtmlPageIndex, SearchPattern aPathSearchPattern, FindSpot aPathSpot, SearchPattern aSearchPattern, HtmlElement anInnerHtmlElement) {
            super(aHtmlPageIndex, aPathSearchPattern, aPathSpot, aSearchPattern, WeightedControlList.FoundType.BY_INNER_IMG_TITLE_ATTRIBUTE);
            this.innerHtmlElement = anInnerHtmlElement;
        }

        @Override
        protected String getAttributeValue(HtmlElement aHtmlElement) {
            if (this.innerHtmlElement instanceof HtmlImage || this.innerHtmlElement instanceof HtmlImageInput) {
                return this.innerHtmlElement.getAttribute("title");
            }
            return null;
        }
    }

    protected static class ByInnerImageSrcAttributeMatcher
    extends AbstractByAttributeMatcher {
        private HtmlElement innerHtmlElement;

        public ByInnerImageSrcAttributeMatcher(HtmlPageIndex aHtmlPageIndex, SearchPattern aPathSearchPattern, FindSpot aPathSpot, SearchPattern aSearchPattern, HtmlElement anInnerHtmlElement) {
            super(aHtmlPageIndex, aPathSearchPattern, aPathSpot, aSearchPattern, WeightedControlList.FoundType.BY_INNER_IMG_SRC_ATTRIBUTE);
            this.innerHtmlElement = anInnerHtmlElement;
            this.matchType = AbstractByAttributeMatcher.MatchType.ENDS_WITH;
        }

        @Override
        protected String getAttributeValue(HtmlElement aHtmlElement) {
            if (this.innerHtmlElement instanceof HtmlImage) {
                return ((HtmlImage)this.innerHtmlElement).getSrcAttribute();
            }
            if (this.innerHtmlElement instanceof HtmlImageInput) {
                return ((HtmlImageInput)this.innerHtmlElement).getSrcAttribute();
            }
            return null;
        }
    }

    protected static class ByInnerImageAltAttributeMatcher
    extends AbstractByAttributeMatcher {
        private HtmlElement innerHtmlElement;

        public ByInnerImageAltAttributeMatcher(HtmlPageIndex aHtmlPageIndex, SearchPattern aPathSearchPattern, FindSpot aPathSpot, SearchPattern aSearchPattern, HtmlElement anInnerHtmlElement) {
            super(aHtmlPageIndex, aPathSearchPattern, aPathSpot, aSearchPattern, WeightedControlList.FoundType.BY_INNER_IMG_ALT_ATTRIBUTE);
            this.innerHtmlElement = anInnerHtmlElement;
        }

        @Override
        protected String getAttributeValue(HtmlElement aHtmlElement) {
            if (this.innerHtmlElement instanceof HtmlImage) {
                return ((HtmlImage)this.innerHtmlElement).getAltAttribute();
            }
            if (this.innerHtmlElement instanceof HtmlImageInput) {
                return ((HtmlImageInput)this.innerHtmlElement).getAltAttribute();
            }
            return null;
        }
    }
}

