/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.util;

import com.gargoylesoftware.htmlunit.html.HtmlElement;
import org.apache.commons.lang3.StringUtils;

public final class DescribingTextBuilder {
    private HtmlElement htmlElement;
    private StringBuilder describingText = new StringBuilder();

    public static DescribingTextBuilder createDefault(HtmlElement anHtmlElement) {
        return new DescribingTextBuilder(anHtmlElement).addId().addName();
    }

    public static DescribingTextBuilder createCustom(HtmlElement anHtmlElement) {
        return new DescribingTextBuilder(anHtmlElement);
    }

    private DescribingTextBuilder(HtmlElement anHtmlElement) {
        this.htmlElement = anHtmlElement;
        this.describingText.append('[').append(this.htmlElement.getClass().getSimpleName());
    }

    public DescribingTextBuilder addId() {
        return this.addAttribute("id", this.htmlElement.getAttribute("id"));
    }

    public DescribingTextBuilder addName() {
        return this.addAttribute("name", this.htmlElement.getAttribute("name"));
    }

    public DescribingTextBuilder addAttribute(String aName, String aValue) {
        if (StringUtils.isNotBlank((CharSequence)aName) && StringUtils.isNotEmpty((CharSequence)aValue)) {
            this.describingText.append(" (").append(aName).append("='").append(aValue).append("')");
        }
        return this;
    }

    public DescribingTextBuilder addText(String aText) {
        this.describingText.append(" '").append(aText).append('\'');
        return this;
    }

    public DescribingTextBuilder addPlain(String aText) {
        if (StringUtils.isNotBlank((CharSequence)aText)) {
            this.describingText.append(' ').append(aText);
        }
        return this;
    }

    public String build() {
        return this.describingText.append(']').toString();
    }
}

