/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.util;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.XHtmlPage;
import com.gargoylesoftware.htmlunit.html.parser.HTMLParser;
import java.io.IOException;
import java.net.URL;

public final class PageUtil {
    public static HtmlPage constructHtmlPage(String anHtmlCode) throws IOException {
        return PageUtil.constructHtmlPage(BrowserVersion.FIREFOX_78, anHtmlCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HtmlPage constructHtmlPage(BrowserVersion aBrowserVersion, String anHtmlCode) throws IOException {
        try (WebClient tmpWebClient = new WebClient(aBrowserVersion);){
            HTMLParser tmpHtmlParser = tmpWebClient.getPageCreator().getHtmlParser();
            WebWindow tmpWebWindow = tmpWebClient.getCurrentWindow();
            StringWebResponse tmpWebResponse = new StringWebResponse(anHtmlCode, new URL("http://www.wetator.org/test.html"));
            HtmlPage tmpPage = new HtmlPage((WebResponse)tmpWebResponse, tmpWebWindow);
            tmpWebWindow.setEnclosedPage((Page)tmpPage);
            tmpHtmlParser.parse((WebResponse)tmpWebResponse, tmpPage, true);
            HtmlPage htmlPage = tmpPage;
            return htmlPage;
        }
    }

    public static XHtmlPage constructXHtmlPage(String anXHtmlCode) throws IOException {
        return PageUtil.constructXHtmlPage(BrowserVersion.getDefault(), anXHtmlCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XHtmlPage constructXHtmlPage(BrowserVersion aBrowserVersion, String anXHtmlCode) throws IOException {
        try (WebClient tmpWebClient = new WebClient(aBrowserVersion);){
            HTMLParser tmpHtmlParser = tmpWebClient.getPageCreator().getHtmlParser();
            WebWindow tmpWebWindow = tmpWebClient.getCurrentWindow();
            StringWebResponse tmpWebResponse = new StringWebResponse(anXHtmlCode, new URL("http://www.wetator.org/test.xhtml"));
            XHtmlPage tmpPage = new XHtmlPage((WebResponse)tmpWebResponse, tmpWebWindow);
            tmpWebWindow.setEnclosedPage((Page)tmpPage);
            tmpHtmlParser.parse((WebResponse)tmpWebResponse, (HtmlPage)tmpPage, true);
            XHtmlPage xHtmlPage = tmpPage;
            return xHtmlPage;
        }
    }

    private PageUtil() {
    }
}

