/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.commandset;

import com.github.rjeschke.txtmark.Processor;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.wetator.backend.IBrowser;
import org.wetator.backend.IControlFinder;
import org.wetator.backend.WPath;
import org.wetator.backend.WeightedControlList;
import org.wetator.backend.control.IControl;
import org.wetator.backend.control.IDeselectable;
import org.wetator.backend.control.ISelectable;
import org.wetator.backend.control.ISettable;
import org.wetator.commandset.AbstractCommandSet;
import org.wetator.core.Command;
import org.wetator.core.ForceExecution;
import org.wetator.core.ICommandImplementation;
import org.wetator.core.Variable;
import org.wetator.core.WetatorContext;
import org.wetator.core.searchpattern.ContentPattern;
import org.wetator.exception.ActionException;
import org.wetator.exception.AssertionException;
import org.wetator.exception.BackendException;
import org.wetator.exception.CommandException;
import org.wetator.exception.InvalidInputException;
import org.wetator.i18n.Messages;
import org.wetator.util.Assert;
import org.wetator.util.SecretString;

public final class DefaultCommandSet
extends AbstractCommandSet {
    @Override
    protected void registerCommands() {
        this.registerCommand("describe", new CommandDescribe());
        this.registerCommand("open-url", new CommandOpenUrl());
        this.registerCommand("use-module", new CommandUseModule());
        this.registerCommand("close-window", new CommandCloseWindow());
        this.registerCommand("go-back", new CommandGoBack());
        this.registerCommand("click-on", new CommandClickOn());
        this.registerCommand("click-double-on", new CommandClickDoubleOn());
        this.registerCommand("click-right-on", new CommandClickRightOn());
        this.registerCommand("set", new CommandSet());
        this.registerCommand("select", new CommandSelect());
        this.registerCommand("deselect", new CommandDeselect());
        this.registerCommand("mouse-over", new CommandMouseOver());
        this.registerCommand("assert-title", new CommandAssertTitle());
        this.registerCommand("assert-content", new CommandAssertContent());
        this.registerCommand("assert-enabled", new CommandAssertEnabled());
        this.registerCommand("assert-disabled", new CommandAssertDisabled());
        this.registerCommand("assert-set", new CommandAssertSet());
        this.registerCommand("assert-selected", new CommandAssertSelected());
        this.registerCommand("assert-deselected", new CommandAssertDeselected());
        this.registerCommand("exec-java", new CommandExecJava());
    }

    @Override
    public void initialize(Properties aConfiguration) {
    }

    @Override
    public void cleanup() {
    }

    @ForceExecution
    public static final class CommandExecJava
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            String tmpMethodName;
            SecretString tmpCall = aCommand.getRequiredFirstParameterValue(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            String tmpCallString = tmpCall.toString();
            int tmpLastDotPos = tmpCallString.lastIndexOf(46);
            if (tmpLastDotPos < 0) {
                String tmpMessage = Messages.getMessage("javaExecSyntax", tmpCallString);
                throw new InvalidInputException(tmpMessage);
            }
            String tmpClassName = tmpCallString.substring(0, tmpLastDotPos);
            if (StringUtils.isEmpty((CharSequence)tmpClassName)) {
                String tmpMessage = Messages.getMessage("javaExecSyntax", tmpCallString);
                throw new InvalidInputException(tmpMessage);
            }
            if (tmpClassName.endsWith("()")) {
                tmpClassName = tmpClassName.substring(0, tmpClassName.length() - 2);
            }
            if (StringUtils.isEmpty((CharSequence)(tmpMethodName = tmpCallString.substring(tmpLastDotPos + 1)))) {
                String tmpMessage = Messages.getMessage("javaExecSyntax", tmpCallString);
                throw new InvalidInputException(tmpMessage);
            }
            if (tmpMethodName.endsWith("()")) {
                tmpMethodName = tmpMethodName.substring(0, tmpMethodName.length() - 2);
            }
            List<SecretString> tmpMethodParameters = aCommand.getSecondParameterValues(aContext);
            Object[] tmpParams = new String[tmpMethodParameters.size()];
            Class[] tmpParamTypes = new Class[tmpMethodParameters.size()];
            int i = 0;
            for (SecretString tmpSecret : tmpMethodParameters) {
                tmpParams[i] = tmpSecret.toString();
                tmpParamTypes[i] = String.class;
                ++i;
            }
            StringBuilder tmpMethodLabel = new StringBuilder(tmpMethodName);
            try {
                Object tmpResult;
                Class<?> tmpClass = Class.forName(tmpClassName);
                Method tmpMethod = MethodUtils.getMatchingAccessibleMethod(tmpClass, (String)tmpMethodName, (Class[])tmpParamTypes);
                if (null == tmpMethod) {
                    tmpMethod = MethodUtils.getMatchingAccessibleMethod(tmpClass, (String)tmpMethodName, (Class[])new Class[]{String[].class});
                    tmpParams = new Object[]{tmpParams};
                }
                tmpMethodLabel.append('(');
                for (int j = 0; j < tmpParamTypes.length; ++j) {
                    if (j > 0) {
                        tmpMethodLabel.append(", ");
                    }
                    tmpMethodLabel.append("String");
                }
                tmpMethodLabel.append(')');
                if (null == tmpMethod) {
                    String tmpMessage = Messages.getMessage("javaExecMethodNotFound", tmpClassName, tmpMethodLabel.toString());
                    throw new InvalidInputException(tmpMessage);
                }
                if (Modifier.isStatic(tmpMethod.getModifiers())) {
                    tmpResult = MethodUtils.invokeStaticMethod(tmpClass, (String)tmpMethod.getName(), (Object[])tmpParams);
                } else {
                    Object tmpReceiver = tmpClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    tmpResult = MethodUtils.invokeMethod(tmpReceiver, (String)tmpMethod.getName(), (Object[])tmpParams);
                }
                if (Void.TYPE != tmpMethod.getReturnType()) {
                    if (null == tmpResult) {
                        aContext.informListenersInfo("javaExecResult", "null");
                    } else {
                        aContext.informListenersInfo("javaExecResult", tmpResult.toString());
                    }
                }
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                aContext.informListenersWarn("stacktrace", ExceptionUtils.getStackTrace((Throwable)e));
                aContext.informListenersInfo("javaExecClasspath", System.getProperty("java.class.path"));
                String tmpMessage = Messages.getMessage("javaExecClassNotFound", tmpClassName, e.toString());
                throw new CommandException(tmpMessage);
            }
            catch (IllegalArgumentException e) {
                String tmpMessage = Messages.getMessage("javaExecIllegalArgument", tmpClassName, tmpMethodLabel.toString(), tmpMethodParameters.toString(), e.getMessage());
                throw new CommandException(tmpMessage);
            }
            catch (IllegalAccessException e) {
                aContext.informListenersWarn("stacktrace", ExceptionUtils.getStackTrace((Throwable)e));
                String tmpMessage = Messages.getMessage("javaExecIllegalAccess", tmpClassName, tmpMethodLabel.toString(), tmpMethodParameters.toString(), e.getMessage());
                throw new CommandException(tmpMessage);
            }
            catch (InvocationTargetException e) {
                aContext.informListenersWarn("stacktrace", ExceptionUtils.getStackTrace((Throwable)e));
                if (null == e.getCause()) {
                    String tmpMessage = Messages.getMessage("javaExecInvocationTarget", tmpClassName, tmpMethodLabel.toString(), tmpMethodParameters.toString(), e.toString());
                    throw new CommandException(tmpMessage);
                }
                String tmpMessage = Messages.getMessage("javaExecInvocationTarget", tmpClassName, tmpMethodLabel.toString(), tmpMethodParameters.toString(), e.getCause().toString());
                throw new CommandException(tmpMessage);
            }
            catch (InstantiationException | NoSuchMethodException e) {
                aContext.informListenersWarn("stacktrace", ExceptionUtils.getStackTrace((Throwable)e));
                if (null == e.getCause()) {
                    String tmpMessage = Messages.getMessage("javaExecInstantiation", tmpClassName, tmpMethodLabel.toString(), tmpMethodParameters.toString(), e.toString());
                    throw new CommandException(tmpMessage);
                }
                String tmpMessage = Messages.getMessage("javaExecInstantiation", tmpClassName, tmpMethodLabel.toString(), tmpMethodParameters.toString(), e.getCause().toString());
                throw new CommandException(tmpMessage);
            }
        }
    }

    public final class CommandAssertDeselected
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            WPath tmpWPath = new WPath(aCommand.getRequiredFirstParameterValue(aContext), aContext.getConfiguration());
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            IBrowser tmpBrowser = DefaultCommandSet.this.getBrowser(aContext);
            IControlFinder tmpControlFinder = DefaultCommandSet.this.getControlFinder(tmpBrowser);
            WeightedControlList tmpFoundElements = tmpControlFinder.getAllSelectables(tmpWPath);
            ISelectable tmpControl = (ISelectable)DefaultCommandSet.this.getFirstRequiredHtmlElementFrom(aContext, tmpFoundElements, tmpWPath, "noDeselectableHtmlElmentFound");
            tmpBrowser.markControls(tmpControl);
            boolean tmpIsSelected = tmpControl.isSelected(aContext);
            Assert.assertFalse(tmpIsSelected, "elementNotDeselected", tmpControl.getDescribingText());
        }
    }

    public final class CommandAssertSelected
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            WPath tmpWPath = new WPath(aCommand.getRequiredFirstParameterValue(aContext), aContext.getConfiguration());
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            IBrowser tmpBrowser = DefaultCommandSet.this.getBrowser(aContext);
            IControlFinder tmpControlFinder = DefaultCommandSet.this.getControlFinder(tmpBrowser);
            WeightedControlList tmpFoundElements = tmpControlFinder.getAllSelectables(tmpWPath);
            ISelectable tmpControl = (ISelectable)DefaultCommandSet.this.getFirstRequiredHtmlElementFrom(aContext, tmpFoundElements, tmpWPath, "noSelectableHtmlElmentFound");
            tmpBrowser.markControls(tmpControl);
            boolean tmpIsSelected = tmpControl.isSelected(aContext);
            Assert.assertTrue(tmpIsSelected, "elementNotSelected", tmpControl.getDescribingText());
        }
    }

    public final class CommandAssertSet
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            WPath tmpWPath = new WPath(aCommand.getRequiredFirstParameterValue(aContext), aContext.getConfiguration());
            SecretString tmpValueParam = aCommand.getSecondParameterValue(aContext);
            if (null == tmpValueParam) {
                tmpValueParam = new SecretString("");
            }
            aCommand.checkNoUnusedThirdParameter(aContext);
            IBrowser tmpBrowser = DefaultCommandSet.this.getBrowser(aContext);
            IControlFinder tmpControlFinder = DefaultCommandSet.this.getControlFinder(tmpBrowser);
            WeightedControlList tmpFoundElements = tmpControlFinder.getAllSettables(tmpWPath);
            ISettable tmpControl = (ISettable)DefaultCommandSet.this.getFirstRequiredHtmlElementFrom(aContext, tmpFoundElements, tmpWPath, "noSettableHtmlElmentFound");
            tmpBrowser.markControls(tmpControl);
            tmpControl.assertValue(aContext, tmpValueParam);
        }
    }

    public final class CommandAssertDisabled
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            WPath tmpWPath = new WPath(aCommand.getRequiredFirstParameterValue(aContext), aContext.getConfiguration());
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            IBrowser tmpBrowser = DefaultCommandSet.this.getBrowser(aContext);
            IControlFinder tmpControlFinder = DefaultCommandSet.this.getControlFinder(tmpBrowser);
            WeightedControlList tmpFoundElements = tmpControlFinder.getAllSettables(tmpWPath);
            tmpFoundElements.addAll(tmpControlFinder.getAllSelectables(tmpWPath));
            tmpFoundElements.addAll(tmpControlFinder.getAllClickables(tmpWPath));
            tmpFoundElements.addAll(tmpControlFinder.getAllOtherControls(tmpWPath));
            tmpFoundElements.addAll(tmpControlFinder.getAllControlsForText(tmpWPath));
            IControl tmpControl = DefaultCommandSet.this.getFirstRequiredHtmlElementFrom(aContext, tmpFoundElements, tmpWPath, "noHtmlElementFound");
            tmpBrowser.markControls(tmpControl);
            boolean tmpIsDisabled = tmpControl.isDisabled(aContext);
            Assert.assertTrue(tmpIsDisabled, "elementNotDisabled", tmpControl.getDescribingText());
        }
    }

    public final class CommandAssertEnabled
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            WPath tmpWPath = new WPath(aCommand.getRequiredFirstParameterValue(aContext), aContext.getConfiguration());
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            IBrowser tmpBrowser = DefaultCommandSet.this.getBrowser(aContext);
            IControlFinder tmpControlFinder = DefaultCommandSet.this.getControlFinder(tmpBrowser);
            WeightedControlList tmpFoundElements = tmpControlFinder.getAllSettables(tmpWPath);
            tmpFoundElements.addAll(tmpControlFinder.getAllSelectables(tmpWPath));
            tmpFoundElements.addAll(tmpControlFinder.getAllClickables(tmpWPath));
            tmpFoundElements.addAll(tmpControlFinder.getAllOtherControls(tmpWPath));
            tmpFoundElements.addAll(tmpControlFinder.getAllControlsForText(tmpWPath));
            IControl tmpControl = DefaultCommandSet.this.getFirstRequiredHtmlElementFrom(aContext, tmpFoundElements, tmpWPath, "noHtmlElementFound");
            tmpBrowser.markControls(tmpControl);
            boolean tmpIsDisabled = tmpControl.isDisabled(aContext);
            Assert.assertFalse(tmpIsDisabled, "elementNotEnabled", tmpControl.getDescribingText());
        }
    }

    public final class CommandAssertContent
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            ContentPattern tmpPattern = new ContentPattern(aCommand.getRequiredFirstParameterValue(aContext));
            Long tmpTimeout = aCommand.getSecondParameterLongValue(aContext);
            if (null == tmpTimeout) {
                tmpTimeout = 0L;
            }
            aCommand.checkNoUnusedThirdParameter(aContext);
            tmpTimeout = Math.max(0L, tmpTimeout);
            IBrowser tmpBrowser = DefaultCommandSet.this.getBrowser(aContext);
            try {
                boolean tmpContentChanged = tmpBrowser.assertContentInTimeFrame(tmpPattern, tmpTimeout);
                if (tmpContentChanged) {
                    tmpBrowser.saveCurrentWindowToLog(new IControl[0]);
                }
            }
            catch (AssertionException e) {
                tmpBrowser.saveCurrentWindowToLog(new IControl[0]);
                throw e;
            }
        }
    }

    public final class CommandAssertTitle
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            ContentPattern tmpPattern = new ContentPattern(aCommand.getRequiredFirstParameterValue(aContext));
            Long tmpTimeout = aCommand.getSecondParameterLongValue(aContext);
            if (null == tmpTimeout) {
                tmpTimeout = 0L;
            }
            aCommand.checkNoUnusedThirdParameter(aContext);
            tmpTimeout = Math.max(0L, tmpTimeout);
            IBrowser tmpBrowser = DefaultCommandSet.this.getBrowser(aContext);
            try {
                boolean tmpContentChanged = tmpBrowser.assertTitleInTimeFrame(tmpPattern, tmpTimeout);
                if (tmpContentChanged) {
                    tmpBrowser.saveCurrentWindowToLog(new IControl[0]);
                }
            }
            catch (AssertionException e) {
                tmpBrowser.saveCurrentWindowToLog(new IControl[0]);
                throw e;
            }
        }
    }

    public final class CommandGoBack
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            SecretString tmpStepsParam = aCommand.getFirstParameterValue(aContext);
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            int tmpSteps = 1;
            if (!tmpStepsParam.isEmpty()) {
                try {
                    tmpSteps = Integer.parseInt(tmpStepsParam.getValue());
                }
                catch (NumberFormatException e) {
                    String tmpMessage = Messages.getMessage("stepsNotANumber", tmpStepsParam.toString(), Integer.toString(tmpSteps));
                    throw new InvalidInputException(tmpMessage);
                }
            }
            IBrowser tmpBrowser = DefaultCommandSet.this.getBrowser(aContext);
            tmpBrowser.goBackInCurrentWindow(tmpSteps);
            tmpBrowser.saveCurrentWindowToLog(new IControl[0]);
        }
    }

    public final class CommandCloseWindow
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            SecretString tmpWindowNameParam = aCommand.getFirstParameterValue(aContext);
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            IBrowser tmpBrowser = DefaultCommandSet.this.getBrowser(aContext);
            tmpBrowser.closeWindow(tmpWindowNameParam);
            tmpBrowser.saveCurrentWindowToLog(new IControl[0]);
        }
    }

    public final class CommandMouseOver
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            WPath tmpWPath = new WPath(aCommand.getRequiredFirstParameterValue(aContext), aContext.getConfiguration());
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            IBrowser tmpBrowser = DefaultCommandSet.this.getBrowser(aContext);
            IControlFinder tmpControlFinder = DefaultCommandSet.this.getControlFinder(tmpBrowser);
            WeightedControlList tmpFoundElements = tmpControlFinder.getAllSettables(tmpWPath);
            tmpFoundElements.addAll(tmpControlFinder.getAllSelectables(tmpWPath));
            tmpFoundElements.addAll(tmpControlFinder.getAllClickables(tmpWPath));
            tmpFoundElements.addAll(tmpControlFinder.getAllOtherControls(tmpWPath));
            tmpFoundElements.addAll(tmpControlFinder.getAllControlsForText(tmpWPath));
            IControl tmpControl = DefaultCommandSet.this.getFirstRequiredHtmlElementFrom(aContext, tmpFoundElements, tmpWPath, "noHtmlElementFound");
            tmpBrowser.markControls(tmpControl);
            tmpControl.mouseOver(aContext);
            tmpBrowser.saveCurrentWindowToLog(new IControl[0]);
        }
    }

    public final class CommandDeselect
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            WPath tmpWPath = new WPath(aCommand.getRequiredFirstParameterValue(aContext), aContext.getConfiguration());
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            IBrowser tmpBrowser = DefaultCommandSet.this.getBrowser(aContext);
            IControlFinder tmpControlFinder = DefaultCommandSet.this.getControlFinder(tmpBrowser);
            WeightedControlList tmpFoundElements = tmpControlFinder.getAllDeselectables(tmpWPath);
            IDeselectable tmpControl = (IDeselectable)DefaultCommandSet.this.getFirstRequiredHtmlElementFrom(aContext, tmpFoundElements, tmpWPath, "noDeselectableHtmlElmentFound");
            tmpBrowser.markControls(tmpControl);
            tmpControl.deselect(aContext);
            tmpBrowser.saveCurrentWindowToLog(tmpControl);
        }
    }

    public final class CommandSelect
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            WPath tmpWPath = new WPath(aCommand.getRequiredFirstParameterValue(aContext), aContext.getConfiguration());
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            IBrowser tmpBrowser = DefaultCommandSet.this.getBrowser(aContext);
            IControlFinder tmpControlFinder = DefaultCommandSet.this.getControlFinder(tmpBrowser);
            WeightedControlList tmpFoundElements = tmpControlFinder.getAllSelectables(tmpWPath);
            ISelectable tmpControl = (ISelectable)DefaultCommandSet.this.getFirstRequiredHtmlElementFrom(aContext, tmpFoundElements, tmpWPath, "noSelectableHtmlElmentFound");
            tmpBrowser.markControls(tmpControl);
            tmpControl.select(aContext);
            tmpBrowser.saveCurrentWindowToLog(tmpControl);
        }
    }

    public final class CommandClickRightOn
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            WPath tmpWPath = new WPath(aCommand.getRequiredFirstParameterValue(aContext), aContext.getConfiguration());
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            IBrowser tmpBrowser = DefaultCommandSet.this.getBrowser(aContext);
            IControlFinder tmpControlFinder = DefaultCommandSet.this.getControlFinder(tmpBrowser);
            WeightedControlList tmpFoundElements = tmpControlFinder.getAllSettables(tmpWPath);
            tmpFoundElements.addAll(tmpControlFinder.getAllSelectables(tmpWPath));
            tmpFoundElements.addAll(tmpControlFinder.getAllClickables(tmpWPath));
            tmpFoundElements.addAll(tmpControlFinder.getAllOtherControls(tmpWPath));
            tmpFoundElements.addAll(tmpControlFinder.getAllControlsForText(tmpWPath));
            IControl tmpControl = DefaultCommandSet.this.getFirstRequiredHtmlElementFrom(aContext, tmpFoundElements, tmpWPath, "noRClickableHtmlElmentFound");
            tmpBrowser.markControls(tmpControl);
            tmpControl.clickRight(aContext);
            tmpBrowser.saveCurrentWindowToLog(tmpControl);
        }
    }

    public final class CommandClickDoubleOn
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            WPath tmpWPath = new WPath(aCommand.getRequiredFirstParameterValue(aContext), aContext.getConfiguration());
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            IBrowser tmpBrowser = DefaultCommandSet.this.getBrowser(aContext);
            IControlFinder tmpControlFinder = DefaultCommandSet.this.getControlFinder(tmpBrowser);
            WeightedControlList tmpFoundElements = tmpControlFinder.getAllSettables(tmpWPath);
            tmpFoundElements.addAll(tmpControlFinder.getAllSelectables(tmpWPath));
            tmpFoundElements.addAll(tmpControlFinder.getAllClickables(tmpWPath));
            tmpFoundElements.addAll(tmpControlFinder.getAllOtherControls(tmpWPath));
            tmpFoundElements.addAll(tmpControlFinder.getAllControlsForText(tmpWPath));
            IControl tmpControl = DefaultCommandSet.this.getFirstRequiredHtmlElementFrom(aContext, tmpFoundElements, tmpWPath, "no2ClickableHtmlElmentFound");
            tmpBrowser.markControls(tmpControl);
            tmpControl.clickDouble(aContext);
            tmpBrowser.saveCurrentWindowToLog(tmpControl);
        }
    }

    public final class CommandClickOn
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            WPath tmpWPath = new WPath(aCommand.getRequiredFirstParameterValue(aContext), aContext.getConfiguration());
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            IBrowser tmpBrowser = DefaultCommandSet.this.getBrowser(aContext);
            IControlFinder tmpControlFinder = DefaultCommandSet.this.getControlFinder(tmpBrowser);
            WeightedControlList tmpFoundElements = tmpControlFinder.getAllClickables(tmpWPath);
            tmpFoundElements.addAll(tmpControlFinder.getAllControlsForText(tmpWPath));
            IControl tmpControl = DefaultCommandSet.this.getFirstRequiredHtmlElementFrom(aContext, tmpFoundElements, tmpWPath, "noClickableHtmlElmentFound");
            tmpBrowser.markControls(tmpControl);
            tmpControl.click(aContext);
            tmpBrowser.saveCurrentWindowToLog(tmpControl);
        }
    }

    public final class CommandSet
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            WPath tmpWPath = new WPath(aCommand.getFirstParameterValue(aContext), aContext.getConfiguration());
            SecretString tmpValueParam = aCommand.getSecondParameterValue(aContext);
            if (null == tmpValueParam) {
                tmpValueParam = new SecretString("");
            }
            aCommand.checkNoUnusedThirdParameter(aContext);
            IBrowser tmpBrowser = DefaultCommandSet.this.getBrowser(aContext);
            ISettable tmpControl = null;
            if (tmpWPath.isEmpty()) {
                try {
                    IControl tmpFocusedControl = tmpBrowser.getFocusedControl();
                    if (tmpFocusedControl instanceof ISettable) {
                        tmpControl = (ISettable)tmpFocusedControl;
                    }
                    if (tmpControl != null) {
                        aContext.informListenersWarn("focusedElementUsed", tmpControl.getDescribingText());
                    }
                }
                catch (BackendException e) {
                    String tmpMessage = Messages.getMessage("commandBackendError", e.getMessage());
                    throw new ActionException(tmpMessage, e);
                }
            }
            if (tmpControl == null) {
                IControlFinder tmpControlFinder = DefaultCommandSet.this.getControlFinder(tmpBrowser);
                WeightedControlList tmpFoundElements = tmpControlFinder.getAllSettables(tmpWPath);
                if (tmpWPath.isEmpty()) {
                    WeightedControlList.Entry tmpEntry;
                    Iterator<WeightedControlList.Entry> iterator = tmpFoundElements.getEntriesSorted().iterator();
                    while (iterator.hasNext() && (tmpControl = (ISettable)(tmpEntry = iterator.next()).getControl()).isDisabled(aContext)) {
                    }
                    if (null == tmpControl) {
                        String tmpMessage = Messages.getMessage("noSettableHtmlElmentFound", tmpWPath.toString());
                        throw new ActionException(tmpMessage);
                    }
                    aContext.informListenersWarn("firstElementUsed", tmpControl.getDescribingText());
                } else {
                    tmpControl = (ISettable)DefaultCommandSet.this.getFirstRequiredHtmlElementFrom(aContext, tmpFoundElements, tmpWPath, "noSettableHtmlElmentFound");
                }
            }
            tmpBrowser.markControls(tmpControl);
            tmpControl.setValue(aContext, tmpValueParam, aContext.getFile().getParentFile());
            tmpBrowser.saveCurrentWindowToLog(tmpControl);
        }
    }

    @ForceExecution
    public static final class CommandUseModule
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            SecretString tmpModuleParameter = aCommand.getRequiredFirstParameterValue(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            String tmpModule = tmpModuleParameter.getValue();
            File tmpFile = new File(tmpModule);
            if (!tmpFile.isAbsolute()) {
                tmpFile = new File(aContext.getFile().getParent(), tmpModule);
                aContext.informListenersInfo("useModule", tmpFile.getAbsolutePath());
            }
            if (!tmpFile.exists() || !tmpFile.isFile()) {
                String tmpMessage = Messages.getMessage("moduleFileNotFound", FilenameUtils.normalize((String)tmpFile.getAbsolutePath()));
                throw new InvalidInputException(tmpMessage);
            }
            WetatorContext tmpWetatorContext = aContext.createSubContext(tmpFile);
            List<SecretString> tmpModuleParameters = aCommand.getSecondParameterValues(aContext);
            int i = 1;
            for (SecretString tmpSecretString : tmpModuleParameters) {
                Variable tmpVariable = new Variable(Integer.toString(i), tmpSecretString);
                tmpWetatorContext.addVariable(tmpVariable);
                ++i;
            }
            tmpWetatorContext.execute();
        }
    }

    public final class CommandOpenUrl
    implements ICommandImplementation {
        private static final String SLASH = "/";

        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            SecretString tmpUrlParam = aCommand.getRequiredFirstParameterValue(aContext);
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            try {
                String tmpUrlToLower = tmpUrlParam.toLowerCase(Locale.ENGLISH);
                if (tmpUrlToLower.startsWith("http://") || tmpUrlToLower.startsWith("https://") || tmpUrlToLower.startsWith("file://")) {
                    aContext.informListenersWarn("absoluteUrl", tmpUrlParam.toString());
                } else {
                    String tmpBaseUrl = aContext.getConfiguration().getBaseUrl();
                    if (tmpUrlParam.startsWith(SLASH) && tmpBaseUrl.endsWith(SLASH)) {
                        tmpUrlParam = tmpUrlParam.substring(1);
                    } else if (!tmpUrlParam.startsWith(SLASH) && !tmpBaseUrl.endsWith(SLASH)) {
                        tmpUrlParam.prefixWith(SLASH);
                    }
                    tmpUrlParam.prefixWith(tmpBaseUrl);
                }
                URL tmpUrl = new URL(tmpUrlParam.getValue());
                aContext.informListenersInfo("openUrl", tmpUrl.toString());
                IBrowser tmpBrowser = DefaultCommandSet.this.getBrowser(aContext);
                tmpBrowser.openUrl(tmpUrl);
            }
            catch (MalformedURLException e) {
                String tmpMessage = Messages.getMessage("invalidUrl", tmpUrlParam.toString(), e.getMessage());
                throw new InvalidInputException(tmpMessage);
            }
            DefaultCommandSet.this.getBrowser(aContext).saveCurrentWindowToLog(new IControl[0]);
        }
    }

    public static final class CommandDescribe
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            SecretString tmpMarkdown = aCommand.getRequiredFirstParameterValue(aContext);
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            String tmpHtml = Processor.process((String)tmpMarkdown.toString());
            aContext.informListenersHtmlDocu(tmpHtml.trim());
        }
    }
}

