/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.commandset;

import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.HtmlApplet;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.applet.Applet;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.wetator.backend.IBrowser;
import org.wetator.backend.IControlFinder;
import org.wetator.backend.WPath;
import org.wetator.backend.WeightedControlList;
import org.wetator.backend.control.IControl;
import org.wetator.backend.control.KeySequence;
import org.wetator.backend.htmlunit.HtmlUnitBrowser;
import org.wetator.commandset.AbstractCommandSet;
import org.wetator.core.Command;
import org.wetator.core.ICommandImplementation;
import org.wetator.core.WetatorContext;
import org.wetator.core.searchpattern.ContentPattern;
import org.wetator.exception.ActionException;
import org.wetator.exception.AssertionException;
import org.wetator.exception.BackendException;
import org.wetator.exception.CommandException;
import org.wetator.exception.InvalidInputException;
import org.wetator.i18n.Messages;
import org.wetator.util.Assert;
import org.wetator.util.SecretString;

public final class IncubatorCommandSet
extends AbstractCommandSet {
    @Override
    protected void registerCommands() {
        this.registerCommand("assert-focus", new CommandAssertFocus());
        this.registerCommand("save-bookmark", new CommandSaveBookmark());
        this.registerCommand("open-bookmark", new CommandOpenBookmark());
        this.registerCommand("assert-applet", new CommandAssertApplet());
        this.registerCommand("exec-js", new CommandExecJs());
        this.registerCommand("type", new CommandType());
        this.registerCommand("confirm-next", new CommandConfirmNext());
        this.registerCommand("wait", new CommandWait());
    }

    @Override
    public void initialize(Properties aConfiguration) {
    }

    @Override
    public void cleanup() {
    }

    public final class CommandType
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            String tmpKeys = aCommand.getRequiredFirstParameterValue(aContext).getValue();
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            IBrowser tmpBrowser = IncubatorCommandSet.this.getBrowser(aContext);
            try {
                IControl tmpFocusedControl = tmpBrowser.getFocusedControl();
                tmpBrowser.markControls(tmpFocusedControl);
                tmpFocusedControl.type(aContext, KeySequence.parse(tmpKeys));
                tmpBrowser.saveCurrentWindowToLog(tmpFocusedControl);
            }
            catch (BackendException e) {
                String tmpMessage = Messages.getMessage("commandBackendError", e.getMessage());
                throw new ActionException(tmpMessage, e);
            }
        }
    }

    public final class CommandAssertApplet
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            SecretString tmpAppletName = aCommand.getFirstParameterValue(aContext);
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            boolean tmpAppletTested = false;
            String tmpAppletNameValue = "";
            if (null != tmpAppletName) {
                tmpAppletNameValue = tmpAppletName.getValue();
            }
            try {
                IBrowser tmpBrowser = IncubatorCommandSet.this.getBrowser(aContext);
                if (tmpBrowser instanceof HtmlUnitBrowser) {
                    HtmlUnitBrowser tmpHtmlUnitBrowser = (HtmlUnitBrowser)tmpBrowser;
                    HtmlPage tmpHtmlPage = tmpHtmlUnitBrowser.getCurrentHtmlPage();
                    DomNodeList tmpAppletElements = tmpHtmlPage.getElementsByTagName("applet");
                    for (DomElement tmpAppletElement : tmpAppletElements) {
                        HtmlApplet tmpHtmlApplet = (HtmlApplet)tmpAppletElement;
                        if (!StringUtils.isEmpty((CharSequence)tmpAppletNameValue) && !tmpAppletNameValue.equals(tmpHtmlApplet.getNameAttribute())) continue;
                        aContext.informListenersInfo("assertApplet", tmpAppletNameValue);
                        tmpAppletTested = true;
                        try {
                            Applet tmpApplet = tmpHtmlApplet.getApplet();
                            tmpApplet.stop();
                            tmpApplet.destroy();
                        }
                        catch (Exception e) {
                            aContext.informListenersWarn("stacktrace", ExceptionUtils.getStackTrace((Throwable)e));
                            this.checkArchiveAvailability(aContext, tmpHtmlApplet);
                            String tmpMessage = Messages.getMessage("assertAppletFailed", tmpHtmlApplet.getNameAttribute(), e.getMessage());
                            throw new AssertionException(tmpMessage, e);
                        }
                    }
                    if (!tmpAppletTested) {
                        String tmpMessage = Messages.getMessage("assertAppletNotFound", tmpAppletNameValue);
                        throw new AssertionException(tmpMessage);
                    }
                }
            }
            catch (BackendException e) {
                String tmpMessage = Messages.getMessage("commandBackendError", e.getMessage());
                throw new AssertionException(tmpMessage, e);
            }
        }

        private void checkArchiveAvailability(WetatorContext aContext, HtmlApplet aHtmlApplet) {
            aContext.informListenersWarn("assertAppletArchives", aHtmlApplet.getArchiveAttribute());
            List tmpJarUrls = aHtmlApplet.getArchiveUrls();
            if (null != tmpJarUrls) {
                for (URL tmpJarUrl : tmpJarUrls) {
                    try {
                        InputStream tmpIs = tmpJarUrl.openStream();
                        Throwable throwable = null;
                        if (tmpIs == null) continue;
                        if (throwable != null) {
                            try {
                                tmpIs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            continue;
                        }
                        tmpIs.close();
                    }
                    catch (Exception eUrl) {
                        aContext.informListenersWarn("assertAppletUnreachableJar", tmpJarUrl.toString(), eUrl.toString());
                    }
                }
            }
        }
    }

    public final class CommandConfirmNext
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            SecretString tmpButton = aCommand.getRequiredFirstParameterValue(aContext);
            if (!"ok".equalsIgnoreCase(tmpButton.getValue()) && !"cancel".equalsIgnoreCase(tmpButton.getValue())) {
                String tmpMessage = Messages.getMessage("confirmationOkOrCancel", tmpButton.toString());
                throw new InvalidInputException(tmpMessage);
            }
            ContentPattern tmpPattern = new ContentPattern(aCommand.getRequiredSecondParameterValue(aContext));
            IBrowser tmpBrowser = IncubatorCommandSet.this.getBrowser(aContext);
            if (tmpBrowser instanceof HtmlUnitBrowser) {
                HtmlUnitBrowser tmpHtmlUnitBrowser = (HtmlUnitBrowser)tmpBrowser;
                if ("ok".equalsIgnoreCase(tmpButton.getValue())) {
                    tmpHtmlUnitBrowser.chooseOkOnNextConfirmFor(tmpPattern);
                } else {
                    tmpHtmlUnitBrowser.chooseCancelOnNextConfirmFor(tmpPattern);
                }
            }
        }
    }

    public final class CommandExecJs
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            SecretString tmpJsString = aCommand.getRequiredFirstParameterValue(aContext);
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            try {
                IBrowser tmpBrowser = IncubatorCommandSet.this.getBrowser(aContext);
                if (tmpBrowser instanceof HtmlUnitBrowser) {
                    HtmlUnitBrowser tmpHtmlUnitBrowser = (HtmlUnitBrowser)tmpBrowser;
                    HtmlPage tmpHtmlPage = tmpHtmlUnitBrowser.getCurrentHtmlPage();
                    tmpHtmlPage.executeJavaScript(tmpJsString.getValue());
                    tmpHtmlUnitBrowser.waitForImmediateJobs();
                    tmpBrowser.saveCurrentWindowToLog(new IControl[0]);
                }
            }
            catch (BackendException e) {
                String tmpMessage = Messages.getMessage("commandBackendError", e.getMessage());
                throw new AssertionException(tmpMessage, e);
            }
        }
    }

    public final class CommandWait
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            long tmpWaitTime;
            SecretString tmpWaitTimeString = aCommand.getRequiredFirstParameterValue(aContext);
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            try {
                BigDecimal tmpValue = new BigDecimal(tmpWaitTimeString.getValue());
                tmpWaitTime = tmpValue.longValueExact();
            }
            catch (ArithmeticException | NumberFormatException e) {
                String tmpMessage = Messages.getMessage("integerParameterExpected", "wait", tmpWaitTimeString.toString(), "1");
                throw new InvalidInputException(tmpMessage);
            }
            IBrowser tmpBrowser = IncubatorCommandSet.this.getBrowser(aContext);
            try {
                Thread.sleep(tmpWaitTime * 1000L);
                tmpBrowser.saveCurrentWindowToLog(new IControl[0]);
            }
            catch (InterruptedException e) {
                String tmpMessage = Messages.getMessage("waitError", new Object[0]);
                throw new ActionException(tmpMessage, e);
            }
        }
    }

    public final class CommandSaveBookmark
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            SecretString tmpBookmarkName = aCommand.getRequiredFirstParameterValue(aContext);
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            IBrowser tmpBrowser = IncubatorCommandSet.this.getBrowser(aContext);
            tmpBrowser.bookmarkPage(tmpBookmarkName.getValue());
        }
    }

    public final class CommandOpenBookmark
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            SecretString tmpBookmarkName = aCommand.getRequiredFirstParameterValue(aContext);
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            IBrowser tmpBrowser = IncubatorCommandSet.this.getBrowser(aContext);
            URL tmpUrl = tmpBrowser.getBookmark(tmpBookmarkName.getValue());
            if (tmpUrl == null) {
                String tmpMessage = Messages.getMessage("unknownBookmark", tmpBookmarkName.getValue());
                throw new ActionException(tmpMessage);
            }
            aContext.informListenersInfo("openUrl", tmpUrl.toString());
            tmpBrowser.openUrl(tmpUrl);
            tmpBrowser.saveCurrentWindowToLog(new IControl[0]);
        }
    }

    public final class CommandAssertFocus
    implements ICommandImplementation {
        @Override
        public void execute(WetatorContext aContext, Command aCommand) throws CommandException, InvalidInputException {
            WPath tmpWPath = new WPath(aCommand.getRequiredFirstParameterValue(aContext), aContext.getConfiguration());
            aCommand.checkNoUnusedSecondParameter(aContext);
            aCommand.checkNoUnusedThirdParameter(aContext);
            IBrowser tmpBrowser = IncubatorCommandSet.this.getBrowser(aContext);
            IControlFinder tmpControlFinder = IncubatorCommandSet.this.getControlFinder(tmpBrowser);
            WeightedControlList tmpFoundElements = tmpControlFinder.getAllSettables(tmpWPath);
            tmpFoundElements.addAll(tmpControlFinder.getAllSelectables(tmpWPath));
            tmpFoundElements.addAll(tmpControlFinder.getAllClickables(tmpWPath));
            tmpFoundElements.addAll(tmpControlFinder.getAllOtherControls(tmpWPath));
            tmpFoundElements.addAll(tmpControlFinder.getAllControlsForText(tmpWPath));
            IControl tmpControl = IncubatorCommandSet.this.getFirstRequiredHtmlElementFrom(aContext, tmpFoundElements, tmpWPath, "noHtmlElementFound");
            tmpBrowser.markControls(tmpControl);
            boolean tmpHasFocus = tmpControl.hasFocus(aContext);
            Assert.assertTrue(tmpHasFocus, "elementNotFocused", tmpControl.getDescribingText());
        }
    }
}

