/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.core;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import org.wetator.core.Parameter;
import org.wetator.core.WetatorContext;
import org.wetator.exception.InvalidInputException;
import org.wetator.i18n.Messages;
import org.wetator.util.SecretString;

public final class Command {
    private String name;
    private boolean comment;
    private Parameter firstParameter;
    private Parameter secondParameter;
    private Parameter thirdParameter;
    private int lineNo;

    public Command(String aName, boolean anIsCommentFlag) {
        this.name = aName;
        this.comment = anIsCommentFlag;
        this.lineNo = -1;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public void setLineNo(int aLineNo) {
        this.lineNo = aLineNo;
    }

    public String getName() {
        return this.name;
    }

    public boolean isComment() {
        return this.comment;
    }

    public Parameter getFirstParameter() {
        return this.firstParameter;
    }

    public void setFirstParameter(Parameter aFirstParameter) {
        this.firstParameter = aFirstParameter;
    }

    public Parameter getSecondParameter() {
        return this.secondParameter;
    }

    public void setSecondParameter(Parameter aSecondParameter) {
        this.secondParameter = aSecondParameter;
    }

    public Parameter getThirdParameter() {
        return this.thirdParameter;
    }

    public void setThirdParameter(Parameter aThirdParameter) {
        this.thirdParameter = aThirdParameter;
    }

    public String toPrintableString(WetatorContext aContext) {
        StringBuilder tmpResult = new StringBuilder("[Command '").append(this.getName()).append('\'');
        if (this.comment) {
            tmpResult.append(" COMMENT");
        }
        Parameter tmpParameter = this.getFirstParameter();
        tmpResult.append(" firstParam: '");
        if (null != tmpParameter) {
            tmpResult.append(tmpParameter.getValue(aContext).toString());
        }
        tmpResult.append('\'');
        tmpParameter = this.getSecondParameter();
        tmpResult.append(" '");
        if (null != tmpParameter) {
            tmpResult.append(this.getSecondParameter().getValue(aContext).toString());
        }
        tmpResult.append('\'');
        tmpParameter = this.getThirdParameter();
        if (null != tmpParameter) {
            tmpResult.append(" '").append(this.getThirdParameter().getValue(aContext).toString()).append('\'');
        }
        tmpResult.append(']');
        return tmpResult.toString();
    }

    public SecretString getFirstParameterValue(WetatorContext aContext) {
        Parameter tmpFirstParameter = this.getFirstParameter();
        if (null == tmpFirstParameter) {
            return new SecretString();
        }
        return tmpFirstParameter.getValue(aContext);
    }

    public SecretString getRequiredFirstParameterValue(WetatorContext aContext) throws InvalidInputException {
        Parameter tmpFirstParameter = this.getFirstParameter();
        if (null == tmpFirstParameter) {
            Command.invalidInput("emptyFirstParameter", this.getName());
        }
        return tmpFirstParameter.getValue(aContext);
    }

    public List<SecretString> getSecondParameterValues(WetatorContext aContext) {
        Parameter tmpSecondParameter = this.getSecondParameter();
        LinkedList<SecretString> tmpResult = new LinkedList<SecretString>();
        if (null == tmpSecondParameter) {
            return tmpResult;
        }
        List<Parameter.Part> tmpParts = tmpSecondParameter.getParts();
        for (Parameter.Part tmpPart : tmpParts) {
            tmpResult.add(tmpPart.getValue(aContext));
        }
        return tmpResult;
    }

    public SecretString getSecondParameterValue(WetatorContext aContext) {
        Parameter tmpSecondParameter = this.getSecondParameter();
        if (null == tmpSecondParameter) {
            return null;
        }
        return tmpSecondParameter.getValue(aContext);
    }

    public Long getSecondParameterLongValue(WetatorContext aContext) throws InvalidInputException {
        Parameter tmpSecondParameter = this.getSecondParameter();
        if (null == tmpSecondParameter) {
            return null;
        }
        SecretString tmpSecondValue = tmpSecondParameter.getValue(aContext);
        if (tmpSecondValue.isEmpty()) {
            return null;
        }
        try {
            BigDecimal tmpValue = new BigDecimal(tmpSecondValue.getValue());
            return tmpValue.longValueExact();
        }
        catch (ArithmeticException | NumberFormatException e) {
            Command.invalidInput("integerParameterExpected", this.getName(), tmpSecondParameter.getValue(aContext).toString(), "2");
            return null;
        }
    }

    public List<SecretString> getRequiredSecondParameterValues(WetatorContext aContext) throws InvalidInputException {
        Parameter tmpSecondParameter = this.getSecondParameter();
        if (null == tmpSecondParameter) {
            Command.invalidInput("emptySecondParameter", this.getName());
        }
        return this.getSecondParameterValues(aContext);
    }

    public SecretString getRequiredSecondParameterValue(WetatorContext aContext) throws InvalidInputException {
        Parameter tmpSecondParameter = this.getSecondParameter();
        if (null == tmpSecondParameter) {
            Command.invalidInput("emptySecondParameter", this.getName());
        }
        return tmpSecondParameter.getValue(aContext);
    }

    public void checkNoUnusedSecondParameter(WetatorContext aContext) throws InvalidInputException {
        Parameter tmpParameter = this.getSecondParameter();
        if (null != tmpParameter) {
            Command.invalidInput("unusedParameter", this.getName(), tmpParameter.getValue(aContext).toString(), "2");
        }
    }

    public void checkNoUnusedThirdParameter(WetatorContext aContext) throws InvalidInputException {
        Parameter tmpParameter = this.getThirdParameter();
        if (null != tmpParameter) {
            Command.invalidInput("unusedParameter", this.getName(), tmpParameter.getValue(aContext).toString(), "3");
        }
    }

    private static void invalidInput(String aMessageKey, Object ... aParameters) throws InvalidInputException {
        String tmpMessage = Messages.getMessage(aMessageKey, aParameters);
        throw new InvalidInputException(tmpMessage);
    }
}

