/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.core;

import org.apache.commons.lang3.StringUtils;
import org.wetator.util.SecretString;

public final class Variable {
    private String name;
    private SecretString value;

    public Variable(String aName, String aValue) {
        this(aName, aValue, false);
    }

    public Variable(String aName, String aValue, boolean anSecretFlag) {
        if (StringUtils.isBlank((CharSequence)aName)) {
            throw new IllegalArgumentException("The variable's name is mandatory.");
        }
        this.name = aName;
        this.value = anSecretFlag ? new SecretString().appendSecret(aValue) : new SecretString(aValue);
    }

    public Variable(String aName, SecretString aValue) {
        if (StringUtils.isBlank((CharSequence)aName)) {
            throw new IllegalArgumentException("The variable's name is mandatory.");
        }
        this.name = aName;
        this.value = aValue;
    }

    public String getName() {
        return this.name;
    }

    public SecretString getValue() {
        return this.value;
    }
}

