/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.gui;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JWindow;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wetator.Wetator;
import org.wetator.i18n.Messages;
import org.wetator.util.StringUtil;

public final class DialogUtil {
    private static final Logger LOG = LogManager.getLogger(DialogUtil.class);
    private static final char FILE_SEPARATOR = ';';
    private static final String LAST_DIR = "lastDir";
    private static final String LAST_FILES = "lastFiles";
    private static final String LAST_X = "lastX";
    private static final String LAST_Y = "lastY";
    private static final String LAST_WIDTH = "lastWidth";
    private static final String LAST_HEIGHT = "lastHeight";

    public static File chooseFile(JWindow aWindow, String aPropertyKey) {
        File[] tmpResult = DialogUtil.chooseFilesSwing(aWindow, aPropertyKey, false);
        if (null == tmpResult) {
            return null;
        }
        return tmpResult[0];
    }

    public static File[] chooseFiles(JWindow aWindow, String aPropertyKey) {
        File[] tmpResult = DialogUtil.chooseFilesSwing(aWindow, aPropertyKey, true);
        return tmpResult;
    }

    private static File[] chooseFilesSwing(JWindow aWindow, String aPropertyKey, boolean aMultiSelectionFlag) {
        File tmpLastDir;
        Preferences tmpPreferences = Preferences.userNodeForPackage(Wetator.class);
        String tmpLastDirName = null;
        if (!(null == aPropertyKey || (tmpLastDir = new File(tmpLastDirName = tmpPreferences.get("lastDir_" + aPropertyKey, ""))).exists() && tmpLastDir.isDirectory())) {
            tmpLastDirName = null;
        }
        if (StringUtils.isBlank(tmpLastDirName)) {
            tmpLastDirName = tmpPreferences.get(LAST_DIR, "");
        }
        if (!(tmpLastDir = new File(tmpLastDirName)).exists() || !tmpLastDir.isDirectory()) {
            tmpLastDir = null;
        }
        LookAndFeel tmpCurrentLook = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        PlaceableFileChooser tmpFileChooser = new PlaceableFileChooser(tmpPreferences);
        tmpFileChooser.setFileSelectionMode(0);
        tmpFileChooser.setMultiSelectionEnabled(aMultiSelectionFlag);
        tmpFileChooser.setDialogTitle(Messages.getMessage("fileChooserTitle", new Object[0]));
        tmpFileChooser.setCurrentDirectory(tmpLastDir);
        File[] tmpOldFiles = DialogUtil.restoreFiles(tmpPreferences, tmpLastDir);
        try {
            tmpFileChooser.setSelectedFiles(tmpOldFiles);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        try {
            UIManager.setLookAndFeel(tmpCurrentLook);
        }
        catch (Exception e) {
            // empty catch block
        }
        int tmpChooserAction = ((JFileChooser)tmpFileChooser).showOpenDialog(aWindow);
        switch (tmpChooserAction) {
            case 0: {
                if (aMultiSelectionFlag) {
                    File[] tmpSelectedFiles = tmpFileChooser.getSelectedFiles();
                    if (tmpSelectedFiles.length > 0) {
                        tmpPreferences.put(LAST_DIR, tmpSelectedFiles[0].getParentFile().getAbsolutePath());
                        if (null != aPropertyKey) {
                            tmpPreferences.put("lastDir_" + aPropertyKey, tmpSelectedFiles[0].getParentFile().getAbsolutePath());
                        }
                    }
                    DialogUtil.storeFiles(tmpPreferences, tmpSelectedFiles);
                    return tmpSelectedFiles;
                }
                File tmpSelectedFile = tmpFileChooser.getSelectedFile();
                if (null == tmpSelectedFile) {
                    return null;
                }
                DialogUtil.storeFiles(tmpPreferences, tmpSelectedFile);
                return new File[]{tmpSelectedFile};
            }
            case 1: {
                return null;
            }
        }
        return null;
    }

    private DialogUtil() {
    }

    public static void storeOptions(Preferences aPreferences, JDialog aDialog) {
        if (null == aDialog) {
            return;
        }
        Rectangle tmpBounds = aDialog.getBounds();
        aPreferences.put(LAST_X, Integer.toString((int)tmpBounds.getX()));
        aPreferences.put(LAST_Y, Integer.toString((int)tmpBounds.getY()));
        aPreferences.put(LAST_WIDTH, Integer.toString((int)tmpBounds.getWidth()));
        aPreferences.put(LAST_HEIGHT, Integer.toString((int)tmpBounds.getHeight()));
    }

    public static void restoreOptions(Preferences aPreferences, JDialog aDialog) {
        GraphicsDevice[] tmpDevices;
        int tmpX = Integer.parseInt(aPreferences.get(LAST_X, "-1"));
        int tmpY = Integer.parseInt(aPreferences.get(LAST_Y, "-1"));
        int tmpWidth = Integer.parseInt(aPreferences.get(LAST_WIDTH, "-1"));
        int tmpHeight = Integer.parseInt(aPreferences.get(LAST_HEIGHT, "-1"));
        Rectangle tmpBounds = new Rectangle(tmpX, tmpY, tmpWidth, tmpHeight);
        GraphicsEnvironment tmpGEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice tmpGraphicsDevice : tmpDevices = tmpGEnv.getScreenDevices()) {
            GraphicsConfiguration[] tmpConfigs;
            for (GraphicsConfiguration tmpGraphicsConfiguration : tmpConfigs = tmpGraphicsDevice.getConfigurations()) {
                Rectangle2D tmpVisibleRect = tmpGraphicsConfiguration.getBounds().createIntersection(tmpBounds);
                if (!(tmpVisibleRect.getHeight() > 100.0) || !(tmpVisibleRect.getWidth() > 100.0)) continue;
                aDialog.setBounds(tmpBounds);
                return;
            }
        }
    }

    public static void storeFiles(Preferences aPreferences, File ... aFiles) {
        if (null == aFiles) {
            return;
        }
        StringBuilder tmpFiles = new StringBuilder();
        for (File tmpFile : aFiles) {
            tmpFiles.append(tmpFile.getAbsolutePath());
            tmpFiles.append(';');
        }
        List<String> tmpParts = StringUtil.split(tmpFiles.toString(), 8192);
        aPreferences.put(LAST_FILES, Integer.toString(tmpParts.size()));
        for (int i = 0; i < tmpParts.size(); ++i) {
            aPreferences.put(LAST_FILES + i, tmpParts.get(i));
        }
    }

    public static File[] restoreFiles(Preferences aPreferences, File aDir) {
        if (aDir == null) {
            return new File[0];
        }
        StringBuilder tmpLastFilesBuilder = new StringBuilder();
        int tmpPartsCount = 1;
        try {
            tmpPartsCount = Integer.parseInt(aPreferences.get(LAST_FILES, "1"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        for (int i = 0; i < tmpPartsCount; ++i) {
            tmpLastFilesBuilder.append(aPreferences.get(LAST_FILES + i, ""));
        }
        String[] tmpFiles = StringUtils.split((String)tmpLastFilesBuilder.toString(), (char)';');
        LinkedList<File> tmpResult = new LinkedList<File>();
        String tmpCurrentDir = aDir.getAbsolutePath();
        for (String tmpString : tmpFiles) {
            File tmpFile = new File(tmpString);
            if (!tmpFile.exists() || !tmpFile.getAbsolutePath().startsWith(tmpCurrentDir)) continue;
            tmpResult.add(tmpFile);
        }
        return tmpResult.toArray(new File[0]);
    }

    private static class PlaceableFileChooser
    extends JFileChooser {
        private static final long serialVersionUID = 6223316475899932034L;
        private final Preferences preferences;
        private JDialog jDialog;

        PlaceableFileChooser(Preferences aPreferences) {
            this.preferences = aPreferences;
        }

        @Override
        protected JDialog createDialog(Component aParent) {
            this.jDialog = super.createDialog(aParent);
            DialogUtil.restoreOptions(this.preferences, this.jDialog);
            return this.jDialog;
        }

        @Override
        public int showOpenDialog(Component aParent) {
            int tmpResult = super.showOpenDialog(aParent);
            DialogUtil.storeOptions(this.preferences, this.jDialog);
            return tmpResult;
        }
    }
}

