/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.scriptcreator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.FilenameUtils;
import org.wetator.core.Command;
import org.wetator.scriptcreator.IScriptCreator;

public class LegacyXMLScriptCreator
implements IScriptCreator {
    private List<Command> commands;
    private String fileName;
    private String dtd;
    private File outputDir;
    private static final String R_TEST_CASE = "testcase";
    private static final String ENCODING = "UTF-8";
    private static final String VERSION = "1.0";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createScript() {
        XMLOutputFactory tmpFactory = XMLOutputFactory.newInstance();
        try {
            File tmpFile = new File(this.outputDir, this.fileName + ".xml");
            try (OutputStream tmpFileOut = Files.newOutputStream(tmpFile.toPath(), new OpenOption[0]);
                 XMLStreamWriter tmpWriter = tmpFactory.createXMLStreamWriter(tmpFileOut, ENCODING);){
                tmpWriter.writeStartDocument(ENCODING, VERSION);
                tmpWriter.writeCharacters("\n");
                if (null != this.dtd) {
                    tmpWriter.writeDTD("<!DOCTYPE testcase " + this.dtd + ">");
                    tmpWriter.writeCharacters("\n");
                }
                tmpWriter.writeCharacters("\n");
                tmpWriter.writeStartElement(R_TEST_CASE);
                tmpWriter.writeDefaultNamespace("http://www.wetator.org/xsd/defaultCommandSet");
                tmpWriter.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                tmpWriter.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "http://www.wetator.org/xsd/defaultCommandSet http://www.wetator.org/xsd/defaultCommandSet.xsd");
                tmpWriter.writeCharacters("\n");
                for (Command tmpCommand : this.commands) {
                    tmpWriter.writeCharacters("    ");
                    tmpWriter.writeStartElement("step");
                    tmpWriter.writeAttribute("command", tmpCommand.getName().replace(' ', '_'));
                    if (tmpCommand.isComment() && !"Comment".equals(tmpCommand.getName())) {
                        tmpWriter.writeAttribute("comment", "true");
                    }
                    if (tmpCommand.getFirstParameter() != null) {
                        String tmpCharacterDataPattern = ".*[<>&]";
                        String tmpParameter = tmpCommand.getFirstParameter().getValue();
                        if (tmpParameter.matches(".*[<>&]")) {
                            tmpWriter.writeCData(tmpParameter);
                        } else {
                            tmpWriter.writeCharacters(tmpParameter);
                        }
                        if (tmpCommand.getSecondParameter() != null) {
                            tmpWriter.writeStartElement("optionalParameter");
                            String tmpOptionalParameter = tmpCommand.getSecondParameter().getValue();
                            if (tmpOptionalParameter.matches(".*[<>&]")) {
                                tmpWriter.writeCData(tmpOptionalParameter);
                            } else {
                                tmpWriter.writeCharacters(tmpOptionalParameter);
                            }
                            tmpWriter.writeEndElement();
                            if (tmpCommand.getThirdParameter() != null) {
                                tmpWriter.writeStartElement("optionalParameter2");
                                tmpOptionalParameter = tmpCommand.getThirdParameter().getValue();
                                if (tmpOptionalParameter.matches(".*[<>&]")) {
                                    tmpWriter.writeCData(tmpOptionalParameter);
                                } else {
                                    tmpWriter.writeCharacters(tmpOptionalParameter);
                                }
                                tmpWriter.writeEndElement();
                            }
                        }
                    }
                    tmpWriter.writeEndElement();
                    tmpWriter.writeCharacters("\n");
                }
                tmpWriter.writeEndElement();
                tmpWriter.writeEndDocument();
            }
            catch (FileNotFoundException e) {
                FileNotFoundException tmpException = new FileNotFoundException("Can't create output file '" + FilenameUtils.normalize((String)tmpFile.getAbsolutePath()) + "'.");
                tmpException.initCause(e);
                throw tmpException;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setCommands(List<Command> aCommandList) {
        this.commands = aCommandList;
    }

    @Override
    public void setFileName(String aFileName) {
        this.fileName = aFileName;
    }

    @Override
    public void setOutputDir(String anOutputDir) {
        this.outputDir = new File(anOutputDir);
    }

    public void setDtd(String aDtd) {
        this.dtd = aDtd;
    }
}

