/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.scriptcreator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.wetator.core.Command;
import org.wetator.scriptcreator.IScriptCreator;
import org.wetator.scripter.xml.ModelBuilder;
import org.wetator.scripter.xml.XMLSchema;
import org.wetator.scripter.xml.model.CommandType;
import org.wetator.scripter.xml.model.ParameterType;

public class XMLScriptCreator
implements IScriptCreator {
    private List<Command> commands;
    private String fileName;
    private File outputDir;
    private static final String XML_ENCODING = "UTF-8";
    private static final String XML_VERSION = "1.0";
    private static final String E_TEST_CASE = "test-case";
    private static final String E_COMMAND = "command";
    private static final String E_COMMENT = "comment";
    private static final String A_VERSION = "version";
    private static final String A_DISABLED = "disabled";
    private static final String TEST_CASE_XSD_VERSION = "1.0.0";
    private static final Pattern CHARACTER_DATA_PATTERN = Pattern.compile(".*[<>&]");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createScript() {
        XMLOutputFactory tmpFactory = XMLOutputFactory.newInstance();
        try {
            Object tmpCommandType;
            ArrayList<XMLSchema> tmpSchemas = new ArrayList<XMLSchema>();
            tmpSchemas.add(new XMLSchema("http://www.wetator.org/xsd/test-case", "test-case-1.0.0.xsd"));
            tmpSchemas.add(new XMLSchema("d", "http://www.wetator.org/xsd/default-command-set", "default-command-set-1.0.0.xsd"));
            tmpSchemas.add(new XMLSchema("sql", "http://www.wetator.org/xsd/sql-command-set", "sql-command-set-1.0.0.xsd"));
            tmpSchemas.add(new XMLSchema("tst", "http://www.wetator.org/xsd/test-command-set", "test-command-set-1.0.0.xsd"));
            tmpSchemas.add(new XMLSchema("inc", "http://www.wetator.org/xsd/incubator-command-set", "incubator-command-set-1.0.0.xsd"));
            ModelBuilder tmpModel = new ModelBuilder(tmpSchemas, this.outputDir);
            ArrayList<NamespaceBean> tmpNamespaces = new ArrayList<NamespaceBean>();
            for (Command tmpCommand : this.commands) {
                if (tmpCommand.isComment() || !StringUtils.isNotEmpty((CharSequence)tmpCommand.getName())) continue;
                tmpCommandType = tmpModel.getCommandType(tmpCommand.getName());
                if (tmpCommandType == null) {
                    throw new RuntimeException("Unknown command '" + tmpCommand.getName() + "'.");
                }
                NamespaceBean tmpBean = NamespaceBean.create(((CommandType)tmpCommandType).getNamespace());
                if (tmpNamespaces.contains(tmpBean)) continue;
                tmpNamespaces.add(tmpBean);
            }
            File tmpFile = new File(this.outputDir, this.fileName + ".wet");
            try {
                OutputStream tmpFileOut = Files.newOutputStream(tmpFile.toPath(), new OpenOption[0]);
                tmpCommandType = null;
                try (XMLStreamWriter tmpWriter = tmpFactory.createXMLStreamWriter(tmpFileOut, XML_ENCODING);){
                    tmpWriter.writeStartDocument(XML_ENCODING, XML_VERSION);
                    tmpWriter.writeCharacters("\n");
                    tmpWriter.writeStartElement(E_TEST_CASE);
                    tmpWriter.writeDefaultNamespace("http://www.wetator.org/xsd/test-case");
                    for (NamespaceBean tmpNamespaceBean : tmpNamespaces) {
                        tmpWriter.writeNamespace(tmpNamespaceBean.getSymbol(), tmpNamespaceBean.getNamespace());
                    }
                    tmpWriter.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                    StringBuilder tmpLocations = new StringBuilder("http://www.wetator.org/xsd/test-case test-case-1.0.0.xsd\n");
                    for (NamespaceBean tmpNamespaceBean : tmpNamespaces) {
                        tmpLocations.append(tmpNamespaceBean.getNamespace());
                        tmpLocations.append(' ');
                        tmpLocations.append(tmpNamespaceBean.getLocation());
                        tmpLocations.append('\n');
                    }
                    tmpWriter.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", tmpLocations.substring(0, tmpLocations.length() - 1));
                    tmpWriter.writeAttribute(A_VERSION, TEST_CASE_XSD_VERSION);
                    tmpWriter.writeCharacters("\n");
                    for (Command tmpCommand : this.commands) {
                        tmpWriter.writeCharacters("    ");
                        if (tmpCommand.isComment() && StringUtils.isEmpty((CharSequence)tmpCommand.getName())) {
                            tmpWriter.writeStartElement(E_COMMENT);
                            if (tmpCommand.getFirstParameter() != null) {
                                this.writeContent(tmpWriter, tmpCommand.getFirstParameter().getValue());
                            }
                            tmpWriter.writeEndElement();
                            tmpWriter.writeCharacters("\n");
                            continue;
                        }
                        CommandType tmpCommandType2 = tmpModel.getCommandType(tmpCommand.getName());
                        if (tmpCommandType2 == null) {
                            if (tmpCommand.isComment()) {
                                tmpWriter.writeStartElement(E_COMMENT);
                                StringBuilder tmpContent = new StringBuilder();
                                if (!StringUtils.isEmpty((CharSequence)tmpCommand.getName())) {
                                    tmpContent.append(tmpCommand.getName());
                                }
                                if (tmpCommand.getFirstParameter() != null) {
                                    if (tmpContent.length() > 0) {
                                        tmpContent.append(" - ");
                                    }
                                    tmpContent.append(tmpCommand.getFirstParameter().getValue());
                                }
                                if (tmpCommand.getSecondParameter() != null) {
                                    if (tmpContent.length() > 0) {
                                        tmpContent.append(" - ");
                                    }
                                    tmpContent.append(tmpCommand.getSecondParameter().getValue());
                                }
                                this.writeContent(tmpWriter, tmpContent.toString());
                                tmpWriter.writeEndElement();
                                tmpWriter.writeCharacters("\n");
                                continue;
                            }
                            throw new RuntimeException("Unknown command '" + tmpCommand.getName() + "'.");
                        }
                        tmpWriter.writeStartElement(E_COMMAND);
                        if (tmpCommand.isComment()) {
                            tmpWriter.writeAttribute(A_DISABLED, "true");
                        }
                        tmpWriter.writeStartElement(tmpCommandType2.getNamespace(), tmpCommandType2.getName());
                        List<ParameterType> tmpParameterTypes = tmpCommandType2.getParameterTypes();
                        String[] tmpParameterValues = new String[tmpParameterTypes.size()];
                        if (tmpParameterValues.length >= 1 && tmpCommand.getFirstParameter() != null) {
                            tmpParameterValues[0] = tmpCommand.getFirstParameter().getValue();
                        }
                        if (tmpParameterValues.length >= 2 && tmpCommand.getSecondParameter() != null) {
                            tmpParameterValues[1] = tmpCommand.getSecondParameter().getValue();
                        }
                        if (tmpParameterValues.length >= 3 && tmpCommand.getThirdParameter() != null) {
                            tmpParameterValues[2] = tmpCommand.getThirdParameter().getValue();
                        }
                        int i = 0;
                        for (ParameterType tmpParameterType : tmpParameterTypes) {
                            if (StringUtils.isNotEmpty((CharSequence)tmpParameterValues[i])) {
                                tmpWriter.writeStartElement(tmpParameterType.getNamespace(), tmpParameterType.getName());
                                this.writeContent(tmpWriter, tmpParameterValues[i]);
                                tmpWriter.writeEndElement();
                            }
                            ++i;
                        }
                        tmpWriter.writeEndElement();
                        tmpWriter.writeEndElement();
                        tmpWriter.writeCharacters("\n");
                    }
                    tmpWriter.writeEndElement();
                    tmpWriter.writeEndDocument();
                }
                catch (Throwable throwable) {
                    tmpCommandType = throwable;
                    throw throwable;
                }
                finally {
                    if (tmpFileOut != null) {
                        if (tmpCommandType != null) {
                            try {
                                tmpFileOut.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)tmpCommandType).addSuppressed(throwable);
                            }
                        } else {
                            tmpFileOut.close();
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                FileNotFoundException tmpException = new FileNotFoundException("Can't create output file '" + tmpFile.getAbsolutePath() + "'.");
                tmpException.initCause(e);
                throw tmpException;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeContent(XMLStreamWriter aWriter, String aContent) throws XMLStreamException {
        if (CHARACTER_DATA_PATTERN.matcher(aContent).matches()) {
            aWriter.writeCData(aContent);
        } else {
            aWriter.writeCharacters(aContent);
        }
    }

    @Override
    public void setCommands(List<Command> aCommandList) {
        this.commands = aCommandList;
    }

    @Override
    public void setFileName(String aFileName) {
        this.fileName = aFileName;
    }

    @Override
    public void setOutputDir(String anOutputDir) {
        this.outputDir = new File(anOutputDir);
    }

    private static class NamespaceBean {
        private String symbol;
        private String namespace;
        private String location;

        public static NamespaceBean create(String aNamespace) {
            if ("http://www.wetator.org/xsd/default-command-set".equals(aNamespace)) {
                return new NamespaceBean("d", aNamespace, "default-command-set-1.0.0.xsd");
            }
            if ("http://www.wetator.org/xsd/sql-command-set".equals(aNamespace)) {
                return new NamespaceBean("s", aNamespace, "sql-command-set-1.0.0.xsd");
            }
            if ("http://www.wetator.org/xsd/incubator-command-set".equals(aNamespace)) {
                return new NamespaceBean("i", aNamespace, "incubator-command-set-1.0.0.xsd");
            }
            if ("http://www.wetator.org/xsd/test-command-set".equals(aNamespace)) {
                return new NamespaceBean("t", aNamespace, "test-command-set-1.0.0.xsd");
            }
            throw new RuntimeException("Unknown command set '" + aNamespace + "'.");
        }

        NamespaceBean(String aSymbol, String aNamespace, String aLocation) {
            this.symbol = aSymbol;
            this.namespace = aNamespace;
            this.location = aLocation;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getLocation() {
            return this.location;
        }

        public int hashCode() {
            int tmpPrime = 31;
            int tmpResult = 31;
            if (this.location != null) {
                tmpResult += this.location.hashCode();
            }
            tmpResult = 31 * tmpResult;
            if (this.namespace != null) {
                tmpResult += this.namespace.hashCode();
            }
            tmpResult = 31 * tmpResult;
            if (this.symbol != null) {
                tmpResult += this.symbol.hashCode();
            }
            return tmpResult;
        }

        public boolean equals(Object anObj) {
            if (this == anObj) {
                return true;
            }
            if (anObj == null) {
                return false;
            }
            if (this.getClass() != anObj.getClass()) {
                return false;
            }
            NamespaceBean tmpOther = (NamespaceBean)anObj;
            if (this.location == null ? tmpOther.location != null : !this.location.equals(tmpOther.location)) {
                return false;
            }
            if (this.namespace == null ? tmpOther.namespace != null : !this.namespace.equals(tmpOther.namespace)) {
                return false;
            }
            return !(this.symbol == null ? tmpOther.symbol != null : !this.symbol.equals(tmpOther.symbol));
        }
    }
}

