/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.scripter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.wetator.core.Command;
import org.wetator.core.IScripter;
import org.wetator.core.Parameter;
import org.wetator.exception.InvalidInputException;
import org.wetator.exception.ResourceException;
import org.wetator.scripter.ParseException;
import org.wetator.scripter.xml.ModelBuilder;
import org.wetator.scripter.xml.SchemaFinder;
import org.wetator.scripter.xml.XMLSchema;
import org.wetator.scripter.xml.model.CommandType;
import org.wetator.scripter.xml.model.ParameterType;
import org.xml.sax.SAXException;

public class XMLScripter
implements IScripter {
    private static final String WET_FILE_EXTENSION = ".wet";
    private static final String XML_FILE_EXTENSION = ".xml";
    public static final XMLSchema BASE_SCHEMA = new XMLSchema("http://www.wetator.org/xsd/test-case", "test-case-1.0.0.xsd");
    private static final List<String> SUPPORTED_VERSIONS = Arrays.asList("1.0.0");
    private static final String E_TEST_CASE = "test-case";
    private static final String E_COMMAND = "command";
    private static final String E_COMMENT = "comment";
    private static final String A_VERSION = "version";
    private static final String A_DISABLED = "disabled";
    private static final Pattern VERSION_PATTERN = Pattern.compile(".*version\\s*=\\s*[\"'](.*)[\"'].*");
    public static final XMLSchema DEFAULT_COMMAND_SET_SCHEMA = new XMLSchema("d", "http://www.wetator.org/xsd/default-command-set", "default-command-set-1.0.0.xsd");
    private List<XMLSchema> schemas;
    private ModelBuilder model;
    private List<Command> commands;

    @Override
    public void initialize(Properties aConfiguration) {
    }

    @Override
    public IScripter.IsSupportedResult isSupported(File aFile) {
        String tmpFileName = aFile.getName().toLowerCase(Locale.ROOT);
        if (!tmpFileName.endsWith(WET_FILE_EXTENSION) && !tmpFileName.endsWith(XML_FILE_EXTENSION)) {
            return new IScripter.IsSupportedResult("File '" + aFile.getName() + "' not supported by XMLScripter. Extension is not '" + WET_FILE_EXTENSION + "' or '" + XML_FILE_EXTENSION + "'.");
        }
        if (!aFile.exists() || !aFile.isFile()) {
            return new IScripter.IsSupportedResult("File '" + aFile.getName() + "' not supported by XMLScripter. Could not find file.");
        }
        if (!aFile.canRead()) {
            return new IScripter.IsSupportedResult("File '" + aFile.getName() + "' not supported by XMLScripter. Could not read file.");
        }
        try {
            if (!this.isSupported(this.createUTF8Reader(aFile))) {
                return new IScripter.IsSupportedResult("File '" + aFile.getName() + "' not supported by XMLScripter. Could not parse file.");
            }
        }
        catch (FileNotFoundException e) {
            return new IScripter.IsSupportedResult("File '" + aFile.getName() + "' not supported by XMLScripter. Could not find file (" + e.getMessage() + ").");
        }
        catch (IOException e) {
            return new IScripter.IsSupportedResult("File '" + aFile.getName() + "' not supported by XMLScripter. Could not read file (" + e.getMessage() + ").");
        }
        return IScripter.IS_SUPPORTED;
    }

    public boolean isSupported(String aContent) {
        try {
            return this.isSupported(new StringReader(aContent));
        }
        catch (IOException e) {
            throw new ResourceException("Could not read content.", e);
        }
    }

    private boolean isSupported(Reader aContent) throws IOException {
        try (BufferedReader tmpReader = new BufferedReader(aContent);){
            String tmpLine;
            boolean tmpTestCase = false;
            boolean tmpBaseSchema = false;
            String tmpVersion = null;
            while ((tmpLine = tmpReader.readLine()) != null) {
                Matcher tmpMatcher;
                if (tmpLine.contains("<test-case")) {
                    tmpTestCase = true;
                }
                if (tmpLine.contains("<command")) break;
                if (tmpLine.contains("<comment")) {
                    break;
                }
                if (tmpTestCase && tmpLine.contains(BASE_SCHEMA.getNamespace())) {
                    tmpBaseSchema = true;
                }
                if (tmpTestCase && tmpLine.contains(A_VERSION) && (tmpMatcher = VERSION_PATTERN.matcher(tmpLine)).matches()) {
                    tmpVersion = tmpMatcher.group(1);
                }
                if (!tmpBaseSchema || tmpVersion == null || !SUPPORTED_VERSIONS.contains(tmpVersion)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public void script(File aFile) throws InvalidInputException {
        try {
            try (Reader tmpReader = this.createUTF8Reader(aFile);){
                List<XMLSchema> tmpSchemas = new SchemaFinder(tmpReader).getSchemas();
                if (null == tmpSchemas || tmpSchemas.isEmpty()) {
                    throw new InvalidInputException("No schemas found in file '" + FilenameUtils.normalize((String)aFile.getAbsolutePath()) + "'.");
                }
                this.addDefaultSchemas(tmpSchemas);
                this.removeDuplicateSchemas(tmpSchemas);
                this.schemas = tmpSchemas;
                this.model = new ModelBuilder(tmpSchemas, aFile.getParentFile());
            }
            tmpReader = this.createUTF8Reader(aFile);
            var3_6 = null;
            try {
                this.commands = this.parseScript(tmpReader);
            }
            catch (Throwable throwable) {
                var3_6 = throwable;
                throw throwable;
            }
            finally {
                if (tmpReader != null) {
                    if (var3_6 != null) {
                        try {
                            tmpReader.close();
                        }
                        catch (Throwable throwable) {
                            var3_6.addSuppressed(throwable);
                        }
                    } else {
                        tmpReader.close();
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new InvalidInputException("Could not find file '" + FilenameUtils.normalize((String)aFile.getAbsolutePath()) + "'.", e);
        }
        catch (IOException e) {
            throw new ResourceException("Could not read file '" + FilenameUtils.normalize((String)aFile.getAbsolutePath()) + "'.", e);
        }
        catch (XMLStreamException | ParseException | SAXException e) {
            throw new InvalidInputException("Error parsing file '" + FilenameUtils.normalize((String)aFile.getAbsolutePath()) + "' (" + e.getMessage() + ").", e);
        }
    }

    public void script(String aContent, File aDirectory) throws InvalidInputException {
        try (StringReader tmpReader = new StringReader(aContent);){
            List<XMLSchema> tmpSchemas = new SchemaFinder(tmpReader).getSchemas();
            if (null == tmpSchemas || tmpSchemas.isEmpty()) {
                throw new InvalidInputException("No schemas found in content.");
            }
            this.addDefaultSchemas(tmpSchemas);
            this.removeDuplicateSchemas(tmpSchemas);
            this.schemas = tmpSchemas;
            this.model = new ModelBuilder(tmpSchemas, aDirectory);
            ((Reader)tmpReader).reset();
            this.commands = this.parseScript(tmpReader);
        }
        catch (IOException e) {
            throw new ResourceException("Could not read content.", e);
        }
        catch (XMLStreamException | ParseException | SAXException e) {
            throw new InvalidInputException("Error parsing content (" + e.getMessage() + ").", e);
        }
    }

    private void addDefaultSchemas(List<XMLSchema> aSchemaList) {
        aSchemaList.add(1, DEFAULT_COMMAND_SET_SCHEMA);
    }

    private void removeDuplicateSchemas(List<XMLSchema> aSchemaList) {
        LinkedHashSet<XMLSchema> tmpSchemaSet = new LinkedHashSet<XMLSchema>(aSchemaList);
        aSchemaList.clear();
        aSchemaList.addAll(tmpSchemaSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Command> parseScript(Reader aContent) throws XMLStreamException {
        XMLInputFactory tmpFactory = XMLInputFactory.newInstance();
        XMLStreamReader tmpReader = tmpFactory.createXMLStreamReader(aContent);
        ArrayList<Command> tmpResult = new ArrayList<Command>();
        try {
            while (!(!tmpReader.hasNext() || tmpReader.next() == 1 && BASE_SCHEMA.getNamespace().equals(tmpReader.getNamespaceURI()) && E_TEST_CASE.equals(tmpReader.getLocalName()))) {
            }
            boolean tmpInComment = false;
            boolean tmpInCommand = false;
            boolean tmpInCommandType = false;
            boolean tmpInParameter = false;
            CommandType tmpCurrentCommandType = null;
            int tmpCurrentParameter = -1;
            StringBuilder tmpCurrentText = new StringBuilder();
            boolean tmpDisabled = false;
            String[] tmpParameters = new String[]{};
            Command tmpCommand = null;
            block12: while (tmpReader.hasNext()) {
                int tmpEvent = tmpReader.next();
                if (tmpEvent == 1) {
                    if (E_COMMENT.equals(tmpReader.getLocalName())) {
                        tmpInComment = true;
                        tmpCommand = new Command("", true);
                        tmpCommand.setLineNo(tmpResult.size() + 1);
                        tmpCurrentText = new StringBuilder();
                        continue;
                    }
                    if (E_COMMAND.equals(tmpReader.getLocalName())) {
                        tmpInCommand = true;
                        String tmpIsCommentAsString = tmpReader.getAttributeValue(null, A_DISABLED);
                        if (!StringUtils.isNotEmpty((CharSequence)tmpIsCommentAsString)) continue;
                        tmpDisabled = Boolean.parseBoolean(tmpIsCommentAsString);
                        continue;
                    }
                    CommandType tmpCommandType = null;
                    if (!tmpInCommandType) {
                        tmpCommandType = this.model.getCommandType(tmpReader.getLocalName());
                    }
                    if (tmpCommandType != null) {
                        tmpInCommandType = true;
                        tmpCurrentCommandType = tmpCommandType;
                        tmpCommand = new Command(tmpCurrentCommandType.getName(), tmpDisabled);
                        tmpCommand.setLineNo(tmpResult.size() + 1);
                        tmpParameters = new String[tmpCurrentCommandType.getParameterTypes().size()];
                        continue;
                    }
                    if (!tmpInCommandType) continue;
                    int i = 0;
                    for (ParameterType tmpParameterType : tmpCurrentCommandType.getParameterTypes()) {
                        if (tmpParameterType.getName().equals(tmpReader.getLocalName())) {
                            tmpInParameter = true;
                            tmpCurrentParameter = i;
                            tmpCurrentText = new StringBuilder();
                            continue block12;
                        }
                        ++i;
                    }
                    continue;
                }
                if (tmpEvent == 4) {
                    if (!tmpInComment && !tmpInParameter) continue;
                    tmpCurrentText.append(tmpReader.getText());
                    continue;
                }
                if (tmpEvent != 2) continue;
                if (tmpInParameter) {
                    tmpInParameter = false;
                    tmpParameters[tmpCurrentParameter] = tmpCurrentText.toString();
                    tmpCurrentParameter = -1;
                    tmpCurrentText = null;
                    continue;
                }
                if (tmpInCommandType) {
                    tmpInCommandType = false;
                    if (tmpParameters.length >= 1 && StringUtils.isNotEmpty((CharSequence)tmpParameters[0])) {
                        tmpCommand.setFirstParameter(new Parameter(tmpParameters[0]));
                    }
                    if (tmpParameters.length >= 2 && StringUtils.isNotEmpty((CharSequence)tmpParameters[1])) {
                        tmpCommand.setSecondParameter(new Parameter(tmpParameters[1]));
                    }
                    if (tmpParameters.length >= 3 && StringUtils.isNotEmpty((CharSequence)tmpParameters[2])) {
                        tmpCommand.setThirdParameter(new Parameter(tmpParameters[2]));
                    }
                    tmpResult.add(tmpCommand);
                    tmpCurrentCommandType = null;
                    continue;
                }
                if (tmpInCommand) {
                    tmpInCommand = false;
                    tmpDisabled = false;
                    continue;
                }
                if (!tmpInComment) continue;
                tmpInComment = false;
                tmpCommand.setFirstParameter(new Parameter(tmpCurrentText.toString()));
                tmpResult.add(tmpCommand);
                tmpCurrentText = null;
            }
        }
        finally {
            try {
                tmpReader.close();
            }
            catch (Exception exception) {}
            if (aContent != null) {
                try {
                    aContent.close();
                }
                catch (Exception exception) {}
            }
        }
        return tmpResult;
    }

    private Reader createUTF8Reader(File aFile) throws IOException {
        return Files.newBufferedReader(aFile.toPath(), StandardCharsets.UTF_8);
    }

    @Override
    public List<Command> getCommands() {
        return this.commands;
    }

    public ModelBuilder getModel() {
        return this.model;
    }

    public List<XMLSchema> getSchemas() {
        return new ArrayList<XMLSchema>(this.schemas);
    }
}

