/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.formula.eval.NotImplementedException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.wetator.backend.IBrowser;
import org.wetator.backend.htmlunit.util.ContentTypeUtil;
import org.wetator.util.NormalizedString;
import org.wetator.util.StringUtil;

public final class ContentUtil {
    private static final Logger LOG = LogManager.getLogger(ContentUtil.class);
    private static final String MORE = " ...";

    public static String getTxtContentAsString(String aContent, int aMaxLength) {
        NormalizedString tmpResult = new NormalizedString(aContent);
        if (tmpResult.length() > aMaxLength) {
            return tmpResult.substring(0, aMaxLength) + MORE;
        }
        return tmpResult.toString();
    }

    public static String getTxtContentAsString(InputStream anInputStream, Charset aCharset, int aMaxLength) throws IOException {
        int tmpChars;
        boolean tmpContinue;
        NormalizedString tmpResult = new NormalizedString();
        InputStreamReader tmpReader = new InputStreamReader(anInputStream, aCharset);
        char[] tmpCharBuffer = new char[1024];
        do {
            tmpChars = tmpReader.read(tmpCharBuffer);
            tmpResult.append(tmpCharBuffer, tmpChars);
        } while (tmpContinue = tmpChars > 0 && tmpResult.length() <= aMaxLength);
        if (tmpResult.length() > aMaxLength) {
            return tmpResult.substring(0, aMaxLength) + MORE;
        }
        return tmpResult.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPdfContentAsString(InputStream anInputStream, int aMaxLength) throws IOException {
        try (PDDocument tmpDocument = PDDocument.load((InputStream)anInputStream);){
            AccessPermission tmpPermissions = tmpDocument.getCurrentAccessPermission();
            if (!tmpPermissions.canExtractContent()) {
                throw new IOException("Content extraction forbidden for the given PDF document.");
            }
            PDFTextStripper tmpStripper = new PDFTextStripper();
            String tmpContentAsText = tmpStripper.getText(tmpDocument);
            NormalizedString tmpResult = new NormalizedString(tmpContentAsText);
            if (tmpResult.length() > aMaxLength) {
                String string = tmpResult.substring(0, aMaxLength) + MORE;
                return string;
            }
            String string = tmpResult.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPdfTitleAsString(InputStream anInputStream) throws IOException {
        try (PDDocument tmpDocument = PDDocument.load((InputStream)anInputStream);){
            PDDocumentInformation tmpInfo = tmpDocument.getDocumentInformation();
            if (null != tmpInfo) {
                NormalizedString tmpResult = new NormalizedString(tmpInfo.getTitle());
                String string = tmpResult.toString();
                return string;
            }
            String string = "";
            return string;
        }
    }

    public static String getRtfContentAsString(InputStream anInputStream, int aMaxLength) throws IOException, BadLocationException {
        RTFEditorKit tmpRtfEditorKit = new RTFEditorKit();
        Document tmpDocument = tmpRtfEditorKit.createDefaultDocument();
        tmpRtfEditorKit.read(anInputStream, tmpDocument, 0);
        int tmpLength = Math.min(tmpDocument.getLength(), aMaxLength);
        NormalizedString tmpResult = new NormalizedString(tmpDocument.getText(0, tmpLength));
        if (tmpDocument.getLength() > aMaxLength) {
            tmpResult.append(MORE);
        }
        return tmpResult.toString();
    }

    public static String getZipContentAsString(InputStream anInputStream, Charset aCharset, Locale aXlsLocale, int aMaxLength) throws IOException {
        NormalizedString tmpResult = new NormalizedString();
        ZipInputStream tmpZipInput = new ZipInputStream(anInputStream);
        ZipEntry tmpZipEntry = tmpZipInput.getNextEntry();
        while (null != tmpZipEntry) {
            tmpResult.append("[");
            tmpResult.append(tmpZipEntry.getName());
            tmpResult.append("] ");
            IBrowser.ContentType tmpType = ContentTypeUtil.getContentTypeForFileName(tmpZipEntry.getName());
            if (IBrowser.ContentType.PDF == tmpType) {
                try {
                    tmpResult.append(ContentUtil.getPdfContentAsString(new CloseIgnoringInputStream(tmpZipInput), aMaxLength));
                }
                catch (IOException e) {
                    throw new IOException("Can't convert the zipped pdf '" + tmpZipEntry.getName() + "' into text (reason: " + e.toString() + ").");
                }
            }
            if (IBrowser.ContentType.XLS == tmpType || IBrowser.ContentType.XLSX == tmpType) {
                try {
                    tmpResult.append(ContentUtil.getExcelContentAsString(new CloseIgnoringInputStream(tmpZipInput), aXlsLocale, aMaxLength));
                }
                catch (IOException | InvalidFormatException e) {
                    throw new IOException("Can't convert the zipped xls '" + tmpZipEntry.getName() + "' into text (reason: " + e.toString() + ").");
                }
            }
            if (IBrowser.ContentType.DOCX == tmpType) {
                try {
                    tmpResult.append(ContentUtil.getWordContentAsString(new CloseIgnoringInputStream(tmpZipInput), aMaxLength));
                }
                catch (IOException | InvalidFormatException e) {
                    throw new IOException("Can't convert the zipped doc '" + tmpZipEntry.getName() + "' into text (reason: " + e.toString() + ").");
                }
            }
            if (IBrowser.ContentType.RTF == tmpType) {
                try {
                    tmpResult.append(ContentUtil.getRtfContentAsString(new CloseIgnoringInputStream(tmpZipInput), aMaxLength));
                }
                catch (IOException | BadLocationException e) {
                    throw new IOException("Can't convert the zipped rtf '" + tmpZipEntry.getName() + "' into text (reason: " + e.toString() + ").");
                }
            }
            try {
                tmpResult.append(ContentUtil.getTxtContentAsString(new CloseIgnoringInputStream(tmpZipInput), aCharset, aMaxLength));
            }
            catch (IOException e) {
                throw new IOException("Can't convert the zipped content '" + tmpZipEntry.getName() + "' into text (reason: " + e.toString() + ").");
            }
            if (null == (tmpZipEntry = tmpZipInput.getNextEntry())) continue;
            tmpResult.append(" ");
        }
        return tmpResult.toString();
    }

    /*
     * Exception decompiling
     */
    public static String getWordContentAsString(InputStream anInputStream, int aMaxLength) throws IOException, InvalidFormatException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getExcelContentAsString(InputStream anInputStream, Locale aLocale, int aMaxLength) throws IOException, InvalidFormatException {
        NormalizedString tmpResult = new NormalizedString();
        try (Workbook tmpWorkbook = WorkbookFactory.create((InputStream)anInputStream);){
            FormulaEvaluator tmpFormulaEvaluator = tmpWorkbook.getCreationHelper().createFormulaEvaluator();
            Locale tmpLocale = aLocale;
            if (null == tmpLocale) {
                tmpLocale = Locale.getDefault();
            }
            for (int i = 0; i < tmpWorkbook.getNumberOfSheets(); ++i) {
                Sheet tmpSheet = tmpWorkbook.getSheetAt(i);
                tmpResult.append("[");
                tmpResult.append(tmpSheet.getSheetName());
                tmpResult.append("] ");
                for (int tmpRowNum = 0; tmpRowNum <= tmpSheet.getLastRowNum(); ++tmpRowNum) {
                    Row tmpRow = tmpSheet.getRow(tmpRowNum);
                    if (null == tmpRow) continue;
                    for (int tmpCellNum = 0; tmpCellNum <= tmpRow.getLastCellNum(); ++tmpCellNum) {
                        String tmpCellValue = ContentUtil.readCellContentAsString(tmpRow, tmpCellNum, tmpFormulaEvaluator, tmpLocale);
                        if (null == tmpCellValue) continue;
                        tmpResult.append(tmpCellValue);
                        tmpResult.append(" ");
                    }
                    if (tmpResult.length() > aMaxLength) {
                        String string = tmpResult.substring(0, aMaxLength) + MORE;
                        return string;
                    }
                    tmpResult.append(" ");
                }
            }
        }
        return tmpResult.toString();
    }

    public static String readCellContentAsString(Row aRow, int aColumnsNo, FormulaEvaluator aFormulaEvaluator, Locale aLocale) {
        Cell tmpCell = aRow.getCell(aColumnsNo);
        if (null == tmpCell) {
            return null;
        }
        DataFormatter tmpDataFormatter = new DataFormatter(aLocale);
        try {
            return tmpDataFormatter.formatCellValue(tmpCell, aFormulaEvaluator);
        }
        catch (NotImplementedException e) {
            StringBuilder tmpMsg = new StringBuilder(e.getMessage());
            if (null != e.getCause()) {
                tmpMsg.append(" (");
                tmpMsg.append(e.getCause().toString());
                tmpMsg.append(')');
            }
            LOG.error(tmpMsg.toString());
            return tmpDataFormatter.formatCellValue(tmpCell, null);
        }
    }

    public static boolean isTxt(String aText) {
        int tmpCharCount = 0;
        for (int i = 0; i < aText.length(); ++i) {
            char tmpChar = aText.charAt(i);
            if (!Character.isLetterOrDigit(tmpChar)) continue;
            ++tmpCharCount;
        }
        return (double)tmpCharCount * 1.0 / (double)aText.length() > 0.7;
    }

    public static Locale determineLocaleFromRequestHeader(String anAcceptLanguageHeader) {
        if (null == anAcceptLanguageHeader) {
            return null;
        }
        Iterator<String> tmpLanguages = StringUtil.extractStrings(anAcceptLanguageHeader, ",", -1).iterator();
        while (tmpLanguages.hasNext()) {
            List<String> tmpLanguageDescriptor = StringUtil.extractStrings(tmpLanguages.next(), ";", -1);
            if (tmpLanguageDescriptor.isEmpty()) {
                return null;
            }
            String tmpLocaleString = tmpLanguageDescriptor.get(0);
            List<String> tmpLocaleDescriptor = StringUtil.extractStrings(tmpLocaleString, "-", -1);
            if (tmpLocaleDescriptor.isEmpty()) break;
            String[] tmpISO639 = Locale.getISOLanguages();
            String tmpLanguage = tmpLocaleDescriptor.get(0).toLowerCase(Locale.ENGLISH);
            for (String tmpISO639Language : tmpISO639) {
                if (!tmpISO639Language.equals(tmpLanguage)) continue;
                String tmpCountry3166 = "";
                if (tmpLocaleDescriptor.size() > 1) {
                    String[] tmpISO3166;
                    String tmpCountry = tmpLocaleDescriptor.get(1).toUpperCase(Locale.ENGLISH);
                    for (String tmpISO3166Country : tmpISO3166 = Locale.getISOCountries()) {
                        if (!tmpISO3166Country.equals(tmpCountry)) continue;
                        tmpCountry3166 = tmpCountry;
                    }
                }
                return new Locale(tmpLanguage, tmpCountry3166);
            }
        }
        return null;
    }

    private ContentUtil() {
    }

    private static final class CloseIgnoringInputStream
    extends FilterInputStream {
        private CloseIgnoringInputStream(InputStream anInputStream) {
            super(anInputStream);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

