/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationUnknown;

public class PDObjectReference
implements COSObjectable {
    private static final Log LOG = LogFactory.getLog(PDObjectReference.class);
    public static final String TYPE = "OBJR";
    private final COSDictionary dictionary;

    public PDObjectReference() {
        this.dictionary = new COSDictionary();
        this.dictionary.setName(COSName.TYPE, TYPE);
    }

    public PDObjectReference(COSDictionary theDictionary) {
        this.dictionary = theDictionary;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.dictionary;
    }

    public COSObjectable getReferencedObject() {
        COSDictionary objDictionary = this.getCOSObject().getCOSDictionary(COSName.OBJ);
        if (objDictionary == null) {
            return null;
        }
        try {
            PDXObject xobject;
            if (objDictionary instanceof COSStream && (xobject = PDXObject.createXObject(objDictionary, null)) != null) {
                return xobject;
            }
            PDAnnotation annotation2 = PDAnnotation.createAnnotation(objDictionary);
            if (!(annotation2 instanceof PDAnnotationUnknown) || COSName.ANNOT.equals(objDictionary.getCOSName(COSName.TYPE))) {
                return annotation2;
            }
        }
        catch (IOException exception) {
            LOG.debug("Couldn't get the referenced object - returning null instead", exception);
        }
        return null;
    }

    public void setReferencedObject(PDAnnotation annotation2) {
        this.getCOSObject().setItem(COSName.OBJ, (COSObjectable)annotation2);
    }

    public void setReferencedObject(PDXObject xobject) {
        this.getCOSObject().setItem(COSName.OBJ, (COSObjectable)xobject);
    }

    public PDPage getPage() {
        COSDictionary pageDict = this.getCOSObject().getCOSDictionary(COSName.PG);
        if (pageDict != null) {
            return new PDPage(pageDict);
        }
        return null;
    }

    public void setPage(PDPage page) {
        this.getCOSObject().setItem(COSName.PG, (COSObjectable)page);
    }
}

