/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.fdf;

import java.awt.Color;
import java.io.IOException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotation;
import org.w3c.dom.Element;

public class FDFAnnotationPolyline
extends FDFAnnotation {
    private static final Log LOG = LogFactory.getLog(FDFAnnotationPolyline.class);
    public static final String SUBTYPE = "Polyline";

    public FDFAnnotationPolyline() {
        this.annot.setName(COSName.SUBTYPE, SUBTYPE);
    }

    public FDFAnnotationPolyline(COSDictionary a) {
        super(a);
    }

    public FDFAnnotationPolyline(Element element) throws IOException {
        super(element);
        this.annot.setName(COSName.SUBTYPE, SUBTYPE);
        this.initVertices(element);
        this.initStyles(element);
    }

    private void initVertices(Element element) throws IOException {
        XPath xpath2 = XPathFactory.newInstance().newXPath();
        try {
            String vertices = xpath2.evaluate("vertices[1]", element);
            if (vertices == null || vertices.isEmpty()) {
                throw new IOException("Error: missing element 'vertices'");
            }
            String[] verticesValues = vertices.split("[,;]");
            float[] values = this.parseFloats(verticesValues);
            this.setVertices(values);
        }
        catch (XPathExpressionException e) {
            LOG.debug("Error while evaluating XPath expression for polyline vertices", e);
        }
    }

    private void initStyles(Element element) {
        String color;
        String endStyle;
        String startStyle = element.getAttribute("head");
        if (startStyle != null && !startStyle.isEmpty()) {
            this.setStartPointEndingStyle(startStyle);
        }
        if ((endStyle = element.getAttribute("tail")) != null && !endStyle.isEmpty()) {
            this.setEndPointEndingStyle(endStyle);
        }
        if ((color = element.getAttribute("interior-color")) != null && color.length() == 7 && color.charAt(0) == '#') {
            int colorValue = Integer.parseInt(color.substring(1, 7), 16);
            this.setInteriorColor(new Color(colorValue));
        }
    }

    public void setVertices(float[] vertices) {
        COSArray newVertices = new COSArray();
        newVertices.setFloatArray(vertices);
        this.annot.setItem(COSName.VERTICES, (COSBase)newVertices);
    }

    public float[] getVertices() {
        COSArray array = this.annot.getCOSArray(COSName.VERTICES);
        return array != null ? array.toFloatArray() : null;
    }

    public void setStartPointEndingStyle(String style) {
        String actualStyle = style == null ? "None" : style;
        COSArray array = this.annot.getCOSArray(COSName.LE);
        if (array == null) {
            array = new COSArray();
            array.add(COSName.getPDFName(actualStyle));
            array.add(COSName.getPDFName("None"));
            this.annot.setItem(COSName.LE, (COSBase)array);
        } else {
            array.setName(0, actualStyle);
        }
    }

    public String getStartPointEndingStyle() {
        COSArray array = this.annot.getCOSArray(COSName.LE);
        return array != null ? array.getName(0) : "None";
    }

    public void setEndPointEndingStyle(String style) {
        String actualStyle = style == null ? "None" : style;
        COSArray array = this.annot.getCOSArray(COSName.LE);
        if (array == null) {
            array = new COSArray();
            array.add(COSName.getPDFName("None"));
            array.add(COSName.getPDFName(actualStyle));
            this.annot.setItem(COSName.LE, (COSBase)array);
        } else {
            array.setName(1, actualStyle);
        }
    }

    public String getEndPointEndingStyle() {
        COSArray array = this.annot.getCOSArray(COSName.LE);
        return array != null ? array.getName(1) : "None";
    }

    public void setInteriorColor(Color color) {
        COSArray array = null;
        if (color != null) {
            float[] colors = color.getRGBColorComponents(null);
            array = new COSArray();
            array.setFloatArray(colors);
        }
        this.annot.setItem(COSName.IC, array);
    }

    public Color getInteriorColor() {
        return this.getColor(COSName.IC);
    }
}

