/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.fdf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.fdf.FDFAnnotation;
import org.apache.pdfbox.util.Hex;
import org.apache.pdfbox.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FDFAnnotationStamp
extends FDFAnnotation {
    private static final Log LOG = LogFactory.getLog(FDFAnnotationStamp.class);
    public static final String SUBTYPE = "Stamp";

    public FDFAnnotationStamp() {
        this.annot.setName(COSName.SUBTYPE, SUBTYPE);
    }

    public FDFAnnotationStamp(COSDictionary a) {
        super(a);
    }

    public FDFAnnotationStamp(Element element) throws IOException {
        super(element);
        byte[] decodedAppearanceXML;
        String base64EncodedAppearance;
        this.annot.setName(COSName.SUBTYPE, SUBTYPE);
        XPath xpath2 = XPathFactory.newInstance().newXPath();
        LOG.debug("Get the DOM Document for the stamp appearance");
        try {
            base64EncodedAppearance = xpath2.evaluate("appearance", element);
        }
        catch (XPathExpressionException e) {
            LOG.error("Error while evaluating XPath expression for appearance: " + e);
            return;
        }
        try {
            decodedAppearanceXML = Hex.decodeBase64(base64EncodedAppearance);
        }
        catch (IllegalArgumentException ex) {
            LOG.error("Bad base64 encoded appearance ignored", ex);
            return;
        }
        if (base64EncodedAppearance != null && !base64EncodedAppearance.isEmpty()) {
            LOG.debug("Decoded XML: " + new String(decodedAppearanceXML, StandardCharsets.UTF_8));
            Document stampAppearance = XMLUtil.parse(new ByteArrayInputStream(decodedAppearanceXML));
            Element appearanceEl = stampAppearance.getDocumentElement();
            if (!"dict".equalsIgnoreCase(appearanceEl.getNodeName())) {
                throw new IOException("Error while reading stamp document, root should be 'dict' and not '" + appearanceEl.getNodeName() + "'");
            }
            LOG.debug("Generate and set the appearance dictionary to the stamp annotation");
            this.annot.setItem(COSName.AP, (COSBase)this.parseStampAnnotationAppearanceXML(appearanceEl));
        }
    }

    private COSDictionary parseStampAnnotationAppearanceXML(Element appearanceXML) throws IOException {
        COSDictionary dictionary = new COSDictionary();
        dictionary.setItem(COSName.N, (COSBase)new COSStream());
        LOG.debug("Build dictionary for Appearance based on the appearanceXML");
        NodeList nodeList = appearanceXML.getChildNodes();
        String parentAttrKey = appearanceXML.getAttribute("KEY");
        LOG.debug("Appearance Root - tag: " + appearanceXML.getTagName() + ", name: " + appearanceXML.getNodeName() + ", key: " + parentAttrKey + ", children: " + nodeList.getLength());
        if (!"AP".equals(appearanceXML.getAttribute("KEY"))) {
            LOG.warn(parentAttrKey + " => Not handling element: " + appearanceXML.getTagName() + " with key: " + appearanceXML.getAttribute("KEY"));
            return dictionary;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            String childTagName = child.getTagName();
            if ("STREAM".equalsIgnoreCase(childTagName)) {
                LOG.debug(parentAttrKey + " => Process " + child.getAttribute("KEY") + " item in the dictionary after processing the " + childTagName);
                dictionary.setItem(child.getAttribute("KEY"), (COSBase)this.parseStreamElement(child));
                LOG.debug(parentAttrKey + " => Set " + child.getAttribute("KEY"));
                continue;
            }
            LOG.warn(parentAttrKey + " => Not handling element: " + childTagName);
        }
        return dictionary;
    }

    /*
     * Unable to fully structure code
     */
    private COSStream parseStreamElement(Element streamEl) throws IOException {
        FDFAnnotationStamp.LOG.debug("Parse " + streamEl.getAttribute("KEY") + " Stream");
        stream = new COSStream();
        nodeList = streamEl.getChildNodes();
        parentAttrKey = streamEl.getAttribute("KEY");
        block36: for (i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            child = (Element)node;
            childAttrKey = child.getAttribute("KEY");
            childAttrVal = child.getAttribute("VAL");
            childTagName = child.getTagName();
            FDFAnnotationStamp.LOG.debug(parentAttrKey + " => reading child: " + child.getTagName() + " with key: " + childAttrKey);
            if (childTagName == null) {
                FDFAnnotationStamp.LOG.warn(parentAttrKey + " => Not handling child element: null");
                continue;
            }
            var11_11 = childTagName.toUpperCase();
            var12_12 = -1;
            switch (var11_11.hashCode()) {
                case 72655: {
                    if (!var11_11.equals("INT")) break;
                    var12_12 = 0;
                    break;
                }
                case 66907988: {
                    if (!var11_11.equals("FIXED")) break;
                    var12_12 = 1;
                    break;
                }
                case 2388619: {
                    if (!var11_11.equals("NAME")) break;
                    var12_12 = 2;
                    break;
                }
                case 2044650: {
                    if (!var11_11.equals("BOOL")) break;
                    var12_12 = 3;
                    break;
                }
                case 62552633: {
                    if (!var11_11.equals("ARRAY")) break;
                    var12_12 = 4;
                    break;
                }
                case 2098102: {
                    if (!var11_11.equals("DICT")) break;
                    var12_12 = 5;
                    break;
                }
                case -1838660736: {
                    if (!var11_11.equals("STREAM")) break;
                    var12_12 = 6;
                    break;
                }
                case 2090922: {
                    if (!var11_11.equals("DATA")) break;
                    var12_12 = 7;
                }
            }
            switch (var12_12) {
                case 0: {
                    if ("Length".equals(childAttrKey)) continue block36;
                    stream.setInt(COSName.getPDFName(childAttrKey), Integer.parseInt(childAttrVal));
                    FDFAnnotationStamp.LOG.debug(parentAttrKey + " => Set " + childAttrKey + ": " + childAttrVal);
                    continue block36;
                }
                case 1: {
                    stream.setFloat(COSName.getPDFName(childAttrKey), Float.parseFloat(childAttrVal));
                    FDFAnnotationStamp.LOG.debug(parentAttrKey + " => Set " + childAttrKey + ": " + childAttrVal);
                    continue block36;
                }
                case 2: {
                    stream.setName(COSName.getPDFName(childAttrKey), childAttrVal);
                    FDFAnnotationStamp.LOG.debug(parentAttrKey + " => Set " + childAttrKey + ": " + childAttrVal);
                    continue block36;
                }
                case 3: {
                    stream.setBoolean(COSName.getPDFName(childAttrKey), Boolean.parseBoolean(childAttrVal));
                    FDFAnnotationStamp.LOG.debug(parentAttrKey + " => Set " + childAttrVal);
                    continue block36;
                }
                case 4: {
                    stream.setItem(COSName.getPDFName(childAttrKey), (COSBase)this.parseArrayElement(child));
                    FDFAnnotationStamp.LOG.debug(parentAttrKey + " => Set " + childAttrKey);
                    continue block36;
                }
                case 5: {
                    stream.setItem(COSName.getPDFName(childAttrKey), (COSBase)this.parseDictElement(child));
                    FDFAnnotationStamp.LOG.debug(parentAttrKey + " => Set " + childAttrKey);
                    continue block36;
                }
                case 6: {
                    stream.setItem(COSName.getPDFName(childAttrKey), (COSBase)this.parseStreamElement(child));
                    FDFAnnotationStamp.LOG.debug(parentAttrKey + " => Set " + childAttrKey);
                    continue block36;
                }
                case 7: {
                    childEncodingAttr = child.getAttribute("ENCODING");
                    FDFAnnotationStamp.LOG.debug(parentAttrKey + " => Handling DATA with encoding: " + childEncodingAttr);
                    if (!"HEX".equals(childEncodingAttr)) ** GOTO lbl114
                    os = stream.createRawOutputStream();
                    var15_15 = null;
                    os.write(Hex.decodeHex(child.getTextContent()));
                    FDFAnnotationStamp.LOG.debug(parentAttrKey + " => Data was streamed");
                    if (os == null) continue block36;
                    if (var15_15 == null) ** GOTO lbl97
                    try {
                        os.close();
                    }
                    catch (Throwable var16_17) {
                        var15_15.addSuppressed(var16_17);
                    }
                    continue block36;
lbl97:
                    // 1 sources

                    os.close();
                    continue block36;
                    catch (Throwable var16_18) {
                        try {
                            var15_15 = var16_18;
                            throw var16_18;
                        }
                        catch (Throwable var17_21) {
                            if (os != null) {
                                if (var15_15 != null) {
                                    try {
                                        os.close();
                                    }
                                    catch (Throwable var18_22) {
                                        var15_15.addSuppressed(var18_22);
                                    }
                                } else {
                                    os.close();
                                }
                            }
                            throw var17_21;
                        }
                    }
lbl114:
                    // 1 sources

                    if (!"ASCII".equals(childEncodingAttr)) ** GOTO lbl150
                    os = stream.createOutputStream();
                    var15_15 = null;
                    encoding = child.getOwnerDocument().getXmlEncoding();
                    if (encoding == null) {
                        encoding = child.getOwnerDocument().getInputEncoding();
                    }
                    if (encoding == null) {
                        encoding = "UTF-8";
                    }
                    os.write(child.getTextContent().getBytes(encoding));
                    FDFAnnotationStamp.LOG.debug(parentAttrKey + " => Data was streamed");
                    if (os == null) continue block36;
                    if (var15_15 == null) ** GOTO lbl133
                    try {
                        os.close();
                    }
                    catch (Throwable var16_19) {
                        var15_15.addSuppressed(var16_19);
                    }
                    continue block36;
lbl133:
                    // 1 sources

                    os.close();
                    continue block36;
                    catch (Throwable var16_20) {
                        try {
                            var15_15 = var16_20;
                            throw var16_20;
                        }
                        catch (Throwable var19_23) {
                            if (os != null) {
                                if (var15_15 != null) {
                                    try {
                                        os.close();
                                    }
                                    catch (Throwable var20_24) {
                                        var15_15.addSuppressed(var20_24);
                                    }
                                } else {
                                    os.close();
                                }
                            }
                            throw var19_23;
                        }
                    }
lbl150:
                    // 1 sources

                    FDFAnnotationStamp.LOG.warn(parentAttrKey + " => Not handling element DATA encoding: " + childEncodingAttr);
                    continue block36;
                }
                default: {
                    FDFAnnotationStamp.LOG.warn(parentAttrKey + " => Not handling child element: " + childTagName);
                }
            }
        }
        return stream;
    }

    private COSArray parseArrayElement(Element arrayEl) throws IOException {
        LOG.debug("Parse " + arrayEl.getAttribute("KEY") + " Array");
        COSArray array = new COSArray();
        NodeList nodeList = arrayEl.getChildNodes();
        String parentAttrKey = arrayEl.getAttribute("KEY");
        if ("BBox".equals(parentAttrKey) && nodeList.getLength() < 4) {
            throw new IOException("BBox does not have enough coordinates, only has: " + nodeList.getLength());
        }
        if ("Matrix".equals(parentAttrKey) && nodeList.getLength() < 6) {
            throw new IOException("Matrix does not have enough coordinates, only has: " + nodeList.getLength());
        }
        block17: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            String childAttrKey = child.getAttribute("KEY");
            String childAttrVal = child.getAttribute("VAL");
            String childTagName = child.getTagName();
            LOG.debug(parentAttrKey + " => reading child: " + childTagName + " with key: " + childAttrKey);
            if (childTagName == null) {
                LOG.warn(parentAttrKey + " => Not handling child element: null");
                continue;
            }
            switch (childTagName.toUpperCase()) {
                case "INT": 
                case "FIXED": {
                    LOG.debug(parentAttrKey + " value(" + i + "): " + childAttrVal);
                    array.add(COSNumber.get(childAttrVal));
                    continue block17;
                }
                case "NAME": {
                    LOG.debug(parentAttrKey + " value(" + i + "): " + childAttrVal);
                    array.add(COSName.getPDFName(childAttrVal));
                    continue block17;
                }
                case "BOOL": {
                    LOG.debug(parentAttrKey + " value(" + i + "): " + childAttrVal);
                    array.add(COSBoolean.getBoolean(Boolean.parseBoolean(childAttrVal)));
                    continue block17;
                }
                case "DICT": {
                    LOG.debug(parentAttrKey + " value(" + i + "): " + childAttrVal);
                    array.add(this.parseDictElement(child));
                    continue block17;
                }
                case "STREAM": {
                    LOG.debug(parentAttrKey + " value(" + i + "): " + childAttrVal);
                    array.add(this.parseStreamElement(child));
                    continue block17;
                }
                case "ARRAY": {
                    LOG.debug(parentAttrKey + " value(" + i + "): " + childAttrVal);
                    array.add(this.parseArrayElement(child));
                    continue block17;
                }
                default: {
                    LOG.warn(parentAttrKey + " => Not handling child element: " + childTagName);
                }
            }
        }
        return array;
    }

    private COSDictionary parseDictElement(Element dictEl) throws IOException {
        LOG.debug("Parse " + dictEl.getAttribute("KEY") + " Dictionary");
        COSDictionary dict = new COSDictionary();
        NodeList nodeList = dictEl.getChildNodes();
        String parentAttrKey = dictEl.getAttribute("KEY");
        block18: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            String childAttrKey = child.getAttribute("KEY");
            String childAttrVal = child.getAttribute("VAL");
            String childTagName = child.getTagName();
            if (childTagName == null) {
                LOG.warn(parentAttrKey + " => NOT handling child element: null");
                continue;
            }
            switch (childTagName) {
                case "DICT": {
                    LOG.debug(parentAttrKey + " => Handling DICT element with key: " + childAttrKey);
                    dict.setItem(COSName.getPDFName(childAttrKey), (COSBase)this.parseDictElement(child));
                    LOG.debug(parentAttrKey + " => Set " + childAttrKey);
                    continue block18;
                }
                case "STREAM": {
                    LOG.debug(parentAttrKey + " => Handling STREAM element with key: " + childAttrKey);
                    dict.setItem(COSName.getPDFName(childAttrKey), (COSBase)this.parseStreamElement(child));
                    continue block18;
                }
                case "NAME": {
                    LOG.debug(parentAttrKey + " => Handling NAME element with key: " + childAttrKey);
                    dict.setName(COSName.getPDFName(childAttrKey), childAttrVal);
                    LOG.debug(parentAttrKey + " => Set " + childAttrKey + ": " + childAttrVal);
                    continue block18;
                }
                case "INT": {
                    dict.setInt(COSName.getPDFName(childAttrKey), Integer.parseInt(childAttrVal));
                    LOG.debug(parentAttrKey + " => Set " + childAttrKey + ": " + childAttrVal);
                    continue block18;
                }
                case "FIXED": {
                    dict.setFloat(COSName.getPDFName(childAttrKey), Float.parseFloat(childAttrVal));
                    LOG.debug(parentAttrKey + " => Set " + childAttrKey + ": " + childAttrVal);
                    continue block18;
                }
                case "BOOL": {
                    dict.setBoolean(COSName.getPDFName(childAttrKey), Boolean.parseBoolean(childAttrVal));
                    LOG.debug(parentAttrKey + " => Set " + childAttrVal);
                    continue block18;
                }
                case "ARRAY": {
                    dict.setItem(COSName.getPDFName(childAttrKey), (COSBase)this.parseArrayElement(child));
                    LOG.debug(parentAttrKey + " => Set " + childAttrKey);
                    continue block18;
                }
                default: {
                    LOG.warn(parentAttrKey + " => NOT handling child element: " + childTagName);
                }
            }
        }
        return dict;
    }
}

