/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.htmlunit.httpclient.HtmlUnitUsernamePasswordCredentials;

public class DefaultCredentialsProvider
implements CredentialsProvider,
Serializable {
    public static final String ANY_HOST = null;
    public static final int ANY_PORT = -1;
    public static final String ANY_REALM = null;
    public static final String ANY_SCHEME = null;
    private static SocksProxyAuthenticator SocksAuthenticator_;
    private final Map<AuthScopeProxy, Credentials> credentialsMap_ = new HashMap<AuthScopeProxy, Credentials>();

    public void addCredentials(String username, char[] password) {
        this.addCredentials(username, password, ANY_HOST, -1, ANY_REALM);
    }

    public void addCredentials(String username, char[] password, String host, int port, String realm) {
        AuthScope authscope = new AuthScope(host, port, realm, ANY_SCHEME);
        HtmlUnitUsernamePasswordCredentials credentials = new HtmlUnitUsernamePasswordCredentials(username, password);
        this.setCredentials(authscope, credentials);
    }

    public void addNTLMCredentials(String username, char[] password, String host, int port, String workstation, String domain) {
        AuthScope authscope = new AuthScope(host, port, ANY_REALM, ANY_SCHEME);
        NTCredentials credentials = new NTCredentials(username, String.valueOf(password), workstation, domain);
        this.setCredentials(authscope, credentials);
    }

    public void addSocksCredentials(String username, char[] password, String host, int port) {
        AuthScope authscope = new AuthScope(host, port, ANY_REALM, ANY_SCHEME);
        HtmlUnitUsernamePasswordCredentials credentials = new HtmlUnitUsernamePasswordCredentials(username, password);
        this.setCredentials(authscope, credentials);
        DefaultCredentialsProvider.initSocksAuthenticatorIfNeeded(this);
    }

    private static synchronized void initSocksAuthenticatorIfNeeded(CredentialsProvider provider) {
        if (SocksAuthenticator_ == null) {
            SocksAuthenticator_ = new SocksProxyAuthenticator();
            SocksAuthenticator_.credentialsProvider_ = provider;
            Authenticator.setDefault(SocksAuthenticator_);
        }
    }

    @Override
    public synchronized void setCredentials(AuthScope authscope, Credentials credentials) {
        if (authscope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        if (credentials instanceof UsernamePasswordCredentials || credentials instanceof HtmlUnitUsernamePasswordCredentials || credentials instanceof NTCredentials) {
            this.credentialsMap_.put(new AuthScopeProxy(authscope), credentials);
            return;
        }
        throw new IllegalArgumentException("Unsupported Credential type: " + credentials.getClass().getName());
    }

    private static Credentials matchCredentials(Map<AuthScopeProxy, Credentials> map, AuthScope authscope) {
        Credentials creds = map.get(new AuthScopeProxy(authscope));
        if (creds == null) {
            int bestMatchFactor = -1;
            AuthScopeProxy bestMatch = null;
            for (AuthScopeProxy proxy : map.keySet()) {
                AuthScope current = proxy.getAuthScope();
                int factor = authscope.match(current);
                if (factor <= bestMatchFactor) continue;
                bestMatchFactor = factor;
                bestMatch = proxy;
            }
            if (bestMatch != null) {
                creds = map.get(bestMatch);
            }
        }
        return creds;
    }

    @Override
    public synchronized Credentials getCredentials(AuthScope authscope) {
        if (authscope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        return DefaultCredentialsProvider.matchCredentials(this.credentialsMap_, authscope);
    }

    public synchronized boolean removeCredentials(AuthScope authscope) {
        if (authscope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        int bestMatchFactor = -1;
        AuthScopeProxy bestMatch = null;
        for (AuthScopeProxy proxy : this.credentialsMap_.keySet()) {
            AuthScope current = proxy.getAuthScope();
            int factor = authscope.match(current);
            if (factor <= bestMatchFactor) continue;
            bestMatchFactor = factor;
            bestMatch = proxy;
        }
        return this.credentialsMap_.remove(bestMatch) != null;
    }

    public String toString() {
        return this.credentialsMap_.toString();
    }

    @Override
    public synchronized void clear() {
        this.credentialsMap_.clear();
    }

    private static class AuthScopeProxy
    implements Serializable {
        private AuthScope authScope_;

        AuthScopeProxy(AuthScope authScope) {
            this.authScope_ = authScope;
        }

        public AuthScope getAuthScope() {
            return this.authScope_;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.writeObject(this.authScope_.getHost());
            stream.writeInt(this.authScope_.getPort());
            stream.writeObject(this.authScope_.getRealm());
            stream.writeObject(this.authScope_.getScheme());
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            String host = (String)stream.readObject();
            int port = stream.readInt();
            String realm = (String)stream.readObject();
            String scheme = (String)stream.readObject();
            this.authScope_ = new AuthScope(host, port, realm, scheme);
        }

        public int hashCode() {
            return this.authScope_.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof AuthScopeProxy && this.authScope_.equals(((AuthScopeProxy)obj).getAuthScope());
        }
    }

    private static final class SocksProxyAuthenticator
    extends Authenticator {
        private CredentialsProvider credentialsProvider_;

        private SocksProxyAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            boolean isProxy;
            boolean bl = isProxy = Authenticator.RequestorType.PROXY.equals((Object)this.getRequestorType()) || "SOCKS authentication".equals(this.getRequestingPrompt());
            if (!isProxy) {
                return null;
            }
            AuthScope authScope = new AuthScope(this.getRequestingHost(), this.getRequestingPort(), this.getRequestingScheme());
            Credentials credentials = this.credentialsProvider_.getCredentials(authScope);
            if (credentials == null) {
                return null;
            }
            return new PasswordAuthentication(credentials.getUserPrincipal().getName(), credentials.getPassword().toCharArray());
        }
    }
}

