/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.htmlunit.Page;
import org.htmlunit.WebRequest;
import org.htmlunit.WebWindow;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.event.PopStateEvent;
import org.htmlunit.util.HeaderUtils;
import org.htmlunit.util.UrlUtils;

public class History
implements Serializable {
    private final WebWindow window_;
    private transient ThreadLocal<Boolean> ignoreNewPages_;
    private final List<HistoryEntry> entries_ = new ArrayList<HistoryEntry>();
    private int index_ = -1;

    public History(WebWindow window) {
        this.window_ = window;
        this.initTransientFields();
    }

    private void initTransientFields() {
        this.ignoreNewPages_ = new ThreadLocal();
    }

    public int getLength() {
        return this.entries_.size();
    }

    public int getIndex() {
        return this.index_;
    }

    public URL getUrl(int index) {
        if (index >= 0 && index < this.entries_.size()) {
            return UrlUtils.toUrlSafe(this.entries_.get(index).getUrl().toExternalForm());
        }
        return null;
    }

    public History back() throws IOException {
        if (this.index_ > 0) {
            --this.index_;
            this.goToUrlAtCurrentIndex();
        }
        return this;
    }

    public History forward() throws IOException {
        if (this.index_ < this.entries_.size() - 1) {
            ++this.index_;
            this.goToUrlAtCurrentIndex();
        }
        return this;
    }

    public History go(int relativeIndex) throws IOException {
        int i = this.index_ + relativeIndex;
        if (i < this.entries_.size() && i >= 0) {
            this.index_ = i;
            this.goToUrlAtCurrentIndex();
        }
        return this;
    }

    public String toString() {
        return this.entries_.toString();
    }

    public void removeCurrent() {
        if (this.index_ >= 0 && this.index_ < this.entries_.size()) {
            this.entries_.remove(this.index_);
            if (this.index_ > 0) {
                --this.index_;
            }
        }
    }

    protected HistoryEntry addPage(Page page) {
        Boolean ignoreNewPages = this.ignoreNewPages_.get();
        if (ignoreNewPages != null && ignoreNewPages.booleanValue()) {
            return null;
        }
        int sizeLimit = this.window_.getWebClient().getOptions().getHistorySizeLimit();
        if (sizeLimit <= 0) {
            this.entries_.clear();
            this.index_ = -1;
            return null;
        }
        ++this.index_;
        while (this.entries_.size() > this.index_) {
            this.entries_.remove(this.index_);
        }
        while (this.entries_.size() >= sizeLimit) {
            this.entries_.remove(0);
            --this.index_;
        }
        HistoryEntry entry = new HistoryEntry(page);
        this.entries_.add(entry);
        int cacheLimit = Math.max(this.window_.getWebClient().getOptions().getHistoryPageCacheLimit(), 0);
        if (this.entries_.size() > cacheLimit) {
            this.entries_.get(this.entries_.size() - cacheLimit - 1).clearPage();
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void goToUrlAtCurrentIndex() throws IOException {
        Boolean old = this.ignoreNewPages_.get();
        this.ignoreNewPages_.set(Boolean.TRUE);
        try {
            HistoryEntry entry = this.entries_.get(this.index_);
            Page page = entry.getPage();
            if (page == null) {
                this.window_.getWebClient().getPage(this.window_, entry.getWebRequest(), false);
            } else {
                this.window_.setEnclosedPage(page);
                page.getWebResponse().getWebRequest().setUrl(entry.getUrl());
            }
            Window jsWindow = (Window)this.window_.getScriptableObject();
            if (jsWindow != null && jsWindow.hasEventHandlers("onpopstate")) {
                PopStateEvent event = new PopStateEvent(jsWindow, "popstate", entry.getState());
                jsWindow.executeEventLocally(event);
            }
        }
        finally {
            this.ignoreNewPages_.set(old);
        }
    }

    public void replaceState(Object state, URL url) {
        if (this.index_ >= 0 && this.index_ < this.entries_.size()) {
            HistoryEntry entry = this.entries_.get(this.index_);
            Page page = entry.getPage();
            if (page == null) {
                page = this.window_.getEnclosedPage();
            }
            entry.setUrl(url, page);
            entry.setState(state);
        }
    }

    public void pushState(Object state, URL url) {
        Page page = this.window_.getEnclosedPage();
        HistoryEntry entry = this.addPage(page);
        if (entry != null) {
            entry.setUrl(url, page);
            entry.setState(state);
        }
    }

    public Object getCurrentState() {
        if (this.index_ >= 0 && this.index_ < this.entries_.size()) {
            return this.entries_.get(this.index_).getState();
        }
        return null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransientFields();
    }

    private static final class HistoryEntry
    implements Serializable {
        private transient SoftReference<Page> page_;
        private final WebRequest webRequest_;
        private Object state_;

        HistoryEntry(Page page) {
            this.page_ = HeaderUtils.containsNoStore(page.getWebResponse()) ? null : new SoftReference<Page>(page);
            WebRequest request = page.getWebResponse().getWebRequest();
            this.webRequest_ = new WebRequest(request.getUrl(), request.getHttpMethod());
            this.webRequest_.setRequestParameters(request.getRequestParameters());
        }

        Page getPage() {
            if (this.page_ == null) {
                return null;
            }
            return this.page_.get();
        }

        void clearPage() {
            this.page_ = null;
        }

        WebRequest getWebRequest() {
            return this.webRequest_;
        }

        URL getUrl() {
            return this.webRequest_.getUrl();
        }

        void setUrl(URL url, Page page) {
            if (url != null) {
                WebWindow webWindow = null;
                if (page != null) {
                    webWindow = page.getEnclosingWindow();
                }
                URL encoded = UrlUtils.encodeUrl(url, this.webRequest_.getCharset());
                this.webRequest_.setUrl(encoded);
                if (page != null) {
                    Window win;
                    page.getWebResponse().getWebRequest().setUrl(encoded);
                    if (webWindow != null && (win = (Window)webWindow.getScriptableObject()) != null) {
                        win.getLocation().setHash(null, encoded.getRef(), false);
                    }
                }
            }
        }

        Object getState() {
            return this.state_;
        }

        void setState(Object state) {
            this.state_ = state;
        }
    }
}

