/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.NativeConsole;
import org.htmlunit.corejs.javascript.ScriptStackElement;
import org.htmlunit.corejs.javascript.Scriptable;

public class WebConsole
implements NativeConsole.ConsolePrinter,
Serializable {
    private static final Log LOG = LogFactory.getLog(WebConsole.class);
    private transient Logger logger_ = new DefaultLogger(LOG);

    public void setLogger(Logger logger) {
        this.logger_ = logger;
    }

    public Logger getLogger() {
        return this.logger_;
    }

    @Override
    public void print(Context cx, Scriptable scope, NativeConsole.Level level, Object[] args, ScriptStackElement[] stack) {
        switch (level) {
            case TRACE: {
                if (!this.logger_.isInfoEnabled()) break;
                String msg = WebConsole.format(cx, scope, args);
                if (stack != null) {
                    StringBuilder scriptStack = new StringBuilder();
                    scriptStack.append(msg);
                    for (ScriptStackElement scriptStackElement : stack) {
                        if (scriptStack.length() > 0) {
                            scriptStack.append('\n');
                        }
                        scriptStack.append(scriptStackElement);
                    }
                    msg = scriptStack.toString();
                }
                this.logger_.info(msg);
                break;
            }
            case DEBUG: {
                if (!this.logger_.isDebugEnabled()) break;
                this.logger_.debug(WebConsole.format(cx, scope, args));
                break;
            }
            case INFO: {
                if (!this.logger_.isInfoEnabled()) break;
                this.logger_.info(WebConsole.format(cx, scope, args));
                break;
            }
            case WARN: {
                if (!this.logger_.isWarnEnabled()) break;
                this.logger_.warn(WebConsole.format(cx, scope, args));
                break;
            }
            case ERROR: {
                if (!this.logger_.isErrorEnabled()) break;
                this.logger_.error(WebConsole.format(cx, scope, args));
                break;
            }
        }
    }

    private static String format(Context cx, Scriptable scope, Object[] args) {
        String msg = NativeConsole.format(cx, scope, args);
        msg = msg.replaceAll("\\r?\\n", "\n");
        return msg;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.setLogger(new DefaultLogger(LOG));
    }

    private static class DefaultLogger
    implements Logger {
        private final Log webConsoleLogger_;

        DefaultLogger(Log logger) {
            this.webConsoleLogger_ = logger;
        }

        @Override
        public boolean isTraceEnabled() {
            return this.webConsoleLogger_.isTraceEnabled();
        }

        @Override
        public void trace(Object message) {
            this.webConsoleLogger_.trace(message);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.webConsoleLogger_.isDebugEnabled();
        }

        @Override
        public void debug(Object message) {
            this.webConsoleLogger_.debug(message);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.webConsoleLogger_.isInfoEnabled();
        }

        @Override
        public void info(Object message) {
            this.webConsoleLogger_.info(message);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.webConsoleLogger_.isWarnEnabled();
        }

        @Override
        public void warn(Object message) {
            this.webConsoleLogger_.warn(message);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.webConsoleLogger_.isErrorEnabled();
        }

        @Override
        public void error(Object message) {
            this.webConsoleLogger_.error(message);
        }
    }

    public static interface Logger {
        public boolean isTraceEnabled();

        public void trace(Object var1);

        public boolean isDebugEnabled();

        public void debug(Object var1);

        public boolean isInfoEnabled();

        public void info(Object var1);

        public boolean isWarnEnabled();

        public void warn(Object var1);

        public boolean isErrorEnabled();

        public void error(Object var1);
    }
}

