/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.attachment;

import java.io.Serializable;
import org.htmlunit.Page;
import org.htmlunit.WebResponse;
import org.htmlunit.util.StringUtils;

public interface AttachmentHandler
extends Serializable {
    public void handleAttachment(Page var1, String var2);

    default public boolean handleAttachment(WebResponse response, String attachmentFilename) {
        return false;
    }

    default public boolean isAttachment(WebResponse response) {
        String disp = response.getResponseHeaderValue("Content-Disposition");
        if (disp == null) {
            String contentType = response.getResponseHeaderValue("Content-Type");
            return "application/octet-stream".equalsIgnoreCase(contentType);
        }
        return StringUtils.startsWithIgnoreCase(disp, "attachment");
    }
}

