/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.htmlunit.corejs.javascript.Callable;
import org.htmlunit.corejs.javascript.CompoundOperationMap;
import org.htmlunit.corejs.javascript.Constructable;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.IdFunctionObject;
import org.htmlunit.corejs.javascript.IteratorLikeIterable;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.LambdaFunction;
import org.htmlunit.corejs.javascript.NativeArray;
import org.htmlunit.corejs.javascript.NativeProxy;
import org.htmlunit.corejs.javascript.RegExpProxy;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.ScriptRuntimeES6;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.Symbol;
import org.htmlunit.corejs.javascript.SymbolKey;
import org.htmlunit.corejs.javascript.Undefined;

public class AbstractEcmaObjectOperations {
    static boolean hasOwnProperty(Context cx, Object o, Object property) {
        Scriptable obj = ScriptableObject.ensureScriptable(o);
        if (property instanceof Symbol) {
            return ScriptableObject.ensureSymbolScriptable(o).has((Symbol)property, obj);
        }
        ScriptRuntime.StringIdOrIndex s = ScriptRuntime.toStringIdOrIndex(property);
        if (s.stringId == null) {
            return obj.has(s.index, obj);
        }
        return obj.has(s.stringId, obj);
    }

    static boolean testIntegrityLevel(Context cx, Object o, INTEGRITY_LEVEL level) {
        Object[] ids;
        ScriptableObject obj = ScriptableObject.ensureScriptableObject(o);
        if (obj.isExtensible()) {
            return false;
        }
        try (CompoundOperationMap map = obj.startCompoundOp(false);){
            ids = obj.getIds(map, true, true);
        }
        for (Object name : ids) {
            ScriptableObject.DescriptorInfo desc = obj.getOwnPropertyDescriptor(cx, name);
            if (desc.isConfigurable()) {
                return false;
            }
            if (level != INTEGRITY_LEVEL.FROZEN || !desc.isDataDescriptor() || !desc.isWritable()) continue;
            return false;
        }
        return true;
    }

    static boolean setIntegrityLevel(Context cx, Object o, INTEGRITY_LEVEL level) {
        Object[] ids;
        ScriptableObject obj = ScriptableObject.ensureScriptableObject(o);
        if (!obj.preventExtensions()) {
            return false;
        }
        try (CompoundOperationMap map = obj.startCompoundOp(false);){
            ids = obj.getIds(map, true, true);
        }
        for (Object key : ids) {
            ScriptableObject.DescriptorInfo desc = obj.getOwnPropertyDescriptor(cx, key);
            if (level == INTEGRITY_LEVEL.SEALED) {
                if (!desc.isConfigurable()) continue;
                desc.configurable = false;
                obj.defineOwnProperty(cx, key, desc, false);
                continue;
            }
            if (desc.isDataDescriptor() && desc.isWritable()) {
                desc.writable = false;
            }
            if (desc.isConfigurable()) {
                desc.configurable = false;
            }
            obj.defineOwnProperty(cx, key, desc, false);
        }
        return true;
    }

    public static Constructable speciesConstructor(Context cx, Scriptable s, Constructable defaultConstructor) {
        Object constructor = ScriptableObject.getProperty(s, "constructor");
        if (constructor == Scriptable.NOT_FOUND || Undefined.isUndefined(constructor)) {
            return defaultConstructor;
        }
        if (!ScriptRuntime.isObject(constructor)) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(constructor));
        }
        Object species = ScriptableObject.getProperty((Scriptable)constructor, SymbolKey.SPECIES);
        if (species == Scriptable.NOT_FOUND || species == null || Undefined.isUndefined(species)) {
            return defaultConstructor;
        }
        if (!(species instanceof Constructable)) {
            throw ScriptRuntime.typeErrorById("msg.not.ctor", ScriptRuntime.typeof(species));
        }
        return (Constructable)species;
    }

    static void put(Context cx, Scriptable o, String p, Object v, boolean isThrow) {
        Scriptable base = ScriptableObject.getBase(o, p);
        if (base == null) {
            base = o;
        }
        if (base instanceof ScriptableObject) {
            if (((ScriptableObject)base).putOwnProperty(p, o, v, isThrow)) {
                return;
            }
            o.put(p, o, v);
        } else {
            base.put(p, o, v);
        }
    }

    static void put(Context cx, Scriptable o, int p, Object v, boolean isThrow) {
        Scriptable base = ScriptableObject.getBase(o, p);
        if (base == null) {
            base = o;
        }
        if (base instanceof ScriptableObject) {
            if (((ScriptableObject)base).putOwnProperty(p, o, v, isThrow)) {
                return;
            }
            o.put(p, o, v);
        } else {
            base.put(p, o, v);
        }
    }

    static void put(Context cx, Scriptable o, Symbol p, Object v, boolean isThrow) {
        Scriptable base = ScriptableObject.getBase(o, p);
        if (base == null) {
            base = o;
        }
        if (base instanceof ScriptableObject) {
            if (((ScriptableObject)base).putOwnProperty(p, o, v, isThrow)) {
                return;
            }
            ScriptableObject.ensureSymbolScriptable(o).put(p, o, v);
        } else {
            ScriptableObject.ensureSymbolScriptable(base).put(p, o, v);
        }
    }

    static Map<Object, List<Object>> groupBy(Context cx, Scriptable scope, IdFunctionObject f, Object items, Object callback, KEY_COERCION keyCoercion) {
        return AbstractEcmaObjectOperations.groupBy(cx, scope, f.getTag(), f.getFunctionName(), items, callback, keyCoercion);
    }

    static Map<Object, List<Object>> groupBy(Context cx, Scriptable scope, Object classTag, String functionName, Object items, Object callback, KEY_COERCION keyCoercion) {
        ScriptRuntimeES6.requireObjectCoercible(cx, items, classTag, functionName);
        if (!(callback instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.isnt.function", callback, ScriptRuntime.typeof(callback));
        }
        LinkedHashMap<Object, List<Object>> groups = new LinkedHashMap<Object, List<Object>>();
        Object iterator = ScriptRuntime.callIterator(items, cx, scope);
        try (IteratorLikeIterable it = new IteratorLikeIterable(cx, scope, iterator);){
            double i = 0.0;
            for (Object o : it) {
                if (i > 9.007199254740991E15) {
                    it.close();
                    throw ScriptRuntime.typeError("Too many values to iterate");
                }
                Object[] args = new Object[]{o, i};
                Object key = ((Callable)callback).call(cx, scope, Undefined.SCRIPTABLE_UNDEFINED, args);
                if (keyCoercion == KEY_COERCION.PROPERTY) {
                    if (!ScriptRuntime.isSymbol(key)) {
                        key = ScriptRuntime.toString(key);
                    }
                } else {
                    assert (keyCoercion == KEY_COERCION.COLLECTION);
                    if (key instanceof Number && ((Number)key).doubleValue() == ScriptRuntime.negativeZero) {
                        key = ScriptRuntime.zeroObj;
                    }
                }
                List group2 = groups.computeIfAbsent(key, k -> new ArrayList());
                group2.add(o);
                i += 1.0;
            }
        }
        return groups;
    }

    static List<Object> createListFromArrayLike(Context cx, Scriptable o, Predicate<Object> elementTypesPredicate, String msg) {
        ScriptableObject obj = ScriptableObject.ensureScriptableObject(o);
        if (obj instanceof NativeArray) {
            Object[] arr;
            for (Object next : arr = ((NativeArray)obj).toArray()) {
                if (elementTypesPredicate.test(next)) continue;
                throw ScriptRuntime.typeError(msg);
            }
            return Arrays.asList(arr);
        }
        long len = AbstractEcmaObjectOperations.lengthOfArrayLike(cx, obj);
        ArrayList<Object> list = new ArrayList<Object>();
        for (long index = 0L; index < len; ++index) {
            Object next = ScriptableObject.getProperty((Scriptable)obj, (int)index);
            if (!elementTypesPredicate.test(next)) {
                throw ScriptRuntime.typeError(msg);
            }
            list.add(next);
        }
        return list;
    }

    public static long lengthOfArrayLike(Context cx, Scriptable o) {
        Object value = ScriptableObject.getProperty(o, "length");
        long len = ScriptRuntime.toLength(new Object[]{value}, 0);
        return len;
    }

    static boolean isCompatiblePropertyDescriptor(Context cx, boolean extensible, ScriptableObject.DescriptorInfo desc, ScriptableObject.DescriptorInfo current) {
        return AbstractEcmaObjectOperations.validateAndApplyPropertyDescriptor(cx, Undefined.SCRIPTABLE_UNDEFINED, Undefined.SCRIPTABLE_UNDEFINED, extensible, desc, current);
    }

    static boolean validateAndApplyPropertyDescriptor(Context cx, Scriptable o, Scriptable p, boolean extensible, ScriptableObject.DescriptorInfo desc, ScriptableObject.DescriptorInfo current) {
        if (Undefined.isUndefined(current)) {
            if (!extensible) {
                return false;
            }
            if (desc.isGenericDescriptor() || desc.isDataDescriptor()) {
                // empty if block
            }
            return true;
        }
        if (!(desc.hasEnumerable() || desc.hasConfigurable() || desc.hasWritable() || desc.hasGetter() || desc.hasSetter() || desc.hasValue())) {
            return true;
        }
        if (current.isConfigurable(false)) {
            if (desc.isConfigurable()) {
                return false;
            }
            if (desc.hasEnumerable() && !Objects.equals(desc.enumerable, current.enumerable)) {
                return false;
            }
        }
        if (desc.isGenericDescriptor()) {
            return true;
        }
        if (current.isDataDescriptor() != desc.isDataDescriptor()) {
            if (current.isConfigurable(false)) {
                return false;
            }
            if (current.isDataDescriptor() && current.isConfigurable(false)) {
                // empty if block
            }
        } else if (current.isDataDescriptor() && desc.isDataDescriptor()) {
            if (current.isConfigurable(false) && current.isWritable(false)) {
                if (desc.isWritable()) {
                    return false;
                }
                return !desc.hasValue() || Objects.equals(desc.value, current.value);
            }
        } else if (current.isConfigurable(false)) {
            if (desc.hasSetter() && !Objects.equals(desc.setter, current.setter)) {
                return false;
            }
            return !desc.hasGetter() || Objects.equals(desc.getter, current.getter);
        }
        return true;
    }

    public static boolean isConstructor(Context cx, Object argument) {
        if (argument instanceof LambdaConstructor) {
            return true;
        }
        if (argument instanceof LambdaFunction) {
            return false;
        }
        if (argument instanceof NativeProxy.NativeProxyFunction) {
            ScriptableObject f = ((NativeProxy)argument).getTargetThrowIfRevoked();
            return AbstractEcmaObjectOperations.isConstructor(cx, f);
        }
        return argument instanceof Constructable;
    }

    static boolean isRegExp(Context cx, Scriptable scope, Object argument) {
        if (!ScriptRuntime.isObject(argument)) {
            return false;
        }
        Object matcher = ScriptRuntime.getObjectElem(argument, SymbolKey.MATCH, cx, scope);
        if (!Undefined.isUndefined(matcher)) {
            return ScriptRuntime.toBoolean(matcher);
        }
        RegExpProxy regExpProxy = ScriptRuntime.checkRegExpProxy(cx);
        return argument instanceof Scriptable && regExpProxy.isRegExp((Scriptable)argument);
    }

    static enum KEY_COERCION {
        PROPERTY,
        COLLECTION;

    }

    static enum INTEGRITY_LEVEL {
        FROZEN,
        SEALED;

    }
}

