/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import org.htmlunit.corejs.javascript.BaseFunction;
import org.htmlunit.corejs.javascript.CompoundOperationMap;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.JSFunction;
import org.htmlunit.corejs.javascript.Kit;
import org.htmlunit.corejs.javascript.NativeCall;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.Symbol;
import org.htmlunit.corejs.javascript.SymbolKey;
import org.htmlunit.corejs.javascript.TopLevel;

class Arguments
extends ScriptableObject {
    private static final long serialVersionUID = 4275508002492040609L;
    private static final String CLASS_NAME = "Arguments";
    private Object calleeObj;
    private Object lengthObj;
    private NativeCall activation;
    private Object[] args;

    public Arguments(NativeCall activation, Context cx) {
        this.activation = activation;
        Scriptable parent = activation.getParentScope();
        this.setParentScope(parent);
        this.setPrototype(ScriptableObject.getObjectPrototype(parent));
        this.args = activation.originalArgs;
        this.lengthObj = this.args.length;
        JSFunction f = activation.function;
        this.calleeObj = f;
        this.defineProperty(SymbolKey.ITERATOR, TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(parent), TopLevel.Builtins.Array).get("values", parent), 2);
        this.defineProperty("length", this.lengthObj, 2);
        if (activation.isStrict) {
            BaseFunction typeErrorThrower = ScriptRuntime.typeErrorThrower(cx);
            int version = cx.getLanguageVersion();
            this.setGetterOrSetter("callee", 0, typeErrorThrower, true);
            this.setGetterOrSetter("callee", 0, typeErrorThrower, false);
            this.setAttributes("callee", 6);
            this.calleeObj = null;
        } else {
            this.defineProperty("callee", this.calleeObj, 2);
            int n = cx.getLanguageVersion();
        }
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    private Object arg(int index) {
        if (index < 0 || this.args.length <= index) {
            return NOT_FOUND;
        }
        return this.args[index];
    }

    private void putIntoActivation(int index, Object value) {
        String argName = this.activation.function.getParamOrVarName(index);
        this.activation.put(argName, (Scriptable)this.activation, value);
    }

    private Object getFromActivation(int index) {
        String argName = this.activation.function.getParamOrVarName(index);
        return this.activation.get(argName, (Scriptable)this.activation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceArg(int index, Object value) {
        if (this.sharedWithActivation(index)) {
            this.putIntoActivation(index, value);
        }
        Arguments arguments = this;
        synchronized (arguments) {
            if (this.activation != null && this.args == this.activation.originalArgs) {
                this.args = (Object[])this.args.clone();
            }
            this.args[index] = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeArg(int index) {
        Arguments arguments = this;
        synchronized (arguments) {
            if (this.args[index] != NOT_FOUND) {
                if (this.args == this.activation.originalArgs) {
                    this.args = (Object[])this.args.clone();
                }
                this.args[index] = NOT_FOUND;
            }
        }
    }

    @Override
    public boolean has(int index, Scriptable start) {
        if (this.arg(index) != NOT_FOUND) {
            return true;
        }
        return super.has(index, start);
    }

    @Override
    public Object get(int index, Scriptable start) {
        Object value = this.arg(index);
        if (value == NOT_FOUND) {
            return super.get(index, start);
        }
        if (this.sharedWithActivation(index)) {
            return this.getFromActivation(index);
        }
        return value;
    }

    private boolean sharedWithActivation(int index) {
        Context cx = Context.getContext();
        if (cx.isStrictMode()) {
            return false;
        }
        if (this.activation == null) {
            return false;
        }
        JSFunction f = this.activation.function;
        if (f == null || f.hasDefaultParameters()) {
            return false;
        }
        int definedCount = f.getParamCount();
        if (index < definedCount) {
            if (index < definedCount - 1) {
                String argName = f.getParamOrVarName(index);
                for (int i = index + 1; i < definedCount; ++i) {
                    if (!argName.equals(f.getParamOrVarName(i))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void put(int index, Scriptable start, Object value) {
        if (this.arg(index) == NOT_FOUND) {
            super.put(index, start, value);
        } else {
            this.replaceArg(index, value);
        }
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        super.put(name, start, value);
    }

    @Override
    public void put(Symbol key, Scriptable start, Object value) {
        super.put(key, start, value);
    }

    @Override
    public void delete(int index) {
        if (0 <= index && index < this.args.length) {
            this.removeArg(index);
        }
        super.delete(index);
    }

    @Override
    Object[] getIds(CompoundOperationMap map, boolean getNonEnumerable, boolean getSymbols) {
        Object[] ids = super.getIds(map, getNonEnumerable, getSymbols);
        if (this.args.length != 0) {
            int i;
            boolean[] present = new boolean[this.args.length];
            int extraCount = this.args.length;
            for (i = 0; i != ids.length; ++i) {
                int index;
                Object id = ids[i];
                if (!(id instanceof Integer) || 0 > (index = ((Integer)id).intValue()) || index >= this.args.length || present[index]) continue;
                present[index] = true;
                --extraCount;
            }
            if (!getNonEnumerable) {
                for (i = 0; i < present.length; ++i) {
                    if (present[i] || !super.has(i, (Scriptable)this)) continue;
                    present[i] = true;
                    --extraCount;
                }
            }
            if (extraCount != 0) {
                Object[] tmp = new Object[extraCount + ids.length];
                System.arraycopy(ids, 0, tmp, extraCount, ids.length);
                ids = tmp;
                int offset = 0;
                for (int i2 = 0; i2 != this.args.length; ++i2) {
                    if (present[i2]) continue;
                    ids[offset] = i2;
                    ++offset;
                }
                if (offset != extraCount) {
                    Kit.codeBug();
                }
            }
        }
        return ids;
    }

    @Override
    protected ScriptableObject.DescriptorInfo getOwnPropertyDescriptor(Context cx, Object id) {
        int index;
        if (ScriptRuntime.isSymbol(id) || id instanceof Scriptable) {
            return super.getOwnPropertyDescriptor(cx, id);
        }
        double d = ScriptRuntime.toNumber(id);
        if (d != (double)(index = (int)d)) {
            return super.getOwnPropertyDescriptor(cx, id);
        }
        Object value = this.arg(index);
        if (value == NOT_FOUND) {
            return super.getOwnPropertyDescriptor(cx, id);
        }
        if (this.sharedWithActivation(index)) {
            value = this.getFromActivation(index);
        }
        if (super.has(index, (Scriptable)this)) {
            ScriptableObject.DescriptorInfo desc = super.getOwnPropertyDescriptor(cx, id);
            desc.value = value;
            return desc;
        }
        return Arguments.buildDataDescriptor(value, 0);
    }

    @Override
    protected boolean defineOwnProperty(Context cx, Object id, ScriptableObject.DescriptorInfo desc, boolean checkValid) {
        int index;
        super.defineOwnProperty(cx, id, desc, checkValid);
        if (ScriptRuntime.isSymbol(id)) {
            return true;
        }
        double d = ScriptRuntime.toNumber(id);
        if (d != (double)(index = (int)d)) {
            return true;
        }
        Object value = this.arg(index);
        if (value == NOT_FOUND) {
            return true;
        }
        if (desc.isAccessorDescriptor()) {
            this.removeArg(index);
            return true;
        }
        Object newValue = desc.value;
        if (newValue == NOT_FOUND) {
            return true;
        }
        this.replaceArg(index, newValue);
        if (Arguments.isFalse(desc.writable)) {
            this.removeArg(index);
        }
        return true;
    }

    public Arguments(Arguments original) {
        this.activation = original.activation;
        this.setParentScope(original.getParentScope());
        this.setPrototype(original.getPrototype());
        this.args = original.args;
        this.lengthObj = original.lengthObj;
        this.calleeObj = original.calleeObj;
    }

    static final class ReadonlyArguments
    extends Arguments {
        private boolean initialized = true;

        public ReadonlyArguments(Arguments arguments, Context cx) {
            super(arguments.activation, cx);
        }

        @Override
        public void put(int index, Scriptable start, Object value) {
            if (this.initialized) {
                return;
            }
            super.put(index, start, value);
        }

        @Override
        public void put(String name, Scriptable start, Object value) {
            if (this.initialized) {
                return;
            }
            super.put(name, start, value);
        }

        @Override
        public void put(Symbol key, Scriptable start, Object value) {
            if (this.initialized) {
                return;
            }
            super.put(key, start, value);
        }

        @Override
        public void delete(int index) {
            if (this.initialized) {
                return;
            }
            super.delete(index);
        }

        @Override
        public void delete(String name) {
            if (this.initialized) {
                return;
            }
            super.delete(name);
        }

        @Override
        public void delete(Symbol key) {
            if (this.initialized) {
                return;
            }
            super.delete(key);
        }
    }
}

