/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.htmlunit.corejs.javascript.CompilerEnvirons;
import org.htmlunit.corejs.javascript.JSCode;
import org.htmlunit.corejs.javascript.JSDescriptor;
import org.htmlunit.corejs.javascript.JSFunction;
import org.htmlunit.corejs.javascript.ScriptOrFn;
import org.htmlunit.corejs.javascript.ast.AstNode;
import org.htmlunit.corejs.javascript.ast.AstRoot;
import org.htmlunit.corejs.javascript.ast.Block;
import org.htmlunit.corejs.javascript.ast.FunctionNode;
import org.htmlunit.corejs.javascript.ast.Scope;
import org.htmlunit.corejs.javascript.ast.ScriptNode;

public class CodeGenUtils {
    public static void fillInForNestedFunction(JSDescriptor.Builder<JSFunction> builder, JSDescriptor.Builder<?> parent, FunctionNode fn) {
        AstNode fnParent = fn.getParent();
        if (!(fnParent instanceof AstRoot || fnParent instanceof Scope || fnParent instanceof Block)) {
            boolean isArrow;
            builder.declaredAsFunctionExpression = true;
            builder.hasLexicalThis = isArrow = fn.getFunctionType() == 4;
            boolean bl = builder.hasPrototype = !isArrow;
            builder.constructor = !isArrow ? builder.code : new JSCode.NullBuilder();
        } else {
            builder.hasLexicalThis = false;
            builder.hasPrototype = true;
            builder.constructor = builder.code;
        }
        CodeGenUtils.fillInForFunction(builder, fn);
    }

    private static void fillInForFunction(JSDescriptor.Builder builder, FunctionNode fn) {
        builder.functionType = fn.getFunctionType();
        builder.requiresActivationFrame = fn.requiresActivation();
        builder.requiresArgumentObject = fn.requiresArgumentObject();
        if (fn.getFunctionName() != null) {
            builder.name = fn.getName();
        }
        if (fn.isInStrictMode()) {
            builder.isStrict = true;
        }
        if (fn.isES6Generator()) {
            builder.isES6Generator = true;
        }
        if (fn.isShorthand()) {
            builder.isShorthand = true;
        }
        CodeGenUtils.fillInCommon(builder, fn);
    }

    public static void fillInForTopLevelFunction(JSDescriptor.Builder builder, FunctionNode fn, String rawSource, CompilerEnvirons compilerEnv) {
        builder.hasPrototype = true;
        CodeGenUtils.fillInTopLevelCommon(builder, fn, rawSource, compilerEnv);
        CodeGenUtils.fillInForFunction(builder, fn);
    }

    public static void fillInForScript(JSDescriptor.Builder builder, ScriptNode scriptOrFn, String rawSource, CompilerEnvirons compilerEnv) {
        builder.hasPrototype = false;
        CodeGenUtils.fillInTopLevelCommon(builder, scriptOrFn, rawSource, compilerEnv);
        CodeGenUtils.fillInCommon(builder, scriptOrFn);
    }

    private static void fillInTopLevelCommon(JSDescriptor.Builder builder, ScriptNode scriptOrFn, String rawSource, CompilerEnvirons compilerEnv) {
        builder.sourceFile = scriptOrFn.getSourceName();
        builder.rawSource = rawSource;
        builder.isTopLevel = true;
        builder.isScript = true;
        builder.isEvalFunction = compilerEnv.isInEval();
        builder.isStrict = scriptOrFn.isInStrictMode();
        builder.hasLexicalThis = false;
        builder.securityController = compilerEnv.securityController();
        builder.securityDomain = compilerEnv.securityDomain();
    }

    private static void fillInCommon(JSDescriptor.Builder builder, ScriptNode scriptOrFn) {
        builder.paramAndVarNames = CodeGenUtils.disambiguateNames(scriptOrFn.getParamAndVarNames(), scriptOrFn.getParamCount());
        builder.paramCount = scriptOrFn.getParamCount();
        builder.paramIsConst = scriptOrFn.getParamAndVarConst();
        builder.paramAndVarCount = scriptOrFn.getParamAndVarCount();
        builder.hasRestArg = scriptOrFn.hasRestParameter();
        builder.hasDefaultParameters = scriptOrFn.getDefaultParams() != null;
        builder.arity = FunctionNode.calculateFunctionArity(scriptOrFn);
        builder.rawSourceStart = scriptOrFn.getRawSourceStart();
        builder.rawSourceEnd = scriptOrFn.getRawSourceEnd();
    }

    public static <T extends ScriptOrFn<T>> void setConstructor(JSDescriptor.Builder<T> builder, ScriptNode scriptOrFn) {
        if (scriptOrFn instanceof FunctionNode) {
            boolean isArrow;
            FunctionNode f = (FunctionNode)scriptOrFn;
            boolean bl = isArrow = f.getFunctionType() == 4;
            builder.constructor = isArrow || f.isMethodDefinition() || f.isGenerator() ? new JSCode.NullBuilder() : builder.code;
        } else {
            builder.constructor = new JSCode.NullBuilder();
        }
    }

    private static String[] disambiguateNames(String[] names, int paramCount) {
        String[] result = new String[names.length];
        HashMap<String, AtomicInteger> checkMap = new HashMap<String, AtomicInteger>();
        for (int i = 0; i < names.length; ++i) {
            AtomicInteger counter = checkMap.computeIfAbsent(names[i], k -> new AtomicInteger());
            int count = counter.getAndIncrement();
            result[i] = i >= paramCount && count > 0 ? String.format("%s(%d)", names[i], count) : names[i];
        }
        return result;
    }
}

