/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.math.BigInteger;
import java.util.Objects;

class DToA {
    private static final int Frac_mask = 1048575;
    private static final int Exp_shift = 20;
    private static final int Exp_msk1 = 0x100000;
    private static final long Frac_maskL = 0xFFFFFFFFFFFFFL;
    private static final int Exp_shiftL = 52;
    private static final long Exp_msk1L = 0x10000000000000L;
    private static final int Bias = 1023;
    private static final int P = 53;
    private static final int Exp_shift1 = 20;
    private static final int Exp_mask = 0x7FF00000;
    private static final int Exp_mask_shifted = 2047;
    private static final int Bndry_mask = 1048575;
    private static final int Log2P = 1;
    private static final int Sign_bit = Integer.MIN_VALUE;
    private static final int Exp_11 = 0x3FF00000;
    private static final int Ten_pmax = 22;
    private static final int Quick_max = 14;
    private static final int Bletch = 16;
    private static final int Frac_mask1 = 1048575;
    private static final int Int_max = 14;
    private static final int n_bigtens = 5;
    private static final double[] tens = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
    private static final double[] bigtens = new double[]{1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};

    DToA() {
    }

    private static char BASEDIGIT(int digit) {
        return (char)(digit >= 10 ? 87 + digit : 48 + digit);
    }

    private static int lo0bits(int y) {
        int x = y;
        if ((x & 7) != 0) {
            if ((x & 1) != 0) {
                return 0;
            }
            if ((x & 2) != 0) {
                return 1;
            }
            return 2;
        }
        int k = 0;
        if ((x & 0xFFFF) == 0) {
            k = 16;
            x >>>= 16;
        }
        if ((x & 0xFF) == 0) {
            k += 8;
            x >>>= 8;
        }
        if ((x & 0xF) == 0) {
            k += 4;
            x >>>= 4;
        }
        if ((x & 3) == 0) {
            k += 2;
            x >>>= 2;
        }
        if ((x & 1) == 0) {
            ++k;
            if (((x >>>= 1) & 1) == 0) {
                return 32;
            }
        }
        return k;
    }

    private static int hi0bits(int x) {
        int k = 0;
        if ((x & 0xFFFF0000) == 0) {
            k = 16;
            x <<= 16;
        }
        if ((x & 0xFF000000) == 0) {
            k += 8;
            x <<= 8;
        }
        if ((x & 0xF0000000) == 0) {
            k += 4;
            x <<= 4;
        }
        if ((x & 0xC0000000) == 0) {
            k += 2;
            x <<= 2;
        }
        if ((x & Integer.MIN_VALUE) == 0) {
            ++k;
            if ((x & 0x40000000) == 0) {
                return 32;
            }
        }
        return k;
    }

    private static void stuffBits(byte[] bits, int offset, int val) {
        bits[offset] = (byte)(val >> 24);
        bits[offset + 1] = (byte)(val >> 16);
        bits[offset + 2] = (byte)(val >> 8);
        bits[offset + 3] = (byte)val;
    }

    private static BigInteger d2b(double d, int[] e, int[] bits) {
        int i;
        int k;
        byte[] dbl_bits;
        int y;
        long dBits = Double.doubleToLongBits(d);
        int d0 = (int)(dBits >>> 32);
        int d1 = (int)dBits;
        int z = d0 & 0xFFFFF;
        int de = (d0 &= Integer.MAX_VALUE) >>> 20;
        if (de != 0) {
            z |= 0x100000;
        }
        if ((y = d1) != 0) {
            dbl_bits = new byte[8];
            k = DToA.lo0bits(y);
            y >>>= k;
            if (k != 0) {
                DToA.stuffBits(dbl_bits, 4, y | z << 32 - k);
                z >>= k;
            } else {
                DToA.stuffBits(dbl_bits, 4, y);
            }
            DToA.stuffBits(dbl_bits, 0, z);
            i = z != 0 ? 2 : 1;
        } else {
            dbl_bits = new byte[4];
            k = DToA.lo0bits(z);
            DToA.stuffBits(dbl_bits, 0, z >>>= k);
            k += 32;
            i = 1;
        }
        if (de != 0) {
            e[0] = de - 1023 - 52 + k;
            bits[0] = 53 - k;
        } else {
            e[0] = de - 1023 - 52 + 1 + k;
            bits[0] = 32 * i - DToA.hi0bits(z);
        }
        return new BigInteger(dbl_bits);
    }

    static String JS_dtobasestr(int base, double d) {
        BigInteger mlo;
        String intDigits;
        boolean negative;
        if (2 > base || base > 36) {
            throw new IllegalArgumentException("Bad base: " + base);
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (Double.isInfinite(d)) {
            return d > 0.0 ? "Infinity" : "-Infinity";
        }
        if (d == 0.0) {
            return "0";
        }
        if (d >= 0.0) {
            negative = false;
        } else {
            negative = true;
            d = -d;
        }
        double dfloor = Math.floor(d);
        long lfloor = (long)dfloor;
        if ((double)lfloor == dfloor) {
            intDigits = Long.toString(negative ? -lfloor : lfloor, base);
        } else {
            long floorBits = Double.doubleToLongBits(dfloor);
            int exp = (int)(floorBits >> 52) & 0x7FF;
            long mantissa = exp == 0 ? (floorBits & 0xFFFFFFFFFFFFFL) << 1 : floorBits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            if (negative) {
                mantissa = -mantissa;
            }
            BigInteger x = BigInteger.valueOf(mantissa);
            if ((exp -= 1075) > 0) {
                x = x.shiftLeft(exp);
            } else if (exp < 0) {
                x = x.shiftRight(-exp);
            }
            intDigits = x.toString(base);
        }
        if (d == dfloor) {
            return intDigits;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(intDigits).append('.');
        double df = d - dfloor;
        long dBits = Double.doubleToLongBits(d);
        int word0 = (int)(dBits >> 32);
        int word1 = (int)dBits;
        int[] e = new int[1];
        int[] bbits = new int[1];
        BigInteger b = DToA.d2b(df, e, bbits);
        int s2 = -(word0 >>> 20 & 0x7FF);
        if (s2 == 0) {
            s2 = -1;
        }
        s2 += 1076;
        BigInteger mhi = mlo = BigInteger.valueOf(1L);
        if (word1 == 0 && (word0 & 0xFFFFF) == 0 && (word0 & 0x7FE00000) != 0) {
            ++s2;
            mhi = BigInteger.valueOf(2L);
        }
        b = b.shiftLeft(e[0] + s2);
        BigInteger s = BigInteger.valueOf(1L);
        s = s.shiftLeft(s2);
        BigInteger bigBase = BigInteger.valueOf(base);
        boolean done = false;
        do {
            int j1;
            b = b.multiply(bigBase);
            BigInteger[] divResult = b.divideAndRemainder(s);
            b = divResult[1];
            int digit = divResult[0].intValue();
            if (Objects.equals(mlo, mhi)) {
                mlo = mhi = mlo.multiply(bigBase);
            } else {
                mlo = mlo.multiply(bigBase);
                mhi = mhi.multiply(bigBase);
            }
            int j = b.compareTo(mlo);
            BigInteger delta = s.subtract(mhi);
            int n = j1 = delta.signum() <= 0 ? 1 : b.compareTo(delta);
            if (j1 == 0 && (word1 & 1) == 0) {
                if (j > 0) {
                    ++digit;
                }
                done = true;
            } else if (j < 0 || j == 0 && (word1 & 1) == 0) {
                if (j1 > 0 && (j1 = (b = b.shiftLeft(1)).compareTo(s)) > 0) {
                    ++digit;
                }
                done = true;
            } else if (j1 > 0) {
                ++digit;
                done = true;
            }
            buffer.append(DToA.BASEDIGIT(digit));
        } while (!done);
        return buffer.toString();
    }
}

