/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import org.htmlunit.corejs.javascript.Callable;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ES6Iterator;
import org.htmlunit.corejs.javascript.JSFunction;
import org.htmlunit.corejs.javascript.JavaScriptException;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.LambdaFunction;
import org.htmlunit.corejs.javascript.NativeGenerator;
import org.htmlunit.corejs.javascript.NativeIterator;
import org.htmlunit.corejs.javascript.RhinoException;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.SymbolKey;
import org.htmlunit.corejs.javascript.Undefined;

public final class ES6Generator
extends ScriptableObject {
    private static final long serialVersionUID = 1645892441041347273L;
    static final Object GENERATOR_TAG = "Generator";
    private JSFunction function;
    private Object savedState;
    private String lineSource;
    private int lineNumber;
    private State state = State.SUSPENDED_START;
    private Object delegee;

    static ES6Generator init(ScriptableObject scope, boolean sealed) {
        ES6Generator prototype = new ES6Generator();
        if (scope != null) {
            prototype.setParentScope(scope);
            prototype.setPrototype(ES6Generator.getObjectPrototype(scope));
        }
        LambdaFunction next = new LambdaFunction(scope, "next", 1, ES6Generator::js_next);
        ScriptableObject.defineProperty(prototype, "next", next, 2);
        LambdaFunction returnFunc = new LambdaFunction(scope, "return", 1, ES6Generator::js_return);
        ScriptableObject.defineProperty(prototype, "return", returnFunc, 2);
        LambdaFunction throwFunc = new LambdaFunction(scope, "throw", 1, ES6Generator::js_throw);
        ScriptableObject.defineProperty(prototype, "throw", throwFunc, 2);
        LambdaFunction iterator = new LambdaFunction(scope, "[Symbol.iterator]", 0, ES6Generator::js_iterator);
        prototype.defineProperty(SymbolKey.ITERATOR, (Object)iterator, 2);
        prototype.defineProperty(SymbolKey.TO_STRING_TAG, (Object)"Generator", 3);
        if (sealed) {
            prototype.sealObject();
        }
        if (scope != null) {
            scope.associateValue(GENERATOR_TAG, prototype);
        }
        return prototype;
    }

    private ES6Generator() {
    }

    public ES6Generator(Scriptable scope, JSFunction function, Object savedState) {
        this.function = function;
        this.savedState = savedState;
        Scriptable top = ScriptableObject.getTopLevelScope(scope);
        this.setParentScope(top);
        Object functionPrototype = ScriptableObject.getProperty((Scriptable)function, "prototype");
        if (functionPrototype instanceof Scriptable) {
            this.setPrototype((Scriptable)functionPrototype);
        } else {
            ES6Generator prototype = (ES6Generator)ScriptableObject.getTopScopeValue(top, GENERATOR_TAG);
            this.setPrototype(prototype);
        }
    }

    @Override
    public String getClassName() {
        return "Generator";
    }

    private static ES6Generator realThis(Scriptable thisObj) {
        return LambdaConstructor.convertThisObject(thisObj, ES6Generator.class);
    }

    private static Object js_return(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object value;
        ES6Generator generator = ES6Generator.realThis(thisObj);
        Object object = value = args.length >= 1 ? args[0] : Undefined.instance;
        if (generator.delegee == null) {
            return generator.resumeAbruptLocal(cx, scope, 2, value);
        }
        return generator.resumeDelegeeReturn(cx, scope, value);
    }

    private static Object js_next(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object value;
        ES6Generator generator = ES6Generator.realThis(thisObj);
        Object object = value = args.length >= 1 ? args[0] : Undefined.instance;
        if (generator.delegee == null) {
            return generator.resumeLocal(cx, scope, value);
        }
        return generator.resumeDelegee(cx, scope, value);
    }

    private static Object js_throw(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object value;
        ES6Generator generator = ES6Generator.realThis(thisObj);
        Object object = value = args.length >= 1 ? args[0] : Undefined.instance;
        if (generator.delegee == null) {
            return generator.resumeAbruptLocal(cx, scope, 1, value);
        }
        return generator.resumeDelegeeThrow(cx, scope, value);
    }

    private static Object js_iterator(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return thisObj;
    }

    private Scriptable resumeDelegee(Context cx, Scriptable scope, Object value) {
        try {
            Object[] objectArray;
            if (Undefined.isUndefined(value)) {
                objectArray = ScriptRuntime.emptyArgs;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = value;
            }
            Object[] nextArgs = objectArray;
            ScriptRuntime.LookupResult nextFn = ScriptRuntime.getPropAndThis(this.delegee, "next", cx, scope);
            Object nr = nextFn.call(cx, scope, nextArgs);
            Scriptable nextResult = ScriptableObject.ensureScriptable(nr);
            if (ScriptRuntime.isIteratorDone(cx, nextResult)) {
                this.delegee = null;
                return this.resumeLocal(cx, scope, ScriptableObject.getProperty(nextResult, "value"));
            }
            return nextResult;
        }
        catch (RhinoException re) {
            this.delegee = null;
            return this.resumeAbruptLocal(cx, scope, 1, re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Scriptable resumeDelegeeThrow(Context cx, Scriptable scope, Object value) {
        boolean returnCalled = false;
        try {
            ScriptRuntime.LookupResult throwFn = ScriptRuntime.getPropAndThis(this.delegee, "throw", cx, scope);
            Object throwResult = throwFn.call(cx, scope, new Object[]{value});
            if (ScriptRuntime.isIteratorDone(cx, throwResult)) {
                try {
                    returnCalled = true;
                    this.callReturnOptionally(cx, scope, Undefined.instance);
                }
                finally {
                    this.delegee = null;
                }
                return this.resumeLocal(cx, scope, ScriptRuntime.getObjectProp(throwResult, "value", cx, scope));
            }
            return ES6Generator.ensureScriptable(throwResult);
        }
        catch (RhinoException re) {
            block12: {
                try {
                    if (returnCalled) break block12;
                    try {
                        this.callReturnOptionally(cx, scope, Undefined.instance);
                    }
                    catch (RhinoException re2) {
                        Scriptable scriptable = this.resumeAbruptLocal(cx, scope, 1, re2);
                        this.delegee = null;
                        return scriptable;
                    }
                }
                finally {
                    this.delegee = null;
                }
            }
            return this.resumeAbruptLocal(cx, scope, 1, re);
        }
    }

    private Scriptable resumeDelegeeReturn(Context cx, Scriptable scope, Object value) {
        try {
            Object retResult = this.callReturnOptionally(cx, scope, value);
            if (retResult != null && !Undefined.isUndefined(retResult)) {
                if (ScriptRuntime.isIteratorDone(cx, retResult)) {
                    this.delegee = null;
                    return this.resumeAbruptLocal(cx, scope, 2, ScriptRuntime.getObjectPropNoWarn(retResult, "value", cx, scope));
                }
                return ES6Generator.ensureScriptable(retResult);
            }
            this.delegee = null;
            return this.resumeAbruptLocal(cx, scope, 2, value);
        }
        catch (RhinoException re) {
            this.delegee = null;
            return this.resumeAbruptLocal(cx, scope, 1, re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Scriptable resumeLocal(Context cx, Scriptable scope, Object value) {
        Scriptable result;
        block27: {
            if (this.state == State.COMPLETED) {
                return ES6Iterator.makeIteratorResult(cx, scope, Boolean.TRUE);
            }
            if (this.state == State.EXECUTING) {
                throw ScriptRuntime.typeErrorById("msg.generator.executing", new Object[0]);
            }
            result = ES6Iterator.makeIteratorResult(cx, scope, Boolean.FALSE);
            this.state = State.EXECUTING;
            try {
                Object r = this.function.resumeGenerator(cx, scope, 0, this.savedState, value);
                if (r instanceof YieldStarResult) {
                    Scriptable delResult;
                    this.state = State.SUSPENDED_YIELD;
                    YieldStarResult ysResult = (YieldStarResult)r;
                    try {
                        this.delegee = ScriptRuntime.callIterator(ysResult.getResult(), cx, scope);
                    }
                    catch (RhinoException re) {
                        Scriptable scriptable = this.resumeAbruptLocal(cx, scope, 1, re);
                        if (this.state == State.COMPLETED) {
                            ScriptableObject.putProperty(result, "done", (Object)Boolean.TRUE);
                        } else {
                            this.state = State.SUSPENDED_YIELD;
                        }
                        return scriptable;
                    }
                    try {
                        delResult = this.resumeDelegee(cx, scope, Undefined.instance);
                    }
                    finally {
                        this.state = State.EXECUTING;
                    }
                    if (ScriptRuntime.isIteratorDone(cx, delResult)) {
                        this.state = State.COMPLETED;
                    }
                    Scriptable scriptable = delResult;
                    return scriptable;
                }
                ScriptableObject.putProperty(result, "value", r);
            }
            catch (NativeGenerator.GeneratorClosedException gce) {
                this.state = State.COMPLETED;
            }
            catch (JavaScriptException jse) {
                this.state = State.COMPLETED;
                if (jse.getValue() instanceof NativeIterator.StopIteration) {
                    ScriptableObject.putProperty(result, "value", ((NativeIterator.StopIteration)jse.getValue()).getValue());
                    break block27;
                }
                this.lineNumber = jse.lineNumber();
                this.lineSource = jse.lineSource();
                if (jse.getValue() instanceof RhinoException) {
                    throw (RhinoException)jse.getValue();
                }
                throw jse;
            }
            catch (RhinoException re) {
                this.lineNumber = re.lineNumber();
                this.lineSource = re.lineSource();
                throw re;
            }
            finally {
                if (this.state == State.COMPLETED) {
                    ScriptableObject.putProperty(result, "done", (Object)Boolean.TRUE);
                } else {
                    this.state = State.SUSPENDED_YIELD;
                }
            }
        }
        return result;
    }

    private Scriptable resumeAbruptLocal(Context cx, Scriptable scope, int op, Object value) {
        Scriptable result;
        block22: {
            if (this.state == State.EXECUTING) {
                throw ScriptRuntime.typeErrorById("msg.generator.executing", new Object[0]);
            }
            if (this.state == State.SUSPENDED_START) {
                this.state = State.COMPLETED;
            }
            result = ES6Iterator.makeIteratorResult(cx, scope, Boolean.FALSE);
            if (this.state == State.COMPLETED) {
                if (op == 1) {
                    throw new JavaScriptException(value, this.lineSource, this.lineNumber);
                }
                ScriptableObject.putProperty(result, "done", (Object)Boolean.TRUE);
                return result;
            }
            this.state = State.EXECUTING;
            Object throwValue = value;
            if (op == 2) {
                if (!(value instanceof NativeGenerator.GeneratorClosedException)) {
                    throwValue = new NativeGenerator.GeneratorClosedException(value);
                }
            } else if (value instanceof JavaScriptException) {
                throwValue = ((JavaScriptException)value).getValue();
            } else if (value instanceof RhinoException) {
                throwValue = ScriptRuntime.wrapException((Throwable)value, scope, cx);
            }
            try {
                Object r = this.function.resumeGenerator(cx, scope, op, this.savedState, throwValue);
                ScriptableObject.putProperty(result, "value", r);
                this.state = State.SUSPENDED_YIELD;
            }
            catch (NativeGenerator.GeneratorClosedException gce) {
                this.state = State.COMPLETED;
                ScriptableObject.putProperty(result, "value", gce.getValue());
            }
            catch (JavaScriptException jse) {
                this.state = State.COMPLETED;
                if (jse.getValue() instanceof NativeIterator.StopIteration) {
                    ScriptableObject.putProperty(result, "value", ((NativeIterator.StopIteration)jse.getValue()).getValue());
                    break block22;
                }
                this.lineNumber = jse.lineNumber();
                this.lineSource = jse.lineSource();
                if (jse.getValue() instanceof RhinoException) {
                    throw (RhinoException)jse.getValue();
                }
                throw jse;
            }
            catch (RhinoException re) {
                this.state = State.COMPLETED;
                this.lineNumber = re.lineNumber();
                this.lineSource = re.lineSource();
                throw re;
            }
            finally {
                if (this.state == State.COMPLETED) {
                    this.delegee = null;
                    ScriptableObject.putProperty(result, "done", (Object)Boolean.TRUE);
                }
            }
        }
        return result;
    }

    private Object callReturnOptionally(Context cx, Scriptable scope, Object value) {
        Object[] objectArray;
        if (Undefined.isUndefined(value)) {
            objectArray = ScriptRuntime.emptyArgs;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = value;
        }
        Object[] retArgs = objectArray;
        Object retFnObj = ScriptRuntime.getObjectPropNoWarn(this.delegee, "return", cx, scope);
        if (retFnObj != null && !Undefined.isUndefined(retFnObj)) {
            if (!(retFnObj instanceof Callable)) {
                throw ScriptRuntime.typeErrorById("msg.isnt.function", "return", ScriptRuntime.typeof(retFnObj));
            }
            return ((Callable)retFnObj).call(cx, scope, ES6Generator.ensureScriptable(this.delegee), retArgs);
        }
        return null;
    }

    public static final class YieldStarResult {
        private Object result;

        public YieldStarResult(Object result) {
            this.result = result;
        }

        Object getResult() {
            return this.result;
        }
    }

    static enum State {
        SUSPENDED_START,
        SUSPENDED_YIELD,
        EXECUTING,
        COMPLETED;

    }
}

