/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.LambdaFunction;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.SymbolKey;
import org.htmlunit.corejs.javascript.Undefined;

public abstract class ES6Iterator
extends ScriptableObject {
    private static final long serialVersionUID = 2438373029140003950L;
    public static final String NEXT_METHOD = "next";
    public static final String DONE_PROPERTY = "done";
    public static final String RETURN_PROPERTY = "return";
    public static final String VALUE_PROPERTY = "value";
    public static final String RETURN_METHOD = "return";
    protected boolean exhausted = false;
    private String tag;

    protected static void init(ScriptableObject scope, boolean sealed, ScriptableObject prototype, String tag) {
        if (scope != null) {
            prototype.setParentScope(scope);
            prototype.setPrototype(ES6Iterator.getObjectPrototype(scope));
        }
        LambdaFunction next = new LambdaFunction(scope, NEXT_METHOD, 0, ES6Iterator::js_next);
        ScriptableObject.defineProperty(prototype, NEXT_METHOD, next, 2);
        LambdaFunction iterator = new LambdaFunction(scope, "[Symbol.iterator]", 1, ES6Iterator::js_iterator);
        prototype.defineProperty(SymbolKey.ITERATOR, (Object)iterator, 2);
        prototype.defineProperty(SymbolKey.TO_STRING_TAG, (Object)prototype.getClassName(), 3);
        if (sealed) {
            prototype.sealObject();
        }
        if (scope != null) {
            scope.associateValue(tag, prototype);
        }
    }

    protected ES6Iterator() {
    }

    protected ES6Iterator(Scriptable scope, String tag) {
        this.tag = tag;
        Scriptable top = ScriptableObject.getTopLevelScope(scope);
        this.setParentScope(top);
        ScriptableObject prototype = (ScriptableObject)ScriptableObject.getTopScopeValue(top, tag);
        this.setPrototype(prototype);
    }

    private static ES6Iterator realThis(Scriptable thisObj) {
        return LambdaConstructor.convertThisObject(thisObj, ES6Iterator.class);
    }

    private static Object js_next(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        ES6Iterator iterator = ES6Iterator.realThis(thisObj);
        return iterator.next(cx, scope);
    }

    private static Object js_iterator(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return thisObj;
    }

    protected abstract boolean isDone(Context var1, Scriptable var2);

    protected abstract Object nextValue(Context var1, Scriptable var2);

    protected Object next(Context cx, Scriptable scope) {
        boolean done;
        Object value = Undefined.instance;
        boolean bl = done = this.isDone(cx, scope) || this.exhausted;
        if (!done) {
            value = this.nextValue(cx, scope);
        } else {
            this.exhausted = true;
        }
        return ES6Iterator.makeIteratorResult(cx, scope, done, value);
    }

    protected String getTag() {
        return this.tag;
    }

    static Scriptable makeIteratorResult(Context cx, Scriptable scope, Boolean done) {
        return ES6Iterator.makeIteratorResult(cx, scope, done, Undefined.instance);
    }

    static Scriptable makeIteratorResult(Context cx, Scriptable scope, Boolean done, Object value) {
        Scriptable iteratorResult = cx.newObject(scope);
        ScriptableObject.putProperty(iteratorResult, VALUE_PROPERTY, value);
        ScriptableObject.putProperty(iteratorResult, DONE_PROPERTY, (Object)done);
        return iteratorResult;
    }
}

