/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.util.ArrayList;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.NativeJavaClass;
import org.htmlunit.corejs.javascript.NativeJavaPackage;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.TopLevel;
import org.htmlunit.corejs.javascript.Undefined;

public class ImporterTopLevel
extends TopLevel {
    private static final long serialVersionUID = -9095380847465315412L;
    private static final String AKEY = "importedPackages";
    private boolean topScopeFlag;

    public ImporterTopLevel() {
    }

    public ImporterTopLevel(Context cx) {
        this(cx, false);
    }

    public ImporterTopLevel(Context cx, boolean sealed) {
        this.initStandardObjects(cx, sealed);
    }

    @Override
    public String getClassName() {
        return this.topScopeFlag ? "global" : "JavaImporter";
    }

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        ImporterTopLevel.init(cx, scope, sealed, false);
    }

    public static void init(Context cx, Scriptable scope, boolean sealed, boolean isTopScope) {
        LambdaConstructor ctor = new LambdaConstructor(scope, "ImporterTopLevel", 0, ImporterTopLevel::js_construct);
        ctor.definePrototypeMethod(scope, "importClass", 1, ImporterTopLevel::js_importClass);
        ctor.definePrototypeMethod(scope, "importPackage", 1, ImporterTopLevel::js_importPackage);
        if (sealed) {
            ctor.sealObject();
        }
        Scriptable proto = (Scriptable)ctor.getPrototypeProperty();
        if (isTopScope) {
            scope.put("importClass", scope, proto.get("importClass", proto));
            scope.put("importPackage", scope, proto.get("importPackage", proto));
        }
        ScriptableObject.defineProperty(scope, "JavaImporter", ctor, 2);
    }

    public void initStandardObjects(Context cx, boolean sealed) {
        cx.initStandardObjects(this, sealed);
        this.topScopeFlag = true;
        ImporterTopLevel.init(cx, this, sealed, true);
        this.delete("constructor");
    }

    @Override
    public boolean has(String name, Scriptable start) {
        return super.has(name, start) || this.getPackageProperty(name, start) != NOT_FOUND;
    }

    @Override
    public Object get(String name, Scriptable start) {
        Object result = super.get(name, start);
        if (result != NOT_FOUND) {
            return result;
        }
        result = this.getPackageProperty(name, start);
        return result;
    }

    private Object getPackageProperty(String name, Scriptable start) {
        Object[] elements;
        Object result = NOT_FOUND;
        Scriptable scope = start;
        if (this.topScopeFlag) {
            scope = ScriptableObject.getTopLevelScope(scope);
        }
        if ((elements = ImporterTopLevel.getNativeJavaPackages(scope)) == null) {
            return result;
        }
        for (Object element : elements) {
            NativeJavaPackage p = (NativeJavaPackage)element;
            Object v = p.getPkgProperty(name, start, false);
            if (v == null || v instanceof NativeJavaPackage) continue;
            if (result == NOT_FOUND) {
                result = v;
                continue;
            }
            throw Context.reportRuntimeErrorById("msg.ambig.import", result.toString(), v.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] getNativeJavaPackages(Scriptable scope) {
        Scriptable scriptable = scope;
        synchronized (scriptable) {
            ScriptableObject so;
            ArrayList importedPackages;
            if (scope instanceof ScriptableObject && (importedPackages = (ArrayList)(so = (ScriptableObject)scope).getAssociatedValue(AKEY)) != null) {
                return importedPackages.toArray();
            }
        }
        return null;
    }

    @Deprecated
    public void importPackage(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ImporterTopLevel.js_importPackage(cx, funObj.getDeclarationScope(), this, args);
    }

    private static Scriptable js_construct(Context cx, Scriptable scope, Object[] args) {
        ImporterTopLevel result = new ImporterTopLevel();
        for (int i = 0; i != args.length; ++i) {
            Object arg = args[i];
            if (arg instanceof NativeJavaClass) {
                ImporterTopLevel.importClass(result, (NativeJavaClass)arg);
                continue;
            }
            if (arg instanceof NativeJavaPackage) {
                ImporterTopLevel.importPackage(result, (NativeJavaPackage)arg);
                continue;
            }
            throw Context.reportRuntimeErrorById("msg.not.class.not.pkg", Context.toString(arg));
        }
        result.setParentScope(scope);
        return result;
    }

    private static Object js_importClass(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        for (int i = 0; i != args.length; ++i) {
            Object arg = args[i];
            if (!(arg instanceof NativeJavaClass)) {
                throw Context.reportRuntimeErrorById("msg.not.class", Context.toString(arg));
            }
            ImporterTopLevel.importClass((ScriptableObject)thisObj, (NativeJavaClass)arg);
        }
        return Undefined.instance;
    }

    private static Object js_importPackage(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        for (int i = 0; i != args.length; ++i) {
            Object arg = args[i];
            if (!(arg instanceof NativeJavaPackage)) {
                throw Context.reportRuntimeErrorById("msg.not.pkg", Context.toString(arg));
            }
            ImporterTopLevel.importPackage((ScriptableObject)thisObj, (NativeJavaPackage)arg);
        }
        return Undefined.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importPackage(ScriptableObject scope, NativeJavaPackage pkg) {
        if (pkg == null) {
            return;
        }
        ScriptableObject scriptableObject = scope;
        synchronized (scriptableObject) {
            ArrayList<NativeJavaPackage> importedPackages = (ArrayList<NativeJavaPackage>)scope.getAssociatedValue(AKEY);
            if (importedPackages == null) {
                importedPackages = new ArrayList<NativeJavaPackage>();
                scope.associateValue(AKEY, importedPackages);
            }
            for (int j = 0; j != importedPackages.size(); ++j) {
                if (!pkg.equals(importedPackages.get(j))) continue;
                return;
            }
            importedPackages.add(pkg);
        }
    }

    private static void importClass(Scriptable scope, NativeJavaClass cl) {
        String s = cl.getClassObject().getName();
        String n = s.substring(s.lastIndexOf(46) + 1);
        Object val = scope.get(n, scope);
        if (val != NOT_FOUND) {
            if (val.equals(cl)) {
                return;
            }
            throw Context.reportRuntimeErrorById("msg.prop.defined", n);
        }
        scope.put(n, scope, (Object)cl);
    }
}

