/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.htmlunit.corejs.classfile.ClassFileWriter;
import org.htmlunit.corejs.javascript.ClassCache;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ContextFactory;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.GeneratedClassLoader;
import org.htmlunit.corejs.javascript.Kit;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.NativeJavaClass;
import org.htmlunit.corejs.javascript.NativeJavaMethod;
import org.htmlunit.corejs.javascript.NativeJavaObject;
import org.htmlunit.corejs.javascript.NativeObject;
import org.htmlunit.corejs.javascript.Script;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.SecurityController;
import org.htmlunit.corejs.javascript.SecurityUtilities;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.corejs.javascript.Wrapper;
import org.htmlunit.corejs.javascript.lc.type.TypeInfo;

public final class JavaAdapter {
    public static void init(Context cx, Scriptable scope, boolean sealed) {
        LambdaConstructor ctor = new LambdaConstructor(scope, "JavaAdapter", 1, JavaAdapter::js_createAdapter);
        if (sealed) {
            ctor.sealObject();
        }
        ScriptableObject.defineProperty(scope, "JavaAdapter", ctor, 2);
    }

    public static Object convertResult(Object result, Class<?> c) {
        if (result == Undefined.instance && c != ScriptRuntime.ObjectClass && c != ScriptRuntime.StringClass) {
            return null;
        }
        return Context.jsToJava(result, c);
    }

    public static Scriptable createAdapterWrapper(Scriptable obj, Object adapter) {
        Scriptable scope = ScriptableObject.getTopLevelScope(obj);
        NativeJavaObject res = new NativeJavaObject(scope, adapter, TypeInfo.NONE, true);
        res.setPrototype(obj);
        return res;
    }

    public static Object getAdapterSelf(Class<?> adapterClass, Object adapter) throws NoSuchFieldException, IllegalAccessException {
        Field self = adapterClass.getDeclaredField("self");
        return self.get(adapter);
    }

    static Scriptable js_createAdapter(Context cx, Scriptable scope, Object[] args) {
        int N = args.length;
        if (N == 0) {
            throw ScriptRuntime.typeErrorById("msg.adapter.zero.args", new Object[0]);
        }
        JavaAdapterSignature sig = new JavaAdapterSignature();
        int classCount = JavaAdapter.fillAdapterInheritanceData(args, sig);
        Scriptable obj = ScriptableObject.ensureScriptable(args[classCount]);
        sig.names = JavaAdapter.getObjectFunctionNames(obj);
        Class<?> adapterClass = JavaAdapter.getAdapterClass(scope, sig);
        int argsCount = N - classCount - 1;
        try {
            Object unwrapped;
            Object adapter;
            if (argsCount > 0) {
                Object[] ctorArgs = new Object[argsCount + 2];
                ctorArgs[0] = obj;
                ctorArgs[1] = cx.getFactory();
                System.arraycopy(args, classCount + 1, ctorArgs, 2, argsCount);
                NativeJavaClass classWrapper = new NativeJavaClass(scope, adapterClass, true);
                NativeJavaMethod ctors = classWrapper.members.ctors;
                int index = ctors.findCachedFunction(cx, ctorArgs);
                if (index < 0) {
                    throw Context.reportRuntimeErrorById("msg.no.java.ctor", adapterClass.getName(), NativeJavaMethod.scriptSignature(args));
                }
                adapter = NativeJavaClass.constructInternal(ctorArgs, ctors.methods[index]);
            } else {
                Class[] ctorParms = new Class[]{ScriptRuntime.ScriptableClass, ScriptRuntime.ContextFactoryClass};
                Object[] ctorArgs = new Object[]{obj, cx.getFactory()};
                adapter = adapterClass.getConstructor(ctorParms).newInstance(ctorArgs);
            }
            Scriptable self = (Scriptable)JavaAdapter.getAdapterSelf(adapterClass, adapter);
            if (self instanceof Wrapper && (unwrapped = ((Wrapper)((Object)self)).unwrap()) instanceof Scriptable) {
                if (unwrapped instanceof ScriptableObject) {
                    ScriptRuntime.setObjectProtoAndParent((ScriptableObject)unwrapped, scope);
                }
                return (Scriptable)unwrapped;
            }
            return self;
        }
        catch (Exception ex) {
            throw Context.throwAsScriptRuntimeEx(ex);
        }
    }

    private static int fillAdapterInheritanceData(Object[] args, JavaAdapterSignature signature) {
        Object arg;
        int classCount;
        int len = args.length;
        for (classCount = 0; classCount < len - 1 && !((arg = args[classCount]) instanceof NativeObject); ++classCount) {
            if (arg instanceof NativeJavaClass) continue;
            throw ScriptRuntime.typeErrorById("msg.not.java.class.arg", String.valueOf(classCount), ScriptRuntime.toString(arg));
        }
        Class<?> superClass = null;
        Class[] interfaces = new Class[classCount];
        int interfaceCount = 0;
        for (int i = 0; i < classCount; ++i) {
            Class<?> c = ((NativeJavaClass)args[i]).getClassObject();
            if (c.isInterface()) {
                interfaces[interfaceCount++] = c;
                continue;
            }
            if (superClass != null) {
                throw ScriptRuntime.typeErrorById("msg.only.one.super", superClass.getName(), c.getName());
            }
            superClass = c;
        }
        signature.superClass = superClass == null ? Object.class : superClass;
        signature.interfaces = interfaceCount == interfaces.length ? interfaces : Arrays.copyOf(interfaces, interfaceCount);
        return classCount;
    }

    public static void writeAdapterObject(Object javaObject, ObjectOutputStream out) throws IOException {
        Class<?> cl = javaObject.getClass();
        out.writeObject(cl.getSuperclass().getName());
        Class<?>[] interfaces = cl.getInterfaces();
        String[] interfaceNames = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceNames[i] = interfaces[i].getName();
        }
        out.writeObject(interfaceNames);
        try {
            Object delegee = cl.getField("delegee").get(javaObject);
            out.writeObject(delegee);
            return;
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            throw new IOException();
        }
    }

    public static Object readAdapterObject(Scriptable self, ObjectInputStream in) throws IOException, ClassNotFoundException {
        Context cx = Context.getCurrentContext();
        ContextFactory factory = cx != null ? cx.getFactory() : null;
        JavaAdapterSignature sig = new JavaAdapterSignature();
        sig.superClass = Class.forName((String)in.readObject());
        String[] interfaceNames = (String[])in.readObject();
        sig.interfaces = new Class[interfaceNames.length];
        for (int i = 0; i < interfaceNames.length; ++i) {
            sig.interfaces[i] = Class.forName(interfaceNames[i]);
        }
        Scriptable delegee = (Scriptable)in.readObject();
        sig.names = JavaAdapter.getObjectFunctionNames(delegee);
        Class<?> adapterClass = JavaAdapter.getAdapterClass(self, sig);
        Class[] ctorParms = new Class[]{ScriptRuntime.ContextFactoryClass, ScriptRuntime.ScriptableClass, ScriptRuntime.ScriptableClass};
        Object[] ctorArgs = new Object[]{factory, delegee, self};
        try {
            return adapterClass.getConstructor(ctorParms).newInstance(ctorArgs);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new ClassNotFoundException("adapter");
        }
    }

    private static Map<String, Integer> getObjectFunctionNames(Scriptable obj) {
        Object[] ids = ScriptableObject.getPropertyIds(obj);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i != ids.length; ++i) {
            String id;
            Object value;
            if (!(ids[i] instanceof String) || !((value = ScriptableObject.getProperty(obj, id = (String)ids[i])) instanceof Function)) continue;
            Function f = (Function)value;
            int length = ScriptRuntime.toInt32(ScriptableObject.getProperty((Scriptable)f, "length"));
            if (length < 0) {
                length = 0;
            }
            map.put(id, length);
        }
        return map;
    }

    private static Class<?> getAdapterClass(Scriptable scope, JavaAdapterSignature sig) {
        ClassCache cache = ClassCache.get(scope);
        Map<JavaAdapterSignature, Class<?>> generated = cache.getInterfaceAdapterCacheMap();
        Class<?> adapterClass = generated.get(sig);
        if (adapterClass == null) {
            String adapterName = "adapter" + cache.newClassSerialNumber();
            byte[] code = JavaAdapter.createAdapterCode(sig.names, adapterName, sig.superClass, sig.interfaces, null);
            adapterClass = JavaAdapter.loadAdapterClass(adapterName, code);
            if (cache.isCachingEnabled()) {
                generated.put(sig, adapterClass);
            }
        }
        return adapterClass;
    }

    public static byte[] createAdapterCode(Map<String, Integer> functionNames, String adapterName, Class<?> superClass, Class<?>[] interfaces, String scriptClassName) {
        String methodKey;
        String methodSignature;
        Class<?>[] argTypes;
        String methodName;
        Constructor<?>[] ctors;
        ClassFileWriter cfw = new ClassFileWriter(adapterName, superClass.getName(), "<adapter>");
        cfw.addField("factory", "Lorg/htmlunit/corejs/javascript/ContextFactory;", (short)17);
        cfw.addField("delegee", "Lorg/htmlunit/corejs/javascript/Scriptable;", (short)17);
        cfw.addField("self", "Lorg/htmlunit/corejs/javascript/Scriptable;", (short)17);
        int interfacesCount = interfaces == null ? 0 : interfaces.length;
        for (int i = 0; i < interfacesCount; ++i) {
            if (interfaces[i] == null) continue;
            cfw.addInterface(interfaces[i].getName());
        }
        String superName = superClass.getName().replace('.', '/');
        for (Constructor<?> ctor : ctors = superClass.getDeclaredConstructors()) {
            int n = ctor.getModifiers();
            if (!Modifier.isPublic(n) && !Modifier.isProtected(n)) continue;
            JavaAdapter.generateCtor(cfw, adapterName, superName, ctor);
        }
        JavaAdapter.generateSerialCtor(cfw, adapterName, superName);
        if (scriptClassName != null) {
            JavaAdapter.generateEmptyCtor(cfw, adapterName, superName, scriptClassName);
        }
        HashMap<String, Integer> generatedOverrides = new HashMap<String, Integer>();
        HashMap<String, Integer> generatedMethods = new HashMap<String, Integer>();
        for (int i = 0; i < interfacesCount; ++i) {
            Method[] methods;
            Method[] methodArray = methods = interfaces[i].getMethods();
            int n = methodArray.length;
            for (int j = 0; j < n; ++j) {
                Method method = methodArray[j];
                int mods = method.getModifiers();
                if (Modifier.isStatic(mods) || Modifier.isFinal(mods) || method.isDefault()) continue;
                methodName = method.getName();
                argTypes = method.getParameterTypes();
                if (!functionNames.containsKey(methodName)) {
                    try {
                        superClass.getMethod(methodName, argTypes);
                        continue;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                methodSignature = JavaAdapter.getMethodSignature(method, argTypes);
                methodKey = methodName + methodSignature;
                if (generatedOverrides.containsKey(methodKey)) continue;
                JavaAdapter.generateMethod(cfw, adapterName, methodName, argTypes, method.getReturnType(), true);
                generatedOverrides.put(methodKey, 0);
                generatedMethods.put(methodName, 0);
            }
        }
        Method[] methods = JavaAdapter.getOverridableMethods(superClass);
        for (Method method : methods) {
            int mods = method.getModifiers();
            boolean isAbstractMethod = Modifier.isAbstract(mods);
            methodName = method.getName();
            if (!isAbstractMethod && !functionNames.containsKey(methodName)) continue;
            argTypes = method.getParameterTypes();
            methodSignature = JavaAdapter.getMethodSignature(method, argTypes);
            methodKey = methodName + methodSignature;
            if (generatedOverrides.containsKey(methodKey)) continue;
            JavaAdapter.generateMethod(cfw, adapterName, methodName, argTypes, method.getReturnType(), true);
            generatedOverrides.put(methodKey, 0);
            generatedMethods.put(methodName, 0);
            if (isAbstractMethod) continue;
            JavaAdapter.generateSuper(cfw, adapterName, superName, methodName, methodSignature, argTypes, method.getReturnType());
        }
        for (Map.Entry entry : functionNames.entrySet()) {
            String functionName = (String)entry.getKey();
            if (generatedMethods.containsKey(functionName)) continue;
            int length = (Integer)entry.getValue();
            Class[] parms = new Class[length];
            for (int k = 0; k < length; ++k) {
                parms[k] = ScriptRuntime.ObjectClass;
            }
            JavaAdapter.generateMethod(cfw, adapterName, functionName, parms, ScriptRuntime.ObjectClass, false);
        }
        return cfw.toByteArray();
    }

    static Method[] getOverridableMethods(Class<?> clazz) {
        Class<?> c;
        ArrayList<Method> list = new ArrayList<Method>();
        HashSet<String> skip = new HashSet<String>();
        for (c = clazz; c != null; c = c.getSuperclass()) {
            JavaAdapter.appendOverridableMethods(c, list, skip);
        }
        for (c = clazz; c != null; c = c.getSuperclass()) {
            for (Class<?> intf : c.getInterfaces()) {
                JavaAdapter.appendOverridableMethods(intf, list, skip);
            }
        }
        return list.toArray(new Method[0]);
    }

    private static void appendOverridableMethods(Class<?> c, List<Method> list, Set<String> skip) {
        Method[] methods;
        for (Method method : methods = c.isInterface() ? c.getMethods() : c.getDeclaredMethods()) {
            int mods;
            String methodKey = method.getName() + JavaAdapter.getMethodSignature(method, method.getParameterTypes());
            if (skip.contains(methodKey) || Modifier.isStatic(mods = method.getModifiers())) continue;
            if (Modifier.isFinal(mods)) {
                skip.add(methodKey);
                continue;
            }
            if (!Modifier.isPublic(mods) && !Modifier.isProtected(mods)) continue;
            list.add(method);
            skip.add(methodKey);
        }
    }

    static Class<?> loadAdapterClass(String className, byte[] classBytes) {
        Object staticDomain;
        Class<?> domainClass = SecurityController.getStaticSecurityDomainClass();
        if (domainClass == CodeSource.class || domainClass == ProtectionDomain.class) {
            ProtectionDomain protectionDomain = SecurityUtilities.getScriptProtectionDomain();
            if (protectionDomain == null) {
                protectionDomain = JavaAdapter.class.getProtectionDomain();
            }
            staticDomain = domainClass == CodeSource.class ? (protectionDomain == null ? null : protectionDomain.getCodeSource()) : protectionDomain;
        } else {
            staticDomain = null;
        }
        GeneratedClassLoader loader = SecurityController.createLoader(null, staticDomain);
        Class<?> result = loader.defineClass(className, classBytes);
        loader.linkClass(result);
        return result;
    }

    public static Function getFunction(Scriptable obj, String functionName) {
        Object x = ScriptableObject.getProperty(obj, functionName);
        if (x == Scriptable.NOT_FOUND) {
            return null;
        }
        if (!(x instanceof Function)) {
            throw ScriptRuntime.notFunctionError(x, functionName);
        }
        return (Function)x;
    }

    public static Object callMethod(ContextFactory factory, Scriptable thisObj, Function f, Object[] args, long argsToWrap) {
        if (f == null) {
            return null;
        }
        if (factory == null) {
            factory = ContextFactory.getGlobal();
        }
        Scriptable scope = f.getDeclarationScope();
        if (argsToWrap == 0L) {
            return Context.call(factory, f, scope, thisObj, args);
        }
        Context cx = Context.getCurrentContext();
        if (cx != null) {
            return JavaAdapter.doCall(cx, scope, thisObj, f, args, argsToWrap);
        }
        return factory.call(cx2 -> JavaAdapter.doCall(cx2, scope, thisObj, f, args, argsToWrap));
    }

    private static Object doCall(Context cx, Scriptable scope, Scriptable thisObj, Function f, Object[] args, long argsToWrap) {
        for (int i = 0; i != args.length; ++i) {
            Object arg;
            if (0L == (argsToWrap & (long)(1 << i)) || (arg = args[i]) instanceof Scriptable) continue;
            args[i] = cx.getWrapFactory().wrap(cx, scope, arg, TypeInfo.NONE);
        }
        return f.call(cx, scope, thisObj, args);
    }

    public static Scriptable runScript(Script script) {
        return ContextFactory.getGlobal().call(cx -> {
            ScriptableObject global = ScriptRuntime.getGlobal(cx);
            script.exec(cx, global, global);
            return global;
        });
    }

    private static void generateCtor(ClassFileWriter cfw, String adapterName, String superName, Constructor<?> superCtor) {
        int locals = 3;
        Class<?>[] parameters = superCtor.getParameterTypes();
        if (parameters.length == 0) {
            cfw.startMethod("<init>", "(Lorg/htmlunit/corejs/javascript/Scriptable;Lorg/htmlunit/corejs/javascript/ContextFactory;)V", (short)1);
            cfw.add(42);
            cfw.addInvoke(183, superName, "<init>", "()V");
        } else {
            StringBuilder sig = new StringBuilder("(Lorg/htmlunit/corejs/javascript/Scriptable;Lorg/htmlunit/corejs/javascript/ContextFactory;");
            int marker = sig.length();
            for (Class<?> c : parameters) {
                JavaAdapter.appendTypeString(sig, c);
            }
            sig.append(")V");
            cfw.startMethod("<init>", sig.toString(), (short)1);
            cfw.add(42);
            int paramOffset = 3;
            for (Class<?> parameter : parameters) {
                paramOffset += JavaAdapter.generatePushParam(cfw, paramOffset, parameter);
            }
            locals = paramOffset;
            sig.delete(1, marker);
            cfw.addInvoke(183, superName, "<init>", sig.toString());
        }
        cfw.add(42);
        cfw.add(43);
        cfw.add(181, adapterName, "delegee", "Lorg/htmlunit/corejs/javascript/Scriptable;");
        cfw.add(42);
        cfw.add(44);
        cfw.add(181, adapterName, "factory", "Lorg/htmlunit/corejs/javascript/ContextFactory;");
        cfw.add(42);
        cfw.add(43);
        cfw.add(42);
        cfw.addInvoke(184, "org/htmlunit/corejs/javascript/JavaAdapter", "createAdapterWrapper", "(Lorg/htmlunit/corejs/javascript/Scriptable;Ljava/lang/Object;)Lorg/htmlunit/corejs/javascript/Scriptable;");
        cfw.add(181, adapterName, "self", "Lorg/htmlunit/corejs/javascript/Scriptable;");
        cfw.add(177);
        cfw.stopMethod(locals);
    }

    private static void generateSerialCtor(ClassFileWriter cfw, String adapterName, String superName) {
        cfw.startMethod("<init>", "(Lorg/htmlunit/corejs/javascript/ContextFactory;Lorg/htmlunit/corejs/javascript/Scriptable;Lorg/htmlunit/corejs/javascript/Scriptable;)V", (short)1);
        cfw.add(42);
        cfw.addInvoke(183, superName, "<init>", "()V");
        cfw.add(42);
        cfw.add(43);
        cfw.add(181, adapterName, "factory", "Lorg/htmlunit/corejs/javascript/ContextFactory;");
        cfw.add(42);
        cfw.add(44);
        cfw.add(181, adapterName, "delegee", "Lorg/htmlunit/corejs/javascript/Scriptable;");
        cfw.add(42);
        cfw.add(45);
        cfw.add(181, adapterName, "self", "Lorg/htmlunit/corejs/javascript/Scriptable;");
        cfw.add(177);
        cfw.stopMethod(4);
    }

    private static void generateEmptyCtor(ClassFileWriter cfw, String adapterName, String superName, String scriptClassName) {
        cfw.startMethod("<init>", "()V", (short)1);
        cfw.add(42);
        cfw.addInvoke(183, superName, "<init>", "()V");
        cfw.add(42);
        cfw.add(1);
        cfw.add(181, adapterName, "factory", "Lorg/htmlunit/corejs/javascript/ContextFactory;");
        cfw.add(187, scriptClassName);
        cfw.add(89);
        cfw.addInvoke(183, scriptClassName, "<init>", "()V");
        cfw.addInvoke(184, "org/htmlunit/corejs/javascript/JavaAdapter", "runScript", "(Lorg/htmlunit/corejs/javascript/Script;)Lorg/htmlunit/corejs/javascript/Scriptable;");
        cfw.add(76);
        cfw.add(42);
        cfw.add(43);
        cfw.add(181, adapterName, "delegee", "Lorg/htmlunit/corejs/javascript/Scriptable;");
        cfw.add(42);
        cfw.add(43);
        cfw.add(42);
        cfw.addInvoke(184, "org/htmlunit/corejs/javascript/JavaAdapter", "createAdapterWrapper", "(Lorg/htmlunit/corejs/javascript/Scriptable;Ljava/lang/Object;)Lorg/htmlunit/corejs/javascript/Scriptable;");
        cfw.add(181, adapterName, "self", "Lorg/htmlunit/corejs/javascript/Scriptable;");
        cfw.add(177);
        cfw.stopMethod(2);
    }

    static void generatePushWrappedArgs(ClassFileWriter cfw, Class<?>[] argTypes, int arrayLength) {
        cfw.addPush(arrayLength);
        cfw.add(189, "java/lang/Object");
        int paramOffset = 1;
        for (int i = 0; i != argTypes.length; ++i) {
            cfw.add(89);
            cfw.addPush(i);
            paramOffset += JavaAdapter.generateWrapArg(cfw, paramOffset, argTypes[i]);
            cfw.add(83);
        }
    }

    private static int generateWrapArg(ClassFileWriter cfw, int paramOffset, Class<?> argType) {
        int size = 1;
        if (!argType.isPrimitive()) {
            cfw.add(25, paramOffset);
        } else if (argType == Boolean.TYPE) {
            cfw.add(187, "java/lang/Boolean");
            cfw.add(89);
            cfw.add(21, paramOffset);
            cfw.addInvoke(183, "java/lang/Boolean", "<init>", "(Z)V");
        } else if (argType == Character.TYPE) {
            cfw.add(21, paramOffset);
            cfw.addInvoke(184, "java/lang/String", "valueOf", "(C)Ljava/lang/String;");
        } else {
            cfw.add(187, "java/lang/Double");
            cfw.add(89);
            String typeName = argType.getName();
            switch (typeName.charAt(0)) {
                case 'b': 
                case 'i': 
                case 's': {
                    cfw.add(21, paramOffset);
                    cfw.add(135);
                    break;
                }
                case 'l': {
                    cfw.add(22, paramOffset);
                    cfw.add(138);
                    size = 2;
                    break;
                }
                case 'f': {
                    cfw.add(23, paramOffset);
                    cfw.add(141);
                    break;
                }
                case 'd': {
                    cfw.add(24, paramOffset);
                    size = 2;
                }
            }
            cfw.addInvoke(183, "java/lang/Double", "<init>", "(D)V");
        }
        return size;
    }

    static void generateReturnResult(ClassFileWriter cfw, Class<?> retType, boolean callConvertResult) {
        if (retType == Void.TYPE) {
            cfw.add(87);
            cfw.add(177);
        } else if (retType == Boolean.TYPE) {
            cfw.addInvoke(184, "org/htmlunit/corejs/javascript/Context", "toBoolean", "(Ljava/lang/Object;)Z");
            cfw.add(172);
        } else if (retType == Character.TYPE) {
            cfw.addInvoke(184, "org/htmlunit/corejs/javascript/Context", "toString", "(Ljava/lang/Object;)Ljava/lang/String;");
            cfw.add(3);
            cfw.addInvoke(182, "java/lang/String", "charAt", "(I)C");
            cfw.add(172);
        } else if (retType.isPrimitive()) {
            cfw.addInvoke(184, "org/htmlunit/corejs/javascript/Context", "toNumber", "(Ljava/lang/Object;)D");
            String typeName = retType.getName();
            switch (typeName.charAt(0)) {
                case 'b': 
                case 'i': 
                case 's': {
                    cfw.add(142);
                    cfw.add(172);
                    break;
                }
                case 'l': {
                    cfw.add(143);
                    cfw.add(173);
                    break;
                }
                case 'f': {
                    cfw.add(144);
                    cfw.add(174);
                    break;
                }
                case 'd': {
                    cfw.add(175);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected return type " + retType);
                }
            }
        } else {
            String retTypeStr = retType.getName();
            if (callConvertResult) {
                cfw.addLoadConstant(retTypeStr);
                cfw.addInvoke(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
                cfw.addInvoke(184, "org/htmlunit/corejs/javascript/JavaAdapter", "convertResult", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;");
            }
            cfw.add(192, retTypeStr);
            cfw.add(176);
        }
    }

    private static void generateMethod(ClassFileWriter cfw, String genName, String methodName, Class<?>[] parms, Class<?> returnType, boolean convertResult) {
        StringBuilder sb = new StringBuilder();
        int paramsEnd = JavaAdapter.appendMethodSignature(parms, returnType, sb);
        String methodSignature = sb.toString();
        cfw.startMethod(methodName, methodSignature, (short)1);
        cfw.add(42);
        cfw.add(180, genName, "factory", "Lorg/htmlunit/corejs/javascript/ContextFactory;");
        cfw.add(42);
        cfw.add(180, genName, "self", "Lorg/htmlunit/corejs/javascript/Scriptable;");
        cfw.add(42);
        cfw.add(180, genName, "delegee", "Lorg/htmlunit/corejs/javascript/Scriptable;");
        cfw.addPush(methodName);
        cfw.addInvoke(184, "org/htmlunit/corejs/javascript/JavaAdapter", "getFunction", "(Lorg/htmlunit/corejs/javascript/Scriptable;Ljava/lang/String;)Lorg/htmlunit/corejs/javascript/Function;");
        JavaAdapter.generatePushWrappedArgs(cfw, parms, parms.length);
        if (parms.length > 64) {
            throw Context.reportRuntimeErrorById("JavaAdapter can not subclass methods with more then 64 arguments.", new Object[0]);
        }
        long conversionMask = 0L;
        for (int i = 0; i != parms.length; ++i) {
            if (parms[i].isPrimitive()) continue;
            conversionMask |= (long)(1 << i);
        }
        cfw.addPush(conversionMask);
        cfw.addInvoke(184, "org/htmlunit/corejs/javascript/JavaAdapter", "callMethod", "(Lorg/htmlunit/corejs/javascript/ContextFactory;Lorg/htmlunit/corejs/javascript/Scriptable;Lorg/htmlunit/corejs/javascript/Function;[Ljava/lang/Object;J)Ljava/lang/Object;");
        JavaAdapter.generateReturnResult(cfw, returnType, convertResult);
        cfw.stopMethod((short)paramsEnd);
    }

    private static int generatePushParam(ClassFileWriter cfw, int paramOffset, Class<?> paramType) {
        if (!paramType.isPrimitive()) {
            cfw.addALoad(paramOffset);
            return 1;
        }
        String typeName = paramType.getName();
        switch (typeName.charAt(0)) {
            case 'b': 
            case 'c': 
            case 'i': 
            case 's': 
            case 'z': {
                cfw.addILoad(paramOffset);
                return 1;
            }
            case 'l': {
                cfw.addLLoad(paramOffset);
                return 2;
            }
            case 'f': {
                cfw.addFLoad(paramOffset);
                return 1;
            }
            case 'd': {
                cfw.addDLoad(paramOffset);
                return 2;
            }
        }
        throw Kit.codeBug();
    }

    private static void generatePopResult(ClassFileWriter cfw, Class<?> retType) {
        if (retType.isPrimitive()) {
            String typeName = retType.getName();
            switch (typeName.charAt(0)) {
                case 'b': 
                case 'c': 
                case 'i': 
                case 's': 
                case 'z': {
                    cfw.add(172);
                    break;
                }
                case 'l': {
                    cfw.add(173);
                    break;
                }
                case 'f': {
                    cfw.add(174);
                    break;
                }
                case 'd': {
                    cfw.add(175);
                }
            }
        } else {
            cfw.add(176);
        }
    }

    private static void generateSuper(ClassFileWriter cfw, String genName, String superName, String methodName, String methodSignature, Class<?>[] parms, Class<?> returnType) {
        cfw.startMethod("super$" + methodName, methodSignature, (short)1);
        cfw.add(25, 0);
        int paramOffset = 1;
        for (Class<?> parm : parms) {
            paramOffset += JavaAdapter.generatePushParam(cfw, paramOffset, parm);
        }
        cfw.addInvoke(183, superName, methodName, methodSignature);
        if (!returnType.equals(Void.TYPE)) {
            JavaAdapter.generatePopResult(cfw, returnType);
        } else {
            cfw.add(177);
        }
        cfw.stopMethod((short)(paramOffset + 1));
    }

    private static String getMethodSignature(Method method, Class<?>[] argTypes) {
        StringBuilder sb = new StringBuilder();
        JavaAdapter.appendMethodSignature(argTypes, method.getReturnType(), sb);
        return sb.toString();
    }

    static int appendMethodSignature(Class<?>[] argTypes, Class<?> returnType, StringBuilder sb) {
        sb.append('(');
        int firstLocal = 1 + argTypes.length;
        for (Class<?> type : argTypes) {
            JavaAdapter.appendTypeString(sb, type);
            if (type != Long.TYPE && type != Double.TYPE) continue;
            ++firstLocal;
        }
        sb.append(')');
        JavaAdapter.appendTypeString(sb, returnType);
        return firstLocal;
    }

    private static StringBuilder appendTypeString(StringBuilder sb, Class<?> type) {
        while (type.isArray()) {
            sb.append('[');
            type = type.getComponentType();
        }
        if (type.isPrimitive()) {
            char typeLetter;
            if (type == Boolean.TYPE) {
                typeLetter = 'Z';
            } else if (type == Long.TYPE) {
                typeLetter = 'J';
            } else {
                String typeName = type.getName();
                typeLetter = Character.toUpperCase(typeName.charAt(0));
            }
            sb.append(typeLetter);
        } else {
            sb.append('L');
            sb.append(type.getName().replace('.', '/'));
            sb.append(';');
        }
        return sb;
    }

    static int[] getArgsToConvert(Class<?>[] argTypes) {
        int count = 0;
        for (int i = 0; i != argTypes.length; ++i) {
            if (argTypes[i].isPrimitive()) continue;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        int[] array = new int[count];
        count = 0;
        for (int i = 0; i != argTypes.length; ++i) {
            if (argTypes[i].isPrimitive()) continue;
            array[count++] = i;
        }
        return array;
    }

    static class JavaAdapterSignature {
        Class<?> superClass;
        Class<?>[] interfaces;
        Map<String, Integer> names;

        JavaAdapterSignature() {
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof JavaAdapterSignature)) {
                return false;
            }
            JavaAdapterSignature sig = (JavaAdapterSignature)obj;
            return this.superClass == sig.superClass && Arrays.equals(this.interfaces, sig.interfaces) && this.names.equals(sig.names);
        }

        public int hashCode() {
            return this.superClass.hashCode() * 31 + Arrays.hashCode(this.interfaces) ^ this.names.size();
        }
    }
}

