/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.util.Iterator;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ES6Generator;
import org.htmlunit.corejs.javascript.JavaScriptException;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.NativeObject;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.corejs.javascript.Wrapper;

public final class NativeIterator
extends ScriptableObject {
    private static final long serialVersionUID = -4136968203581667681L;
    private static final Object ITERATOR_TAG = "Iterator";
    private static final String CLASS_NAME = "Iterator";
    private Object objectIterator;
    private static final String STOP_ITERATION = "StopIteration";
    public static final String ITERATOR_PROPERTY_NAME = "__iterator__";

    static void init(Context cx, ScriptableObject scope, boolean sealed) {
        LambdaConstructor constructor = new LambdaConstructor((Scriptable)scope, CLASS_NAME, 2, NativeIterator::jsConstructorCall, NativeIterator::jsConstructor);
        constructor.setPrototypePropertyAttributes(7);
        NativeIterator proto = new NativeIterator();
        constructor.setPrototypeScriptable(proto);
        constructor.definePrototypeMethod((Scriptable)scope, "next", 0, NativeIterator::js_next);
        constructor.definePrototypeMethod((Scriptable)scope, ITERATOR_PROPERTY_NAME, 1, NativeIterator::js_iteratorMethod);
        ScriptableObject.defineProperty(scope, CLASS_NAME, constructor, 2);
        if (sealed) {
            constructor.sealObject();
            ((ScriptableObject)constructor.getPrototypeProperty()).sealObject();
        }
        ES6Generator.init(scope, sealed);
        StopIteration obj = new StopIteration();
        obj.setPrototype(NativeIterator.getObjectPrototype(scope));
        obj.setParentScope(scope);
        if (sealed) {
            obj.sealObject();
        }
        ScriptableObject.defineProperty(scope, STOP_ITERATION, obj, 2);
        scope.associateValue(ITERATOR_TAG, obj);
    }

    private NativeIterator() {
    }

    private NativeIterator(Object objectIterator) {
        this.objectIterator = objectIterator;
    }

    public static Object getStopIterationObject(Scriptable scope) {
        Scriptable top = ScriptableObject.getTopLevelScope(scope);
        return ScriptableObject.getTopScopeValue(top, ITERATOR_TAG);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    private static Object jsConstructorCall(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Scriptable target = NativeIterator.requireIteratorTarget(cx, scope, args);
        boolean keyOnly = NativeIterator.isKeyOnly(args);
        Iterator<?> iterator = NativeIterator.getJavaIterator(target);
        if (iterator != null) {
            Scriptable topScope = ScriptableObject.getTopLevelScope(scope);
            return cx.getWrapFactory().wrap(cx, topScope, (Object)new WrappedJavaIterator(iterator, topScope), WrappedJavaIterator.class);
        }
        Scriptable jsIterator = ScriptRuntime.toIterator(cx, target, keyOnly);
        if (jsIterator != null) {
            return jsIterator;
        }
        return NativeIterator.createNativeIterator(cx, scope, target, keyOnly);
    }

    private static Scriptable jsConstructor(Context cx, Scriptable scope, Object[] args) {
        Scriptable target = NativeIterator.requireIteratorTarget(cx, scope, args);
        boolean keyOnly = NativeIterator.isKeyOnly(args);
        return NativeIterator.createNativeIterator(cx, scope, target, keyOnly);
    }

    private static Scriptable requireIteratorTarget(Context cx, Scriptable scope, Object[] args) {
        if (args.length == 0 || args[0] == null || args[0] == Undefined.instance) {
            Object argument = args.length == 0 ? Undefined.instance : args[0];
            throw ScriptRuntime.typeErrorById("msg.no.properties", ScriptRuntime.toString(argument));
        }
        return ScriptRuntime.toObject(cx, scope, args[0]);
    }

    private static boolean isKeyOnly(Object[] args) {
        return args.length > 1 && ScriptRuntime.toBoolean(args[1]);
    }

    private static Object js_next(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        NativeIterator iterator = NativeIterator.realThis(thisObj);
        return iterator.next(cx, scope);
    }

    private static NativeIterator createNativeIterator(Context cx, Scriptable scope, Scriptable obj, boolean keyOnly) {
        Object objectIterator = ScriptRuntime.enumInit(obj, cx, scope, keyOnly ? 3 : 5);
        ScriptRuntime.setEnumNumbers(objectIterator, true);
        NativeIterator result = new NativeIterator(objectIterator);
        result.setPrototype(ScriptableObject.getClassPrototype(scope, CLASS_NAME));
        result.setParentScope(scope);
        return result;
    }

    private static Object js_iteratorMethod(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeIterator.realThis(thisObj);
    }

    private static NativeIterator realThis(Scriptable thisObj) {
        return LambdaConstructor.convertThisObject(thisObj, NativeIterator.class);
    }

    private Object next(Context cx, Scriptable scope) {
        Boolean b = ScriptRuntime.enumNext(this.objectIterator, cx);
        if (!b.booleanValue()) {
            throw new JavaScriptException(NativeIterator.getStopIterationObject(scope), null, 0);
        }
        return ScriptRuntime.enumId(this.objectIterator, cx);
    }

    private static Iterator<?> getJavaIterator(Object obj) {
        if (obj instanceof Wrapper) {
            Object unwrapped = ((Wrapper)obj).unwrap();
            Iterator iterator = null;
            if (unwrapped instanceof Iterator) {
                iterator = (Iterator)unwrapped;
            }
            if (unwrapped instanceof Iterable) {
                iterator = ((Iterable)unwrapped).iterator();
            }
            return iterator;
        }
        return null;
    }

    public static class WrappedJavaIterator {
        private final Iterator<?> iterator;
        private final Scriptable scope;

        WrappedJavaIterator(Iterator<?> iterator, Scriptable scope) {
            this.iterator = iterator;
            this.scope = scope;
        }

        public Object next() {
            if (!this.iterator.hasNext()) {
                throw new JavaScriptException(NativeIterator.getStopIterationObject(this.scope), null, 0);
            }
            return this.iterator.next();
        }

        public Object __iterator__(boolean b) {
            return this;
        }
    }

    public static class StopIteration
    extends NativeObject {
        private static final long serialVersionUID = 2485151085722377663L;
        private Object value = Undefined.instance;

        public StopIteration() {
        }

        public StopIteration(Object val) {
            this.value = val;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public String getClassName() {
            return NativeIterator.STOP_ITERATION;
        }

        @Override
        public boolean hasInstance(Scriptable instance) {
            return instance instanceof StopIteration;
        }
    }
}

