/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.lang.reflect.Array;
import java.util.Objects;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.NativeJavaObject;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.Symbol;
import org.htmlunit.corejs.javascript.SymbolKey;
import org.htmlunit.corejs.javascript.SymbolScriptable;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.corejs.javascript.Wrapper;
import org.htmlunit.corejs.javascript.lc.type.TypeInfo;
import org.htmlunit.corejs.javascript.lc.type.TypeInfoFactory;

public class NativeJavaArray
extends NativeJavaObject
implements SymbolScriptable {
    private static final long serialVersionUID = -924022554283675333L;
    Object array;
    int length;
    TypeInfo componentType;

    @Override
    public String getClassName() {
        return "JavaArray";
    }

    @Deprecated
    public static NativeJavaArray wrap(Scriptable scope, Object array) {
        return new NativeJavaArray(scope, array);
    }

    @Override
    public Object unwrap() {
        return this.array;
    }

    public NativeJavaArray(Scriptable scope, Object array) {
        this(scope, array, TypeInfoFactory.GLOBAL.create(array.getClass()));
    }

    public NativeJavaArray(Scriptable scope, Object array, TypeInfo staticType) {
        super(scope, null, staticType);
        if (!staticType.isArray() || !array.getClass().isArray()) {
            throw new RuntimeException("Array expected");
        }
        this.array = array;
        this.length = Array.getLength(array);
        this.componentType = staticType.getComponentType();
    }

    @Override
    public boolean has(String id, Scriptable start) {
        return "length".equals(id) || super.has(id, start);
    }

    @Override
    public boolean has(int index, Scriptable start) {
        return 0 <= index && index < this.length;
    }

    @Override
    public boolean has(Symbol key, Scriptable start) {
        return SymbolKey.IS_CONCAT_SPREADABLE.equals(key);
    }

    @Override
    public Object get(String id, Scriptable start) {
        if ("length".equals(id)) {
            return this.length;
        }
        Object result = super.get(id, start);
        if (result == NOT_FOUND && !ScriptableObject.hasProperty(this.getPrototype(), id)) {
            throw Context.reportRuntimeErrorById("msg.java.member.not.found", this.array.getClass().getName(), id);
        }
        return result;
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (0 <= index && index < this.length) {
            Context cx = Context.getContext();
            Object obj = Array.get(this.array, index);
            return cx.getWrapFactory().wrap(cx, (Scriptable)this, obj, this.componentType);
        }
        return Undefined.instance;
    }

    @Override
    public Object get(Symbol key, Scriptable start) {
        if (SymbolKey.IS_CONCAT_SPREADABLE.equals(key)) {
            return Boolean.TRUE;
        }
        return Scriptable.NOT_FOUND;
    }

    @Override
    public void put(String id, Scriptable start, Object value) {
        if (!"length".equals(id)) {
            throw Context.reportRuntimeErrorById("msg.java.array.member.not.found", id);
        }
    }

    @Override
    public void put(int index, Scriptable start, Object value) {
        if (0 > index || index >= this.length) {
            throw Context.reportRuntimeErrorById("msg.java.array.index.out.of.bounds", String.valueOf(index), String.valueOf(this.length - 1));
        }
        Array.set(this.array, index, Context.jsToJava(value, this.componentType));
    }

    @Override
    public void delete(Symbol key) {
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (hint == null || hint == ScriptRuntime.StringClass) {
            return this.array.toString();
        }
        if (hint == ScriptRuntime.BooleanClass) {
            return Boolean.TRUE;
        }
        if (hint == ScriptRuntime.NumberClass) {
            return ScriptRuntime.NaNobj;
        }
        return this;
    }

    @Override
    public Object[] getIds() {
        Object[] result = new Object[this.length];
        int i = this.length;
        while (--i >= 0) {
            result[i] = i;
        }
        return result;
    }

    @Override
    public boolean hasInstance(Scriptable value) {
        return value instanceof Wrapper && this.componentType.isInstance(((Wrapper)((Object)value)).unwrap());
    }

    @Override
    public Scriptable getPrototype() {
        if (this.prototype == null) {
            this.prototype = ScriptableObject.getArrayPrototype(this.getParentScope());
        }
        return this.prototype;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof NativeJavaArray && Objects.equals(((NativeJavaArray)obj).array, this.array);
    }

    @Override
    public int hashCode() {
        return this.array == null ? 0 : this.array.hashCode();
    }
}

