/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.text.Collator;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.htmlunit.corejs.javascript.AbstractEcmaObjectOperations;
import org.htmlunit.corejs.javascript.AbstractEcmaStringOperations;
import org.htmlunit.corejs.javascript.Callable;
import org.htmlunit.corejs.javascript.CompoundOperationMap;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.NativeArray;
import org.htmlunit.corejs.javascript.NativeJSON;
import org.htmlunit.corejs.javascript.NativeStringIterator;
import org.htmlunit.corejs.javascript.RegExpProxy;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.ScriptRuntimeES6;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.SerializableCallable;
import org.htmlunit.corejs.javascript.Symbol;
import org.htmlunit.corejs.javascript.SymbolKey;
import org.htmlunit.corejs.javascript.Undefined;

final class NativeString
extends ScriptableObject {
    private static final long serialVersionUID = 920268368584188687L;
    private static final String CLASS_NAME = "String";
    private final CharSequence string;

    static void init(Scriptable scope, boolean sealed) {
        LambdaConstructor c = new LambdaConstructor(scope, CLASS_NAME, 1, NativeString::js_constructorFunc, NativeString::js_constructor);
        c.setPrototypePropertyAttributes(7);
        c.setPrototypeScriptable(new NativeString(""));
        NativeString.defConsMethod(c, scope, "fromCharCode", 1, NativeString::js_fromCharCode);
        NativeString.defConsMethod(c, scope, "fromCodePoint", 1, NativeString::js_fromCodePoint);
        NativeString.defConsMethod(c, scope, "raw", 1, NativeString::js_raw);
        NativeString.defConsMethod(c, scope, "charAt", 1, NativeString.wrapConstructor(NativeString::js_charAt));
        NativeString.defConsMethod(c, scope, "charCodeAt", 1, NativeString.wrapConstructor(NativeString::js_charCodeAt));
        NativeString.defConsMethod(c, scope, "indexOf", 2, NativeString.wrapConstructor(NativeString::js_indexOf));
        NativeString.defConsMethod(c, scope, "lastIndexOf", 2, NativeString.wrapConstructor(NativeString::js_lastIndexOf));
        NativeString.defConsMethod(c, scope, "split", 3, NativeString.wrapConstructor(NativeString::js_split));
        NativeString.defConsMethod(c, scope, "substring", 3, NativeString.wrapConstructor(NativeString::js_substring));
        NativeString.defConsMethod(c, scope, "toLowerCase", 1, NativeString.wrapConstructor(NativeString::js_toLowerCase));
        NativeString.defConsMethod(c, scope, "toUpperCase", 1, NativeString.wrapConstructor(NativeString::js_toUpperCase));
        NativeString.defConsMethod(c, scope, "substr", 3, NativeString.wrapConstructor(NativeString::js_substr));
        NativeString.defConsMethod(c, scope, "concat", 2, NativeString.wrapConstructor(NativeString::js_concat));
        NativeString.defConsMethod(c, scope, "slice", 3, NativeString.wrapConstructor(NativeString::js_slice));
        NativeString.defConsMethod(c, scope, "equalsIgnoreCase", 2, NativeString.wrapConstructor(NativeString::js_equalsIgnoreCase));
        NativeString.defConsMethod(c, scope, "match", 2, NativeString.wrapConstructor(NativeString::js_match));
        NativeString.defConsMethod(c, scope, "search", 2, NativeString.wrapConstructor(NativeString::js_search));
        NativeString.defConsMethod(c, scope, "replace", 2, NativeString.wrapConstructor(NativeString::js_replace));
        NativeString.defConsMethod(c, scope, "replaceAll", 2, NativeString.wrapConstructor(NativeString::js_replaceAll));
        NativeString.defConsMethod(c, scope, "localeCompare", 2, NativeString.wrapConstructor(NativeString::js_localeCompare));
        NativeString.defConsMethod(c, scope, "toLocaleLowerCase", 1, NativeString.wrapConstructor(NativeString::js_toLocaleLowerCase));
        NativeString.defProtoMethod(c, scope, SymbolKey.ITERATOR, 0, NativeString::js_iterator);
        NativeString.defProtoMethod(c, scope, "toString", 0, NativeString::js_toString);
        NativeString.defProtoMethod(c, scope, "toSource", 0, NativeString::js_toSource);
        NativeString.defProtoMethod(c, scope, "valueOf", 0, NativeString::js_toString);
        NativeString.defProtoMethod(c, scope, "charAt", 1, NativeString::js_charAt);
        NativeString.defProtoMethod(c, scope, "charCodeAt", 1, NativeString::js_charCodeAt);
        NativeString.defProtoMethod(c, scope, "indexOf", 1, NativeString::js_indexOf);
        NativeString.defProtoMethod(c, scope, "lastIndexOf", 1, NativeString::js_lastIndexOf);
        NativeString.defProtoMethod(c, scope, "split", 2, NativeString::js_split);
        NativeString.defProtoMethod(c, scope, "substring", 2, NativeString::js_substring);
        NativeString.defProtoMethod(c, scope, "toLowerCase", 0, NativeString::js_toLowerCase);
        NativeString.defProtoMethod(c, scope, "toUpperCase", 0, NativeString::js_toUpperCase);
        NativeString.defProtoMethod(c, scope, "substr", 2, NativeString::js_substr);
        NativeString.defProtoMethod(c, scope, "concat", 1, NativeString::js_concat);
        NativeString.defProtoMethod(c, scope, "slice", 2, NativeString::js_slice);
        NativeString.defProtoMethod(c, scope, "bold", 0, NativeString::js_bold);
        NativeString.defProtoMethod(c, scope, "italics", 0, NativeString::js_italics);
        NativeString.defProtoMethod(c, scope, "fixed", 0, NativeString::js_fixed);
        NativeString.defProtoMethod(c, scope, "strike", 0, NativeString::js_strike);
        NativeString.defProtoMethod(c, scope, "small", 0, NativeString::js_small);
        NativeString.defProtoMethod(c, scope, "big", 0, NativeString::js_big);
        NativeString.defProtoMethod(c, scope, "blink", 0, NativeString::js_blink);
        NativeString.defProtoMethod(c, scope, "sup", 0, NativeString::js_sup);
        NativeString.defProtoMethod(c, scope, "sub", 0, NativeString::js_sub);
        NativeString.defProtoMethod(c, scope, "fontsize", 0, NativeString::js_fontsize);
        NativeString.defProtoMethod(c, scope, "fontcolor", 0, NativeString::js_fontcolor);
        NativeString.defProtoMethod(c, scope, "link", 0, NativeString::js_link);
        NativeString.defProtoMethod(c, scope, "anchor", 0, NativeString::js_anchor);
        NativeString.defProtoMethod(c, scope, "equals", 1, NativeString::js_equals);
        NativeString.defProtoMethod(c, scope, "equalsIgnoreCase", 1, NativeString::js_equalsIgnoreCase);
        NativeString.defProtoMethod(c, scope, "match", 1, NativeString::js_match);
        NativeString.defProtoMethod(c, scope, "matchAll", 1, NativeString::js_matchAll);
        NativeString.defProtoMethod(c, scope, "search", 1, NativeString::js_search);
        NativeString.defProtoMethod(c, scope, "replace", 2, NativeString::js_replace);
        NativeString.defProtoMethod(c, scope, "replaceAll", 2, NativeString::js_replaceAll);
        NativeString.defProtoMethod(c, scope, "at", 1, NativeString::js_at);
        NativeString.defProtoMethod(c, scope, "localeCompare", 1, NativeString::js_localeCompare);
        NativeString.defProtoMethod(c, scope, "toLocaleLowerCase", 0, NativeString::js_toLocaleLowerCase);
        NativeString.defProtoMethod(c, scope, "toLocaleUpperCase", 0, NativeString::js_toLocaleUpperCase);
        NativeString.defProtoMethod(c, scope, "trim", 0, NativeString::js_trim);
        NativeString.defProtoMethod(c, scope, "trimLeft", 0, NativeString::js_trimLeft);
        NativeString.defProtoMethod(c, scope, "trimStart", 0, NativeString::js_trimLeft);
        NativeString.defProtoMethod(c, scope, "trimRight", 0, NativeString::js_trimRight);
        NativeString.defProtoMethod(c, scope, "trimEnd", 0, NativeString::js_trimRight);
        NativeString.defProtoMethod(c, scope, "includes", 1, NativeString::js_includes);
        NativeString.defProtoMethod(c, scope, "startsWith", 1, NativeString::js_startsWith);
        NativeString.defProtoMethod(c, scope, "endsWith", 1, NativeString::js_endsWith);
        NativeString.defProtoMethod(c, scope, "normalize", 0, NativeString::js_normalize);
        NativeString.defProtoMethod(c, scope, "repeat", 1, NativeString::js_repeat);
        NativeString.defProtoMethod(c, scope, "codePointAt", 1, NativeString::js_codePointAt);
        NativeString.defProtoMethod(c, scope, "padStart", 1, NativeString::js_padStart);
        NativeString.defProtoMethod(c, scope, "padEnd", 1, NativeString::js_padEnd);
        NativeString.defProtoMethod(c, scope, "isWellFormed", 0, NativeString::js_isWellFormed);
        NativeString.defProtoMethod(c, scope, "toWellFormed", 0, NativeString::js_toWellFormed);
        if (sealed) {
            c.sealObject();
            ((NativeString)c.getPrototypeProperty()).sealObject();
        }
        ScriptableObject.defineProperty(scope, CLASS_NAME, c, 2);
    }

    private static void defConsMethod(LambdaConstructor c, Scriptable scope, String name, int length, SerializableCallable target) {
        c.defineConstructorMethod(scope, name, length, target);
    }

    private static void defProtoMethod(LambdaConstructor c, Scriptable scope, SymbolKey key, int length, SerializableCallable target) {
        c.definePrototypeMethod(scope, key, length, target);
    }

    private static void defProtoMethod(LambdaConstructor c, Scriptable scope, String name, int length, SerializableCallable target) {
        c.definePrototypeMethod(scope, name, length, target);
    }

    NativeString(CharSequence s) {
        this.string = s;
        this.defineProperty("length", s::length, null, 7);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    private static SerializableCallable wrapConstructor(SerializableCallable target) {
        return (cx, scope, origThis, origArgs) -> {
            Object[] newArgs;
            Scriptable thisObj;
            if (origArgs.length > 0) {
                thisObj = ScriptRuntime.toObject(cx, scope, ScriptRuntime.toCharSequence(origArgs[0]));
                newArgs = new Object[origArgs.length - 1];
                System.arraycopy(origArgs, 1, newArgs, 0, newArgs.length);
            } else {
                thisObj = ScriptRuntime.toObject(cx, scope, ScriptRuntime.toCharSequence(origThis));
                newArgs = origArgs;
            }
            return target.call(cx, scope, thisObj, newArgs);
        };
    }

    private static Scriptable js_constructor(Context cx, Scriptable scope, Object[] args) {
        CharSequence s = args.length == 0 ? "" : ScriptRuntime.toCharSequence(args[0]);
        return new NativeString(s);
    }

    private static Object js_constructorFunc(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        CharSequence s = args.length == 0 ? "" : (ScriptRuntime.isSymbol(args[0]) ? args[0].toString() : ScriptRuntime.toCharSequence(args[0]));
        return s instanceof String ? s : s.toString();
    }

    private static Object js_fromCharCode(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        int n = args.length;
        if (n < 1) {
            return "";
        }
        char[] chars = new char[n];
        for (int i = 0; i != n; ++i) {
            chars[i] = ScriptRuntime.toUint16(args[i]);
        }
        return new String(chars);
    }

    private static Object js_fromCodePoint(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        int n = args.length;
        if (n < 1) {
            return "";
        }
        int[] codePoints = new int[n];
        for (int i = 0; i != n; ++i) {
            Object arg = args[i];
            int codePoint = ScriptRuntime.toInt32(arg);
            double num = ScriptRuntime.toNumber(arg);
            if (!ScriptRuntime.eqNumber(num, codePoint) || !Character.isValidCodePoint(codePoint)) {
                throw ScriptRuntime.rangeError("Invalid code point " + ScriptRuntime.toString(arg));
            }
            codePoints[i] = codePoint;
        }
        return new String(codePoints, 0, n);
    }

    private static Object js_charAt(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeString.charAt(cx, thisObj, args, false);
    }

    private static Object js_charCodeAt(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeString.charAt(cx, thisObj, args, true);
    }

    private static Object charAt(Context cx, Scriptable thisObj, Object[] args, boolean getCode) {
        CharSequence target = ScriptRuntime.toCharSequence(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "charAt"));
        double pos = ScriptRuntime.toInteger(args, 0);
        if (pos < 0.0 || pos >= (double)target.length()) {
            if (!getCode) {
                return "";
            }
            return ScriptRuntime.NaNobj;
        }
        char c = target.charAt((int)pos);
        if (!getCode) {
            return String.valueOf(c);
        }
        return ScriptRuntime.wrapInt(c);
    }

    private static Object js_indexOf(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String target = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "indexOf"));
        String searchStr = ScriptRuntime.toString(args, 0);
        double position = ScriptRuntime.toInteger(args, 1);
        if (searchStr.isEmpty()) {
            return position > (double)target.length() ? target.length() : (int)position;
        }
        if (position > (double)target.length()) {
            return -1;
        }
        if (position < 0.0) {
            position = 0.0;
        }
        return target.indexOf(searchStr, (int)position);
    }

    private static Object js_startsWith(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String target = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "startsWith"));
        NativeString.checkValidRegex(cx, args, 0, "startsWith");
        String searchStr = ScriptRuntime.toString(args, 0);
        double position = ScriptRuntime.toInteger(args, 1);
        if (position < 0.0) {
            position = 0.0;
        } else if (position > (double)target.length()) {
            position = target.length();
        }
        return target.startsWith(searchStr, (int)position);
    }

    private static Object js_endsWith(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String target = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "endsWith"));
        NativeString.checkValidRegex(cx, args, 0, "endsWith");
        String searchStr = ScriptRuntime.toString(args, 0);
        double position = ScriptRuntime.toInteger(args, 1);
        if (position < 0.0) {
            position = 0.0;
        } else if (Double.isNaN(position) || position > (double)target.length()) {
            position = target.length();
        }
        if (args.length == 0 || args.length == 1 || args.length == 2 && Undefined.isUndefined(args[1])) {
            position = target.length();
        }
        return target.substring(0, (int)position).endsWith(searchStr);
    }

    private static Object js_includes(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String target = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "includes"));
        String searchStr = ScriptRuntime.toString(args, 0);
        NativeString.checkValidRegex(cx, args, 0, "includes");
        int position = (int)ScriptRuntime.toInteger(args, 1);
        return target.indexOf(searchStr, position) != -1;
    }

    private static void checkValidRegex(Context cx, Object[] args, int pos, String functionName) {
        Scriptable arg;
        RegExpProxy reProxy;
        if (args.length > pos && args[pos] instanceof Scriptable && (reProxy = ScriptRuntime.getRegExpProxy(cx)) != null && reProxy.isRegExp(arg = (Scriptable)args[pos]) && ScriptableObject.isTrue(ScriptableObject.getProperty(arg, SymbolKey.MATCH))) {
            throw ScriptRuntime.typeErrorById("msg.first.arg.not.regexp", CLASS_NAME, functionName);
        }
    }

    private static Object js_split(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String t;
        Object splitter;
        Object limit;
        Object o = ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "split");
        Object separator = args.length > 0 ? args[0] : Undefined.instance;
        Object object = limit = args.length > 1 ? args[1] : Undefined.instance;
        if (!Undefined.isUndefined(separator) && separator != null && (splitter = ScriptRuntime.getObjectElem(separator, SymbolKey.SPLIT, cx, scope)) != null && !Undefined.isUndefined(splitter)) {
            if (!(splitter instanceof Callable)) {
                throw ScriptRuntime.notFunctionError(separator, splitter, SymbolKey.SPLIT.getName());
            }
            return ((Callable)splitter).call(cx, scope, ScriptRuntime.toObject(scope, separator), new Object[]{o instanceof NativeString ? ((NativeString)o).string : o, limit});
        }
        String s = ScriptRuntime.toString(o);
        long lim = Undefined.isUndefined(limit) ? Integer.MAX_VALUE : ScriptRuntime.toUint32(limit);
        String r = ScriptRuntime.toString(separator);
        if (lim == 0L) {
            return cx.newArray(scope, 0);
        }
        if (Undefined.isUndefined(separator)) {
            return cx.newArray(scope, new Object[]{s});
        }
        int separatorLength = r.length();
        if (separatorLength == 0) {
            char c;
            int strLen = s.length();
            int outLen = ScriptRuntime.clamp((int)lim, 0, strLen);
            String head = s.substring(0, outLen);
            ArrayList<String> codeUnits = new ArrayList<String>();
            for (int i = 0; i < head.length(); i += Character.charCount(c)) {
                c = head.charAt(i);
                codeUnits.add(Character.toString(c));
            }
            return cx.newArray(scope, codeUnits.toArray());
        }
        if (s.isEmpty()) {
            return cx.newArray(scope, new Object[]{s});
        }
        ArrayList<String> substrings = new ArrayList<String>();
        int i = 0;
        int j = s.indexOf(r);
        while (j != -1) {
            t = s.substring(i, j);
            substrings.add(t);
            if ((long)substrings.size() >= lim) {
                return cx.newArray(scope, substrings.toArray());
            }
            i = j + separatorLength;
            j = s.indexOf(r, i);
        }
        t = s.substring(i);
        substrings.add(t);
        return cx.newArray(scope, substrings.toArray());
    }

    private static NativeString realThis(Scriptable thisObj) {
        return LambdaConstructor.convertThisObject(thisObj, NativeString.class);
    }

    private static Object js_iterator(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return new NativeStringIterator(scope, ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "[Symbol.iterator]"));
    }

    private static Object js_toString(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        CharSequence cs = NativeString.realThis((Scriptable)thisObj).string;
        return cs instanceof String ? cs : cs.toString();
    }

    private static Object js_toSource(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        CharSequence s = NativeString.realThis((Scriptable)thisObj).string;
        return "(new String(\"" + ScriptRuntime.escapeString(s.toString()) + "\"))";
    }

    private static String tagify(Context cx, Scriptable thisObj, String functionName, String tag, String attribute, Object[] args) {
        String str = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, functionName));
        StringBuilder result = new StringBuilder();
        result.append('<').append(tag);
        if (attribute != null && !attribute.isEmpty()) {
            String attributeValue = ScriptRuntime.toString(args, 0);
            attributeValue = attributeValue.replace("\"", "&quot;");
            result.append(' ').append(attribute).append("=\"").append(attributeValue).append('\"');
        }
        result.append('>').append(str).append("</").append(tag).append('>');
        return result.toString();
    }

    public CharSequence toCharSequence() {
        return this.string;
    }

    public String toString() {
        return this.string instanceof String ? (String)this.string : this.string.toString();
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (0 <= index && index < this.string.length()) {
            return String.valueOf(this.string.charAt(index));
        }
        return super.get(index, start);
    }

    @Override
    public void put(int index, Scriptable start, Object value) {
        if (0 <= index && index < this.string.length()) {
            return;
        }
        super.put(index, start, value);
    }

    @Override
    public boolean has(int index, Scriptable start) {
        if (0 <= index && index < this.string.length()) {
            return true;
        }
        return super.has(index, start);
    }

    @Override
    public int getAttributes(int index) {
        if (0 <= index && index < this.string.length()) {
            int attribs = 5;
            return attribs;
        }
        return super.getAttributes(index);
    }

    @Override
    protected Object[] getIds(CompoundOperationMap map, boolean nonEnumerable, boolean getSymbols) {
        Context cx = Context.getCurrentContext();
        if (cx != null) {
            int i;
            Object[] sids = super.getIds(map, nonEnumerable, getSymbols);
            Object[] a = new Object[sids.length + this.string.length()];
            for (i = 0; i < this.string.length(); ++i) {
                a[i] = i;
            }
            System.arraycopy(sids, 0, a, i, sids.length);
            return a;
        }
        return super.getIds(map, nonEnumerable, getSymbols);
    }

    @Override
    protected ScriptableObject.DescriptorInfo getOwnPropertyDescriptor(Context cx, Object id) {
        if (!(id instanceof Symbol) && cx != null) {
            ScriptRuntime.StringIdOrIndex s = ScriptRuntime.toStringIdOrIndex(id);
            if (s.stringId == null && 0 <= s.index && s.index < this.string.length()) {
                String value = String.valueOf(this.string.charAt(s.index));
                return this.defaultIndexPropertyDescriptor(value);
            }
        }
        return super.getOwnPropertyDescriptor(cx, id);
    }

    private ScriptableObject.DescriptorInfo defaultIndexPropertyDescriptor(Object value) {
        return new ScriptableObject.DescriptorInfo(true, false, false, NOT_FOUND, NOT_FOUND, value);
    }

    private static Object js_match(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String flags;
        Object matcher;
        Object o = ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "match");
        Object regexp = args.length > 0 ? args[0] : Undefined.instance;
        RegExpProxy regExpProxy = ScriptRuntime.checkRegExpProxy(cx);
        if (regexp != null && !Undefined.isUndefined(regexp) && (matcher = ScriptRuntime.getObjectElem(regexp, SymbolKey.MATCH, cx, scope)) != null && !Undefined.isUndefined(matcher)) {
            if (!(matcher instanceof Callable)) {
                throw ScriptRuntime.notFunctionError(regexp, matcher, SymbolKey.MATCH.getName());
            }
            return ((Callable)matcher).call(cx, scope, ScriptRuntime.toObject(scope, regexp), new Object[]{o});
        }
        String s = ScriptRuntime.toString(o);
        String regexpToString = Undefined.isUndefined(regexp) ? "" : ScriptRuntime.toString(regexp);
        Object compiledRegExp = regExpProxy.compileRegExp(cx, regexpToString, flags = null);
        Scriptable rx = regExpProxy.wrapRegExp(cx, scope, compiledRegExp);
        Object method = ScriptRuntime.getObjectElem(rx, SymbolKey.MATCH, cx, scope);
        if (!(method instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(rx, method, SymbolKey.MATCH.getName());
        }
        return ((Callable)method).call(cx, scope, rx, new Object[]{s});
    }

    private static Object js_lastIndexOf(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String target = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "lastIndexOf"));
        String search = ScriptRuntime.toString(args, 0);
        double end = ScriptRuntime.toNumber(args, 1);
        if (Double.isNaN(end) || end > (double)target.length()) {
            end = target.length();
        } else if (end < 0.0) {
            end = 0.0;
        }
        return target.lastIndexOf(search, (int)end);
    }

    private static Object js_substring(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double end;
        CharSequence target = ScriptRuntime.toCharSequence(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "substring"));
        int length = target.length();
        double start = ScriptRuntime.toInteger(args, 0);
        if (start < 0.0) {
            start = 0.0;
        } else if (start > (double)length) {
            start = length;
        }
        if (args.length <= 1 || args[1] == Undefined.instance) {
            end = length;
        } else {
            end = ScriptRuntime.toInteger(args[1]);
            if (end < 0.0) {
                end = 0.0;
            } else if (end > (double)length) {
                end = length;
            }
            if (end < start) {
                double temp = start;
                start = end;
                end = temp;
            }
        }
        return target.subSequence((int)start, (int)end);
    }

    private static Object js_toLowerCase(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String thisStr = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "toLowerCase"));
        return thisStr.toLowerCase(Locale.ROOT);
    }

    private static Object js_toUpperCase(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String thisStr = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "toUpperCase"));
        return thisStr.toUpperCase(Locale.ROOT);
    }

    int getLength() {
        return this.string.length();
    }

    private static CharSequence js_substr(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object lengthArg;
        CharSequence target = ScriptRuntime.toCharSequence(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "substr"));
        if (args.length < 1) {
            return target;
        }
        double begin = ScriptRuntime.toInteger(args[0]);
        int length = target.length();
        if (begin < 0.0) {
            if ((begin += (double)length) < 0.0) {
                begin = 0.0;
            }
        } else if (begin > (double)length) {
            begin = length;
        }
        double end = length;
        if (args.length > 1 && !Undefined.isUndefined(lengthArg = args[1])) {
            end = ScriptRuntime.toInteger(lengthArg);
            if (end < 0.0) {
                end = 0.0;
            }
            if ((end += begin) > (double)length) {
                end = length;
            }
        }
        return target.subSequence((int)begin, (int)end);
    }

    private static String js_concat(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String target = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "concat"));
        int N = args.length;
        if (N == 0) {
            return target;
        }
        if (N == 1) {
            String arg = ScriptRuntime.toString(args[0]);
            return target.concat(arg);
        }
        int size = target.length();
        String[] argsAsStrings = new String[N];
        for (int i = 0; i != N; ++i) {
            String s;
            argsAsStrings[i] = s = ScriptRuntime.toString(args[i]);
            size += s.length();
        }
        StringBuilder result = new StringBuilder(size);
        result.append(target);
        for (int i = 0; i != N; ++i) {
            result.append(argsAsStrings[i]);
        }
        return result.toString();
    }

    private static Object js_slice(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double end;
        CharSequence target = ScriptRuntime.toCharSequence(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "slice"));
        double begin = args.length < 1 ? 0.0 : ScriptRuntime.toInteger(args[0]);
        int length = target.length();
        if (begin < 0.0) {
            if ((begin += (double)length) < 0.0) {
                begin = 0.0;
            }
        } else if (begin > (double)length) {
            begin = length;
        }
        if (args.length < 2 || args[1] == Undefined.instance) {
            end = length;
        } else {
            end = ScriptRuntime.toInteger(args[1]);
            if (end < 0.0) {
                if ((end += (double)length) < 0.0) {
                    end = 0.0;
                }
            } else if (end > (double)length) {
                end = length;
            }
            if (end < begin) {
                end = begin;
            }
        }
        return target.subSequence((int)begin, (int)end);
    }

    private static Object js_at(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        int k;
        String str = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "at"));
        Object targetArg = args.length >= 1 ? args[0] : Undefined.instance;
        int len = str.length();
        int relativeIndex = (int)ScriptRuntime.toInteger(targetArg);
        int n = k = relativeIndex >= 0 ? relativeIndex : len + relativeIndex;
        if (k < 0 || k >= len) {
            return Undefined.instance;
        }
        return str.substring(k, k + 1);
    }

    private static Object js_equals(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String s1 = ScriptRuntime.toString(thisObj);
        String s2 = ScriptRuntime.toString(args, 0);
        return s1.equals(s2);
    }

    private static Object js_equalsIgnoreCase(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String s1 = ScriptRuntime.toString(thisObj);
        String s2 = ScriptRuntime.toString(args, 0);
        return s1.equalsIgnoreCase(s2);
    }

    private static Object js_search(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String flags;
        Object matcher;
        Object o = ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "search");
        Object regexp = args.length > 0 ? args[0] : Undefined.instance;
        RegExpProxy regExpProxy = ScriptRuntime.checkRegExpProxy(cx);
        if (regexp != null && !Undefined.isUndefined(regexp) && (matcher = ScriptRuntime.getObjectElem(regexp, SymbolKey.SEARCH, cx, scope)) != null && !Undefined.isUndefined(matcher)) {
            if (!(matcher instanceof Callable)) {
                throw ScriptRuntime.notFunctionError(regexp, matcher, SymbolKey.SEARCH.getName());
            }
            return ((Callable)matcher).call(cx, scope, ScriptRuntime.toObject(scope, regexp), new Object[]{o});
        }
        String s = ScriptRuntime.toString(o);
        String regexpToString = Undefined.isUndefined(regexp) ? "" : ScriptRuntime.toString(regexp);
        Object compiledRegExp = regExpProxy.compileRegExp(cx, regexpToString, flags = null);
        Scriptable rx = regExpProxy.wrapRegExp(cx, scope, compiledRegExp);
        Object method = ScriptRuntime.getObjectElem(rx, SymbolKey.SEARCH, cx, scope);
        if (!(method instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(rx, method, SymbolKey.SEARCH.getName());
        }
        return ((Callable)method).call(cx, scope, rx, new Object[]{s});
    }

    private static Object js_replace(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String replacement;
        Object replacer;
        Object replaceValue;
        Object o = ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "replace");
        Object searchValue = args.length > 0 ? args[0] : Undefined.instance;
        Object object = replaceValue = args.length > 1 ? args[1] : Undefined.instance;
        if (!Undefined.isUndefined(searchValue) && searchValue != null && (replacer = ScriptRuntime.getObjectElem(searchValue, SymbolKey.REPLACE, cx, scope)) != null && !Undefined.isUndefined(replacer)) {
            if (!(replacer instanceof Callable)) {
                throw ScriptRuntime.notFunctionError(searchValue, replacer, SymbolKey.REPLACE.getName());
            }
            return ((Callable)replacer).call(cx, scope, ScriptRuntime.toObject(scope, searchValue), new Object[]{o instanceof NativeString ? ((NativeString)o).string : o, replaceValue});
        }
        String string = ScriptRuntime.toString(o);
        String searchString = ScriptRuntime.toString(searchValue);
        boolean functionalReplace = replaceValue instanceof Callable;
        if (!functionalReplace) {
            replaceValue = ScriptRuntime.toString(replaceValue);
        }
        int searchLength = searchString.length();
        int position = string.indexOf(searchString);
        if (position == -1) {
            return string;
        }
        String preceding = string.substring(0, position);
        String following = string.substring(position + searchLength);
        if (functionalReplace) {
            Scriptable callThis = ScriptRuntime.getApplyOrCallThis(cx, scope, null, 0, (Callable)replaceValue);
            Object replacementObj = ((Callable)replaceValue).call(cx, scope, callThis, new Object[]{searchString, position, string});
            replacement = ScriptRuntime.toString(replacementObj);
        } else {
            NativeArray captures = (NativeArray)cx.newArray(scope, 0);
            replacement = AbstractEcmaStringOperations.getSubstitution(cx, scope, searchString, string, position, captures, Undefined.SCRIPTABLE_UNDEFINED, (String)replaceValue);
        }
        return preceding + replacement + following;
    }

    private static Object js_replaceAll(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object replaceValue;
        Object o = ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "replaceAll");
        Object searchValue = args.length > 0 ? args[0] : Undefined.instance;
        Object object = replaceValue = args.length > 1 ? args[1] : Undefined.instance;
        if (searchValue != null && !Undefined.isUndefined(searchValue)) {
            Object matcher;
            boolean isRegExp;
            boolean bl = isRegExp = searchValue instanceof Scriptable && AbstractEcmaObjectOperations.isRegExp(cx, scope, searchValue);
            if (isRegExp) {
                Object flags = ScriptRuntime.getObjectProp(searchValue, "flags", cx, scope);
                ScriptRuntimeES6.requireObjectCoercible(cx, flags, CLASS_NAME, "replaceAll");
                String flagsStr = ScriptRuntime.toString(flags);
                if (!flagsStr.contains("g")) {
                    throw ScriptRuntime.typeErrorById("msg.str.replace.all.no.global.flag", new Object[0]);
                }
            }
            if ((matcher = ScriptRuntime.getObjectElem(searchValue, SymbolKey.REPLACE, cx, scope)) != null && !Undefined.isUndefined(matcher)) {
                if (!(matcher instanceof Callable)) {
                    throw ScriptRuntime.notFunctionError(searchValue, matcher, SymbolKey.REPLACE.getName());
                }
                return ((Callable)matcher).call(cx, scope, ScriptRuntime.toObject(scope, searchValue), new Object[]{o, replaceValue});
            }
        }
        String string = ScriptRuntime.toString(o);
        String searchString = ScriptRuntime.toString(searchValue);
        boolean functionalReplace = replaceValue instanceof Callable;
        if (!functionalReplace) {
            replaceValue = ScriptRuntime.toString(replaceValue);
        }
        int searchLength = searchString.length();
        int advanceBy = Math.max(1, searchLength);
        ArrayList<Integer> matchPositions = new ArrayList<Integer>();
        int position = string.indexOf(searchString);
        while (position != -1) {
            matchPositions.add(position);
            int newPosition = string.indexOf(searchString, position + advanceBy);
            if (newPosition == position) break;
            position = newPosition;
        }
        int endOfLastMatch = 0;
        StringBuilder result = new StringBuilder();
        for (Integer p : matchPositions) {
            String replacement;
            String preserved = string.substring(endOfLastMatch, p);
            if (functionalReplace) {
                Scriptable callThis = ScriptRuntime.getApplyOrCallThis(cx, scope, null, 0, (Callable)replaceValue);
                Object replacementObj = ((Callable)replaceValue).call(cx, scope, callThis, new Object[]{searchString, p, string});
                replacement = ScriptRuntime.toString(replacementObj);
            } else {
                NativeArray captures = (NativeArray)cx.newArray(scope, 0);
                replacement = AbstractEcmaStringOperations.getSubstitution(cx, scope, searchString, string, p, captures, Undefined.SCRIPTABLE_UNDEFINED, (String)replaceValue);
            }
            result.append(preserved);
            result.append(replacement);
            endOfLastMatch = p + searchLength;
        }
        if (endOfLastMatch < string.length()) {
            result.append(string.substring(endOfLastMatch));
        }
        return result.toString();
    }

    private static Object js_matchAll(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object compiledRegExp;
        Object regexp;
        Object o = ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "matchAll");
        Object object = regexp = args.length > 0 ? args[0] : Undefined.instance;
        if (regexp != null && !Undefined.isUndefined(regexp)) {
            Object matcher;
            boolean isRegExp = AbstractEcmaObjectOperations.isRegExp(cx, scope, regexp);
            if (isRegExp) {
                Object flags = ScriptRuntime.getObjectProp(regexp, "flags", cx, scope);
                ScriptRuntimeES6.requireObjectCoercible(cx, flags, CLASS_NAME, "matchAll");
                String flagsStr = ScriptRuntime.toString(flags);
                if (!flagsStr.contains("g")) {
                    throw ScriptRuntime.typeErrorById("msg.str.match.all.no.global.flag", new Object[0]);
                }
            }
            if ((matcher = ScriptRuntime.getObjectElem(regexp, SymbolKey.MATCH_ALL, cx, scope)) != null && !Undefined.isUndefined(matcher)) {
                if (!(matcher instanceof Callable)) {
                    throw ScriptRuntime.notFunctionError(regexp, matcher, SymbolKey.MATCH_ALL.getName());
                }
                return ((Callable)matcher).call(cx, scope, ScriptRuntime.toObject(scope, regexp), new Object[]{o});
            }
        }
        String s = ScriptRuntime.toString(o);
        String regexpToString = Undefined.isUndefined(regexp) ? "" : ScriptRuntime.toString(regexp);
        RegExpProxy regExpProxy = ScriptRuntime.checkRegExpProxy(cx);
        Scriptable rx = regExpProxy.wrapRegExp(cx, scope, compiledRegExp = regExpProxy.compileRegExp(cx, regexpToString, "g"));
        Object method = ScriptRuntime.getObjectElem(rx, SymbolKey.MATCH_ALL, cx, scope);
        if (!(method instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(rx, method, SymbolKey.MATCH_ALL.getName());
        }
        return ((Callable)method).call(cx, scope, rx, new Object[]{s});
    }

    private static Object js_localeCompare(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String thisStr = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "localeCompare"));
        Collator collator = Collator.getInstance(cx.getLocale());
        collator.setStrength(3);
        collator.setDecomposition(1);
        return collator.compare(thisStr, ScriptRuntime.toString(args, 0));
    }

    private static Object js_toLocaleLowerCase(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String thisStr = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "toLocaleLowerCase"));
        Locale locale = cx.getLocale();
        if (args.length > 0) {
            String lang = ScriptRuntime.toString(args[0]);
            locale = new Locale(lang);
        }
        return thisStr.toLowerCase(locale);
    }

    private static Object js_toLocaleUpperCase(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String thisStr = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "toLocaleUpperCase"));
        Locale locale = cx.getLocale();
        if (args.length > 0) {
            String lang = ScriptRuntime.toString(args[0]);
            locale = new Locale(lang);
        }
        return thisStr.toUpperCase(locale);
    }

    private static Object js_trim(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        int end;
        int start;
        String str = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "trim"));
        char[] chars = str.toCharArray();
        for (start = 0; start < chars.length && ScriptRuntime.isJSWhitespaceOrLineTerminator(chars[start]); ++start) {
        }
        for (end = chars.length; end > start && ScriptRuntime.isJSWhitespaceOrLineTerminator(chars[end - 1]); --end) {
        }
        return str.substring(start, end);
    }

    private static Object js_trimLeft(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        int start;
        String str = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "trimLeft"));
        char[] chars = str.toCharArray();
        for (start = 0; start < chars.length && ScriptRuntime.isJSWhitespaceOrLineTerminator(chars[start]); ++start) {
        }
        int end = chars.length;
        return str.substring(start, end);
    }

    private static Object js_trimRight(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        int end;
        String str = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "trimRight"));
        char[] chars = str.toCharArray();
        int start = 0;
        for (end = chars.length; end > start && ScriptRuntime.isJSWhitespaceOrLineTerminator(chars[end - 1]); --end) {
        }
        return str.substring(start, end);
    }

    private static Object js_normalize(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Normalizer.Form form;
        if (args.length == 0 || Undefined.isUndefined(args[0])) {
            return Normalizer.normalize(ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "normalize")), Normalizer.Form.NFC);
        }
        String formStr = ScriptRuntime.toString(args, 0);
        if (Normalizer.Form.NFD.name().equals(formStr)) {
            form = Normalizer.Form.NFD;
        } else if (Normalizer.Form.NFKC.name().equals(formStr)) {
            form = Normalizer.Form.NFKC;
        } else if (Normalizer.Form.NFKD.name().equals(formStr)) {
            form = Normalizer.Form.NFKD;
        } else if (Normalizer.Form.NFC.name().equals(formStr)) {
            form = Normalizer.Form.NFC;
        } else {
            throw ScriptRuntime.rangeError("The normalization form should be one of 'NFC', 'NFD', 'NFKC', 'NFKD'.");
        }
        return Normalizer.normalize(ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "normalize")), form);
    }

    private static String js_repeat(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        int i;
        String str = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "repeat"));
        double cnt = ScriptRuntime.toInteger(args, 0);
        if (cnt < 0.0 || cnt == Double.POSITIVE_INFINITY) {
            throw ScriptRuntime.rangeError("Invalid count value");
        }
        if (cnt == 0.0 || str.isEmpty()) {
            return "";
        }
        long size = (long)str.length() * (long)cnt;
        if (cnt > 2.147483647E9 || size > Integer.MAX_VALUE) {
            throw ScriptRuntime.rangeError("Invalid size or count value");
        }
        StringBuilder retval = new StringBuilder((int)size);
        retval.append(str);
        int icnt = (int)cnt;
        for (i = 1; i <= icnt / 2; i *= 2) {
            retval.append((CharSequence)retval);
        }
        if (i < icnt) {
            retval.append(retval, 0, str.length() * (icnt - i));
        }
        return retval.toString();
    }

    private static Object js_codePointAt(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String str = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "codePointAt"));
        double cnt = ScriptRuntime.toInteger(args, 0);
        return cnt < 0.0 || cnt >= (double)str.length() ? Undefined.instance : Integer.valueOf(str.codePointAt((int)cnt));
    }

    private static String pad(Context cx, Scriptable thisObj, String functionName, Object[] args, boolean atStart) {
        String pad = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, functionName));
        long intMaxLength = ScriptRuntime.toLength(args, 0);
        if (intMaxLength <= (long)pad.length()) {
            return pad;
        }
        String filler = " ";
        if (args.length >= 2 && !Undefined.isUndefined(args[1]) && (filler = ScriptRuntime.toString(args[1])).isEmpty()) {
            return pad;
        }
        int fillLen = (int)(intMaxLength - (long)pad.length());
        StringBuilder concat = new StringBuilder();
        do {
            concat.append(filler);
        } while (concat.length() < fillLen);
        concat.setLength(fillLen);
        if (atStart) {
            return concat.append(pad).toString();
        }
        return concat.insert(0, pad).toString();
    }

    private static Object js_padStart(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeString.pad(cx, thisObj, "padStart", args, true);
    }

    private static Object js_padEnd(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeString.pad(cx, thisObj, "padEnd", args, false);
    }

    private static Object js_raw(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object arg0 = args.length > 0 ? args[0] : Undefined.instance;
        Scriptable cooked = ScriptRuntime.toObject(cx, scope, arg0);
        Object rawValue = ScriptRuntime.getObjectProp(cooked, "raw", cx);
        Scriptable raw = ScriptRuntime.toObject(cx, scope, rawValue);
        long rawLength = NativeArray.getLengthProperty(cx, raw);
        if (rawLength > Integer.MAX_VALUE) {
            throw ScriptRuntime.rangeError("raw.length > 2147483647");
        }
        int literalSegments = (int)rawLength;
        if (literalSegments <= 0) {
            return "";
        }
        StringBuilder elements = new StringBuilder();
        int nextIndex = 0;
        while (true) {
            Object next = ScriptRuntime.getObjectIndex(raw, nextIndex, cx);
            String nextSeg = ScriptRuntime.toString(next);
            elements.append(nextSeg);
            if (++nextIndex == literalSegments) break;
            if (args.length <= nextIndex) continue;
            next = args[nextIndex];
            String nextSub = ScriptRuntime.toString(next);
            elements.append(nextSub);
        }
        return elements;
    }

    private static Object js_isWellFormed(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        CharSequence str = ScriptRuntime.toCharSequence(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "isWellFormed"));
        int len = str.length();
        boolean foundLeadingSurrogate = false;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (NativeJSON.isLeadingSurrogate(c)) {
                if (foundLeadingSurrogate) {
                    return false;
                }
                foundLeadingSurrogate = true;
                continue;
            }
            if (NativeJSON.isTrailingSurrogate(c)) {
                if (!foundLeadingSurrogate) {
                    return false;
                }
                foundLeadingSurrogate = false;
                continue;
            }
            if (!foundLeadingSurrogate) continue;
            return false;
        }
        return !foundLeadingSurrogate;
    }

    private static Object js_toWellFormed(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        CharSequence str = ScriptRuntime.toCharSequence(ScriptRuntimeES6.requireObjectCoercible(cx, thisObj, CLASS_NAME, "toWellFormed"));
        HashMap<Integer, Boolean> surrogates = new HashMap<Integer, Boolean>();
        int len = str.length();
        char prev = '\u0000';
        int firstSurrogateIndex = -1;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (NativeJSON.isLeadingSurrogate(prev) && NativeJSON.isTrailingSurrogate(c)) {
                surrogates.put(i - 1, Boolean.TRUE);
                surrogates.put(i, Boolean.TRUE);
            } else if (NativeJSON.isLeadingSurrogate(c) || NativeJSON.isTrailingSurrogate(c)) {
                surrogates.put(i, Boolean.FALSE);
                if (firstSurrogateIndex == -1) {
                    firstSurrogateIndex = i;
                }
            }
            prev = c;
        }
        if (surrogates.isEmpty()) {
            return str.toString();
        }
        StringBuilder sb = new StringBuilder(str.subSequence(0, firstSurrogateIndex));
        for (int i = firstSurrogateIndex; i < len; ++i) {
            char c = str.charAt(i);
            Boolean pairOrNormal = (Boolean)surrogates.get(i);
            if (pairOrNormal == null || pairOrNormal.booleanValue()) {
                sb.append(c);
                continue;
            }
            sb.append('\ufffd');
        }
        return sb.toString();
    }

    private static Object js_bold(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeString.tagify(cx, thisObj, "bold", "b", null, args);
    }

    private static Object js_italics(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeString.tagify(cx, thisObj, "italics", "i", null, args);
    }

    private static Object js_fixed(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeString.tagify(cx, thisObj, "fixed", "tt", null, args);
    }

    private static Object js_strike(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeString.tagify(cx, thisObj, "strike", "strike", null, args);
    }

    private static Object js_small(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeString.tagify(cx, thisObj, "small", "small", null, args);
    }

    private static Object js_big(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeString.tagify(cx, thisObj, "big", "big", null, args);
    }

    private static Object js_blink(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeString.tagify(cx, thisObj, "blink", "blink", null, args);
    }

    private static Object js_sup(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeString.tagify(cx, thisObj, "sup", "sup", null, args);
    }

    private static Object js_sub(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeString.tagify(cx, thisObj, "sub", "sub", null, args);
    }

    private static Object js_fontsize(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeString.tagify(cx, thisObj, "fontsize", "font", "size", args);
    }

    private static Object js_fontcolor(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeString.tagify(cx, thisObj, "fontcolor", "font", "color", args);
    }

    private static Object js_link(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeString.tagify(cx, thisObj, "link", "a", "href", args);
    }

    private static Object js_anchor(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeString.tagify(cx, thisObj, "anchor", "a", "name", args);
    }
}

