/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.Symbol;
import org.htmlunit.corejs.javascript.SymbolKey;
import org.htmlunit.corejs.javascript.Undefined;

public class NativeSymbol
extends ScriptableObject
implements Symbol {
    private static final long serialVersionUID = -589539749749830003L;
    public static final String CLASS_NAME = "Symbol";
    public static final String TYPE_NAME = "symbol";
    private final SymbolKey key;
    private static final Map<String, SymbolKey> globalMap = Collections.synchronizedMap(new WeakHashMap());

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        LambdaConstructor ctor = new LambdaConstructor(scope, CLASS_NAME, 0, NativeSymbol::js_constructorCall, null);
        ctor.setPrototypePropertyAttributes(7);
        ctor.defineConstructorMethod(scope, "for", 1, NativeSymbol::js_for);
        ctor.defineConstructorMethod(scope, "keyFor", 1, NativeSymbol::js_keyFor);
        ctor.definePrototypeMethod(scope, "toString", 0, NativeSymbol::js_toString);
        ctor.definePrototypeMethod(scope, "valueOf", 0, NativeSymbol::js_valueOf);
        ctor.definePrototypeMethod(scope, SymbolKey.TO_PRIMITIVE, 1, NativeSymbol::js_valueOf, 3);
        ctor.definePrototypeProperty(SymbolKey.TO_STRING_TAG, (Object)CLASS_NAME, 3);
        ctor.definePrototypeProperty(cx, "description", NativeSymbol::js_description);
        ScriptableObject.defineProperty(scope, CLASS_NAME, ctor, 2);
        NativeSymbol.createStandardSymbol(scope, ctor, "iterator", SymbolKey.ITERATOR);
        NativeSymbol.createStandardSymbol(scope, ctor, "species", SymbolKey.SPECIES);
        NativeSymbol.createStandardSymbol(scope, ctor, "toStringTag", SymbolKey.TO_STRING_TAG);
        NativeSymbol.createStandardSymbol(scope, ctor, "hasInstance", SymbolKey.HAS_INSTANCE);
        NativeSymbol.createStandardSymbol(scope, ctor, "isConcatSpreadable", SymbolKey.IS_CONCAT_SPREADABLE);
        NativeSymbol.createStandardSymbol(scope, ctor, "isRegExp", SymbolKey.IS_REGEXP);
        NativeSymbol.createStandardSymbol(scope, ctor, "toPrimitive", SymbolKey.TO_PRIMITIVE);
        NativeSymbol.createStandardSymbol(scope, ctor, "match", SymbolKey.MATCH);
        NativeSymbol.createStandardSymbol(scope, ctor, "matchAll", SymbolKey.MATCH_ALL);
        NativeSymbol.createStandardSymbol(scope, ctor, "replace", SymbolKey.REPLACE);
        NativeSymbol.createStandardSymbol(scope, ctor, "search", SymbolKey.SEARCH);
        NativeSymbol.createStandardSymbol(scope, ctor, "split", SymbolKey.SPLIT);
        NativeSymbol.createStandardSymbol(scope, ctor, "unscopables", SymbolKey.UNSCOPABLES);
        if (sealed) {
            ctor.sealObject();
        }
    }

    NativeSymbol(SymbolKey key) {
        this.key = key;
    }

    @Override
    public Symbol.Kind getKind() {
        return this.key.getKind();
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    private static void createStandardSymbol(Scriptable scope, LambdaConstructor ctor, String name, SymbolKey key) {
        ctor.defineProperty(name, (Object)key, 7);
    }

    private static NativeSymbol getSelf(Scriptable thisObj) {
        return LambdaConstructor.convertThisObject(thisObj, NativeSymbol.class);
    }

    private static SymbolKey js_constructorCall(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String desc = args.length > 0 && !Undefined.isUndefined(args[0]) ? ScriptRuntime.toString(args[0]) : null;
        return new SymbolKey(desc, Symbol.Kind.REGULAR);
    }

    private static String js_toString(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeSymbol.getSelf(thisObj).toString();
    }

    private static Object js_valueOf(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeSymbol.getSelf((Scriptable)thisObj).key;
    }

    private static Object js_description(Scriptable thisObj) {
        return NativeSymbol.getSelf(thisObj).getKey().getDescription();
    }

    private static Object js_for(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String name = args.length > 0 ? ScriptRuntime.toString(args[0]) : ScriptRuntime.toString(Undefined.instance);
        Map<String, SymbolKey> table = NativeSymbol.getGlobalMap();
        return table.computeIfAbsent(name, k -> new SymbolKey((String)k, Symbol.Kind.REGISTERED));
    }

    private static Object js_keyFor(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        SymbolKey sym;
        Object s;
        Object object = s = args.length > 0 ? args[0] : Undefined.instance;
        if (s instanceof NativeSymbol) {
            sym = ((NativeSymbol)s).key;
        } else if (s instanceof SymbolKey) {
            sym = (SymbolKey)s;
        } else {
            throw ScriptRuntime.throwCustomError(cx, scope, "TypeError", "Not a Symbol");
        }
        if (NativeSymbol.getGlobalMap().get(sym.getName()) == sym) {
            return sym.getName();
        }
        return Undefined.instance;
    }

    public String toString() {
        return this.key.toString();
    }

    @Override
    public String getName() {
        return this.key.getName();
    }

    private static boolean isStrictMode() {
        Context cx = Context.getCurrentContext();
        return cx != null && cx.isStrictMode();
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        if (!this.isSymbol()) {
            super.put(name, start, value);
        } else if (NativeSymbol.isStrictMode()) {
            throw ScriptRuntime.typeErrorById("msg.no.assign.symbol.strict", new Object[0]);
        }
    }

    @Override
    public void put(int index, Scriptable start, Object value) {
        if (!this.isSymbol()) {
            super.put(index, start, value);
        } else if (NativeSymbol.isStrictMode()) {
            throw ScriptRuntime.typeErrorById("msg.no.assign.symbol.strict", new Object[0]);
        }
    }

    @Override
    public void put(Symbol key, Scriptable start, Object value) {
        if (!this.isSymbol()) {
            super.put(key, start, value);
        } else if (NativeSymbol.isStrictMode()) {
            throw ScriptRuntime.typeErrorById("msg.no.assign.symbol.strict", new Object[0]);
        }
    }

    public boolean isSymbol() {
        return false;
    }

    @Override
    public String getTypeOf() {
        return this.isSymbol() ? TYPE_NAME : super.getTypeOf();
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object x) {
        return this.key.equals(x);
    }

    SymbolKey getKey() {
        return this.key;
    }

    private static Map<String, SymbolKey> getGlobalMap() {
        return globalMap;
    }
}

