/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.typedarrays;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.RandomAccess;
import org.htmlunit.corejs.javascript.AbstractEcmaObjectOperations;
import org.htmlunit.corejs.javascript.ArrayLikeAbstractOperations;
import org.htmlunit.corejs.javascript.Callable;
import org.htmlunit.corejs.javascript.Constructable;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ExternalArrayData;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.IteratorLikeIterable;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.NativeArray;
import org.htmlunit.corejs.javascript.NativeArrayIterator;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.SerializableCallable;
import org.htmlunit.corejs.javascript.Symbol;
import org.htmlunit.corejs.javascript.SymbolKey;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.corejs.javascript.Wrapper;
import org.htmlunit.corejs.javascript.typedarrays.NativeArrayBuffer;
import org.htmlunit.corejs.javascript.typedarrays.NativeArrayBufferView;
import org.htmlunit.corejs.javascript.typedarrays.NativeBigIntArrayView;
import org.htmlunit.corejs.javascript.typedarrays.NativeTypedArrayIterator;

public abstract class NativeTypedArrayView<T>
extends NativeArrayBufferView
implements List<T>,
RandomAccess,
ExternalArrayData {
    private static final long serialVersionUID = -4963053773152251274L;
    protected final int length;
    private static final Object TYPED_ARRAY_TAG = "%TypedArray.prototype%";

    protected NativeTypedArrayView() {
        this.length = 0;
    }

    protected NativeTypedArrayView(NativeArrayBuffer ab, int off, int len, int byteLen) {
        super(ab, off, byteLen);
        this.length = len;
    }

    @Override
    public Object get(int index, Scriptable start) {
        return this.js_get(index);
    }

    @Override
    public Object get(String name, Scriptable start) {
        int ix;
        Optional<Double> num = ScriptRuntime.canonicalNumericIndexString(name);
        if (num.isPresent() && (ix = NativeTypedArrayView.toIndex(num.get())) >= 0) {
            return this.js_get(ix);
        }
        return super.get(name, start);
    }

    @Override
    public boolean has(int index, Scriptable start) {
        return !this.checkIndex(index);
    }

    @Override
    public boolean has(String name, Scriptable start) {
        int ix;
        Optional<Double> num = ScriptRuntime.canonicalNumericIndexString(name);
        if (num.isPresent() && (ix = NativeTypedArrayView.toIndex(num.get())) >= 0) {
            return !this.checkIndex(ix);
        }
        return super.has(name, start);
    }

    @Override
    public void put(int index, Scriptable start, Object val) {
        this.js_set(index, val);
    }

    @Override
    public void put(String name, Scriptable start, Object val) {
        Optional<Double> num = ScriptRuntime.canonicalNumericIndexString(name);
        if (num.isPresent()) {
            int ix = NativeTypedArrayView.toIndex(num.get());
            if (ix >= 0) {
                this.js_set(ix, val);
            }
        } else {
            super.put(name, start, val);
        }
    }

    @Override
    public void delete(int index) {
    }

    @Override
    public void delete(String name) {
        Optional<Double> num = ScriptRuntime.canonicalNumericIndexString(name);
        if (!num.isPresent()) {
            super.delete(name);
        }
    }

    @Override
    public Object[] getIds() {
        Object[] ret = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            ret[i] = i;
        }
        return ret;
    }

    @Override
    protected boolean defineOwnProperty(Context cx, Object id, ScriptableObject.DescriptorInfo desc, boolean checkValid) {
        String name;
        Optional<Double> num;
        if (id instanceof CharSequence && (num = ScriptRuntime.canonicalNumericIndexString(name = id.toString())).isPresent()) {
            int idx = num.get().intValue();
            if (this.checkIndex(idx)) {
                return false;
            }
            if (desc.isConfigurable(false)) {
                return false;
            }
            if (desc.isEnumerable(false)) {
                return false;
            }
            if (desc.isAccessorDescriptor()) {
                return false;
            }
            if (desc.isWritable(false)) {
                return false;
            }
            if (desc.hasValue()) {
                this.js_set(idx, desc.value);
            }
            return true;
        }
        return super.defineOwnProperty(cx, id, desc, checkValid);
    }

    private static int toIndex(double num) {
        int ix = (int)num;
        if ((double)ix == num && ix >= 0) {
            return ix;
        }
        return -1;
    }

    static void init(Context cx, Scriptable scope, LambdaConstructor constructor, RealThis realThis) {
        ScriptableObject s = (ScriptableObject)scope;
        LambdaConstructor ta = (LambdaConstructor)s.getAssociatedValue(TYPED_ARRAY_TAG);
        if (ta == null) {
            ScriptableObject proto = (ScriptableObject)cx.newObject(s);
            ta = new LambdaConstructor(s, "TypedArray", 0, proto, null, (lcx, ls, largs) -> {
                throw ScriptRuntime.typeError("Fuck");
            });
            proto.defineProperty("constructor", (Object)ta, 2);
            NativeTypedArrayView.defineProtoProperty(ta, cx, "buffer", NativeTypedArrayView::js_buffer, null);
            NativeTypedArrayView.defineProtoProperty(ta, cx, "byteLength", NativeTypedArrayView::js_byteLength, null);
            NativeTypedArrayView.defineProtoProperty(ta, cx, "byteOffset", NativeTypedArrayView::js_byteOffset, null);
            NativeTypedArrayView.defineProtoProperty(ta, cx, "length", NativeTypedArrayView::js_length, null);
            NativeTypedArrayView.defineProtoProperty(ta, cx, SymbolKey.TO_STRING_TAG, NativeTypedArrayView::js_toStringTag, null);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "at", 1, NativeTypedArrayView::js_at);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "copyWithin", 2, NativeTypedArrayView::js_copyWithin);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "entries", 0, NativeTypedArrayView::js_entries);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "every", 1, NativeTypedArrayView::js_every);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "fill", 1, NativeTypedArrayView::js_fill);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "filter", 1, NativeTypedArrayView::js_filter);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "find", 1, NativeTypedArrayView::js_find);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "findIndex", 1, NativeTypedArrayView::js_findIndex);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "findLast", 1, NativeTypedArrayView::js_findLast);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "findLastIndex", 1, NativeTypedArrayView::js_findLastIndex);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "forEach", 1, NativeTypedArrayView::js_forEach);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "includes", 1, NativeTypedArrayView::js_includes);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "indexOf", 1, NativeTypedArrayView::js_indexOf);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "join", 1, NativeTypedArrayView::js_join);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "keys", 0, NativeTypedArrayView::js_keys);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "lastIndexOf", 1, NativeTypedArrayView::js_lastIndexOf);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "map", 1, NativeTypedArrayView::js_map);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "reduce", 1, NativeTypedArrayView::js_reduce);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "reduceRight", 1, NativeTypedArrayView::js_reduceRight);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "reverse", 0, NativeTypedArrayView::js_reverse);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "set", 1, NativeTypedArrayView::js_set);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "slice", 2, NativeTypedArrayView::js_slice);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "some", 1, NativeTypedArrayView::js_some);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "sort", 1, NativeTypedArrayView::js_sort);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "subarray", 2, NativeTypedArrayView::js_subarray);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "toLocaleString", 0, NativeTypedArrayView::js_toLocaleString);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "toReversed", 0, NativeTypedArrayView::js_toReversed);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "toSorted", 1, NativeTypedArrayView::js_toSorted);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "toString", 0, NativeTypedArrayView::js_toString);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "values", 0, NativeTypedArrayView::js_values);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, "with", 2, NativeTypedArrayView::js_with);
            NativeTypedArrayView.defineMethod(ta, (Scriptable)s, SymbolKey.ITERATOR, 0, NativeTypedArrayView::js_iterator);
            ta.defineConstructorMethod(scope, "from", 1, NativeTypedArrayView::js_from);
            ta.defineConstructorMethod(scope, "of", 0, NativeTypedArrayView::js_of);
            ta = (LambdaConstructor)s.associateValue(TYPED_ARRAY_TAG, ta);
        }
        constructor.setPrototype(ta);
        ((ScriptableObject)constructor.getPrototypeProperty()).setPrototype((Scriptable)ta.getPrototypeProperty());
    }

    private static void defineProtoProperty(LambdaConstructor typedArray, Context cx, String name, ScriptableObject.LambdaGetterFunction getter, ScriptableObject.LambdaSetterFunction setter) {
        typedArray.definePrototypeProperty(cx, name, getter, setter, 3);
    }

    private static void defineProtoProperty(LambdaConstructor typedArray, Context cx, SymbolKey name, ScriptableObject.LambdaGetterFunction getter, ScriptableObject.LambdaSetterFunction setter) {
        typedArray.definePrototypeProperty(cx, (Symbol)name, getter, setter);
    }

    private static void defineMethod(LambdaConstructor typedArray, Scriptable scope, String name, int length, SerializableCallable target) {
        typedArray.definePrototypeMethod(scope, name, length, target);
    }

    private static void defineMethod(LambdaConstructor typedArray, Scriptable scope, SymbolKey key, int length, SerializableCallable target) {
        typedArray.definePrototypeMethod(scope, key, length, target);
    }

    protected boolean checkIndex(int index) {
        return this.isTypedArrayOutOfBounds() || index < 0 || index >= this.length;
    }

    protected void ensureIndex(int index) {
        if (this.checkIndex(index)) {
            throw new IndexOutOfBoundsException("Index: " + index + ", length: " + this.length);
        }
    }

    public abstract int getBytesPerElement();

    protected abstract Object js_get(int var1);

    protected abstract Object js_set(int var1, Object var2);

    protected Object toNumeric(Object num) {
        return ScriptRuntime.toNumber(num);
    }

    private static NativeArrayBuffer makeArrayBuffer(Context cx, Scriptable scope, int length, int bytesPerElement) {
        return (NativeArrayBuffer)cx.newObject(scope, "ArrayBuffer", new Object[]{(double)length * (double)bytesPerElement});
    }

    protected static NativeTypedArrayView<?> js_constructor(Context cx, Scriptable scope, Object[] args, TypedArrayConstructable constructable, int bytesPerElement) {
        if (!NativeTypedArrayView.isArg(args, 0)) {
            return constructable.construct(new NativeArrayBuffer(), 0, 0);
        }
        Object arg0 = args[0];
        if (arg0 == null) {
            return constructable.construct(new NativeArrayBuffer(), 0, 0);
        }
        if (arg0 instanceof Number || arg0 instanceof String) {
            int length = ScriptRuntime.toInt32(arg0);
            NativeArrayBuffer buffer = NativeTypedArrayView.makeArrayBuffer(cx, scope, length, bytesPerElement);
            return constructable.construct(buffer, 0, length);
        }
        if (arg0 instanceof NativeTypedArrayView) {
            NativeTypedArrayView src = (NativeTypedArrayView)arg0;
            NativeArrayBuffer na = NativeTypedArrayView.makeArrayBuffer(cx, scope, src.length, bytesPerElement);
            NativeTypedArrayView<?> v = constructable.construct(na, 0, src.length);
            for (int i = 0; i < src.length; ++i) {
                v.js_set(i, src.js_get(i));
            }
            return v;
        }
        if (arg0 instanceof NativeArrayBuffer) {
            int newByteLength;
            int byteOff;
            NativeArrayBuffer na = (NativeArrayBuffer)arg0;
            int n = byteOff = NativeTypedArrayView.isArg(args, 1) ? ScriptRuntime.toIndex(args[1]) : 0;
            if (byteOff % bytesPerElement != 0) {
                throw ScriptRuntime.rangeErrorById("msg.typed.array.bad.offset.byte.size", byteOff, bytesPerElement);
            }
            int newLength = 0;
            if (NativeTypedArrayView.isArg(args, 2)) {
                newLength = ScriptRuntime.toIndex(args[2]);
            }
            if (na.isDetached()) {
                throw ScriptRuntime.typeErrorById("msg.arraybuf.detached", new Object[0]);
            }
            int bufferByteLength = na.getLength();
            if (!NativeTypedArrayView.isArg(args, 2)) {
                newByteLength = bufferByteLength - byteOff;
                if (bufferByteLength % bytesPerElement != 0) {
                    throw ScriptRuntime.rangeErrorById("msg.typed.array.bad.buffer.length.byte.size", newByteLength, bytesPerElement);
                }
                if (newByteLength < 0) {
                    throw ScriptRuntime.rangeErrorById("msg.typed.array.bad.offset", byteOff);
                }
            } else {
                newByteLength = newLength * bytesPerElement;
                if (byteOff + newByteLength > bufferByteLength) {
                    throw ScriptRuntime.rangeErrorById("msg.typed.array.bad.length", newByteLength);
                }
            }
            if (byteOff < 0 || byteOff > na.getLength()) {
                throw ScriptRuntime.rangeErrorById("msg.typed.array.bad.offset", byteOff);
            }
            return constructable.construct(na, byteOff, newByteLength / bytesPerElement);
        }
        if (arg0 instanceof NativeArray) {
            NativeArray array = (NativeArray)arg0;
            NativeArrayBuffer na = NativeTypedArrayView.makeArrayBuffer(cx, scope, array.size(), bytesPerElement);
            NativeTypedArrayView<?> v = constructable.construct(na, 0, array.size());
            for (int i = 0; i < array.size(); ++i) {
                Object value = array.get(i, (Scriptable)array);
                if (value == Scriptable.NOT_FOUND || value == Undefined.instance) {
                    v.js_set(i, ScriptRuntime.NaNobj);
                    continue;
                }
                if (value instanceof Wrapper) {
                    v.js_set(i, ((Wrapper)value).unwrap());
                    continue;
                }
                v.js_set(i, value);
            }
            return v;
        }
        if (ScriptRuntime.isArrayObject(arg0)) {
            Object[] arrayElements = ScriptRuntime.getArrayElements((Scriptable)arg0);
            NativeArrayBuffer na = NativeTypedArrayView.makeArrayBuffer(cx, scope, arrayElements.length, bytesPerElement);
            NativeTypedArrayView<?> v = constructable.construct(na, 0, arrayElements.length);
            for (int i = 0; i < arrayElements.length; ++i) {
                v.js_set(i, arrayElements[i]);
            }
            return v;
        }
        throw ScriptRuntime.constructError("Error", "invalid argument");
    }

    private void setRange(NativeTypedArrayView<?> source, double dbloff) {
        if (this.isTypedArrayOutOfBounds()) {
            throw ScriptRuntime.typeErrorById("msg.typed.array.out.of.bounds", new Object[0]);
        }
        int targetLength = this.length;
        if (source.isTypedArrayOutOfBounds()) {
            throw ScriptRuntime.typeErrorById("msg.typed.array.out.of.bounds", new Object[0]);
        }
        int srcLength = source.length;
        if (dbloff > (double)targetLength) {
            throw ScriptRuntime.rangeErrorById("msg.typed.array.bad.offset", dbloff);
        }
        if ((double)srcLength + dbloff > (double)targetLength) {
            throw ScriptRuntime.rangeErrorById("msg.typed.array.bad.source.array", new Object[0]);
        }
        if (this instanceof NativeBigIntArrayView != source instanceof NativeBigIntArrayView) {
            throw ScriptRuntime.typeErrorById("msg.typed.array.type.mismatch", new Object[0]);
        }
        int targetOffset = (int)dbloff;
        if (source.arrayBuffer == this.arrayBuffer) {
            int i;
            Object[] tmp = new Object[srcLength];
            for (i = 0; i < srcLength; ++i) {
                tmp[i] = source.js_get(i);
            }
            for (i = 0; i < srcLength; ++i) {
                this.js_set(i + targetOffset, tmp[i]);
            }
        } else {
            for (int i = 0; i < srcLength; ++i) {
                this.js_set(i + targetOffset, source.js_get(i));
            }
        }
    }

    private void setRange(Context cx, Scriptable scope, Scriptable source, double dbloff) {
        if (this.isTypedArrayOutOfBounds()) {
            throw ScriptRuntime.typeErrorById("msg.typed.array.out.of.bounds", new Object[0]);
        }
        int targetLength = this.length;
        Scriptable src = ScriptRuntime.toObject(scope, source);
        long srcLength = AbstractEcmaObjectOperations.lengthOfArrayLike(cx, src);
        if (dbloff > (double)targetLength) {
            throw ScriptRuntime.rangeErrorById("msg.typed.array.bad.offset", dbloff);
        }
        if ((double)srcLength + dbloff > (double)targetLength) {
            throw ScriptRuntime.rangeErrorById("msg.typed.array.bad.source.array", new Object[0]);
        }
        int targetOffset = (int)dbloff;
        int k = 0;
        while ((long)k < srcLength) {
            Object value = source.get(k, source);
            this.js_set(k + targetOffset, value);
            ++k;
        }
    }

    public boolean isTypedArrayOutOfBounds() {
        return this.arrayBuffer.isDetached() || this.outOfRange;
    }

    private long validateAndGetLength() {
        if (this.isTypedArrayOutOfBounds()) {
            throw ScriptRuntime.typeErrorById("msg.typed.array.out.of.bounds", new Object[0]);
        }
        return this.length;
    }

    private static NativeTypedArrayView realThis(Scriptable thisObj) {
        return LambdaConstructor.convertThisObject(thisObj, NativeTypedArrayView.class);
    }

    private static Object js_buffer(Scriptable thisObj) {
        return NativeTypedArrayView.realThis((Scriptable)thisObj).arrayBuffer;
    }

    private static Object js_toStringTag(Scriptable thisObj) {
        if (NativeTypedArrayView.class.isInstance(thisObj)) {
            return thisObj.getClassName();
        }
        return Undefined.instance;
    }

    private static Object js_byteLength(Scriptable thisObj) {
        NativeTypedArrayView o = NativeTypedArrayView.realThis(thisObj);
        if (o.isTypedArrayOutOfBounds()) {
            return 0;
        }
        return o.byteLength;
    }

    private static Object js_byteOffset(Scriptable thisObj) {
        NativeTypedArrayView o = NativeTypedArrayView.realThis(thisObj);
        if (o.isTypedArrayOutOfBounds()) {
            return 0;
        }
        return o.offset;
    }

    private static Object js_length(Scriptable thisObj) {
        NativeTypedArrayView o = NativeTypedArrayView.realThis(thisObj);
        if (o.isTypedArrayOutOfBounds()) {
            return 0;
        }
        return o.length;
    }

    private static String js_toString(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeTypedArrayView.js_toStringInternal(cx, scope, thisObj, args, false);
    }

    private static String js_toLocaleString(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return NativeTypedArrayView.js_toStringInternal(cx, scope, thisObj, args, true);
    }

    private static String js_toStringInternal(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, boolean useLocale) {
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        if (self.isTypedArrayOutOfBounds()) {
            throw ScriptRuntime.typeErrorById("msg.typed.array.out.of.bounds", new Object[0]);
        }
        StringBuilder builder = new StringBuilder();
        if (self.length > 0) {
            Object elem = self.getElemForToString(cx, scope, 0, useLocale);
            builder.append(ScriptRuntime.toString(elem));
        }
        for (int i = 1; i < self.length; ++i) {
            builder.append(',');
            Object elem = self.getElemForToString(cx, scope, i, useLocale);
            builder.append(ScriptRuntime.toString(elem));
        }
        return builder.toString();
    }

    private Object getElemForToString(Context cx, Scriptable scope, int index, boolean useLocale) {
        Object elem = this.js_get(index);
        if (useLocale) {
            ScriptRuntime.LookupResult toLocaleString = ScriptRuntime.getPropAndThis(elem, "toLocaleString", cx, scope);
            return toLocaleString.call(cx, scope, ScriptRuntime.emptyArgs);
        }
        return elem;
    }

    private static Object js_entries(Context lcx, Scriptable lscope, Scriptable thisObj, Object[] args) {
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        if (self.isTypedArrayOutOfBounds()) {
            throw ScriptRuntime.typeErrorById("msg.typed.array.out.of.bounds", new Object[0]);
        }
        return new NativeArrayIterator(lscope, self, NativeArrayIterator.ARRAY_ITERATOR_TYPE.ENTRIES);
    }

    private static Object js_every(Context lcx, Scriptable lscope, Scriptable thisObj, Object[] args) {
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        return ArrayLikeAbstractOperations.coercibleIterativeMethod(lcx, ArrayLikeAbstractOperations.IterativeOperation.EVERY, lscope, self, args, self.validateAndGetLength());
    }

    private static Object js_filter(Context lcx, Scriptable lscope, Scriptable thisObj, Object[] args) {
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        Object array = ArrayLikeAbstractOperations.coercibleIterativeMethod(lcx, ArrayLikeAbstractOperations.IterativeOperation.FILTER, lscope, self, args, self.validateAndGetLength());
        return self.typedArraySpeciesCreate(lcx, lscope, new Object[]{array}, "filter");
    }

    private static Object js_find(Context lcx, Scriptable lscope, Scriptable thisObj, Object[] args) {
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        return ArrayLikeAbstractOperations.coercibleIterativeMethod(lcx, ArrayLikeAbstractOperations.IterativeOperation.FIND, lscope, self, args, self.validateAndGetLength());
    }

    private static Object js_findIndex(Context lcx, Scriptable lscope, Scriptable thisObj, Object[] args) {
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        return ArrayLikeAbstractOperations.coercibleIterativeMethod(lcx, ArrayLikeAbstractOperations.IterativeOperation.FIND_INDEX, lscope, self, args, self.validateAndGetLength());
    }

    private static Object js_findLast(Context lcx, Scriptable lscope, Scriptable thisObj, Object[] args) {
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        return ArrayLikeAbstractOperations.coercibleIterativeMethod(lcx, ArrayLikeAbstractOperations.IterativeOperation.FIND_LAST, lscope, self, args, self.validateAndGetLength());
    }

    private static Object js_findLastIndex(Context lcx, Scriptable lscope, Scriptable thisObj, Object[] args) {
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        return ArrayLikeAbstractOperations.coercibleIterativeMethod(lcx, ArrayLikeAbstractOperations.IterativeOperation.FIND_LAST_INDEX, lscope, self, args, self.validateAndGetLength());
    }

    private static Object js_forEach(Context lcx, Scriptable lscope, Scriptable thisObj, Object[] args) {
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        return ArrayLikeAbstractOperations.coercibleIterativeMethod(lcx, ArrayLikeAbstractOperations.IterativeOperation.FOR_EACH, lscope, self, args, self.validateAndGetLength());
    }

    private static Boolean js_includes(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        long start;
        Object compareTo;
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        long len = self.validateAndGetLength();
        Object object = compareTo = args.length > 0 ? args[0] : Undefined.instance;
        if (len == 0L) {
            return Boolean.FALSE;
        }
        if (args.length < 2) {
            start = 0L;
        } else {
            start = (long)ScriptRuntime.toInteger(args[1]);
            if (start < 0L && (start += len) < 0L) {
                start = 0L;
            }
            if (start > len - 1L) {
                return Boolean.FALSE;
            }
        }
        int i = (int)start;
        while ((long)i < len) {
            Object val = self.js_get(i);
            if (ScriptRuntime.sameZero(val, compareTo)) {
                return Boolean.TRUE;
            }
            ++i;
        }
        return Boolean.FALSE;
    }

    private static Object js_indexOf(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        long start;
        Object compareTo;
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        long len = self.validateAndGetLength();
        Object object = compareTo = args.length > 0 ? args[0] : Undefined.instance;
        if (len == 0L) {
            return -1;
        }
        if (args.length < 2) {
            start = 0L;
        } else {
            start = (long)ScriptRuntime.toInteger(args[1]);
            if (start < 0L && (start += len) < 0L) {
                start = 0L;
            }
            if (start > len - 1L) {
                return -1;
            }
        }
        int i = (int)start;
        while ((long)i < len) {
            Object val;
            if (self.has(i, (Scriptable)self) && (val = self.js_get(i)) != NOT_FOUND && ScriptRuntime.shallowEq(val, compareTo)) {
                return (long)i;
            }
            ++i;
        }
        return -1;
    }

    private static Object js_iterator(Context lcx, Scriptable lscope, Scriptable thisObj, Object[] args) {
        return NativeTypedArrayView.js_values(lcx, lscope, thisObj, args);
    }

    private static Object js_keys(Context lcx, Scriptable lscope, Scriptable thisObj, Object[] args) {
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        if (self.isTypedArrayOutOfBounds()) {
            throw ScriptRuntime.typeErrorById("msg.typed.array.out.of.bounds", new Object[0]);
        }
        return new NativeArrayIterator(lscope, self, NativeArrayIterator.ARRAY_ITERATOR_TYPE.KEYS);
    }

    private static Object js_lastIndexOf(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        long start;
        Object compareTo;
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        long len = self.validateAndGetLength();
        Object object = compareTo = args.length > 0 ? args[0] : Undefined.instance;
        if (len == 0L) {
            return -1;
        }
        if (args.length < 2) {
            start = len - 1L;
        } else {
            start = (long)ScriptRuntime.toInteger(args[1]);
            if (start >= len) {
                start = len - 1L;
            } else if (start < 0L) {
                start += len;
            }
            if (start < 0L) {
                return -1;
            }
        }
        for (int i = (int)start; i >= 0; --i) {
            Object val;
            if (!self.has(i, (Scriptable)self) || (val = self.js_get(i)) == NOT_FOUND || !ScriptRuntime.shallowEq(val, compareTo)) continue;
            return (long)i;
        }
        return -1;
    }

    private static Object js_map(Context lcx, Scriptable lscope, Scriptable thisObj, Object[] args) {
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        Object array = ArrayLikeAbstractOperations.coercibleIterativeMethod(lcx, ArrayLikeAbstractOperations.IterativeOperation.MAP, lscope, thisObj, args, self.validateAndGetLength());
        return self.typedArraySpeciesCreate(lcx, lscope, new Object[]{array}, "map");
    }

    private static Object js_reduce(Context lcx, Scriptable lscope, Scriptable thisObj, Object[] args) {
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        return ArrayLikeAbstractOperations.reduceMethodWithLength(lcx, ArrayLikeAbstractOperations.ReduceOperation.REDUCE, lscope, self, args, self.validateAndGetLength());
    }

    private static Object js_reduceRight(Context lcx, Scriptable lscope, Scriptable thisObj, Object[] args) {
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        return ArrayLikeAbstractOperations.reduceMethodWithLength(lcx, ArrayLikeAbstractOperations.ReduceOperation.REDUCE_RIGHT, lscope, self, args, self.validateAndGetLength());
    }

    private static Scriptable js_slice(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        long end;
        long begin;
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        long srcLength = self.validateAndGetLength();
        if (args.length == 0) {
            begin = 0L;
            end = srcLength;
        } else {
            begin = ArrayLikeAbstractOperations.toSliceIndex(ScriptRuntime.toInteger(args[0]), srcLength);
            end = args.length == 1 || args[1] == Undefined.instance ? srcLength : ArrayLikeAbstractOperations.toSliceIndex(ScriptRuntime.toInteger(args[1]), srcLength);
        }
        if (end - begin > Integer.MAX_VALUE) {
            String msg = ScriptRuntime.getMessageById("msg.arraylength.bad", new Object[0]);
            throw ScriptRuntime.rangeError(msg);
        }
        long count = Math.max(end - begin, 0L);
        NativeTypedArrayView<?> a = self.typedArraySpeciesCreate(cx, scope, new Object[]{count}, "slice");
        if (count > 0L) {
            if (self.isTypedArrayOutOfBounds()) {
                throw ScriptRuntime.typeErrorById("msg.typed.array.out.of.bounds", new Object[0]);
            }
            end = Math.min(end, (long)self.length);
            int n = 0;
            int i = (int)begin;
            while ((long)i < end) {
                Object val = self.js_get(i);
                a.js_set(n, val);
                ++n;
                ++i;
            }
        }
        return a;
    }

    private static Object js_some(Context lcx, Scriptable lscope, Scriptable thisObj, Object[] args) {
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        return ArrayLikeAbstractOperations.coercibleIterativeMethod(lcx, ArrayLikeAbstractOperations.IterativeOperation.SOME, lscope, self, args, self.validateAndGetLength());
    }

    private static Object js_values(Context lcx, Scriptable lscope, Scriptable thisObj, Object[] args) {
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        if (self.isTypedArrayOutOfBounds()) {
            throw ScriptRuntime.typeErrorById("msg.typed.array.out.of.bounds", new Object[0]);
        }
        return new NativeArrayIterator(lscope, self, NativeArrayIterator.ARRAY_ITERATOR_TYPE.VALUES);
    }

    private static String js_join(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String str;
        String separator;
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        long len = self.validateAndGetLength();
        String string = separator = args.length < 1 || args[0] == Undefined.instance ? "," : ScriptRuntime.toString(args[0]);
        if (len == 0L) {
            return "";
        }
        String[] buf = new String[(int)len];
        int total_size = 0;
        int i = 0;
        while ((long)i != len) {
            Object temp = self.js_get(i);
            if (temp != null && temp != Undefined.instance) {
                str = ScriptRuntime.toString(temp);
                total_size += str.length();
                buf[i] = str;
            }
            ++i;
        }
        StringBuilder sb = new StringBuilder(total_size += ((int)len - 1) * separator.length());
        int i2 = 0;
        while ((long)i2 != len) {
            if (i2 != 0) {
                sb.append(separator);
            }
            if ((str = buf[i2]) != null) {
                sb.append(str);
            }
            ++i2;
        }
        return sb.toString();
    }

    private static NativeTypedArrayView<?> js_reverse(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        long len = self.validateAndGetLength();
        int i = 0;
        for (int j = (int)len - 1; i < j; ++i, --j) {
            Object temp = self.js_get(i);
            self.js_set(i, self.js_get(j));
            self.js_set(j, temp);
        }
        return self;
    }

    private static NativeTypedArrayView<?> js_fill(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        long len = self.validateAndGetLength();
        Object value = self.toNumeric(args.length > 0 ? args[0] : Undefined.instance);
        long relativeStart = 0L;
        if (args.length >= 2) {
            relativeStart = (long)ScriptRuntime.toInteger(args[1]);
        }
        long k = relativeStart < 0L ? Math.max(len + relativeStart, 0L) : Math.min(relativeStart, len);
        long relativeEnd = len;
        if (args.length > 2 && !Undefined.isUndefined(args[2])) {
            relativeEnd = (long)ScriptRuntime.toInteger(args[2]);
        }
        long fin = relativeEnd < 0L ? Math.max(len + relativeEnd, 0L) : Math.min(relativeEnd, len);
        if (self.isTypedArrayOutOfBounds()) {
            throw ScriptRuntime.typeErrorById("msg.typed.array.out.of.bounds", new Object[0]);
        }
        int i = (int)k;
        while ((long)i < fin) {
            self.js_set(i, value);
            ++i;
        }
        return self;
    }

    private static Scriptable js_sort(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (NativeTypedArrayView.isArg(args, 0) && !(args[0] instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.function.expected", new Object[0]);
        }
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        long len = self.validateAndGetLength();
        Object[] working = self.sortTemporaryArray(cx, scope, args);
        int i = 0;
        while ((long)i < len) {
            self.js_set(i, working[i]);
            ++i;
        }
        return self;
    }

    private Object[] sortTemporaryArray(Context cx, Scriptable scope, Object[] args) {
        Comparator<Object> comparator = args.length > 0 && Undefined.instance != args[0] ? ArrayLikeAbstractOperations.getSortComparator(cx, scope, args) : Comparator.comparingDouble(e -> ((Number)e).doubleValue());
        Object[] working = this.toArray();
        Arrays.sort(working, comparator);
        return working;
    }

    private static Object js_copyWithin(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        long fin;
        long count;
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        long len = self.validateAndGetLength();
        Object targetArg = args.length >= 1 ? args[0] : Undefined.instance;
        long relativeTarget = (long)ScriptRuntime.toInteger(targetArg);
        long to = relativeTarget < 0L ? Math.max(len + relativeTarget, 0L) : Math.min(relativeTarget, len);
        Object startArg = args.length >= 2 ? args[1] : Undefined.instance;
        long relativeStart = (long)ScriptRuntime.toInteger(startArg);
        long from = relativeStart < 0L ? Math.max(len + relativeStart, 0L) : Math.min(relativeStart, len);
        long relativeEnd = len;
        if (NativeTypedArrayView.isArg(args, 2)) {
            relativeEnd = (long)ScriptRuntime.toInteger(args[2]);
        }
        if ((count = Math.min((fin = relativeEnd < 0L ? Math.max(len + relativeEnd, 0L) : Math.min(relativeEnd, len)) - from, len - to)) > 0L) {
            if (self.isTypedArrayOutOfBounds()) {
                throw ScriptRuntime.typeErrorById("msg.typed.array.out.of.bounds", new Object[0]);
            }
            int direction = 1;
            if (from < to && to < from + count) {
                direction = -1;
                from = from + count - 1L;
                to = to + count - 1L;
            }
            while (count > 0L) {
                Object temp = self.js_get((int)from);
                self.js_set((int)to, temp);
                from += (long)direction;
                to += (long)direction;
                --count;
            }
        }
        return self;
    }

    private static Object js_set(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double offset;
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        double d = offset = NativeTypedArrayView.isArg(args, 1) ? ScriptRuntime.toIntegerOrInfinity(args[1]) : 0.0;
        if (offset < 0.0) {
            throw ScriptRuntime.rangeErrorById("msg.typed.array.bad.offset", offset);
        }
        if (args[0] instanceof NativeTypedArrayView) {
            NativeTypedArrayView nativeView = (NativeTypedArrayView)args[0];
            self.setRange(nativeView, offset);
        } else {
            self.setRange(cx, scope, ScriptableObject.ensureScriptable(args[0]), offset);
        }
        return Undefined.instance;
    }

    private static Object js_subarray(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        NativeTypedArrayView self;
        if (args.length == 0) {
            // empty if block
        }
        int srcLength = (self = NativeTypedArrayView.realThis(thisObj)).isTypedArrayOutOfBounds() ? 0 : self.length;
        int start = NativeTypedArrayView.isArg(args, 0) ? ScriptRuntime.toInt32(args[0]) : 0;
        int end = NativeTypedArrayView.isArg(args, 1) ? ScriptRuntime.toInt32(args[1]) : srcLength;
        start = start < 0 ? srcLength + start : start;
        end = end < 0 ? srcLength + end : end;
        start = Math.max(0, start);
        start = Math.min(start, srcLength);
        end = Math.min(srcLength, end);
        int len = Math.max(0, end - start);
        int byteOff = self.getByteOffset() + start * self.getBytesPerElement();
        return self.typedArraySpeciesCreate(cx, scope, new Object[]{self.arrayBuffer, byteOff, len}, "subarray");
    }

    private static Object js_at(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        long k;
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        long relativeIndex = 0L;
        if (args.length >= 1) {
            relativeIndex = (long)ScriptRuntime.toInteger(args[0]);
        }
        long l = k = relativeIndex >= 0L ? relativeIndex : (long)self.length + relativeIndex;
        if (k < 0L || k >= (long)self.length) {
            return Undefined.instance;
        }
        return NativeTypedArrayView.getProperty(thisObj, (int)k);
    }

    private NativeTypedArrayView<?> typedArraySpeciesCreate(Context cx, Scriptable scope, Object[] args, String methodName) {
        Scriptable topLevelScope = ScriptableObject.getTopLevelScope(scope);
        Function defaultConstructor = ScriptRuntime.getExistingCtor(cx, topLevelScope, this.getClassName());
        Constructable constructable = AbstractEcmaObjectOperations.speciesConstructor(cx, this, defaultConstructor);
        Scriptable newArray = constructable.construct(cx, scope, args);
        if (newArray instanceof NativeTypedArrayView) {
            long len = ((NativeTypedArrayView)newArray).validateAndGetLength();
            if (args.length == 1 && args[0] instanceof Number && len < ((Number)args[0]).longValue()) {
                throw ScriptRuntime.rangeErrorById("msg.typed.array.bad.length", len);
            }
        } else {
            throw ScriptRuntime.typeErrorById("msg.typed.array.receiver.incompatible", "prototype." + methodName);
        }
        return (NativeTypedArrayView)newArray;
    }

    private static Object js_toReversed(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        NativeArrayBuffer newBuffer = new NativeArrayBuffer((double)(self.length * self.getBytesPerElement()));
        Scriptable result = cx.newObject(scope, self.getClassName(), new Object[]{newBuffer, 0, self.length, self.getBytesPerElement()});
        for (int k = 0; k < self.length; ++k) {
            int from = self.length - k - 1;
            Object fromValue = self.js_get(from);
            result.put(k, result, fromValue);
        }
        return result;
    }

    private static Object js_toSorted(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        Object[] working = self.sortTemporaryArray(cx, scope, args);
        NativeArrayBuffer newBuffer = new NativeArrayBuffer((double)(self.length * self.getBytesPerElement()));
        Scriptable result = cx.newObject(scope, self.getClassName(), new Object[]{newBuffer, 0, self.length, self.getBytesPerElement()});
        for (int k = 0; k < self.length; ++k) {
            result.put(k, result, working[k]);
        }
        return result;
    }

    private static Object js_with(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        NativeTypedArrayView self = NativeTypedArrayView.realThis(thisObj);
        long relativeIndex = args.length > 0 ? (long)((int)ScriptRuntime.toInteger(args[0])) : 0L;
        long actualIndex = relativeIndex >= 0L ? relativeIndex : (long)self.length + relativeIndex;
        Double argsValue = args.length > 1 ? ScriptRuntime.toNumber(args[1]) : 0.0;
        if (actualIndex < 0L || actualIndex >= (long)self.length) {
            String msg = ScriptRuntime.getMessageById("msg.typed.array.index.out.of.bounds", relativeIndex, self.length * -1, self.length - 1);
            throw ScriptRuntime.rangeError(msg);
        }
        NativeArrayBuffer newBuffer = new NativeArrayBuffer((double)(self.length * self.getBytesPerElement()));
        Scriptable result = cx.newObject(scope, self.getClassName(), new Object[]{newBuffer, 0, self.length, self.getBytesPerElement()});
        for (int k = 0; k < self.length; ++k) {
            Double fromValue = (long)k == actualIndex ? argsValue : self.js_get(k);
            result.put(k, result, (Object)fromValue);
        }
        return result;
    }

    private static Object js_from(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        int size;
        Object iterator;
        if (args.length < 1) {
            throw ScriptRuntime.typeErrorById("msg.missing.argument", new Object[0]);
        }
        Scriptable items = ScriptRuntime.toObject(scope, args[0]);
        if (!AbstractEcmaObjectOperations.isConstructor(cx, thisObj)) {
            throw ScriptRuntime.typeErrorById("msg.constructor.expected", new Object[0]);
        }
        Constructable constructable = (Constructable)((Object)thisObj);
        Function mapFn = null;
        Object mapArg = args.length >= 2 ? args[1] : Undefined.instance;
        Scriptable mapFnThisArg = Undefined.SCRIPTABLE_UNDEFINED;
        if (!Undefined.isUndefined(mapArg)) {
            if (!(mapArg instanceof Function)) {
                throw ScriptRuntime.typeErrorById("msg.map.function.not", new Object[0]);
            }
            mapFn = (Function)mapArg;
            if (args.length >= 3) {
                mapFnThisArg = ScriptableObject.ensureScriptable(args[2]);
            }
        }
        ArrayList listFromIterator = null;
        Object iteratorProp = ScriptableObject.getProperty(items, SymbolKey.ITERATOR);
        if (!(iteratorProp == Scriptable.NOT_FOUND || items instanceof List || Undefined.isUndefined(iteratorProp) || Undefined.isUndefined(iterator = ScriptRuntime.callIterator(items, cx, scope)))) {
            try (IteratorLikeIterable it = new IteratorLikeIterable(cx, scope, iterator);){
                listFromIterator = new ArrayList();
                for (Object temp : it) {
                    listFromIterator.add(temp);
                }
            }
        }
        if (listFromIterator != null) {
            size = listFromIterator.size();
        } else {
            long sizeLong = AbstractEcmaObjectOperations.lengthOfArrayLike(cx, items);
            if (sizeLong > Integer.MAX_VALUE) {
                throw ScriptRuntime.rangeErrorById("msg.arraylength.bad", new Object[0]);
            }
            size = (int)AbstractEcmaObjectOperations.lengthOfArrayLike(cx, items);
        }
        Scriptable result = constructable.construct(cx, scope, new Object[]{size});
        if (!(result instanceof NativeTypedArrayView)) {
            throw ScriptRuntime.typeErrorById("msg.typed.array.receiver.incompatible", "from");
        }
        NativeTypedArrayView typedArray = (NativeTypedArrayView)result;
        if (typedArray.length < size) {
            throw ScriptRuntime.typeErrorById("msg.typed.array.length.too.small", new Object[0]);
        }
        for (int k = 0; k < size; ++k) {
            Object temp;
            if (listFromIterator != null) {
                temp = listFromIterator.get(k);
            } else if (items instanceof List) {
                try {
                    temp = ((List)((Object)items)).get(k);
                }
                catch (IndexOutOfBoundsException e) {
                    temp = Undefined.instance;
                }
            } else {
                temp = ScriptRuntime.getObjectIndex(items, k, cx, scope);
            }
            if (mapFn != null) {
                temp = mapFn.call(cx, scope, mapFnThisArg, new Object[]{temp, k});
            }
            typedArray.setArrayElement(k, temp);
        }
        return result;
    }

    private static Object js_of(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!AbstractEcmaObjectOperations.isConstructor(cx, thisObj)) {
            throw ScriptRuntime.typeErrorById("msg.constructor.expected", new Object[0]);
        }
        Constructable constructable = (Constructable)((Object)thisObj);
        Scriptable result = constructable.construct(cx, scope, new Object[]{args.length});
        if (!(result instanceof NativeTypedArrayView)) {
            throw ScriptRuntime.typeErrorById("msg.typed.array.receiver.incompatible", "of");
        }
        NativeTypedArrayView typedArray = (NativeTypedArrayView)result;
        if (typedArray.length < args.length) {
            throw ScriptRuntime.typeErrorById("msg.typed.array.length.too.small", new Object[0]);
        }
        for (int k = 0; k < args.length; ++k) {
            typedArray.setArrayElement(k, args[k]);
        }
        return result;
    }

    @Override
    public Object getArrayElement(int index) {
        return this.js_get(index);
    }

    @Override
    public void setArrayElement(int index, Object value) {
        this.js_set(index, value);
    }

    @Override
    public int getArrayLength() {
        return this.length;
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        for (Object o : objects) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.length; ++i) {
            if (!o.equals(this.js_get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.length - 1; i >= 0; --i) {
            if (!o.equals(this.js_get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object[] toArray() {
        Object[] a = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            a[i] = this.js_get(i);
        }
        return a;
    }

    @Override
    public <U> U[] toArray(U[] ts) {
        Object[] a = ts.length >= this.length ? ts : (Object[])Array.newInstance(ts.getClass().getComponentType(), this.length);
        for (int i = 0; i < this.length; ++i) {
            try {
                a[i] = this.js_get(i);
                continue;
            }
            catch (ClassCastException cce) {
                throw new ArrayStoreException();
            }
        }
        return a;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof NativeTypedArrayView)) {
            return false;
        }
        NativeTypedArrayView v = (NativeTypedArrayView)o;
        if (this.length != v.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.js_get(i).equals(v.js_get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hc = 0;
        for (int i = 0; i < this.length; ++i) {
            hc += this.js_get(i).hashCode();
        }
        return hc;
    }

    @Override
    public Iterator<T> iterator() {
        return new NativeTypedArrayIterator(this, 0);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new NativeTypedArrayIterator(this, 0);
    }

    @Override
    public ListIterator<T> listIterator(int start) {
        this.ensureIndex(start);
        return new NativeTypedArrayIterator(this, start);
    }

    @Override
    public List<T> subList(int i, int i2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T aByte) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int i, T aByte) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int i, Collection<? extends T> bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        throw new UnsupportedOperationException();
    }

    protected static interface RealThis {
        public NativeTypedArrayView<?> realThis(Scriptable var1);
    }

    protected static interface TypedArrayConstructable {
        public NativeTypedArrayView<?> construct(NativeArrayBuffer var1, int var2, int var3);
    }
}

