/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.css;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.htmlunit.cssparser.parser.selector.SelectorSpecificity;

public class StyleElement
implements Serializable {
    public static final String PRIORITY_IMPORTANT = "important";
    private static final AtomicLong ELEMENT_INDEX = new AtomicLong();
    private final String name_;
    private final String value_;
    private final String priority_;
    private final long index_;
    private final SelectorSpecificity specificity_;

    public StyleElement(String name, String value, String priority, SelectorSpecificity specificity, long index) {
        this.name_ = name;
        this.value_ = value;
        this.priority_ = priority;
        this.specificity_ = specificity;
        this.index_ = index;
    }

    public StyleElement(String name, String value, String priority, SelectorSpecificity specificity) {
        this(name, value, priority, specificity, ELEMENT_INDEX.incrementAndGet());
    }

    public String getName() {
        return this.name_;
    }

    public String getValue() {
        return this.value_;
    }

    public String getPriority() {
        return this.priority_;
    }

    public boolean isImportant() {
        return PRIORITY_IMPORTANT.equals(this.getPriority());
    }

    public SelectorSpecificity getSpecificity() {
        return this.specificity_;
    }

    public long getIndex() {
        return this.index_;
    }

    public String toString() {
        return "[" + this.index_ + "]" + this.name_ + "=" + this.value_;
    }

    public static int compareToByImportanceAndSpecificity(StyleElement first, StyleElement second) {
        int comp;
        if (first == null) {
            return second == null ? 0 : -1;
        }
        if (second == null) {
            return 1;
        }
        if (first == second) {
            return 0;
        }
        if (first.isImportant()) {
            if (!second.isImportant()) {
                return 1;
            }
        } else if (second.isImportant()) {
            return -1;
        }
        if ((comp = first.getSpecificity().compareTo(second.getSpecificity())) == 0) {
            return Long.compare(first.getIndex(), second.getIndex());
        }
        return comp;
    }
}

